<?php
class Api extends Controller
{
    public function index($resellerObj, $pageParams){
        echo json_encode("Enter a valid method");
    }

    public function signupProcessForm ($resellerObj, $pageParams){
		if (self::NEW_DB_SWITCH) {
			$db = $this->model('database');
			$pk = $this->model('package', [$db, 0]); 
			$model = $this->model('localthanks');
			$model->setPDO ($resellerObj->getPDO());
			$res = $model->signupProcessForm($pageParams['request'], $resellerObj, $pk);
			echo json_encode($res);
		}	
		else{	
			$model = $this->model('localthanks_v1');
			$model->setPDO ($resellerObj->getPDO());
			$res = $model->signupProcessForm($pageParams['request']);
			echo json_encode($res);
		}
    }
	
    public function signupProcessFormStep3 ($resellerObj, $pageParams){
        $model = $this->model('localthanks');
        $model->setPDO ($resellerObj->getPDO());
        $res = $model->signupProcessFormStep3($pageParams['request']);
        echo json_encode($res);
    }

    public function checkMerchantEmail($resellerObj, $pageParams){
        $email = $pageParams['request']['email'];
        if ($email){
            $model = $this->model('localthanks');
            $model->setPDO ($resellerObj->getPDO());
            $res = $model->checkMerchantEmail($email);
        } else {
            $res = 'Enter an email';
        }
        echo json_encode($res);
    }

    public function checkGooglePlaceId($resellerObj, $pageParams){
        $googleId = $pageParams['request']['googleId'];
        if ($googleId){
            $model = $this->model('localthanks');
            $model->setPDO ($resellerObj->getPDO());
            $res = $model->checkGooglePlaceId($googleId);
        } else {
            $res = 'Enter an googleId';
        }
        echo json_encode($res);
    }

    public function getSuccessSurveyQA($resellerObj, $pageParams){
        $model = $this->model('localthanks');
        $model->setPDO ($resellerObj->getPDO());
        $res = $model->getSuccessSurveyQA();
        echo json_encode($res);
    }

    public function successSurveyUpdateMerchant($resellerObj, $pageParams){
        $model = $this->model('localthanks');
        $model->setPDO ($resellerObj->getPDO());
        $res = $model->successSurveyUpdateMerchant($pageParams['request']);
        echo json_encode($res);
    }

    public function getCategoryChildren($resellerObj, $pageParams)
    {   
        $parentCategoryId = $pageParams['request']['parentCategoryId'];
        if ($parentCategoryId){
            $model = $this->model('localthanks');
            $model->setPDO ($resellerObj->getPDO());
            $res = $model->getCategoryChildren($parentCategoryId);
        } else {
            $res = 'Enter a parentCategoryId';
        }
        echo json_encode($res);
    }

    public function getCategoryKeywords($resellerObj, $pageParams)
    {   
        $categoryId = $pageParams['request']['categoryId'];
        if ($categoryId){
            $model = $this->model('localthanks');
            $model->setPDO ($resellerObj->getPDO());
            $res = $model->getCategoryKeywords($categoryId);
        } else {
            $res = 'Enter a categoryId';
        }
        echo json_encode($res);
    }

    public function suggestKeyword ($resellerObj, $pageParams) {
        $request = $pageParams['request'];
        if ($request['suggestedKeyword']){
            $model = $this->model('localthanks');
            $model->setPDO ($resellerObj->getPDO());
            $res = $model->suggestKeyword($request);
        } else {
            $res = 'Enter a suggestedKeyword';
        }
        echo json_encode($res);
    }

    public function submitContactForm($resellerObj, $pageParams){
        $model = $this->model('localthanks');
        $model->setPDO ($resellerObj->getPDO());
        $res = $model->submitContactForm($pageParams['request']);
        echo json_encode($res);
    }
}