<?php
class App {
  protected $controller = 'home';
  protected $method = 'layout1';
  protected $params = [];
  protected $dbo = '';
  
  public function __construct()
  {

    //create database object
    require_once( '../app/models/database.php');
    $this->dbo = new database();

    //sitewide data
    require_once( '../app/models/sitewide.php');
    $sitewideObj = new sitewide ();

    $url = $this->parseUrl();
  
    //determine page controller
    if ($url) {
      if (file_exists('../app/controllers/' . $url[0] . '.php')){
        $this->controller = $url[0];
        unset($url[0]);
      }
      else {
        // bad page name entered
        $this->method='unknown_page';
        require_once('../app/controllers/_404.php');
        $this->controller = '_404';
      }
    }
    // get controller's name as string
    $tmpController = $this->controller;

    //set page controller
    require_once('../app/controllers/' . $this->controller . '.php');
    $this->controller = new $this->controller;

    //reseller data
	if (Controller::NEW_DB_SWITCH) {	
	    
		require_once( '../app/models/reseller.php');
	}	
	else {
		
		require_once( '../app/models/reseller_v1.php');
	}	
	
    $resellerObj = new reseller ($this->dbo, null, $sitewideObj->SUB_DOMAIN );
	$resellerData = $resellerObj->getResellerData();
	
    // METHOD
    if (isset($url[1])){
      if(method_exists($this->controller, $url[1])){
        $this->method = $url[1];
        unset($url[1]);
      }
    }

    // we need to query for method by subdomain but for now we'll just use this if statement:
  	$pagesOutput = array( 'therosienetwork' => array( 'home'=>'layout1', 'pricing'=>'layout1', 'privacy'=>'layout1', 'signup'=>'layout1', 'contact'=>'layout1', 'terms'=>'layout1' ),
                          'veteranslist'    => array( 'home'=>'layout1', 'pricing'=>'layout1', 'privacy'=>'layout1', 'signup'=>'layout1', 'contact'=>'layout1', 'terms'=>'layout1' ),
                          'templargroup'    => array( 'home'=>'layout_html', 'pricing'=>'layout1', 'privacy'=>'layout1', 'signup'=>'layout1', 'contact'=>'layout1', 'terms'=>'layout1' ),
                          'rosieoptions'    => array( 'home'=>'layout1', 'pricing'=>'layout1', 'privacy'=>'layout1', 'signup'=>'layout1', 'contact'=>'layout1', 'terms'=>'layout1' ),
                          'vbs'             => array( 'home'=>'layout1', 'pricing'=>'layout1', 'privacy'=>'layout1', 'signup'=>'layout1', 'contact'=>'layout1', 'terms'=>'layout1' ),
                          'fusion'          => array( 'home'=>'layout_html', 'pricing'=>'layout1', 'privacy'=>'layout1', 'signup'=>'layout1', 'contact'=>'layout1', 'terms'=>'layout1', 'footer'=>'custom' ),
                   'templargroupoptions'    => array( 'home'=>'layout_html', 'pricing'=>'layout1', 'privacy'=>'layout1', 'signup'=>'layout1', 'contact'=>'layout1', 'terms'=>'layout1' ),
                       'templargroupb2b'    => array( 'home'=>'layout_html', 'pricing'=>'layout1', 'privacy'=>'layout1', 'signup'=>'layout1', 'contact'=>'layout1', 'terms'=>'layout1' ),
                        ); //this is hard coded for now it is supposed to be in the database
                        
    // SWITCH METHOD BASED ON RESELLER
  	if (isset($pagesOutput[$sitewideObj->SUB_DOMAIN][$tmpController])){
  		$this->method =  $pagesOutput[$sitewideObj->SUB_DOMAIN][$tmpController];
  	}

    //PARAMETERS
    $this->params = $url ? array_values($url) : [];

    // get JSON request if any were POSTed
    $requestBody = @json_decode( file_get_contents('php://input'), true );  

    if ( $requestBody !== null && json_last_error() == JSON_ERROR_NONE ) {
      // add request to params
      $this->params['request'] = $requestBody;
    }

    // SET FOOTER PARAM
    if (isset($pagesOutput[$sitewideObj->SUB_DOMAIN]['footer'])){
      $this->params['footer'] =  $pagesOutput[$sitewideObj->SUB_DOMAIN]['footer'];
    }  

    if (empty($resellerData) && $this->controller instanceof Api == false){
        // bad subdomain entered && were not trying to access the API
        $this->method='unknown_method';
        require_once('../app/controllers/_404.php');
        $this->controller = new _404 ();
    }

    call_user_func_array([$this->controller, $this->method], array($resellerObj , $this->params));



  }

  public function parseUrl()
  {
    if (isset($_GET['url'])) {
      $url = rtrim($_GET['url'], '/');
      $url = filter_var($url, FILTER_SANITIZE_URL);
      return explode('/', $url);
    }
  }
}