<?php
include 'db_pw.php'; //sets DB_PASS

class database{


	private $host;
    private $user;
    private $pass;
    private $dbname;

    private $dbh;
    private $error;
	private $stmt;
 
    public function __construct(){

		include 'db_pw.php'; //sets dbpw
	    $this->host      = $dbpw['host'];
	    $this->user      = $dbpw['user'];
	    $this->pass      = $dbpw['pass'];
	    $this->dbname    = $dbpw['name'];


        // Set DSN
        $dsn = 'mysql:host=' . $this->host . ';dbname=' . $this->dbname;
        // Set options
        $options = array(
            PDO::ATTR_PERSISTENT    => true,
            PDO::ATTR_ERRMODE       => PDO::ERRMODE_EXCEPTION
        );
        
        // Create a new PDO instanace
        try{
            $this->dbh = new PDO($dsn, $this->user, $this->pass, $options);
        }
        // Catch any errors
        catch(PDOException $e){
            $this->error = $e->getMessage();
        }
    }

	public function query($query){
	    $this->stmt = $this->dbh->prepare($query);
	}

	public function bind($param, $value, $type = null){
	    if (is_null($type)) {
	        switch (true) {
	            case is_int($value):
	                $type = PDO::PARAM_INT;
	                break;
	            case is_bool($value):
	                $type = PDO::PARAM_BOOL;
	                break;
	            case is_null($value):
	                $type = PDO::PARAM_NULL;
	                break;
	            default:
	                $type = PDO::PARAM_STR;
	        }
	    }
	    $this->stmt->bindValue($param, $value, $type);
	}

	public function execute(){
	    return $this->stmt->execute();
	}

	public function resultset(){ //returns an array of the result set rows
	    $this->execute();
	    return $this->stmt->fetchAll(PDO::FETCH_ASSOC);
	}

	public function single(){ //returns a single record
	    $this->execute();
	    return $this->stmt->fetch(PDO::FETCH_ASSOC);
	}

	public function rowCount(){ //returns the number of effected rows
	    return $this->stmt->rowCount();
	}

	public function closeCursor(){
		return $this->stmt->closeCursor();
	}

	public function lastInsertId(){ //returns the last inserted Id as a string
	    return $this->dbh->lastInsertId();
	}

	public function beginTransaction(){
	    return $this->dbh->beginTransaction();
	}

	public function endTransaction(){
	    return $this->dbh->commit();
	}

	public function cancelTransaction(){
	    return $this->dbh->rollBack();
	}

	public function debugDumpParams(){
	    return $this->stmt->debugDumpParams();
	}


}

$dbo = new Database();

/*
EXAMPLES

// Instantiate database.
$db = new Database();

//insert
$db->query('INSERT INTO mytable (FName, LName, Age, Gender) VALUES (:fname, :lname, :age, :gender)');
$db->bind(':fname', 'John');
$db->bind(':lname', 'Smith');
$db->bind(':age', '24');
$db->bind(':gender', 'male');
$db->execute();
echo $db->lastInsertId();

//transaction
$db->beginTransaction();
$db->query('INSERT INTO mytable (FName, LName, Age, Gender) VALUES (:fname, :lname, :age, :gender)');
$db->bind(':fname', 'Jenny');
$db->bind(':lname', 'Smith');
$db->bind(':age', '23');
$db->bind(':gender', 'female');
$db->execute();

$db->bind(':fname', 'Jilly', int);
$db->bind(':lname', 'Smith');
$db->bind(':age', '25');
$db->bind(':gender', 'female');
$db->execute();
echo $db->lastInsertId();
$db->endTransaction();

//Single
$db->query('SELECT FName, LName, Age, Gender FROM mytable WHERE FName = :fname');
$db->bind(':fname', 'Jenny');
$row = $db->single();
echo "<pre>";
print_r($row);
echo "</pre>";


//multiple rows
$db->query('SELECT FName, LName, Age, Gender FROM mytable WHERE LName = :lname');
$db->bind(':lname', 'Smith');
$rows = $db->resultset();
echo "<pre>";
print_r($rows);
echo "</pre>";
echo $db->rowCount();
*/
