<?php
class localthanks_v1 {
	private $dbObj = null;

	function signupProcessForm($formData){
		require_once 'sitewide.php';
		$sitewide = new sitewide ();
		require_once '../../app/class.variables.php';
		// require_once 'database.php';
		require_once 'prismpay.php';
		// $this->dbObj = new database();
		
		// class variables
		$cv = new _variables($formData);
		$fields=array(
			'abc_cc_ltm_state',
			'abc_ltm_state_r',
			'adn_ccnum_r',
			'ema_ltb_email_r',
			'dec2_cc_expmon_r',
			'dec4_cc_expyear_r',
			'dec_cc_ccv_r',
			'nam_cc_cardholder_r',
			'nam_cc_ltm_city',
			'nam_ltb_contact_first_name_r',
			'nam_ltb_contact_last_name_r',
			'nam_ltm_city_r',
			'pho_ltm_phone_number_r',
			'psw_ltb_password2_r',
			'psw_ltb_password_r',
			'txt64_ltm_company_name_r',
			'txt64_ltm_google_id',
			'txt_cc_ltm_address',
			'txt_ltm_address_r',
			'zip_cc_ltm_zipcode',
			'zip_ltm_zipcode_r',
			'dec_lmp_id_r',
			'dec_ltm_lat_r',
			'dec_ltm_lng_r',
			'dec_res_id_r',
			'txt32_subid_r'
		);

		if (isset($formData['bit_use_biz_addr'])){
			array_push($fields, 'bit_use_biz_addr');
		}

		foreach($fields as $name=>$value){$cv->varible_in($value);}
		$_v=$cv->get_cleaned_variables();
		$errors=$cv->get_bad_variables();
		
		if ($formData['psw_ltb_password_r'] !== $formData['psw_ltb_password2_r']){
			array_push($errors, array('psw_ltb_password_r' => 'Passwords must match'));
		}

		if (!$errors){
			// $this->dbObj->query('SELECT ltb_email FROM lt_member_merchants WHERE ltb_email = :ltb_email LIMIT 1');		
			// $this->dbObj->bind(':ltb_email', $_v['ltb_email'], PDO::PARAM_INT);
			// $this->dbObj->execute();	
			// $emailTaken = $this->dbObj->resultset();
			$emailTaken = $this->checkMerchantEmail($_v['ltb_email']);
			if ($emailTaken === "Taken"){
				array_push($errors, array('ema_ltb_email_r' => 'Email already registered'));
			}
		}

		if (!$errors){

			$this->dbObj->query('SELECT LMP.lmp_id, LMP.lmp_name, LMP.lmp_admin_name, LMP.pty_id, LMP.lmp_price, LMP.lmp_fee, LMP.lmp_billing_delay,
			LMP.lmp_description, LMP.lmp_custom_terms, LMP.lmp_custom_breakdown, LMP.pty_id, LMP.lmp_featured, LPF.lpf_feature, LPF.lpf_id, MFC.mfc_count
			FROM lt_merchant_plans LMP 
			INNER JOIN lt_plans2reseller P2R ON LMP.lmp_id = P2R.lmp_id
			INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id 
			LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
			WHERE P2R.res_id = :res_id AND LMP.lmp_id = :lmp_id AND LMP.lmp_active = 1 AND LPF.lpf_active = 1 AND MFC.ltb_id IS NULL');
			
			$this->dbObj->bind(':lmp_id', $_v['lmp_id'], PDO::PARAM_INT);
			$this->dbObj->bind(':res_id', $_v['res_id'], PDO::PARAM_INT);
			$this->dbObj->execute();
			$qry = $this->dbObj->resultset();		
			
			if( !isset( $qry[0] ) ) {
				$response['status'] = 'error';
				$response['error']  = array('dec_lmp_id_r'=>'Plan Does Not Exist'); // this error should only appear if someone changes the hidden form field
				return $response;
				exit();
			} 
			else {			
				foreach ($qry as $k => $v) {
				if (!$chosen_plan){
					$chosen_plan = array(
					'lmp_id'                => $v['lmp_id'],
					'pty_id'                => $v['pty_id'],
					'lmp_name'              => $v['lmp_name'],
					'lmp_price'             => $v['lmp_price'],
					'lmp_fee'               => $v['lmp_fee'],
					'lmp_billing_delay'     => $v['lmp_billing_delay'],
					'lmp_features'      	  	  => array()
					);
					$chosen_plan['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
				} 
				else {
					$chosen_plan['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
				}
				}
			}

			// require processpayment function
			//require '../../includes/function.processpayment.php';
			// set credit card payment variables
			$uri = array(
				'action' => 'ns_quicksale_cc',
				'emailto'=> $sitewide::CSR_FORM_EMAIL, // ALL RECEIPTS FROM 4MY.STORE goto CSR_FORM_EMAIL
				'emailsubject' => '4My.Store Receipt',
				'ccname' => $_v['cc_cardholder'],
				'ccnum'  => $_v['ccnum'],
				'cvv2'   => $_v['cc_ccv'],
				'expmon' => $_v['cc_expmon'],
				'expyear'=> $_v['cc_expyear'],
				'recur_create ' => 1,
				'recur_billingmax' => -1,
				'recur_billingcycle' => 2,//monthly
				'ci_email' => $_v['ltb_email'],
				'ci_billaddr1' => $_v['ltm_address'],
				'ci_billcity' => $_v['ltm_city'],
				'ci_billzip' => $_v['ltm_zipcode'],
				'ci_billstate' => $_v['ltm_state'],
				'subid'=> $_v['subid']
			);
			// billing address is the same as business address?
			if (isset($_v['use_biz_addr']) == false){
				$uri['ci_billaddr1'] = $_v['cc_ltm_address'];
				$uri['ci_billcity']  = $_v['cc_ltm_city'];
				$uri['ci_billzip']	 = $_v['cc_ltm_zipcode'];
				$uri['ci_billstate'] = $_v['cc_ltm_state'];
			}
			$uri['recur_amount'] = floatval($chosen_plan['lmp_price']) * 100; // amounts are passed in cents, so we take the price and multiply by 100

			if (intval($chosen_plan['lmp_billing_delay']) === 0){
				// monthly billing is *not* delayed, charge setup + first month's fee, then begin recurring payments 1 month from today.
				$uri['amount'] = (floatval($chosen_plan['lmp_price']) + floatval($chosen_plan['lmp_fee'])) * 100; // amounts are passed in cents, so we take the price + fee and multiply by 100
				$startTime = strtotime('now');
				$endTime   = strtotime('now +1 month');
				$timeDiff  = abs($endTime - $startTime);
				$delayDays = $timeDiff/86400; // 86400 seconds in one day
				$startCycle = date('Y-m-d',$endTime);
				$uri['recur_start'] = intval($delayDays);
			} else {
				// monthly billing is delayed -- only charge setup fee
				$startTime = strtotime('now');
				$endTime   = strtotime('now +'.intval($chosen_plan['lmp_billing_delay']).' months');
				$timeDiff  = abs($endTime - $startTime);
				$delayDays = $timeDiff/86400; // 86400 seconds in one day
				$startCycle = date('Y-m-d',$endTime);
				$uri['recur_start'] = intval($delayDays);
				// if the monthly bill is delayed && the setup fee is 0, we have to charge a minimum of 1 cent.
				$uri['amount'] = (floatval($chosen_plan['lmp_fee']) * 100 == 0 ? 0.01 : floatval($chosen_plan['lmp_fee']) * 100); // amounts are passed in cents, so we take the fee and multiply by 100
			}
			// echo '<pre>';
			// var_dump($uri);
			// echo '</pre>';
			// process payment
			$thisPay =  prismpay::_appProcessPayment( $uri );
			// check payment status
			if ($thisPay['status'] == "Declined" ) {
				$reason = explode( ':', str_replace('..', '', $thisPay['reason']) );
				$response['status'] = 'error';
				$response['error']  = array('adn_ccnum_r'=>' Credit Card Declined: '.$reason[2]);
				return $response;
				exit();
			}
			else if ( $thisPay['status'] == "Accepted" ){

				// encrypt the password
				require '../../app/model/crypt.php';
				$crypt   = new Crypt( $_v['ltb_email'] );
				$cryptck = $crypt->encode( $_v['ltb_password'] );

				$this->dbObj->query("INSERT INTO `lt_member_merchants`(res_id,lmp_id,pty_id,ltb_slug,ltb_phone_number,ltb_contact_name,ltb_email,ltb_password,ltb_datecreated,ltb_timestamp,ltb_active) 
				VALUES (:res_id,:lmp_id,:pty_id,:slug,:ltm_phone_number,:ltb_contact_name,:ltb_email,:ltb_password,now(),now(),1)");
				
				$this->dbObj->bind(':res_id', $_v['res_id'], PDO::PARAM_INT);
				$this->dbObj->bind(':pty_id', $chosen_plan['pty_id'], PDO::PARAM_INT);
				$this->dbObj->bind(':lmp_id', $chosen_plan['lmp_id'], PDO::PARAM_INT);
				$this->dbObj->bind(':ltm_phone_number', $_v['ltm_phone_number'], PDO::PARAM_STR);
				$this->dbObj->bind(':ltb_contact_name', ucwords( strtolower( $_v['ltb_contact_first_name'].' '.$_v['ltb_contact_last_name'] ) ), PDO::PARAM_STR);
				$this->dbObj->bind(':ltb_email', $_v['ltb_email'], PDO::PARAM_STR);
				$this->dbObj->bind(':slug', strtolower(preg_replace("/[^A-Za-z0-9 ]/", '', $_v['ltb_email'])), PDO::PARAM_STR); // momentary placeholder until we get lastInsertId();
				$this->dbObj->bind(':ltb_password', $cryptck, PDO::PARAM_STR);
				$this->dbObj->execute();
				
				$ltb_id = $this->dbObj->lastInsertId();

				// add store
				$this->dbObj->query("INSERT INTO `lt_merchants` (ltb_id,ltm_google_id,ltm_company_name,ltm_lat,ltm_long,ltm_address,ltm_city,ltm_state,ltm_zipcode,ltm_phone_number,ltm_registerdate,ltm_active) VALUES (:ltb_id,:ltm_google_id,:ltm_company_name,:ltm_lat,:ltm_long,:ltm_address,:ltm_city,:ltm_state,:ltm_zipcode,:ltm_phone_number,now(),1)");
				
				$this->dbObj->bind(':ltb_id', $ltb_id, PDO::PARAM_STR);
				$this->dbObj->bind(':ltm_google_id', $_v['ltm_google_id'], PDO::PARAM_STR);
				$this->dbObj->bind(':ltm_company_name', $_v['ltm_company_name'], PDO::PARAM_STR);
				$this->dbObj->bind(':ltm_lat', $_v['ltm_lat'], PDO::PARAM_STR);
				$this->dbObj->bind(':ltm_long', $_v['ltm_lng'], PDO::PARAM_STR);
				$this->dbObj->bind(':ltm_address', $_v['ltm_address'], PDO::PARAM_STR);
				$this->dbObj->bind(':ltm_city', $_v['ltm_city'], PDO::PARAM_STR);
				$this->dbObj->bind(':ltm_state', $_v['ltm_state'], PDO::PARAM_STR);
				$this->dbObj->bind(':ltm_zipcode', $_v['ltm_zipcode'], PDO::PARAM_STR);
				$this->dbObj->bind(':ltm_phone_number', $_v['ltm_phone_number'], PDO::PARAM_STR);    
				$this->dbObj->execute();
				$ltm_id = $this->dbObj->lastInsertId();

				// begin slug creation
				function checkMerchantSlug($_slug, $dbObj){
					// check if URL slug already exists in our system
					// global $this->dbObj;
					$dbObj->query("SELECT LTB.ltb_slug, BS.bs_slug FROM `lt_member_merchants` LTB, `lt_bad_slugs` BS WHERE ltb_slug=:slug OR bs_slug=:slug LIMIT 1");			  
					$dbObj->bind(':slug', $_slug, PDO::PARAM_STR);
					$dbObj->execute();
					$qry = $dbObj->resultset();
					if( !isset( $qry[0] ) ) { 
						return true; // available
					} else {
						return false; // taken
					}
				}

				$our_slug = strtolower(preg_replace("/[^A-Za-z0-9 ]/", '', $_v['ltm_company_name']));
				$our_slug = str_replace(" ","-",$our_slug);
				$check_slug = checkMerchantSlug($our_slug, $this->dbObj);
				if ($check_slug===false){
				// duplicate slug, add ltb_id to end, check if under 64 characters, if not, minus ltb_id.length from slug then add ltb_id
				$new_slug = $our_slug.'-'.$ltb_id;
				if (strlen($new_slug)>64){
					// new slug is over 64 characters long, trim it
					$slug_overlap = strlen($new_slug)-64;
					$new_slug = substr($our_slug, 0, ($slug_overlap*-1)); // remove the # of overlap characters from the initial slug to make it fit into 64 characters
					$our_slug = $new_slug.'-'.$ltb_id;
				} else {
					$our_slug = $new_slug;
				}
				}

				// update slug
				$this->dbObj->query( "UPDATE `lt_member_merchants` SET ltb_slug=:slug WHERE ltb_id=:id LIMIT 1" );
				$this->dbObj->bind(':id', $ltb_id, PDO::PARAM_INT);
				$this->dbObj->bind(':slug', $our_slug, PDO::PARAM_STR);
				$this->dbObj->execute();	    
				
				// set a default category
				$this->dbObj->query( "INSERT INTO `lt_m2cat` (ltb_id,cat_id) VALUES (:ltb_id, 543)" );		    
				$this->dbObj->bind(':ltb_id', $ltb_id, PDO::PARAM_STR);
				$this->dbObj->execute();

				// update merchant feature counts
				foreach ($chosen_plan['lmp_features'] as $k=>$v){
					switch ($v['lpf_id']){
					//case 9:  // catalog points
					case 13: // monthly emails
					case 14: // sms texts
					case 15: // push notifications
						$this->dbObj->query( "INSERT INTO `lt_feature_cnt` (lfc_count, lpf_id, ltb_id) VALUES (:count, :lpf_id, :ltb_id)" );
						$this->dbObj->bind(':ltb_id', $ltb_id, PDO::PARAM_INT);
						$this->dbObj->bind(':lpf_id', $v['lpf_id'], PDO::PARAM_INT);
						$this->dbObj->bind(':count', $v['mfc_count'], PDO::PARAM_INT);
						$this->dbObj->execute();
					break;
					default:
					break;
					}
				}

				// insert lt_merchant_billing table
				$this->dbObj->query( "INSERT INTO `lt_merchant_billing` (ltm_id, lmp_id, bill_name, bill_address1, bill_state, bill_city, bill_zip, bill_accountnumber, bill_orderid, bill_cyclestart, bill_fee, bill_price) VALUES (:id,:lmp_id,:bill_name,:bill_address1,:bill_state,:bill_city,:bill_zip,:bill_accountnumber,:orderid, :cyclestart, :bill_fee, :bill_price)" );
				$this->dbObj->bind(':id', $ltm_id, PDO::PARAM_STR);
				$this->dbObj->bind(':lmp_id', $chosen_plan['lmp_id'], PDO::PARAM_INT);
				$this->dbObj->bind(':bill_fee', $chosen_plan['lmp_fee'], PDO::PARAM_STR);
				$this->dbObj->bind(':bill_price', $chosen_plan['lmp_price'], PDO::PARAM_STR);
				$this->dbObj->bind(':bill_name', $_v['cc_cardholder'], PDO::PARAM_STR);
				$this->dbObj->bind(':bill_address1', $uri['ci_billaddr1'], PDO::PARAM_STR);
				$this->dbObj->bind(':bill_state', $uri['ci_billstate'], PDO::PARAM_STR);
				$this->dbObj->bind(':bill_city', $uri['ci_billcity'], PDO::PARAM_STR);
				$this->dbObj->bind(':bill_zip', $uri['ci_billzip'], PDO::PARAM_STR);
				$this->dbObj->bind(':bill_accountnumber', $thisPay["accountnumber"], PDO::PARAM_STR);
				$this->dbObj->bind(':orderid', $thisPay['orderid'], PDO::PARAM_STR);
				$this->dbObj->bind(':cyclestart', $startCycle, PDO::PARAM_STR);
				$this->dbObj->execute();
				
				$response['lmp_id'] = $chosen_plan['lmp_id'];
				
				// welcome paid merchant email
				// $ema_body = file_get_contents('../../../mail/localthanks/website/merchant_payment_welcome/merchant_payment_welcome.html');
				// $ema_email = $_v['ltb_email'];
				// $ema_ltm_id = $ltm_id;
				// $amountCharged = $uri['amount'] == 0.01? $uri['amount'] : $uri['amount'] / 100;
				// $amountCharged = strpos( $amountCharged , '.' ) === false? $amountCharged.'.00' : ( strlen($amountCharged) - 2 == strpos($amountCharged , '.')? $amountCharged . '.0' : $amountCharged);
				// $ema_message = '<p>Your payment of <span style="color: #0079FE; font-weight: bold;">$' . $amountCharged . '</span> was processesd.<p><p>Your <span style="color: #0079FE; font-weight: bold;">'.$chosen_plan['lmp_name'].' Membership</span> is now active under the following email address:</p><p style="margin: 0;"><span style="color: #0079FE; font-weight: bold;">'.$_v['ltb_email'].'</span></p>';
				// include '../../includes/build-email.php';
				// $to       = $ema_email;
				// $subject  = 'Welcome to Local Thanks!';
				// $message  = $ema_body;
				// $headers  = "From: noreply@localthanks.com\r\n";
				// $headers .= "Reply-To: noreply@localthanks.com\r\n";
				// $headers .= "MIME-Version: 1.0\r\n";
				// $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
				// mail($to, $subject, $message, $headers);

				// set sessions so user can set their business settings on the next page and go directly to MyStore after
				$_SESSION['user']['merchant']['ltb_id'] = $ltb_id;
				$_SESSION['user']['merchant']['ltm_id']	= $ltm_id;
				$_SESSION['user']['merchant']['ltb_email']	= $_v['ltb_email'];
				$_SESSION['user']['merchant']['ltm_company_name'] = $_v['ltm_company_name'];
				$_SESSION['user']['merchant']['res_id'] = $_v['res_id'];
				$_SESSION['user']['merchant']['promo_count'] = "0";
				$_SESSION['user']['merchant']['tmp_id'] = "1";
				$_SESSION['user']['merchant']['plan']	= $chosen_plan;
				$_SESSION['user']['merchant']['date']	= date('m/d/Y');
				$response['session'] = $_SESSION;
				$response['status'] = 'success';
				return $response;
				exit();
			}
		} 
		else {
			$response['status'] = 'error';
			$response['error']  = $errors;
			return $response;
			exit();
		}
	}

	function signupProcessFormStep3 ($request){
		require_once 'sitewide.php';
		$sitewide = new sitewide ();
		$response = [];
		$response['status'] = '';
		$response['request'] = $request;
		require '../../app/class.variables.php';

		$fields=array(
			// 'dec_cat_id_r',
			'txt255_ltb_description_r',
			'dec_payment_methods_r'
		);

		if (isset($request['url_ltb_web_url'])){
			$request['url_ltb_web_url'] = trim($request['url_ltb_web_url']);
			if (!preg_match('#^https?://#i', $request['url_ltb_web_url']) && !empty($request['url_ltb_web_url'])) {
				$request['url_ltb_web_url'] = "http://{$request['url_ltb_web_url']}";
			}
			array_push($fields, 'url_ltb_web_url');
		}

		// if (isset($request['dec_keyword_selection'])){
		// 	if (count($request['keyword_selection']) > $_SESSION['user']['merchant']['plan']['lmp_features'][17]['mfc_count']){
		// 		$response['status'] = 'error';
		// 		$response['error']  = array('dec_keyword_selection'=>'Maximum of '.$_SESSION['user']['merchant']['plan']['lmp_features'][17]['mfc_count'].' keywords allowed.');
		// 		return $response;
		// 		exit();
		// 	}
		// 	array_push($fields, 'dec_keyword_selection');
		// }

		// class variables
		$cv = new _variables($request);
		
		foreach($fields as $name=>$value){
			$response['var_check_values'] .= $value . ' | ';
			$cv->varible_in($value);
		}
		$_v=$cv->get_cleaned_variables();
		$errors=$cv->get_bad_variables();

		if (!$errors){
			// update category
			// $sql = 'UPDATE `lt_m2cat` SET cat_id=:cat_id WHERE ltb_id=:ltb_id';
			// $this->dbObj->query($sql);
			// $this->dbObj->bind(':cat_id', $_v['cat_id'], PDO::PARAM_INT);
			// $this->dbObj->bind(':ltb_id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_INT);
			// $this->dbObj->execute();

			// update web url && description
			$sql = 'UPDATE `lt_member_merchants` SET ltb_web_url=:ltb_web_url, ltb_description=:ltb_description WHERE ltb_id=:ltb_id';
			$this->dbObj->query($sql);
			$this->dbObj->bind(':ltb_web_url', $_v['ltb_web_url'], PDO::PARAM_STR);
			$this->dbObj->bind(':ltb_description', $_v['ltb_description'], PDO::PARAM_STR);
			$this->dbObj->bind(':ltb_id', $_SESSION['user']['merchant']['ltb_id'], PDO::PARAM_INT);
			$this->dbObj->execute();
			
			// function insertKeyword($key_id, $ltb_id, $dbObj){
			// 	$sql = 'INSERT INTO tbl_m2keyword (ltb_id, key_id) VALUES (:ltb_id, :key_id)';
			// 	$dbObj->query($sql);
			// 	$dbObj->bind(':key_id', $key_id, PDO::PARAM_INT);
			// 	$dbObj->bind(':ltb_id', $ltb_id, PDO::PARAM_INT);
			// 	$dbObj->execute();
			// }

			// // insert keyword(s)
			// if (is_array($_v['keyword_selection'])){
			// 	foreach($_v['keyword_selection'] as $key=>$value){
			// 		insertKeyword($value, $_SESSION['user']['merchant']['ltb_id'], $this->dbObj);
			// 	}
			// } else if (isset($_v['keyword_selection'])){
			// 	insertKeyword($_v['keyword_selection'], $_SESSION['user']['merchant']['ltb_id'], $this->dbObj);
			// }

			function insertPaymentMethod($ccd_id, $ltb_id, $dbObj){
				$sql = "INSERT INTO `lt_m2ccards` (ltb_id, ccd_id) VALUES (:ltb_id, :ccd_id)";
				$dbObj->query( $sql );
				$dbObj->bind(':ltb_id', $ltb_id, PDO::PARAM_INT);
				$dbObj->bind(':ccd_id', $ccd_id, PDO::PARAM_INT);    
				$dbObj->execute();
			}

			// add payment methods
			if (is_array($_v['payment_methods'])){
				foreach ($_v['payment_methods'] as $k=>$v){
					insertPaymentMethod($v, $_SESSION['user']['merchant']['ltb_id'], $this->dbObj);
				}
			} else {
				insertPaymentMethod($_v['payment_methods'], $_SESSION['user']['merchant']['ltb_id'], $this->dbObj);
			}

			// add store hours
			$storeHours = $request['store-hours'] = json_decode($request['store-hours']);
			$last_open=$last_close='';
			$range_start=1;
			for ($i=1; $i<=8; $i++) {
		      $open = $storeHours[$i-1]->timeFrom;
		      if($open!='') $open = date("H:i", strtotime($storeHours[$i-1]->timeFrom));
		      $close = date("H:i", strtotime($storeHours[$i-1]->timeTill));
		      $appointmentOnly = ($storeHours[$i-1]->appointmentOnly ? 1 : 0);
		      // group days together if their hours match the previous day's hours
		      if (($open != $last_open || $close != $last_close || $appointmentOnly != $last_appt || $i==8) && $i>1) {
		        $firstday = $range_start;
		        $lastday = $i - 1;
		        $opentime = $last_open;
		        $closetime = $last_close;
		        $apptOnly = $last_appt;
		        
		        if ($opentime != ''){
		          //echo $firstday . ' - ' . $lastday . ' open: ' . $opentime . ' closed: ' . $closetime . '<br>';
		          $sql = "INSERT INTO `lt_merchant_hours` (ltm_id,lth_open,lth_close,lth_start_day_num,lth_end_day_num,lth_appointment_only) VALUES (:ltm_id,:opentime,:closetime,:firstday,:lastday,:apptOnly)";
		          $this->dbObj->query( $sql );
		          $this->dbObj->bind(':ltm_id', $_SESSION['user']['merchant']['ltm_id'], PDO::PARAM_INT);
		          $this->dbObj->bind(':opentime', $opentime, PDO::PARAM_STR);
		          $this->dbObj->bind(':closetime', $closetime, PDO::PARAM_STR);
		          $this->dbObj->bind(':firstday', $firstday, PDO::PARAM_INT);
		          $this->dbObj->bind(':lastday', $lastday, PDO::PARAM_INT);
		          $this->dbObj->bind(':apptOnly', $apptOnly, PDO::PARAM_INT);
		          $this->dbObj->execute();
		        }
		        $range_start = $i;
		      }
		      $last_open=$open;
		      $last_close=$close;
		      $last_appt=$appointmentOnly;
			}
			$response['payload'] = $_v;
			$response['status'] = 'success';
			return $response;
			exit();
		} 
		else {
			$response['status'] = 'error';
			$response['error']  = $errors;
			return $response;
			exit();
		}
	}

	function suggestKeyword ($request) {
		// require '../../includes/global.php';
		$response['status']='';

		// sanitize user suggested keyword
		$keyword = htmlspecialchars(preg_replace("/[^A-Za-z0-9 ]/", '', $request['suggestedKeyword']));

		// check if keyword already exists
		$this->dbObj->query("SELECT key_id, key_word FROM tbl_keywords WHERE key_word=:keyword LIMIT 1");
		$this->dbObj->bind(':keyword', $keyword, PDO::PARAM_STR);
		$this->dbObj->execute();
		$qry = $this->dbObj->resultset();
		if (count($qry)){
			$keyId = $qry[0]['key_id'];
			$response['msg'] = 'That keyword exists or has already been suggested.';
		} else {
			if ( isset( $_SESSION['user']['admin']['adm_id'] ) ) {
				$_keywordStatus = 'active';
				$_keywordActive = 1;
			} 
			else {
				$_keywordStatus = 'suggested';
				$_keywordActive = null;
			}
			// add keyword to database, set status to "active or suggested"
			$this->dbObj->query("INSERT INTO tbl_keywords (key_word, key_type, key_active) VALUES (:keyword, :status, :active)");
			$this->dbObj->bind(':keyword', $keyword, PDO::PARAM_STR);
			$this->dbObj->bind(':status', $_keywordStatus, PDO::PARAM_STR);
			$this->dbObj->bind(':active', $_keywordActive, PDO::PARAM_INT);
			$this->dbObj->execute();
			$keyId = $this->dbObj->lastInsertId();
			$response['status']='success';
			$response['msg'] = "Added '{$keyword}' to the suggested keywords list!";
		}
		$response['test']=array('cat'=>$request['catid'], 'key'=>$keyId);
		if ( isset( $request['catid'], $_SESSION['user']['admin']['adm_id'] ) && !empty($request['catid']) && preg_match('/^[0-9]{1,11}?$/', $request['catid']) && $keyId ) {
			// add keyword to the sub-category, table tbl_c2keyword
			$this->dbObj->query("INSERT INTO tbl_c2keyword (cat_id, key_id)		
					SELECT * FROM (SELECT :catid, :keyid) AS tmp 
					WHERE NOT EXISTS (
						SELECT 1 FROM tbl_c2keyword WHERE cat_id = :catid AND key_id = :keyid
			) LIMIT 1");
			$this->dbObj->bind(':keyid', $keyId, PDO::PARAM_INT);
			$this->dbObj->bind(':catid', $request['catid'], PDO::PARAM_INT);			
			$this->dbObj->execute();
			$c2keyId = $this->dbObj->lastInsertId();
			if ($c2keyId) {$response['cat_id'] = $request['catid'];}
			$response['msg'] = "Added '{$keyword}' to the keywords list!";
		}

		return $response;
	}

	function getSuccessSurveyQA(){
		// success survey questions
		$this->dbObj->query("SELECT SVQ.svq_id, SVQ.svq_question, SVQ.svq_parent_id, SVI.svi_id, SVI.svi_label, SVI.svi_type
		FROM tbl_survey_questions SVQ 
		INNER JOIN tbl_survey_inputs SVI ON SVQ.svq_id = SVI.svq_id
		ORDER BY SVQ.svq_id, SVI.svi_order, SVI.svq_id, SVI.svi_id");
		$qry = $this->dbObj->resultset();
		foreach ($qry as $k => $v) {
			if (!$response['survey_questions'][$v['svq_id']]){
			$response['survey_questions'][$v['svq_id']] = array(
				'id'        => $v['svq_id'],
				'question'  => $v['svq_question'],
				'parent_id' => $v['svq_parent_id'],
				'inputs'    => array(array('id'=> $v['svi_id'], 'label'=>$v['svi_label'], 'type'=>$v['svi_type'], 'order'=>$v['svi_order'], 'checked'=>false, 'text'=>null))
			);
			} 
			else {
			$next_input = array('id'=> $v['svi_id'], 'label'=>$v['svi_label'], 'type'=>$v['svi_type'], 'order'=>$v['svi_order']);
			array_push($response['survey_questions'][$v['svq_id']]['inputs'], $next_input);
			}
		}
		return $response;
	}

	function successSurveyUpdateMerchant ($formData){
		$response = [];
		$response['status'] = 'empty';

		if (isset($_SESSION['user']['merchant']['ltb_id']) === FALSE){
			$response['status'] = 'error';
			$response['error'] = 'User not logged in. Session not set.';
			return $response;
		} else {

		$response['formdata'] = $formData;

		function insertSurveyAnswer($svi_id, $svq_id, $ltb_id, $dbo){
			if (is_numeric($svq_id) && is_numeric($svi_id) && is_numeric($ltb_id)){
				$dbo->query("INSERT INTO tbl_survey_answers (svi_id, svq_id, ltb_id) VALUES (:svi_id, :svq_id, :ltb_id)");
				$dbo->bind(':svi_id', $svi_id, PDO::PARAM_INT);
				$dbo->bind(':svq_id', $svq_id, PDO::PARAM_INT);
				$dbo->bind(':ltb_id', $ltb_id, PDO::PARAM_INT);
				$dbo->execute();
			}
		}

		function insertSurveyAnswerText($svi_id, $ltb_id, $text, $dbo){
			if (is_numeric($svi_id) && is_numeric($ltb_id) && $text !== ''){
				$dbo->query("INSERT INTO tbl_survey_answers_text (svt_text, svi_id, ltb_id) VALUES (:svt_text, :svi_id, :ltb_id)");
				$dbo->bind(':svt_text', $text, PDO::PARAM_STR);
				$dbo->bind(':svi_id', $svi_id, PDO::PARAM_INT);
				$dbo->bind(':ltb_id', $ltb_id, PDO::PARAM_INT);
				$dbo->execute();
			}
		}

		// delete previous answers
		$this->dbObj->query("DELETE FROM tbl_survey_answers WHERE ltb_id=:ltb_id; OPTIMIZE TABLE tbl_survey_answers");
		$this->dbObj->bind(':ltb_id', $_SESSION['user']['merchant']['ltb_id']);
		$this->dbObj->execute();
		$this->dbObj->closeCursor();

		$this->dbObj->query("DELETE FROM tbl_survey_answers_text WHERE ltb_id=:ltb_id; OPTIMIZE TABLE tbl_survey_answers_text");
		$this->dbObj->bind(':ltb_id', $_SESSION['user']['merchant']['ltb_id']);
		$this->dbObj->execute();
		$this->dbObj->closeCursor();

		foreach ($formData as $k=>$v){
			$arr = explode('-', $k);
			if ($arr[0] == 'TEXT'){

			if ($arr[1] == 'ONLY'){
				// text only input
				// input id
				$svi_id = explode('_', $arr[2]);
				$svi_id = $svi_id[2];

				// question id
				$svq_id = explode('_', $arr[3]);
				$svq_id = $svq_id[2];

				// sanitize value
				$text = trim(htmlspecialchars(strip_tags($v)));

				// insert
				insertSurveyAnswer($svi_id, $svq_id, $_SESSION['user']['merchant']['ltb_id'], $this->dbObj);
				insertSurveyAnswerText($svi_id, $_SESSION['user']['merchant']['ltb_id'], $text, $this->dbObj);

			} else {
				// text + radio or check mark
				// input id
				$svi_id = explode('_', $arr[1]);
				$svi_id = $svi_id[2];

				// question id
				$svq_id = explode('_', $arr[2]);
				$svq_id = $svq_id[2];

				// sanitize value
				$text = trim(htmlspecialchars(strip_tags($v)));
				// insertSurveyAnswer() will be handled seperately since this input had both a checkbox/radio & text box
				insertSurveyAnswerText($svi_id, $_SESSION['user']['merchant']['ltb_id'], $text, $this->dbObj);
			}

			} else {

			$arr = explode('_', $k);

			if ($arr[0] == 'svq'){

				$svq_id = $arr[2];

				if (is_array($v)){

				foreach ($v as $aKey=>$aVal){
					$svi_id = $aVal;
					insertSurveyAnswer($svi_id, $svq_id, $_SESSION['user']['merchant']['ltb_id'], $this->dbObj);
				}

				} else {
					$svi_id = $v;
					insertSurveyAnswer($svi_id, $svq_id, $_SESSION['user']['merchant']['ltb_id'], $this->dbObj);
				}
			}
			}
		}
		
		$response['post'] = $formData;
		$response['status'] = 'success';
		return $response;
		}
	}

	function submitContactForm($formData){
		$response = [];
		$response['status'] = '';
		require_once 'sitewide.php';
		$sitewide = new sitewide ();
		require_once '../../app/class.variables.php';

		// class variables
		$cv = new _variables($formData);
		$fields=array(
			'txt255_comment_r',
			'txt64_name_r',
			'ema_email_r',
			'pho_phone_r',
			'txt64_business-name_r',
			'txt_res_name',
			'txt_res_subdomain'
		);

		foreach($fields as $name=>$value){$cv->varible_in($value);}
		$_v=$cv->get_cleaned_variables();
		$errors=$cv->get_bad_variables();
		
		if (empty($errors)){
			// send email
			//message body
			$emailMsg = '
						<html>
							<head>
							<title>4My.store - Contact Form</title>
							</head>
							<body>
								<h1>4My.store | '.$_v['res_name'].' | Contact Form</h1>
								<hr>
								<p><strong>Reseller Subdomain:</strong><br> '.$_v['res_subdomain'].'</p>
								<p><strong>Contact Name:</strong><br> '.$_v['name'].'</p>
								<p><strong>Contact Phone:</strong><br> '.$_v['phone'].'</p>
								<p><strong>Contact Email:</strong><br> '.$_v['email'].'</p>
								<p><strong>Business Name:</strong><br> '.$_v['business-name'].'</p>
								<p><strong>Comment:</strong><br> '.$_v['comment'].'</p>
								<p>// End of Message //</p>
							</body>
						</html>
						';
			// To send HTML mail, the Content-type header must be set
			$headers  = 'MIME-Version: 1.0' . "\r\n";
			$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";				

			//send email
			mail($sitewide::CSR_FORM_EMAIL, "4My.store | ".$_v['res_name']." | Contact Form", $emailMsg, $headers);
			$response['status'] = 'success';
			$response['CSR_FORM_EMAIL'] = $sitewide::CSR_FORM_EMAIL;
		} else {
			// return errors
			$response['status'] = 'error';
			$response['errors'] = $errors;
		}

		return $response;
	}

	function checkGooglePlaceId ($googleId){
		$this->dbObj->query("SELECT ltm_google_id FROM lt_merchants WHERE ltm_google_id=:google_id LIMIT 1");
		$this->dbObj->bind(':google_id', $googleId, PDO::PARAM_STR);
		$qry = $this->dbObj->resultset();
		if(!isset($qry[0])){
			$res = 'Available'; 
		} else {
			$res = 'Taken';
		}

		return $res;
	}
	
	function checkMerchantEmail ($email) {
		 // check if member email already exists in our system
		$this->dbObj->query("SELECT ltb_email FROM `lt_member_merchants` WHERE ltb_email=:email LIMIT 1");
		$this->dbObj->bind(':email', $email, PDO::PARAM_STR);	
		$qry = $this->dbObj->resultset();
		if(!isset($qry[0])){
			$res = 'Available'; 
		} else {
			$res = 'Taken';
		}

		return $res;
	}

	function getCategoryKeywords ($categoryId){
		$this->dbObj->query("
		SELECT KW.key_word, KW.key_id
		FROM tbl_keywords KW 
		INNER JOIN tbl_c2keyword C2K 
		ON KW.key_id = C2K.key_id 
		WHERE C2K.cat_id = :cat_id
		AND KW.key_word !=''
		AND KW.key_type = 'active'
		ORDER BY KW.key_word ASC");
		$this->dbObj->bind(':cat_id', $categoryId, PDO::PARAM_INT);
		$qry= $this->dbObj->resultset();
		if(empty($qry)){
			$res = '';
		} else {
			$res = $qry;
		}
		return $res;
	}

	function getCategoryChildren ($parentCategoryId){
		$this->dbObj->query('SELECT cat_id,cat_name,cat_slug FROM `tbl_category` WHERE cat_local=1 AND cat_parent_id=:p_id AND cat_active=1 ORDER BY cat_name');
		$this->dbObj->bind(':p_id', $parentCategoryId, PDO::PARAM_INT);
		$this->dbObj->execute();
		$qry = $this->dbObj->resultset();
		if(empty($qry)){
			$res = '';
		} else {
			$res = $qry;
		}
		return $res;
	}

	function getCategories () {
		$p_category = '';
		$this->dbObj->query('SELECT cat_id,cat_name,cat_slug,cat_parent_id FROM `tbl_category` WHERE cat_local=1 AND cat_parent_id=0 AND cat_active=1 ORDER BY cat_name');			
		$qry = $this->dbObj->resultset();			
		if(isset($qry[0])){
			$p_category = '<option value=0 selected disabled>Select a category</option>';
			foreach ($qry as $value) {
				$p_category .= '<option value="'.$value['cat_id'].'">'.$value['cat_name'].'</option>';
			}
		}
					
		
		return $p_category;
	}
	
	function getCreditCards() {
		$paymentOptions = '';
		$this->dbObj->query('SELECT ccd_id, ccd_name FROM `tbl_creditcards` ORDER BY ccd_id');
		$qry = $this->dbObj->resultset();
		if(isset($qry[0])) {			
			foreach ($qry as $value) {
				$paymentOptions .= '<div class="col-xs-6 col-sm-3"><label><input type="checkbox" name="dec_payment_methods_r[]" class="vCheck" value="'.$value['ccd_id'].'"> '.$value['ccd_name'].'</label></div>';
			}
		}
		return $paymentOptions;
	}
	
	function setPDO ($dbObj) {
		$this->dbObj = $dbObj;
	}
	
	function __construct(  ) {	}	
}