<?php
	require_once 'product.php';
	class package extends product { 
		
		//private properties
		private $packRecords = array();
		private $packId = 0;
		private $productList = array();
		private $basicProductList = array();
		private $preventStackOverflow = array();
		//private functions
		
		private function getPackProducts($packId, $ofrId = null) {			
			$str = 'WHERE PACK.pk_id = :packId';
			
			if ( $ofrId !== null ) {
				$str .= ' AND PROD.ofr_id = :ofrId';
			}
			
			$this->dbObj->query("
				SELECT PPR.*, PROD.*, POFF.ofr_company, POFF.ofr_id, PACK.*, P2P.*, (CASE WHEN PACK1.pk_id IS NULL THEN 0 ELSE 1 END) AS is_pack 
				FROM tbl_prod2pack P2P
				
				INNER JOIN tbl_product PROD ON PROD.prod_id = P2P.prod_id
				LEFT JOIN tbl_package PACK1 ON PACK1.pk_id = PROD.prod_id
				LEFT JOIN (SELECT * FROM tbl_prod_price WHERE ppr_current_price) PPR ON PPR.prod_id = PROD.prod_id
				INNER JOIN tbl_prod_offerer POFF ON POFF.ofr_id = PROD.ofr_id
				
				INNER JOIN tbl_package PACK ON PACK.pk_id = P2P.pk_id				
				{$str}
			");
			
			$this->dbObj->bind(':packId', $packId, \PDO::PARAM_INT);
			
			if ($ofrId !== null) {
				$this->dbObj->bind(':ofrId', $ofrId, \PDO::PARAM_INT);
			}
			
			$Results = $this->dbObj->resultset(  );
			
			$this->productList[$packId]['Products'] = array();
			
			foreach ( $Results as $Result ) {		
				if (intval($Result['is_pack']) === 1) {
					array_push($this->productList[$Result['pk_id']]['Products'], array('Data' => $Result, 'Obj' => new package( $this->dbObj, $Result['prod_id'] ) ) );	
				}	
				else {
					array_push($this->productList[$Result['pk_id']]['Products'], array('Data' => $Result, 'Obj' => new product( $this->dbObj, $Result['prod_id'] ) ) );
				}
			}
			
			return $this->productList;
		}

		public function filterProducts ($filterStructObj, $exclusiveCmp = false) {
			$tmpArr = []; $filterStruct = $filterStructObj;
			foreach ( $this->productList as $id => $v ) {

				$flag=false;

				if ( isset( $filterStruct['prod_active'] ) ) {
					$filterStruct['prod_active'] = (string) $filterStruct['prod_active'];
					
					if ( 
								strcmp ( $filterStruct['prod_active'], '0' ) !== 0
							&&  strcmp ( $filterStruct['prod_active'], '1' ) !== 0
						) {
						unset( $filterStruct['prod_active'] );
					}
				}
				
				if ( isset($v['Data']['ofr_id'], $filterStruct['ofr_id']) && !empty($filterStruct['ofr_id']) && strcmp($v['Data']['ofr_id'], $filterStruct['ofr_id']) !== 0) {
					$flag = true;
				}

				foreach ( $v['Data'] as $field => $fVal ) {
					if ( !$flag && isset( $filterStruct[$field] ) && (!empty( $filterStruct[$field] ) || $field == 'prod_active') ) {
						$flag = $exclusiveCmp? strcmp( $fVal , $filterStruct[$field] ) !== 0 : stripos( $fVal , $filterStruct[$field] ) === false;					
					}
				}
				
				if ($flag) {
					array_push($tmpArr, $id);
				}
			}
			
			foreach ($tmpArr as $v) {
				unset($this->productList[$v]);
			}
		}
		
		function getProductList($packId) {
			if (isset($this->productList[$packId]['Products'])) {
				return $this->productList[$packId]['Products'];
			}
			return array();
		}
		
		function getPackageData($packId) {
			if (isset($this->productList[$packId]['Data'])) {
				return $this->productList[$packId]['Data'];
			}
			return array();
		}
		
		private function getAll() {
			$this->dbObj->query("
				SELECT PPR.*, PROD.*, PACK.*, POFF.ofr_company, POFF.ofr_id 
				FROM tbl_product PROD
				INNER JOIN tbl_package PACK ON PACK.pk_id = PROD.prod_id
				INNER JOIN tbl_prod_offerer POFF ON POFF.ofr_id = PROD.ofr_id
				LEFT JOIN (SELECT * FROM tbl_prod_price WHERE ppr_current_price) PPR ON PPR.prod_id = PROD.prod_id
			");

			$Results = $this->dbObj->resultset(  );
			
			foreach ( $Results as $Result ) {
				$this->productList[$Result['pk_id']]['Data'] = $Result;	
				$this->productList[$Result['pk_id']]['Obj'] = new product( $this->dbObj, $Result['prod_id'] );
				//$this->getPackProducts($Result['pk_id']);
			}
			
			return $this->productList;
		}
		
		private function getPackage($packId) { /*This function should always be private it has to be called thru the constructor*/
			$valRec = array('wnu_value_r'=>$packId);
			if ($this->validate ( $valRec, $errors ) && count($errors) === 0) {				
				$this->dbObj->query("
					SELECT PPR.*,PROD.*, PACK.*
					FROM tbl_product PROD
					INNER JOIN tbl_package PACK ON PACK.pk_id = PROD.prod_id
					LEFT JOIN (SELECT * FROM tbl_prod_price WHERE ppr_current_price) PPR ON PPR.prod_id = PROD.prod_id
					WHERE PACK.pk_id = :pId
					LIMIT 1
				");
				$this->dbObj->bind(':pId', $packId, \PDO::PARAM_INT);
				$Result = $this->dbObj->single();
				
				if ( $Result ) {
					$this->productList[$Result['pk_id']]['Data'] = $Result;	
					$this->productList[$Result['pk_id']]['Obj'] = $this;					
					$this->getPackProducts($Result['pk_id']);
				}
				return $this->productList;
			}
			return false;
		}
		
		public function getPackageInfo($packId) {
			$valRec = array('wnu_value_r'=>$packId);
			if (isset($this->productList[$packId]['Info']))
				return $this->productList[$packId]['Info'];
			elseif ($this->validate ( $valRec, $errors ) && count($errors) === 0) {				
				$this->dbObj->query("
					SELECT PPR.*,PROD.*, PACK.*
					FROM tbl_product PROD
					INNER JOIN tbl_package PACK ON PACK.pk_id = PROD.prod_id
					LEFT JOIN (SELECT * FROM tbl_prod_price WHERE ppr_current_price) PPR ON PPR.prod_id = PROD.prod_id
					WHERE PACK.pk_id = :pId
					LIMIT 1
				");
				$this->dbObj->bind(':pId', $packId, \PDO::PARAM_INT);
				$Result = $this->dbObj->single();
				
				if ( $Result ) {
					$this->productList[$Result['pk_id']]['Info'] = $Result;
					return $this->productList[$Result['pk_id']]['Info'];
				}
			}
			return array();
		}
		
		private function getPackBasicProductList( $packId ) {			
			
			$this->dbObj->query("
				SELECT OFR.*, PROD.*, P2P.*, PPR.ppr_id, PPR.ppr_price, PPR.ppr_setup, PACK1.pk_id AS prodIsPack
				FROM tbl_prod2pack P2P 
				
				INNER JOIN tbl_product PROD ON PROD.prod_id = P2P.prod_id
				INNER JOIN tbl_prod_offerer OFR ON PROD.ofr_id = OFR.ofr_id
				LEFT JOIN (
					SELECT PPR.*
					FROM tbl_prod_price PPR
					INNER JOIN tbl_product PROD ON PROD.prod_id = PPR.prod_id
					WHERE PPR.ppr_current_price
					
				) PPR ON PROD.prod_id = PPR.prod_id
				LEFT JOIN tbl_package PACK1 ON PACK1.pk_id = PROD.prod_id
				
				INNER JOIN tbl_package PACK ON PACK.pk_id = P2P.pk_id
				
				WHERE PACK.pk_id = :packId 
				ORDER BY P2P.p2p_display_order
			");
				
			$this->dbObj->bind( ':packId', $packId, \PDO::PARAM_INT );
		
			$Results = $this->dbObj->resultset(  );
			
			foreach ( $Results as $Result ) {
				if ( isset( $Result['prodIsPack'] ) ) {
					if (isset($this->basicProductList[$packId])) {
						$tmp = $this->findBasicProductList( $Result['prod_id'] );
						foreach ( $tmp as $pId => $v ) {
							$this->basicProductList[ $packId ][ $pId ] = $v;
						}
					}
					else	
						$this->basicProductList[$packId] = $this->findBasicProductList($Result['prod_id']);	
				}	
				else {
					$this->basicProductList[$packId][$Result['prod_id']]['Obj'] = new product( $this->dbObj, $Result['prod_id'] );
					$this->basicProductList[$packId][$Result['prod_id']]['Data'] = $Result;
				}	
			}
			return $this->basicProductList;
		}
		
		public function findBasicProductList ( $packId ) {
	
			$this->preventStackOverflow = [];
			$this->getPackBasicProductList( $packId );			
			
			return isset( $this->basicProductList[$packId] )? $this->basicProductList[$packId]: [];
			
		}
		
		public function getResellerPackages ( $resId, &$htmlTable, $placement = 'msp' ) {
			$errorArr = array(); $htmlTable = '';
			$newProductRec['wnu_res_id_r'] = $resId;
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			switch ($placement) {
				case '4my.store': 
					$p2r_placement = $placement;
				break;	
				default: 
					$p2r_placement = 'msp';
			}

			if ( count( $errorArr ) === 0 ) {
				//good to go
				$this->dbObj->query("
					SELECT DISTINCT PPR.*, P2R.p2r_placement, P2R.p2r_featured, RES.*, PRD.*, PIN.*
					FROM tbl_prod2reseller P2R 
					INNER JOIN tbl_reseller RES ON RES.res_id = P2R.res_id 					
					INNER JOIN tbl_package PIN ON P2R.prod_id = PIN.pk_id 
					INNER JOIN tbl_product PRD ON PRD.prod_id = PIN.pk_id 
					LEFT JOIN ( SELECT * FROM `tbl_prod_price` WHERE ppr_current_price ) PPR ON PRD.prod_id = PPR.prod_id
					WHERE RES.res_id = :res_id AND P2R.p2r_placement = :plac
					ORDER BY PPR.ppr_price 					
				");
							
				$this->dbObj->bind( ':res_id', $cleaned['res_id'], \PDO::PARAM_INT );
				$this->dbObj->bind( ':plac', $p2r_placement, \PDO::PARAM_STR );
				$Results = $this->dbObj->resultset(  );
				$this->productRecords['Reseller_Packages'] = array();
				$results = '';
				foreach ( $Results as $Result ) {
					if (!isset($this->productRecords['Reseller_Packages'][$Result['res_id']]))
						$this->productRecords['Reseller_Packages'][$Result['res_id']] = array();
									
					$results .= '<tr>'; 
					$results .=   '<td><a href="/admin/packages?prod_id='.$Result['prod_id'].'&search=1">'.$Result['prod_id'].'</a></td>';
					$results .=   '<td>'.$Result['prod_name'].'</td>';
					$results .=   '<td>'.$Result['prod_descript'].'</td>';
					$results .=   '<td>'.$Result['pk_internal_name'].'</td>';
					$results .=   '<td>'.$Result['prod_keyword'] . '</td>';
					$results .=   '<td>'.$Result['pk_terms'].'</td>';			
					$results .=   '<td>'.$Result['pk_more_info'].'</td>';
					$results .=   '<td>'.$Result['p2r_placement'].'</td>';
					$results .=   '<td><div style="min-width:80px;" class="btn-group btn-group-md" role="group" aria-label="...">
											<button class="btn btn-danger removePlan" data-placement="'.$Result['p2r_placement'].'" data-resid="'.$Result['res_id'].'" data-placement="'.$Result['p2r_placement'].'" data-pkid="'.$Result['pk_id'].'"><span class="glyphicon glyphicon-trash"></span></button>
											<button data-placement="'.$Result['p2r_placement'].'" class="btn btn-'.(intval($Result['p2r_featured']) === 1?'info unfeaturePlan" title="Featured package, remove featured mark"':'default featurePlan" title="Mark it as a featured package"').' data-resid="'.$Result['res_id'].'" data-pkid="'.$Result['pk_id'].'"><span class="glyphicon glyphicon-' . (intval($Result['p2r_featured']) === 1?'check': 'unchecked') . '"></span></button>
										</div>
									</td>';
					$results .= '</tr>';
					array_push( $this->productRecords['Reseller_Packages'][$Result['res_id']], $Result );
					
					$this->productRecords['Product_List'][$Result['pk_id']] = $this->findBasicProductList( $Result['pk_id'] );
					
				}
				
				$htmlTable = $results;
				return $this->productRecords['Reseller_Packages'];
				
			}
			else {
				$errorArr = array_values( $errorArr );
			}
			
			return [];
		}
		
		public function getArrayKeyValue ($key) {
			return isset($this->productRecords[$key])? $this->productRecords[$key]: [];
		}
		
		public function getResellerTopLevelPackages( $resId, $priceLessThanPackId = 0) {

			$newProductRec['wnu_res_id_r'] = $resId;
			$newProductRec['wnu_pack_id_r'] = $priceLessThanPackId;
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			
			if ( count( $errorArr ) === 0 ) {
				//good to go
				$this->dbObj->query("
					SELECT DISTINCT P2R.p2r_placement, P2R.p2r_featured, RES.*, PRD.*, PIN.*, PPR.*
					FROM tbl_prod2reseller P2R
					INNER JOIN tbl_reseller RES ON RES.res_id = P2R.res_id
					INNER JOIN tbl_package PIN ON P2R.prod_id = PIN.pk_id
					INNER JOIN tbl_product PRD ON PRD.prod_id = PIN.pk_id
					INNER JOIN tbl_prod_price PPR ON PPR.prod_id = PRD.prod_id
					WHERE 
						PRD.prod_active 
						AND PPR.ppr_current_price 
						AND RES.res_id = :res_id 
						AND PIN.pk_id NOT IN (
							SELECT PRD.prod_id
							FROM tbl_prod2pack P2P
							INNER JOIN tbl_package PACK ON P2P.prod_id = PACK.pk_id
							INNER JOIN tbl_product PRD ON PRD.prod_id = PACK.pk_id						
						)					
						AND PPR.ppr_price <= (
							SELECT ppr_price
							FROM tbl_prod_price
							WHERE 
								ppr_current_price 
								AND prod_id = :pack_id 
							LIMIT 1
						)
				");
							
				$this->dbObj->bind( ':res_id', $cleaned['res_id'], \PDO::PARAM_INT );
				$this->dbObj->bind( ':pack_id', $cleaned['pack_id'], \PDO::PARAM_INT );
				$Results = $this->dbObj->resultset(  );
				$this->productRecords['Reseller_Top_Packages'][$cleaned['res_id']] = array();
				$results = '';
				foreach ( $Results as $Result ) {
					if (!isset($this->productRecords['Reseller_Top_Packages'][$Result['res_id']]))
						$this->productRecords['Reseller_Top_Packages'][$Result['res_id']] = array();
					array_push( $this->productRecords['Reseller_Top_Packages'][$Result['res_id']], $Result );
				}
				
				return $this->productRecords['Reseller_Top_Packages'][$cleaned['res_id']];
				
			}
			
			return [];
		}
		
		//constructor
		public function __construct ($dbObj, $packId, $ofrId = null) {
			parent::__construct($dbObj, $packId, null);
			if ($packId === null)
				$this->getAll();
			else
				if ( intval( $packId ) > 0 ) {
					$this->getPackage( $packId );
					$this->getPackageInfo( $packId );
				}	
		}
		
	}
