<?php
require_once 'variables.php';

class product {
		
		//private properties
		private $productId = 0;
		
		//protected properties
		protected $dbObj = null;
		protected $belongsToPack = array();
		protected $productRecords = array();
		
		private function getProducts($prodId = null, $ofrId = null) {
			$str = 'WHERE PACK.pk_id IS NULL';
			if ( $prodId !== null ) {
				$str .= ' AND PRD.prod_id = :prodId';
			}
			
			if ($ofrId !== null) {
				$str .= ' AND PRD.ofr_id = :ofrId';
			}
			
			$this->dbObj->query("
				SELECT PPR.*,PRD.*
				FROM tbl_product PRD
				LEFT JOIN tbl_package PACK ON PACK.pk_id = PRD.prod_id
				LEFT JOIN (SELECT * FROM tbl_prod_price WHERE ppr_current_price) PPR ON PPR.prod_id = PRD.prod_id
				{$str}		
			");
			
			if ($prodId !== null) {
				$this->dbObj->bind(':prodId', $prodId, \PDO::PARAM_INT);
			}
			
			if ($ofrId !== null) {
				$this->dbObj->bind(':ofrId', $ofrId, \PDO::PARAM_INT);
			}
			
			$Results = $this->dbObj->resultset(  );
			
			foreach ( $Results as $Result ) {
				$this->productRecords[$Result['prod_id']] = $Result;
				if (!$productId) {$productId = $Result['prod_id'];}
			}
			
			return $this->productRecords;
			
		}
		
		private function isFeatured( $prodId, $resId, $placement ) {
			$errorArr = array();
			$newProductRec['wnu_res_id_r'] = $resId;
			$newProductRec['wnu_prod_id_r'] = $prodId;
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			switch ($placement) {
				case '4my.store': 
					$p2r_placement = $placement;
				break;	
				default: 
					$p2r_placement = 'msp';
			}

			if ( count( $errorArr ) === 0 ) {
				//good to go
				$stmt = $this->dbObj->prepare("
					SELECT PRD.prod_id
					FROM tbl_product PRD
					INNER JOIN 
				");	
				$stmt->bindValue( ':res_id', $cleaned['res_id'], \PDO::PARAM_INT );
				$stmt->bindValue( ':prod_id', $cleaned['prod_id'], \PDO::PARAM_INT );			
				$stmt->bindValue( ':p2r_placement', $p2r_placement, \PDO::PARAM_STR );							
				$stmt->execute();		
				return $this->dbObj->lastInsertId();
			}
			else {
				$errorArr = array_values($errorArr);
			}	
			return false;
			
		}
		
		public function getProviders () {
			$str = '';
			
			$this->dbObj->query("
				SELECT * FROM tbl_prod_offerer
			");
			
			$Results = $this->dbObj->resultset(  );
			
			$tmp = array();
			
			foreach ( $Results as $Result ) {
				$tmp['Providers'][] = $Result;			
			}
			
			return $tmp['Providers'];
			
		}
		
		protected function validate ( $valRec, &$errors ) {
			$cv= new \_variables( $valRec );
			foreach( $valRec as $name => $value ) $cv->varible_in( $name );
			$clean = $cv->get_cleaned_variables();
			$errors = $cv->get_bad_variables();
			return $clean;
		}
		
		//public functions
		public function getProductOfferers($offererName) {
			$stmt = $this->dbObj->query("
				SELECT DISTINCT PRO.prod_id, OFR.*
				FROM tbl_product PRO
				INNER JOIN tbl_prod_offerer OFR ON OFR.ofr_id = PRO.ofr_id
				WHERE OFR.ofr_company LIKE :name OR OFR.ofr_company LIKE :name1 OR OFR.ofr_company LIKE :name2
			");
			
			$this->dbObj->bind( ':name', $offererName.'%', \PDO::PARAM_STR );
			$this->dbObj->bind( ':name1', '%'.$offererName.'%', \PDO::PARAM_STR );
			$this->dbObj->bind( ':name2', '%'.$offererName, \PDO::PARAM_STR );
			
			$Results = $this->dbObj->resultset(  ); $resultOfferer = []; $tmpArr = [];
			foreach ( $Results as $Result ) {
				$this->productRecords[$Result['prod_id']]['Offerer'] = $Result;
				if (!in_array($Result['ofr_id'], $tmpArr)) {
					array_push($tmpArr, $Result['ofr_id']);
					unset($Result['prod_id']);
					array_push($resultOfferer, $Result);
				}
			}
			
			return $resultOfferer;
			
		}
			
		public function filterProducts ($filterStructObj, $exclusiveCmp = false) {
			$tmpArr = []; $filterStruct = $filterStructObj;
			
			foreach ( $this->productRecords as $id => $v ) {

				$flag=false;

				if ( isset( $filterStruct['prod_active'] ) ) {
					$filterStruct['prod_active'] = (string) $filterStruct['prod_active'];
					
					if ( 
								strcmp ( $filterStruct['prod_active'], '0' ) !== 0
							&&  strcmp ( $filterStruct['prod_active'], '1' ) !== 0
						) {
						unset( $filterStruct['prod_active'] );
					}
				}
				
				if ( isset($v['ofr_id'], $filterStruct['ofr_id']) && !empty($filterStruct['ofr_id']) && strcmp($v['ofr_id'], $filterStruct['ofr_id']) !== 0) {
					$flag = true;
				}

				foreach ( $v as $field => $fVal ) {
					if ( !$flag && isset( $filterStruct[$field] ) && (!empty( $filterStruct[$field] ) || $field == 'prod_active') ) {
						$flag = $exclusiveCmp? strcmp( $fVal , $filterStruct[$field] ) !== 0 : stripos( $fVal , $filterStruct[$field] ) === false;					
					}
				}
				
				if ($flag) {
					array_push($tmpArr, $id);
				}
			}
			
			foreach ($tmpArr as $v) {
				unset($this->productRecords[$v]);
			}
		}
		
		public function getPrices( $prodId ) {
			$errorArr = array();
			$newProductRec['wnu_prod_id_r'] = $prodId;		
			$cleaned = $this->validate ( $newProductRec, $errorArr );
			$this->productRecords[$prodId]['Prices'] = array();
			if ( count( $errorArr ) === 0 ) {				
				$stmt = $this->dbObj->query("
					SELECT * FROM tbl_prod_price WHERE prod_id=:prod_id
				");
				
				$this->dbObj->bind( ':prod_id', $cleaned['prod_id'], \PDO::PARAM_INT );
				
				$Results = $this->dbObj->resultset(  );
				foreach ( $Results as $Result ) {
					$this->productRecords[$cleaned['prod_id']]['Prices'][] = $Result;			
				}
			}
			return $this->productRecords[$prodId]['Prices'];
		}
		
		public function getRecords() {
			return $this->productRecords;
		}
		
		public function getCurrentId() {
			return $this->productId;
		}
		
		//constructor
		public function __construct ($dbObj, $prodId = null, $ofrId = null) {
			$this->dbObj = $dbObj;
			$this->getProducts($prodId, $ofrId);
		}
	}

?>