<?php
	class reseller {

		// Private Properties
		private $resDbo=null;
		
		//protected properties
		protected $currentResellerId = 0;
		protected $resellerRecords = array();
		
		public function getPDO () {
			return $this->resDbo;
		}
		
		public function getPlanFeaturesByOfferer($rpo_id){
			  // get all possible plan features
			  $this->resDbo->query('SELECT LMP.lpf_feature, LMP.lpf_description, LMP.lpf_id FROM lt_plan_features LMP 
			  LEFT JOIN tbl_plan_offerer RPO ON LMP.rpo_id = RPO.rpo_id 
			  WHERE LMP.lpf_active = 1 AND LMP.lpf_display = 1 AND RPO.rpo_id = :rpo_id
			  ORDER BY RPO.rpo_sort, LMP.lpf_id');
			  
			  $this->resDbo->bind(":rpo_id", $rpo_id, PDO::PARAM_INT);
			  $tempResult = $this->resDbo->resultset();
			  			  
			  if(empty($tempResult)){
				// set array to avoid errors
				$results = array();
			  } else {
				$results = $tempResult; 
			  }
			  return $results;
			}

		public function loadRecords($resellerFieldName, $resellerFieldValue, $dataType) {

			$this->resDbo->query("
			SELECT RES.*, MST.fms_id, MST.fms_description, MST.fms_prismpay_subid, MST.fms_logo, MST.fms_logo_secondary, MST.fms_google_analytics
			FROM tbl_reseller RES
			LEFT JOIN tbl_4mystore MST ON RES.res_id=MST.res_id
			WHERE RES.{$resellerFieldName} = :fieldVal AND RES.res_active LIMIT 1");
			$this->resDbo->bind(":fieldVal", $resellerFieldValue, $dataType);
			$tempResult = $this->resDbo->resultset();
			if ( isset($tempResult[0]) ) {
				$resultSet = $tempResult[0];
				$resultSet['Offerers_Offered'] = array();				
				$resultSet['plans']= $this->getResellerPlans( $resultSet['res_id'], $resultSet['Offerers_Offered'] );
		
				$this->currentResellerId = $resultSet['res_id'];				
				$this->resellerRecords[$resultSet['res_id']] = $resultSet;
				
				return $this->resellerRecords[$resultSet['res_id']];
			}

			return array();
		}
		
		public function getCurrentResellerId () {
			return $this->currentResellerId;			
		}
		
		public function getResellerData ($resellerId = null) {
			if ($resellerId===null) {
				if ( isset($this->resellerRecords[$this->currentResellerId]) )
					return $this->resellerRecords[$this->currentResellerId];
			}	
			elseif ( isset($this->resellerRecords[$resellerId]) )
				return $this->resellerRecords[$resellerId];				
			return array();
		}	
		
		public function getChosenPlan ($lmpId) {
			$chosen_plan = array();
			if (is_numeric($lmpId) && intval($lmpId) > 0){
			  $this->resDbo->query('SELECT LMP.lmp_id, LMP.lmp_name, LMP.lmp_custom_terms, LMP.lmp_custom_breakdown, LMP.lmp_price, LMP.lmp_fee, LMP.lmp_billing_delay 
			  FROM lt_merchant_plans LMP 
			  INNER JOIN lt_plans2reseller P2R 
			  ON LMP.lmp_id = P2R.lmp_id 
			  WHERE LMP.lmp_id = :lmp_id AND P2R.res_id = :res_id LIMIT 1');			  
			  $this->resDbo->bind(':lmp_id', intval($lmpId), PDO::PARAM_INT);
			  $this->resDbo->bind(':res_id', $this->currentResellerId, PDO::PARAM_INT);
			  $tempResult = $this->resDbo->resultset();
			  if ( isset($tempResult[0]) ) {
				$chosen_plan = $tempResult[0];
				$this->resellerRecords[$this->currentResellerId]['Chosen_Plan'] = $chosen_plan;				
			  }			  
			} 
			
			return $chosen_plan;  
		}
		
		private function orderPlansByPrice ($resellerPlans) {
			$returnArray = array();
			$resellerPlansLoop = $resellerPlans;
			while( !empty( $resellerPlansLoop ) ) {
				$cPrice = null;
				foreach($resellerPlansLoop as $k=>$v) {
					if ($cPrice === null) {$cPrice = $v['lmp_price']; $key = $k;}
					if ( $v['lmp_price'] < $cPrice ) {$cPrice = $v['lmp_price']; $key = $k;}
				}
				unset($resellerPlansLoop[$key]);
				$returnArray[$key] = $resellerPlans[$key];
			}
			return $returnArray;
		}
		
		public function getResellerPlans ($resellerId, &$OffererArr) {
			$OffererArr = array();

			$this->resDbo->query('SELECT LPO.rpo_logo, LPO.rpo_sort, LPO.rpo_company, LPO.rpo_id, LPO.rpo_description, LMP.lmp_id, LMP.lmp_name, LMP.lmp_admin_name, LMP.pty_id, LMP.lmp_price, LMP.lmp_fee, LMP.lmp_billing_delay,
			LMP.lmp_description, LMP.lmp_custom_terms, LMP.lmp_custom_breakdown, LMP.pty_id, LMP.lmp_featured, LPF.lpf_feature, LPF.lpf_id, MFC.mfc_count
			
			FROM lt_merchant_plans LMP 
			INNER JOIN lt_plans2reseller P2R ON LMP.lmp_id = P2R.lmp_id
			INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id 
			
			LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id			
			LEFT JOIN tbl_plan_offerer LPO ON LPO.rpo_id = LPF.rpo_id
			WHERE P2R.res_id = :res_id AND LMP.lmp_active = 1 AND LPF.lpf_active = 1 AND MFC.ltb_id IS NULL
			ORDER BY LPO.rpo_sort, LMP.lmp_price ASC');
			$this->resDbo->bind(":res_id", $resellerId, PDO::PARAM_INT);
			$rows = $this->resDbo->resultset();
			
			if(empty($rows)){
				// set array to avoid errors
				$results = array();
			} 
			else {
				foreach ($rows as $k => $v) {
					if (!$results[$v['lmp_id']]){
						$results[$v['lmp_id']] = array(
						  'lmp_id'                => $v['lmp_id'],
						  'pty_id'                => $v['pty_id'],
						  'lmp_name'              => $v['lmp_name'],
						  'lmp_price'             => $v['lmp_price'],
						  'lmp_fee'               => $v['lmp_fee'],
						  'lmp_billing_delay'     => $v['lmp_billing_delay'],
						  'lmp_description'       => $v['lmp_description'],
						  'lmp_custom_terms'      => $v['lmp_custom_terms'],
						  'lmp_featured'          => $v['lmp_featured'],
						  'lmp_custom_breakdown'  => $v['lmp_custom_breakdown']
						);
												
						if ($v['lmp_price'] == 0 && $v['pty_id'] > 1) {
						  $results[$v['lmp_id']]['lmp_no_price'] = 1;
						}
					} 
					$id=$v['rpo_id'];
					if (!in_array($id, $OffererArr)) {
						$OffererArr[$id] = array('Id' => $id, 'Sort' => $v['rpo_sort'], 'Logo' => $v['rpo_logo'], 'Company'=>$v['rpo_company'], 'Description' => $v['rpo_description']);
					}
					if ( !isset( $results[$v['lmp_id']]['lmp_features'][$id] ) ) {
						$results[$v['lmp_id']]['lmp_features'][$id] = array('rpo_logo'=>$resultSet['rpo_logo'], 'rpo_id' => $id, 'rpo_company' => $resultSet['rpo_company'], 'Features' => array());
					}					
					array_push($results[$v['lmp_id']]['lmp_features'][$id]['Features'], 
														array(
															'lpf_id'=> $v['lpf_id'], 
															'lpf_feature'=>$v['lpf_feature'], 
															'mfc_count'=>$v['mfc_count']
														));
				}
				$results = $this->orderPlansByPrice ($results);				
			}
			return $results;
		}


		//resellerObj ($dbo, null, SUB_DOMAIN )
		function __construct( $dbObj, $resellerId=null, $ressellerSubDomain=null) {

			$this->resDbo = $dbObj;			
			if ( $resellerId !== null && is_numeric($resellerId) && intval($resellerId) > 0 ) {
				$this->loadRecords('res_id', intval($resellerId), PDO::PARAM_INT);

			}

			elseif ($ressellerSubDomain !== null && preg_match("/^[a-zA-Z\_\-0-9]+$/", $ressellerSubDomain)){
				$this->loadRecords('res_subdomain', $ressellerSubDomain, PDO::PARAM_STR);

			}

		}

		

	}

?>