<?php
/*
EXAMPLE VARIBLE NAME: wnu3_widgetid_r
TYPE = whole number
MAXLENGTH = 3 (if ommited, will be determined by the class based upon it's type)
FRIENDLY NAME = widget (this is the name that will be used when data is returned from the class)
REQUIRED = if the field name ends with '_r' it is a required field

EXAMPLE CALL TO CLASS

$cv= new _variables(); // new instance
$cv_array=array('wnu_id','ema64_email'); //list all varibles to be check in array
foreach($cv_array as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
$clean=$cv->get_cleaned_variables();
$errors=$cv->get_bad_variables();
*/
class _variables{
	function __construct($arrParams = array()) { 
		$this->cleaned = array(); 
		$this->errors = array();
		$this->arrToBeChecked = $arrParams;
	}
	public function get_cleaned_variables(){return $this->cleaned;}
	public function get_bad_variables(){return $this->errors;}

	public function varible_in($var_name){

		if (empty($this->arrToBeChecked)){
			global $_REQUEST;
			$this->arrToBeChecked = $_REQUEST;
		}

		//check if field is present
		if(!isset($this->arrToBeChecked[$var_name])){ 

			$this->errors[$var_name]='missing field';

		//field is present
		}else{
			 
			$var_value=$this->arrToBeChecked[$var_name];
			$var_type=self::variable_specs($var_name,'type');

			//if field is array, loop through the array
			if(is_array($var_value)){
				foreach ($var_value as $value) {
					
					$arr=self::check_var($var_name, $value, self::variable_specs($var_name,'type'));

					$this->cleaned[self::variable_specs($var_name,'name')][]=$arr['clean'];
					
					if($arr['error']){$this->errors[$var_name]=(is_array($arr['error']) ? $arr['error'][0] : $arr['error']);}
				}
 
			
			//check for empty required field
			} else if (trim($var_value)=='' && self::variable_specs($var_name,'required')===true){ 
				$this->cleaned[self::variable_specs($var_name,'name')]=''; 
				$this->errors[$var_name]='cannot be empty';
			

			//check for empty non-required fields
			} else if (trim($var_value)=='' && self::variable_specs($var_name,'required')===false){ 
				$this->cleaned[self::variable_specs($var_name,'name')]=''; 
                
			} else { //check one field
                
				$arr=self::check_var($var_name, $this->arrToBeChecked[$var_name], self::variable_specs($var_name,'type'));
				$this->cleaned[self::variable_specs($var_name,'name')]=$arr['clean'];
				if($arr['error']){$this->errors[$var_name]=$arr['error'];}
			}

         

		}

	}


	private function variable_specs($var_name, $desired_spec){
		$fieldArray = explode("_", $var_name);

		switch ($desired_spec) {
			case 'maxlength':
				$return=substr($fieldArray[0], 3);
				$return = preg_replace("/[^0-9]/", "", $return);
				break;
			case 'type':
				$return=substr($fieldArray[0], 0, 3);  // first three characters
				break;
			case 'required':
				$return=end($fieldArray)=='r' ? true : false;
				break;
			case 'name':
				$length=strlen($var_name)-(strlen($fieldArray[0])+1);
				if(end($fieldArray)=='r') $length-=2;
				$return=substr($var_name, strlen($fieldArray[0])+1, $length);
				break;
			default: $return='';
		}

		return $return;
	}

	private function check_var($var_name, $var_value, $var_type){
	
		// $var_value=$this->arrToBeChecked[$var_name];
		// $var_type=self::variable_specs($var_name,'type');

		$clean=$var_value;
		$error=false;
		switch ($var_type) {
			case 'abc': //alphabet only
				$default_maxlength=64;
				if (!preg_match('/^[a-zA-Z]+$/', $clean)) {
					$clean = trim(preg_replace("/[^a-zA-Z]/", "", $clean));
					$error = 'unallowed characters';
				} 
				break;
			case 'aon': //alphabet or number
				$default_maxlength=64;
				if (!preg_match('/^[a-zA-Z0-9]+$/', $clean)) {
					$clean = trim(preg_replace("/[^a-zA-Z0-9]/", "", $clean));
					$error = 'unallowed characters';
				} 
				break;
			case 'adn': //alphabet, dash, underscore or number
				$default_maxlength=128;
				if (!preg_match('/^[a-zA-Z0-9\-_]+$/', $clean)) {
					$clean = trim(preg_replace("/[^a-zA-Z0-9\-_]/", "", $clean));
					$error = 'unallowed characters';
				} 
				break;	
			case 'nam': //name format
				$default_maxlength=64;
				if (!preg_match("/^[a-zA-Z ,.'-]+$/", $clean)) {
					$clean = trim(preg_replace("/^[a-zA-Z ,.'-]+$/", "", $clean));
					$error = 'unallowed characters';
				} 
				break;	
			case 'bit': //BIT (1,0 or NULL)
				$default_maxlength=1;
				if($clean!='NULL') 
					if($clean!=1){
						if($clean!=0){
							$error = 'unallowed characters';
						}
						$clean=0; 

					}
				break;
			case 'dat': //DATE
				$default_maxlength=10; // mm/dd/yyyy
				if (!preg_match ("/([0-1]{1})([0-9]{1})\/([0-3]{1})([0-9]{1})\/([0-9]{4})/", $clean)){$clean=0; $error = 'unallowed characters';}
				if(!checkdate(substr($clean, 0, 2),substr($clean, 3, 2),substr($clean, 6, 4))){$clean=0; $error = 'not a date';}
				break;
			case 'dec': //DECIMALS
				$default_maxlength=255;
				if(!is_numeric($clean)){$clean=0; $error = 'not a decimal';}
				break;
			case 'ema': //EMAIL
				$default_maxlength=255;
				//check for mail injection
			    if (preg_match("/%0a/i", $clean) || preg_match("/%0d/i", $clean) || preg_match("/bcc:/i", $clean) || preg_match("/to:/i", $clean) || preg_match("/cc:/i", $clean) || preg_match("/Content-Type:/i", $clean) || !filter_var($clean, FILTER_VALIDATE_EMAIL)) { 
					$clean='';
					$error = 'invalid email';
				}
				$clean=strtolower($clean);
				break;

			case 'htm': //HTML
				$default_maxlength=255;
				$clean = preg_replace("/\r\n+|\r+|\n+|\t+/i", " ", $clean); //remove all line breaks, carriage returns and tabs
				$clean = trim(preg_replace('!\s+!', ' ', $clean)); //remove extra white spaces
				break;

			case 'img': //IMAGE FILE
				$default_maxlength=255;
				$allowed_types = array('png','gif','jpg','jpeg');
				$splitname = explode(".", $clean);
				if (!preg_match('/^[0-9a-zA-Z\._-]+$/', $clean)) { $clean=''; $error = 'unallowed characters';	}
				if (!in_array($splitname[1],$allowed_types)){ $clean=''; $error = 'unsupported image type';	}
				break;
			case 'int': //INTEGERS
				$default_maxlength=12;
				if(!is_int($clean)){$clean=0; $error = 'unallowed characters';}
				break;
			case 'pho': //PHONE
				$default_maxlength=10;
				$clean = preg_replace("/[^0-9]/", "", $clean);
				if (strlen($clean) !=10){$error = 'Enter a 10 digit phone number.';}
				break;
			case 'zip': //ZIP CODE
				$default_maxlength=10;
				//$clean = preg_replace("/^(\d{5}(?:[-\s]\d{4})?)$/", "", $clean);
				if (!preg_match ("/^(\d{5}(?:[-\s]\d{4})?)$/", $clean) || (strlen($clean) != 10 && strlen($clean) != 5)){$error = 'Incorrect zip code format.'; }
				break;	
			case 'tim': //TIME
				$default_maxlength=10; //xx:xx xm
				if (!preg_match ("/(1)?([0-9]{1}):([0-5]{1})([0-9]{1})\s?(am|pm|AM|PM)/", $clean)){$clean=0; $error = true;}
				break;

			case 'txl': //TEXT LINE - No line wraps
				$default_maxlength=255;
				$clean = preg_replace("/\r\n+|\r+|\n+|\t+/i", " ", $clean); //remove all line breaks, carriage returns and tabs
				$clean = trim(preg_replace('!\s+!', ' ', $clean)); //remove extra white spaces
				break;

			case 'txt': //TEXT - any safe characters 
				$default_maxlength=255;
				$clean = trim(preg_replace("/\t+/", " ", $clean)); //trim and remove tabs
				$clean = preg_replace('/(\r\n|\r|\n)/', "\n", $clean); //normalize line breaks
				$clean = preg_replace("/[\n]{3,}/", "\n\n", $clean); //replace more than 3 line breaks into 2 line breaks
				break;

			case 'lst': //LIST - comma seperated list of alphanumberic (spaces too), words
				$default_maxlength=255;
				$clean = trim(preg_replace("/[^a-zA-Z0-9, ]/", "", $clean));

				break;
            case 'psw': //LIST - any UTF-8 Chart
			    $default_maxlength=255;
				if (!preg_match('/\p{L}|\p{N}/', $clean)) {					
					$error = 'unallowed characters';
				}
				break;
				
			case 'url': 
				$default_maxlength=255;				
				if (filter_var($clean, FILTER_VALIDATE_URL) === false){
					$clean = preg_replace("/.+:\/\//", "", $clean);
					$clean = preg_replace("/.+:\//", "", $clean);
					$clean = preg_replace("/.+:/", "", $clean);
					$clean = preg_replace('/[^0-9a-z\.&\=?\`\/\~\! \@\#\$\%\^\*\(\)\; \,\'\_\- ]/i', ' ',$clean);
					$error = 'Required format: http://yourwebsite.com';
				}
				break;
			case 'wnu': //WHOLE NUMBERS - NO NULLS
				$default_maxlength=12;
				if (!preg_match('/^[0-9]+$/', $clean)) {
					$clean = preg_replace("/[^0-9]/", "", $clean);
					if(!is_numeric($clean))	$clean=0;
					$error = 'unallowed characters';
				} 
				break;
			case 'wns': //WHOLE NUMBERS STRING- NO NULLS
				$default_maxlength=255;
				if (!preg_match('/^[0-9]+$/', $clean)) {					
					$error = 'unallowed characters';
				} 
				break;	
			case 'yon': //YES OR NO
				$default_maxlength=1;
				if($clean!='Y'){
					if($clean!='N'){$error = 'unallowed characters';}
					$clean='N';
				}
				break;

			default: 
				$default_maxlength=1;
				$clean=''; 
				$error = true;
		}

		//limit length of string ---------------------------------------------------------------------------------
		$maxlength=self::variable_specs($var_name,'maxlength');	//pull maxlength from variable name
		if(!$maxlength) $maxlength=$default_maxlength;	//if maxlength not specified in variable use default

		if(strlen($clean) > $maxlength){
			$clean = substr($clean,0,$maxlength); //cut variable down to maxlength size
			$error = 'string too long';
		}





		//cross-site scripting -----------------------------------------------------------------------------------
		if ($var_type!="htm"){
			$clean = preg_replace("/</", "[", $clean);
			$clean = preg_replace("/>/", "]", $clean);
		}
		$clean = preg_replace("/&[lL][tT];?/", "[", $clean);
		$clean = preg_replace("/&#0{0,5}60;?/", "[", $clean);
		$clean = preg_replace("/&#[xX]0{0,5}3[cC];?/", "[", $clean);
		$clean = preg_replace("/[\\][xX]3[cC]/", "[", $clean);
		$clean = preg_replace("/[\\][uU]003[cC]?/", "[", $clean);
		$clean = preg_replace("/&[gG][tT];?/", "]", $clean);
		$clean = preg_replace("/&#0{0,5}62;?/", "]", $clean);
		$clean = preg_replace("/&#[xX]0{0,5}3[eE];?/", "]", $clean);
		$clean = preg_replace("/[\\][xX]3[eE]/", "]", $clean);
		$clean = preg_replace("/[\\][uU]003[eE]?/", "]", $clean);
		//}

		//remove carriage returns - fight against form post hijacking. --------------------------------------------
		if($var_type!='txt'){
			$clean=trim($clean);
			$clean = preg_replace("/\r/", "", $clean); 
			$clean = preg_replace("/\n/", "", $clean);
		}

		// remove all non-printable characters. CR(0a) and LF(0b) and TAB(9) are allowed
		$clean = preg_replace('/([\x00-\x08][\x0b-\x0c][\x0e-\x20])/', '', $clean);

		//return cleaned variable --------------------------------------------------------------------------------
		$ar=array();
		$ar['clean']=$clean;
		$ar['error']=$error;
		return $ar;

	}	

}








?>
