<?php
function trimTrailingZeroes($nbr) {
    return strpos($nbr,'.')!==false ? rtrim(rtrim($nbr,'0'),'.') : $nbr;
}

function formatPlanFeatureValue ( $value ) {
	$display_val = '';
	if (isset($value['prod_id']) && ( isset($value['prod_keyword']) || is_null($value['prod_keyword']) ) && ( isset($value['p2p_count']) || is_null($value['p2p_count']) )) {
		//echo $value['prod_id'];
		switch ( $value["prod_keyword"] ) {
			case "LT_FULL_SERVICE" : //format customer service time from minutes to hours
				$display_val = round(($value['p2p_count'] / 60), 2);
				($display_val == 0 ? $display_val = '' : 
				($display_val == 1 ? $display_val = $display_val . ' hour/mo.' : $display_val = $display_val . ' hours/mo.'));
			break;
			default:
				if ( is_null( $value['p2p_count'] ) ){
					$display_val = '<img src="/images/icon_checkmark_pricing_18px.svg" style="max-width: 20px;">';
				}
				else if ( $value['p2p_count'][0] === "$" ) {
					$display_val = $value['p2p_count'];
				}
				else {
					$display_val = number_format( $value['p2p_count'] );
				}
		}
	}
  	echo $display_val;
}

?>
<link href="/css/<?php echo $data['Reseller']['fms_id']; ?>pricing.css" rel="stylesheet">

<div class="pricing-hero">
  <div class="container-fluid">
    <div class="row">
      <div class="col-xs-12">
        <div class="pricing-hero__text">
          <h1>Which plan is right for you?</h1>
          <p>We share your businesses journey and have crafted our software to match where you are and anticipate where you want to be.</p>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="container">
  <div class="row">
    <div class="col-xs-12">
      <div class="pricing-head">Choose the plan that best matches your goals today and helps you bring your vision to life tomorrow.</div>
      
      <!-- BEGIN DESKTOP PRICING TABLE -->
      <div class="pricing-table__fixed-head hidden-xs hidden-sm" id="fixedTableHeader" style="display:none;">
        <div class="container">
          <div class="row">
            <div class="col-xs-12">
              <div class="pricing-table clearfix">
                <div class="pricing-table__head">
                  <strong>Choose the plan<br>that best matches<br>your goals</strong>
                </div>
                <?php

				foreach($data['Packages'][$data['Reseller']['res_id']] as $k=>$v){ ?>
                <div class="pricing-table__head <?php if (intval($v['p2r_featured']) === 1) { echo 'pricing-table__head--special'; } ?>">
                  <?php if (intval($v['p2r_featured']) === 1) { ?>
                  <div class="pricing-table__plan-special--text">
                    Most Popular
                  </div>
                  <div class="pricing-table__plan-special--ribbon-wrap">
                    <div class="pricing-table__plan-special--ribbon">
                      <!-- special plan indicator ribbon -->
                    </div>
                  </div>
                  <?php } ?>
                  <div class="pricing-table__plan-title">
                    <?php echo $v['prod_name']; ?>
                  </div>
                  <div class="pricing-table__plan-detail <?php if (intval($v['p2r_featured']) === 1) { echo 'pricing-table__plan-detail--special'; } ?>">
                    <div class="pricing-table__plan-price">
                      <div class="pricing-table__plan-price__sign">$</div>
                      <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['ppr_price']); ?></div>
                      <div class="pricing-table__plan-price__mon">/mo</div>
                    </div>
                  </div>
                  <div class="pricing-table__plan-btn">
                    <a href="signup/1/<?php echo $v['pk_id']; ?>" class="btn btn-success">Buy Now</a>
                  </div>
                </div>
                <?php } ?>
              </div>
            </div>
          </div>
        </div>
      </div>  
          
      <div class="pricing-table clearfix hidden-xs hidden-sm" id="desktopPricing">
        <div class="pricing-table__head">
          <strong>Choose the plan<br>that best matches<br>your goals</strong>
        </div>
        <?php foreach($data['Packages'][$data['Reseller']['res_id']] as $k=>$v){ ?>
        <div class="pricing-table__head <?php if (intval($v['p2r_featured'])===1) { echo 'pricing-table__head--special'; } ?>">
          <?php if (intval($v['p2r_featured'])===1) { ?>
          <div class="pricing-table__plan-special--text">
            Most Popular
          </div>
          <div class="pricing-table__plan-special--ribbon-wrap">
            <div class="pricing-table__plan-special--ribbon">
              <!-- special plan indicator ribbon -->
            </div>
          </div>
          <?php } ?>
          <div class="pricing-table__plan-title">
            <?php echo $v['prod_name']; ?>
          </div>
          <div class="pricing-table__plan-detail <?php if (intval($v['p2r_featured'])===1) { echo 'pricing-table__plan-detail--special'; } ?>">
            <div class="pricing-table__plan-price">
              <div class="pricing-table__plan-price__sign">$</div>
              <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['ppr_price']); ?></div>
              <div class="pricing-table__plan-price__mon">/mo</div>
            </div>
            <div class="pricing-table__plan-desc">
              <?php echo $v['prod_descript']; ?>
            </div>
          </div>
          <div class="pricing-table__plan-btn">
            <a href="signup/1/<?php echo $v['pk_id']; ?>" class="btn btn-success">Buy Now</a>
          </div>
        </div>
        <?php } ?>
        <div class="pricing-table__body" id="pricingTableBody">
          <div class="pricing-table__row">
            <div class="pricing-table__col">
              <div class="pricing-table__cell">
                Set Up
              </div>
            </div>
            <?php foreach($data['Packages'][$data['Reseller']['res_id']] as $k=>$v) { ?>
            <div class="pricing-table__col <?php if (intval($v['p2r_featured'])===1) { echo 'pricing-table__col--special';} ?>">
              <div class="pricing-table__cell">
                <?php echo ($v['ppr_setup'] == 0 ? '' : '$'.trimTrailingZeroes($v['ppr_setup'])); ?>
              </div>
            </div>
            <?php } ?>
          </div>

          <?php
          foreach($data['Offerers'] as $ofeId=>$v){ 
          ?>
            <div class="pricing-table__row">
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  <img src="/images/<?php echo $v['ofr_logo']; ?>" class="img-responsive" style="max-height: 75px;" alt="">
                </div>
              </div>
              <?php foreach($data['Packages'][$data['Reseller']['res_id']] as $k1=>$v1) { ?>
                <div class="pricing-table__col <?php if ( intval( $v1['p2r_featured'] ) === 1 ) { echo 'pricing-table__col--special';} ?>">
                  <div class="pricing-table__cell">
                   
                  </div>
                </div>
              <?php } ?>
            </div>
          <?php foreach ($data['Offerers'][$ofeId]['Product_List'] as $k2=>$v2) { ?>
            <div class="pricing-table__row">
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  <?php echo $v2['prod_name']; ?>
                  <?php if ( $v2['prod_descript'] ) { ?>
                  <img src="/images/icon_tooltip_questionmark_pricing_18px.svg" style="max-width: 20px;" data-toggle="popover" data-content="<?php echo $v2['prod_descript']; ?>">
                  <?php } ?>
                </div>
              </div>
              <?php 
				  foreach( $data['Packages'][$data['Reseller']['res_id']] as $k1=>$v1 ) { ?>
					<div class="pricing-table__col <?php if ( intval( $v1['p2r_featured'] ) === 1 ) { echo 'pricing-table__col--special';} ?>">
					  <div class="pricing-table__cell">
						<?php						
							formatPlanFeatureValue( $data['Offerers'][$ofeId]['Pk_Product_List'][$v1['pk_id']][$v2['prod_id']] );							
						?>
					  </div>
					</div>
			  <?php } ?>
            </div>
          <?php } ?>
        <?php } ?>
        </div>
      </div>
      <!-- END DESKTOP PRICING TABLE -->

      <!-- BEGIN MOBILE PRICING TABLE -->
      <div class="mobile-pricing-table__fixed-head visible-xs visible-sm hidden" id="mobileFixedTableHeader" style="display:none;">
        <div class="container">
          <div class="row">
            <div class="col-xs-12">
              <div class="mobile-pricing clearfix">
              <?php
              $featured_flag = false;
              $i = 0;
			  
              foreach( $data['Packages'][$data['Reseller']['res_id']] as $k=>$v ) { ?>
              <div class="pricing-table__head <?php echo (intval( $v['p2r_featured'] ) === 1 || ($i == count($data['Packages'][$data['Reseller']['res_id']]) - 1 && $featured_flag == false) ? 'active' : '');
                                                    (intval( $v['p2r_featured'] ) === 1 ? $featured_flag = true : '' );  ?>" 
                                                    id="fixed_pk_id_<?php echo $v['pk_id']; ?>">
                <div class="pricing-table__plan-title">
                  <?php echo $v['prod_name']; ?>
                </div>
                <div class="pricing-table__plan-detail">
                  <div class="pricing-table__plan-price">
                    <div class="pricing-table__plan-price__sign">$</div>
                    <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['ppr_price']); ?></div>
                    <div class="pricing-table__plan-price__mon">/mo</div>
                  </div>
                </div>
                <div class="pricing-table__plan-btn">
                  <a href="signup/1/<?php echo $v['pk_id']; ?>" class="btn btn-success">Buy Now</a>
                </div>
              </div>
              <?php $i++; } ?>
              </div>
            </div>
          </div>
        </div>
      </div>     

      <div class="mobile-pricing clearfix visible-xs visible-sm" id="mobilePricing">
        <div class="btn-group btn-group-justified" data-toggle="buttons">
          <?php
          $featured_flag = false;
          $i = 0;
          foreach($data['Packages'][$data['Reseller']['res_id']] as $k=>$v){ ?>
          <label class="btn btn-default mobile-pricing__opt <?php echo (intval( $v['p2r_featured'] ) === 1 ? 'mobile-pricing__opt--special' : ''); ?> <?php echo ( intval( $v['p2r_featured'] ) === 1 || ($i == count($data['Packages'][$data['Reseller']['res_id']]) - 1 && $featured_flag == false) ? 'active' : ''); (intval( $v['p2r_featured'] ) === 1 ? $featured_flag = true : '' ); ?>" data-id="<?php echo $v['pk_id']; ?>">
            <input type="radio" name="mobile-pricing-opt" autocomplete="off" <?php echo ( intval( $v['p2r_featured'] ) === 1 || ($i == count($data['Packages'][$data['Reseller']['res_id']]) - 1 && $featured_flag == false) ? 'checked' : ''); ( intval( $v['p2r_featured'] ) === 1 ? $featured_flag = true : '' ); ?>> <?php echo $v['prod_name']; ?>
          </label>
          <?php $i++; } ?>
        </div>
        <?php
        $featured_flag = false;
        $i = 0;
        foreach( $data['Packages'][$data['Reseller']['res_id']] as $k => $v ){ 
		
		?>
		
        <div class="pricing-table__head <?php echo (intval( $v['p2r_featured'] ) === 1 || ($i == count($data['Packages'][$data['Reseller']['res_id']]) - 1 && $featured_flag == false) ? 'active' : ''); (intval( $v['p2r_featured'] ) === 1 ? $featured_flag = true : '' ); ?>" id="pk_id_<?php echo $v['pk_id']; ?>">
          <div class="pricing-table__plan-title">
            <?php echo $v['prod_name']; ?>
          </div>
          <div class="pricing-table__plan-detail">
            <div class="pricing-table__plan-price">
              <div class="pricing-table__plan-price__sign">$</div>
              <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['ppr_price']); ?></div>
              <div class="pricing-table__plan-price__mon">/mo</div>
            </div>
            <div class="pricing-table__plan-desc">
              <?php echo $v['prod_descript']; ?>
            </div>
          </div>
          <div class="pricing-table__plan-btn">
            <a href="signup/1/<?php echo $v['pk_id']; ?>" class="btn btn-success">Buy Now</a>
          </div>
          <div class="pricing-table__body <?php echo (intval( $v['p2r_featured'] ) === 1 || ($i == count($data['Packages'][$data['Reseller']['res_id']]) - 1 && $featured_flag == false) ? 'active' : ''); 
                                                    (intval( $v['p2r_featured'] ) === 1 ? $featured_flag = true : '' );  ?>">
            <div class="pricing-table__row">
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  Set Up
                </div>
              </div>
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  <?php echo ($v['ppr_setup'] == 0 ? '' : '$'.trimTrailingZeroes($v['ppr_setup'])); ?>
                </div>
              </div>
            </div>
            <?php foreach($data['Offerers'] as $ofeId=>$v1) { 
			
			
			?>
              <div class="pricing-table__row">
                <div class="pricing-table__col">
                  <div class="pricing-table__cell">
                    <img src="/images/<?php echo $v1['ofr_logo']; ?>" class="img-responsive" style="max-height: 75px;" alt="">
                  </div>
                </div>
                <div class="pricing-table__col">
                  <div class="pricing-table__cell">
                    <!-- <?php /*formatPlanFeatureValue($v1['prod_id'], $v['products']);*/ ?> -->
                  </div>
                </div>
              </div>
              <?php 
				
			  	  foreach($v1['Product_List'] as $prodId=>$v2){
			  ?>
                <div class="pricing-table__row">
                  <div class="pricing-table__col">
                    <div class="pricing-table__cell">
                      <?php echo $v2['prod_name']; ?>
                      <?php if ($v2['prod_descript']) { ?>
                      <a tabindex="<?php echo $v2['prod_id']; ?>" role="button" data-toggle="popover" data-content="<?php echo $v2['prod_descript']; ?>"><img src="/images/icon_tooltip_questionmark_pricing_18px.svg" style="max-width: 20px;"></a>
                      <?php } ?>
                    </div>
                  </div>
                  <div class="pricing-table__col">
                    <div class="pricing-table__cell">
                      <?php formatPlanFeatureValue($v1['Pk_Product_List'][$v['pk_id']][$prodId]); ?>
                    </div>
                  </div>
                </div>
              <?php }				
			} ?>
          </div>
        </div>
        <?php $i++; } ?>
      </div>
      <!-- END MOBILE PRICING TABLE -->

      <div class="pricing-head">
        We give businesses the advantage of affordable, easy to use marketing technology that increases sales, customer loyalty, and profitability!
      </div>
    </div>
  </div>
</div>

<script src="/js/pricing.js"></script>