<?php
function trimTrailingZeroes($nbr) {
    return strpos($nbr,'.')!==false ? rtrim(rtrim($nbr,'0'),'.') : $nbr;
}

function formatPlanFeatureValue($featureId, $planFeatures){
  foreach ($planFeatures as $k=>$v){
  	foreach ($v['Features'] as $key=>$value) {
  	  if ($value['lpf_id'] == $featureId){
    		switch ($featureId){
    		  case 7: // format customer service time from minutes to hours
    			$display_val = round(($value['mfc_count'] / 60), 2);
    			($display_val == 0 ? $display_val = '' : 
    			($display_val == 1 ? $display_val = $display_val.' hour/mo.' : $display_val = $display_val.' hours/mo.'));
    		  break;

    		  default:
          if (is_null($value['mfc_count'])){
            $display_val = '<img src="/images/icon_checkmark_pricing_18px.svg" style="max-width: 20px;">';
          } else if ($value['mfc_count'][0] === "$"){
            $display_val = $value['mfc_count'];
          } else {
            $display_val = number_format($value['mfc_count']);
          }
    		  break;
    		}
  		  echo $display_val;
  	  }
  	}
  }
}
$resellerData = $data['Reseller']->getResellerData();

$plan_features = array();
foreach ($resellerData['Offerers_Offered'] as $offerer){
  $plan_features[$offerer['Id']]['logo'] = $offerer['Logo'];
  $plan_features[$offerer['Id']]['description'] = $offerer['Description'];
  $plan_features[$offerer['Id']]['features'] = $data['Reseller']->getPlanFeaturesByOfferer($offerer['Id']);  
}

// remove any features that are not included in any of this resellers plans
foreach($plan_features as $k=>$v){
  foreach ($v['features'] as $k1=>$v1){
    $featureExists = false;
    foreach($resellerData['plans'] as $k2=>$v2){
      foreach ($v2['lmp_features'] as $k3=>$v3){
        foreach ($v3['Features'] as $key=>$value) {
          if ($v1['lpf_id'] == $value['lpf_id']){
            // feature exists on at least one plan
            $featureExists = true;
          }
        }
      }
    }
    // feature does not exist in any plan
    if ($featureExists === false){
      // remove feature
      // var_dump($v1, $k1, $plan_features[$k]['features'][$k1]);
      unset($plan_features[$k]['features'][$k1]);
    }
  }
}

?>
<link href="/css/<?php echo $resellerData['fms_id']; ?>pricing.css" rel="stylesheet">

<div class="pricing-hero">
  <div class="container-fluid">
    <div class="row">
      <div class="col-xs-12">
        <div class="pricing-hero__text">
          <h1>Which plan is right for you?</h1>
          <p>We share your businesses journey and have crafted our software to match where you are and anticipate where you want to be.</p>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="container">
  <div class="row">
    <div class="col-xs-12">
      <div class="pricing-head">Choose the plan that best matches your goals today and helps you bring your vision to life tomorrow.</div>
      
      <!-- BEGIN DESKTOP PRICING TABLE -->
      <div class="pricing-table__fixed-head hidden-xs hidden-sm" id="fixedTableHeader" style="display:none;">
        <div class="container">
          <div class="row">
            <div class="col-xs-12">
              <div class="pricing-table clearfix">
                <div class="pricing-table__head">
                  <strong>Choose the plan<br>that best matches<br>your goals</strong>
                </div>
                <?php foreach($resellerData['plans'] as $k=>$v){ ?>
                <div class="pricing-table__head <?php if ($v['lmp_featured']) { echo 'pricing-table__head--special'; } ?>">
                  <?php if ($v['lmp_featured']) { ?>
                  <div class="pricing-table__plan-special--text">
                    Most Popular
                  </div>
                  <div class="pricing-table__plan-special--ribbon-wrap">
                    <div class="pricing-table__plan-special--ribbon">
                      <!-- special plan indicator ribbon -->
                    </div>
                  </div>
                  <?php } ?>
                  <div class="pricing-table__plan-title">
                    <?php echo $v['lmp_name']; ?>
                  </div>
                  <div class="pricing-table__plan-detail <?php if ($v['lmp_featured']) { echo 'pricing-table__plan-detail--special'; } ?>">
                    <div class="pricing-table__plan-price">
                      <div class="pricing-table__plan-price__sign">$</div>
                      <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['lmp_price']); ?></div>
                      <div class="pricing-table__plan-price__mon">/mo</div>
                    </div>
                  </div>
                  <div class="pricing-table__plan-btn">
                    <a href="signup/1/<?php echo $v['lmp_id']; ?>" class="btn btn-success">Buy Now</a>
                  </div>
                </div>
                <?php } ?>
              </div>
            </div>
          </div>
        </div>
      </div>  
          
      <div class="pricing-table clearfix hidden-xs hidden-sm" id="desktopPricing">
        <div class="pricing-table__head">
          <strong>Choose the plan<br>that best matches<br>your goals</strong>
        </div>
        <?php foreach($resellerData['plans'] as $k=>$v){ ?>
        <div class="pricing-table__head <?php if ($v['lmp_featured']) { echo 'pricing-table__head--special'; } ?>">
          <?php if ($v['lmp_featured']) { ?>
          <div class="pricing-table__plan-special--text">
            Most Popular
          </div>
          <div class="pricing-table__plan-special--ribbon-wrap">
            <div class="pricing-table__plan-special--ribbon">
              <!-- special plan indicator ribbon -->
            </div>
          </div>
          <?php } ?>
          <div class="pricing-table__plan-title">
            <?php echo $v['lmp_name']; ?>
          </div>
          <div class="pricing-table__plan-detail <?php if ($v['lmp_featured']) { echo 'pricing-table__plan-detail--special'; } ?>">
            <div class="pricing-table__plan-price">
              <div class="pricing-table__plan-price__sign">$</div>
              <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['lmp_price']); ?></div>
              <div class="pricing-table__plan-price__mon">/mo</div>
            </div>
            <div class="pricing-table__plan-desc">
              <?php echo $v['lmp_description']; ?>
            </div>
          </div>
          <div class="pricing-table__plan-btn">
            <a href="signup/1/<?php echo $v['lmp_id']; ?>" class="btn btn-success">Buy Now</a>
          </div>
        </div>
        <?php } ?>
        <div class="pricing-table__body" id="pricingTableBody">
          <div class="pricing-table__row">
            <div class="pricing-table__col">
              <div class="pricing-table__cell">
                Set Up
              </div>
            </div>
            <?php foreach($resellerData['plans'] as $k=>$v){ ?>
            <div class="pricing-table__col <?php if ($v['lmp_featured']) { echo 'pricing-table__col--special';} ?>">
              <div class="pricing-table__cell">
                <?php echo ($v['lmp_fee'] == 0 ? '' : '$'.trimTrailingZeroes($v['lmp_fee'])); ?>
              </div>
            </div>
            <?php } ?>
          </div>

          <?php 
          foreach($plan_features as $k=>$v){ 
          ?>
            <div class="pricing-table__row">
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  <div style="text-align: center;text-align: center; position: relative;left: -10px;">
                    <?php if ($resellerData['res_whitelabel']){ ?>
                      <?php if (isset($resellerData["fms_logo_secondary"])){ ?>
                        <img src="/images/<?php echo  $resellerData['fms_id'].'/s_'.$resellerData["fms_logo_secondary"]; ?>"  style="max-height: 75px;">
                      <?php } else { ?>
                        <img src="/images/<?php echo  $resellerData['fms_id'].'/h_'.$resellerData["fms_logo"]; ?>" style="max-height: 75px;">
                      <?php } ?>
                    <?php } else { ?>
                      <img src="/images/<?php echo $v['logo']; ?>" style="max-height: 75px;">
                    <?php } ?>
                    <div style="margin-top: 10px;">
                      <?php echo $v['description']; ?>
                    </div>
                  </div>
                </div>
              </div>
              <?php foreach($resellerData['plans'] as $k1=>$v1){ ?>
                <div class="pricing-table__col <?php if ($v1['lmp_featured']) { echo 'pricing-table__col--special';} ?>">
                  <div class="pricing-table__cell">
                   
                  </div>
                </div>
              <?php } ?>
            </div>
          <?php
          foreach ($v['features'] as $k2=>$v2){
          ?>
            <div class="pricing-table__row">
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  <?php echo $v2['lpf_feature']; ?>
                  <?php if ($v2['lpf_description']) { ?>
                  <img src="/images/icon_tooltip_questionmark_pricing_18px.svg" style="max-width: 20px;" data-toggle="popover" data-content="<?php echo $v2['lpf_description']; ?>">
                  <?php } ?>
                </div>
              </div>
              <?php foreach($resellerData['plans'] as $k1=>$v1){ ?>
                <div class="pricing-table__col <?php if ($v1['lmp_featured']) { echo 'pricing-table__col--special';} ?>">
                  <div class="pricing-table__cell">
                    <?php formatPlanFeatureValue($v2['lpf_id'], $v1['lmp_features']); ?>
                  </div>
                </div>
              <?php } ?>
            </div>
          <?php } ?>
        <?php } ?>
        </div>
      </div>
      <!-- END DESKTOP PRICING TABLE -->

      <!-- BEGIN MOBILE PRICING TABLE -->
      <div class="mobile-pricing-table__fixed-head visible-xs visible-sm hidden" id="mobileFixedTableHeader" style="display:none;">
        <div class="container">
          <div class="row">
            <div class="col-xs-12">
              <div class="mobile-pricing clearfix">
              <?php
              $featured_flag = false;
              $i = 0;
              foreach($resellerData['plans'] as $k=>$v){ ?>
              <div class="pricing-table__head <?php echo ($v['lmp_featured'] || ($i == count($resellerData['plans']) - 1 && $featured_flag == false) ? 'active' : ''); 
                                                    ($v['lmp_featured'] ? $featured_flag = true : '' );  ?>" 
                                                    id="fixed_lmp_id_<?php echo $v['lmp_id']; ?>">
                <div class="pricing-table__plan-title">
                  <?php echo $v['lmp_name']; ?>
                </div>
                <div class="pricing-table__plan-detail">
                  <div class="pricing-table__plan-price">
                    <div class="pricing-table__plan-price__sign">$</div>
                    <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['lmp_price']); ?></div>
                    <div class="pricing-table__plan-price__mon">/mo</div>
                  </div>
                </div>
                <div class="pricing-table__plan-btn">
                  <a href="signup/1/<?php echo $v['lmp_id']; ?>" class="btn btn-success">Buy Now</a>
                </div>
              </div>
              <?php $i++; } ?>
              </div>
            </div>
          </div>
        </div>
      </div>     

      <div class="mobile-pricing clearfix visible-xs visible-sm" id="mobilePricing">
        <div class="btn-group btn-group-justified" data-toggle="buttons">
          <?php
          $featured_flag = false;
          $i = 0;
          foreach($resellerData['plans'] as $k=>$v){ ?>
          <label class="btn btn-default mobile-pricing__opt <?php echo ($v['lmp_featured'] ? 'mobile-pricing__opt--special' : ''); ?> <?php echo ($v['lmp_featured'] || ($i == count($resellerData['plans']) - 1 && $featured_flag == false) ? 'active' : ''); ($v['lmp_featured'] ? $featured_flag = true : '' ); ?>" data-id="<?php echo $v['lmp_id']; ?>">
            <input type="radio" name="mobile-pricing-opt" autocomplete="off" <?php echo ($v['lmp_featured'] || ($i == count($resellerData['plans']) - 1 && $featured_flag == false) ? 'checked' : ''); ($v['lmp_featured'] ? $featured_flag = true : '' ); ?>> <?php echo $v['lmp_name']; ?>
          </label>
          <?php $i++; } ?>
        </div>
        <?php
        $featured_flag = false;
        $i = 0;
        foreach($resellerData['plans'] as $k=>$v){ ?>

        <div class="pricing-table__head <?php echo ($v['lmp_featured'] || ($i == count($resellerData['plans']) - 1 && $featured_flag == false) ? 'active' : ''); ($v['lmp_featured'] ? $featured_flag = true : '' ); ?>" id="lmp_id_<?php echo $v['lmp_id']; ?>">
          <div class="pricing-table__plan-title">
            <?php echo $v['lmp_name']; ?>
          </div>
          <div class="pricing-table__plan-detail">
            <div class="pricing-table__plan-price">
              <div class="pricing-table__plan-price__sign">$</div>
              <div class="pricing-table__plan-price__amt"><?php echo trimTrailingZeroes($v['lmp_price']); ?></div>
              <div class="pricing-table__plan-price__mon">/mo</div>
            </div>
            <div class="pricing-table__plan-desc">
              <?php echo $v['lmp_description']; ?>
            </div>
          </div>
          <div class="pricing-table__plan-btn">
            <a href="signup/1/<?php echo $v['lmp_id']; ?>" class="btn btn-success">Buy Now</a>
          </div>
          <div class="pricing-table__body <?php echo ($v['lmp_featured'] || ($i == count($resellerData['plans']) - 1 && $featured_flag == false) ? 'active' : ''); 
                                                    ($v['lmp_featured'] ? $featured_flag = true : '' );  ?>">
            <div class="pricing-table__row">
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  Set Up
                </div>
              </div>
              <div class="pricing-table__col">
                <div class="pricing-table__cell">
                  <?php echo ($v['lmp_fee'] == 0 ? '' : '$'.trimTrailingZeroes($v['lmp_fee'])); ?>
                </div>
              </div>
            </div>
            <?php foreach($plan_features as $k1=>$v1){ ?>
              <div class="pricing-table__row">
                <div class="pricing-table__col">
                  <div class="pricing-table__cell">
                    <div style="text-align: center;text-align: center; position: relative;left: -10px;">
                      <?php if ($resellerData['res_whitelabel']){ ?>
                        <?php if (isset($resellerData["fms_logo_secondary"])){ ?>
                          <img src="/images/<?php echo  $resellerData['fms_id'].'/s_'.$resellerData["fms_logo_secondary"]; ?>"  style="max-height: 75px;">
                        <?php } else { ?>
                          <img src="/images/<?php echo  $resellerData['fms_id'].'/h_'.$resellerData["fms_logo"]; ?>"  style="max-height: 75px;">
                        <?php } ?>
                      <?php } else { ?>
                        <img src="/images/<?php echo $v1['logo']; ?>" style="max-height: 75px;">
                      <?php } ?>
                      <div style="margin-top: 10px;">
                        <?php echo $v1['description']; ?>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="pricing-table__col">
                  <div class="pricing-table__cell">
                    <!-- <?php formatPlanFeatureValue($v1['lpf_id'], $v['lmp_features']); ?> -->
                  </div>
                </div>
              </div>
              <?php foreach($v1['features'] as $k2=>$v2){ ?>
                <div class="pricing-table__row">
                  <div class="pricing-table__col">
                    <div class="pricing-table__cell">
                      <?php echo $v2['lpf_feature']; ?>
                      <?php if ($v2['lpf_description']) { ?>
                      <a tabindex="<?php echo $k1; ?>" role="button" data-toggle="popover" data-content="<?php echo $v2['lpf_description']; ?>"><img src="/images/icon_tooltip_questionmark_pricing_18px.svg" style="max-width: 20px;"></a>
                      <?php } ?>
                    </div>
                  </div>
                  <div class="pricing-table__col">
                    <div class="pricing-table__cell">
                      <?php formatPlanFeatureValue($v2['lpf_id'], $v['lmp_features']); ?>
                    </div>
                  </div>
                </div>
              <?php } ?>
            <?php } ?>
          </div>
        </div>
        <?php $i++; } ?>
      </div>
      <!-- END MOBILE PRICING TABLE -->

      <div class="pricing-head">
        We give businesses the advantage of affordable, easy to use marketing technology that increases sales, customer loyalty, and profitability!
      </div>
    </div>
  </div>
</div>

<script src="/js/pricing_v1.js"></script>