<?php 
$obj =
array(
	'state' => array(
		'AL' => 'Alabama',
		'AK' => 'Alaska',
		'AZ' => 'Arizona',
		'AR' => 'Arkansas',
		'CA' => 'California',
		'CO' => 'Colorado',
		'CT' => 'Connecticut',
		'DC' => 'District Of Columbia',
		'DE' => 'Delaware',
		'FL' => 'Florida',
		'GA' => 'Georgia',
		'HI' => 'Hawaii',
		'ID' => 'Idaho',
		'IL' => 'Illinois',
		'IN' => 'Indiana',
		'IA' => 'Iowa',
		'KS' => 'Kansas',
		'KY' => 'Kentucky',
		'LA' => 'Louisiana',
		'ME' => 'Maine',
		'MD' => 'Maryland',
		'MA' => 'Massachusetts',
		'MI' => 'Michigan',
		'MN' => 'Minnesota',
		'MS' => 'Mississippi',
		'MO' => 'Missouri',
		'MT' => 'Montana',
		'NE' => 'Nebraska',
		'NV' => 'Nevada',
		'NH' => 'New Hampshire',
		'NJ' => 'New Jersey',
		'NM' => 'New Mexico',
		'NY' => 'New York',
		'NC' => 'North Carolina',
		'ND' => 'North Dakota',
		'OH' => 'Ohio',
		'OK' => 'Oklahoma',
		'OR' => 'Oregon',
		'PA' => 'Pennsylvania',
		'RI' => 'Rhode Island',
		'SC' => 'South Carolina',
		'SD' => 'South Dakota',
		'TN' => 'Tennessee',
		'TX' => 'Texas',
		'UT' => 'Utah',
		'VT' => 'Vermont',
		'VA' => 'Virginia',
		'WA' => 'Washington',
		'WV' => 'West Virginia',
		'WI' => 'Wisconsin',
		'WY' => 'Wyoming'
	),
	'territory' => array( 
		'AS' => 'American Samda',
		'FM' => 'Federated States of Micronesia',
		'GU' => 'Guam',
		'MH' => 'Marshall Islands',
		'MP' => 'Northern Mariana Islands',
		'PW' => 'Palau',
		'PR' => 'Puerto Rico',
		'UM' => 'United States Minor Outlying Islands',
		'VI' => 'Virgin Islands',
		'AA' => 'Armed Forces Americas',
		'AP' => 'Armed Forces Pacific',
		'AE' => 'Armed Forces Others'
	)
);

$states = $territory = '';

foreach( $obj['state'] as $k => $v ) {
	$states .= "<option value='{$k}'>{$v}</option>";
}

foreach( $obj['territory'] as $k => $v ) {
	$territory .= "<option value='{$k}'>{$v}</option>";
}

// Current year for credit card
$year = date( 'Y' );
$yearOpt = '';
for( $i = 0; $i <= 20; ++$i ) {
	$yearOpt.= "<option value='{$year}'>{$year}</option>";   
	$year++;
}

?>
<div class="container signup__wrap signup__height">
	<div class="row">
		<div class="col-xs-12">
			<div id="formErrors"></div>
		</div>
	</div>

	<div class="row">
		<div class="col-xs-12" id="searchBusinessWrap">
			<div class="row">
				<div class="col-xs-12">
					<div class="signup__heading" id="search-prog">Business Information</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xs-12">
					<form id="searchBusinessForm">
						<div class="row">
							<div class="col-xs-12">
								<div class="form-group">
									<label>All fields are required.</label><br>
									<label for="ltm_company_name">Business Name</label>
									<input type="text" name="txt64_ltm_company_name_r" id="ltm_company_name" class="vCheck form-control" required>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-12 col-sm-6">
								<div class="form-group">
									<label for="ltb_email">Email Address</label>&nbsp;&nbsp;&nbsp;<span id="emailMatchError" style="display:none;color: tomato;"><span class="glyphicon glyphicon-exclamation-sign"></span> This email is registered already.</span>
									<input type="email" id="ltb_email" name="ema_ltb_email_r" class="vCheck form-control" required>
								</div>
							</div>
							<div class="col-xs-12 col-sm-6">
								<div class="form-group">
									<label for="ltb_email2">Confirm Email Address</label>&nbsp;&nbsp;&nbsp;<span id="emailMatchError2" style="display:none; color:tomato;"><span class="glyphicon glyphicon-exclamation-sign"></span> Email fields must match</span>
									<input type="email" id="ltb_email2" name="ema_ltb_email2_r" class="vCheck form-control" required>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-12 col-sm-6">
								<div class="form-group">
									<label for="ltb_contact_first_name">Owner First Name</label>
									<input type="text" id="ltb_contact_first_name" name="nam_ltb_contact_first_name_r" class="vCheck form-control" required>
								</div>
							</div>
							<div class="col-xs-12 col-sm-6">
								<div class="form-group">
									<label for="ltb_contact_last_name">Owner Last Name</label>
									<input type="text" id="ltb_contact_last_name" name="nam_ltb_contact_last_name_r" class="vCheck form-control" required>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-12 col-sm-6">
								<div class="form-group">
									<label for="ltm_phone_number">Business Phone Number</label>
									<input type="text" id="ltm_phone_number" name="pho_ltm_phone_number_r" class="vCheck form-control" required>
								</div>
							</div>
							<div class="col-xs-12 col-sm-6">
								<div class="form-group">
									<label for="ltm_zipcode">Business Zip Code</label>
									<input type="text" name="zip_ltm_zipcode_r" class="vCheck form-control" id="ltm_zipcode" required>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-xs-12">
								<div class="form-group">
									<button type="submit" class="btn btn-success" id="searchBusinessSubmit">Continue</button>
								</div>
							</div>
						</div>
					</form>
					<div id="search-results"></div>
					<div id="map-canvas"></div>
				</div>
			</div>
		</div>
		<div class="col-xs-12">
			<form id="businessAddressForm" style="display:none;" method="POST" action='/signup/3/<?php echo $data['URL_Params']['pk_id']; ?>'>
				<input type="hidden" name="txt64_ltm_google_id">
				<input type="hidden" name="dec_ltm_lat_r">
				<input type="hidden" name="dec_ltm_lng_r">
				<input type="hidden" name="nam_ltb_contact_first_name_r">
				<input type="hidden" name="nam_ltb_contact_last_name_r">
				<input type="hidden" name="dec_pk_id_r" value="<?php echo htmlspecialchars(intval($data['URL_Params']['pk_id'])); ?>">
				<input type="hidden" name="dec_res_id_r" value="<?php echo htmlspecialchars(intval($data['Reseller']['res_id'])); ?>">
				<input type="hidden" name="txt32_subid_r" value="<?php echo ($data['Reseller']['fms_prismpay_subid'] ? $data['Reseller']['fms_prismpay_subid'] : 'LOCAL'); ?>">
				<div class="row">
					<div class="col-xs-12">
						<div class="signup__heading">Business Information</div>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 col-sm-7">
						<div class="form-group">
							<label for="txt64_ltm_company_name_r">Business Name</label>
							<input type="text" name="txt64_ltm_company_name_r" id="txt64_ltm_company_name_r" class="vCheck form-control" required>
						</div>
					</div>
					<div class="col-xs-12 col-sm-5">
						<div class="form-group">
							<label for="pho_ltm_phone_number_r">Business Phone Number</label>
							<input type="text" name="pho_ltm_phone_number_r" id="pho_ltm_phone_number_r" class="vCheck form-control" required>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 col-sm-4">
						<div class="form-group">
							<label for="txt_ltm_address_r">Street Address</label>
							<input type="text" name="txt_ltm_address_r" id="txt_ltm_address_r" class="vCheck form-control" required>
						</div>
					</div>
					<div class="col-xs-12 col-sm-3">
						<div class="form-group">
							<label for="nam_ltm_city_r">City</label>
							<input type="text" id="nam_ltm_city_r" name="nam_ltm_city_r" class="vCheck form-control" required>
						</div>
					</div>
					<div class="col-xs-12 col-sm-3">
						<div class="form-group">
							<label for="abc_ltm_state_r">State</label>
							<select id="abc_ltm_state_r" name="abc_ltm_state_r" class="vCheck form-control" required>
								<option value="" selected disabled>Select State</option>
								<optgroup label='States'><?php echo $states; ?></optgroup>
								<optgroup label='U.S. Territories'><?php echo $territory; ?></optgroup>
							</select>
						</div>
					</div>
					<div class="col-xs-12 col-sm-2">
						<div class="form-group">
							<label for="zip_ltm_zipcode_r">Postal Code</label>
							<input type="text" name="zip_ltm_zipcode_r" id="zip_ltm_zipcode_r" class="vCheck form-control" required>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12">
						<div class="form-group">
							<label>
								<input type="checkbox" name="bit_use_biz_addr" id="useBusinessAddress" value="1" checked>
								My Business Address and Billing Address are the same
							</label>
						</div>
					</div>
				</div>
				<div id="billingAddressForm" style="display:none;">
					<div class="row">
						<div class="col-xs-12">
							<div class="signup__heading">Billing Address</div>
						</div>
					</div>
						<div class="row">
							<div class="col-xs-12 col-sm-4">
								<div class="form-group">
									<label for="txt_cc_ltm_address">Street Address</label>
									<input type="text" name="txt_cc_ltm_address" id="txt_cc_ltm_address" class="vCheck form-control">
								</div>
							</div>
							<div class="col-xs-12 col-sm-3">
								<div class="form-group">
									<label for="nam_cc_ltm_city_r">City</label>
									<input type="text" id="nam_cc_ltm_city" name="nam_cc_ltm_city" class="vCheck form-control">
								</div>
							</div>
							<div class="col-xs-12 col-sm-3">
								<div class="form-group">
									<label for="abc_cc_ltm_state">State</label>
									<select id="abc_cc_ltm_state" name="abc_cc_ltm_state" class="vCheck form-control">
										<option value="" disabled>Select State</option>
										<optgroup label='States'><?php echo $states; ?></optgroup>
										<optgroup label='U.S. Territories'><?php echo $territory; ?></optgroup>
									</select>
								</div>
							</div>
							<div class="col-xs-12 col-sm-2">
								<div class="form-group">
									<label for="zip_cc_ltm_zipcode">Postal Code</label>
									<input type="text" name="zip_cc_ltm_zipcode" id="zip_cc_ltm_zipcode" class="vCheck form-control">
								</div>
							</div>
						</div>
					</div> <!-- END  #billingAddressForm -->
					<div class="signup__form-highlight" id="creditCardInput">
						<div class="row">
							<div class="col-xs-12">
								<div class="signup__heading"><img src="/images/icon_lock_secure_48px.svg" class="lock-icon">Billing Information</div>
								<label>All fields are required.</label>
								<div class="row">
									<div class="col-xs-12 col-sm-6">
										<div class="form-group">
											<label for="adn_ccnum_r">Card Number</label>
											<input type="text" name="adn_ccnum_r" id="adn_ccnum_r" class="form-control" required>
										</div>
									</div>
									<div class="col-xs-12 col-sm-6">
										<div class="form-group">
											<label for="nam_cc_cardholder_r">Cardholder Name</label>
											<input type="text" name="nam_cc_cardholder_r" id="nam_cc_cardholder_r" class="vCheck form-control" required>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 col-sm-6">
										<div class="form-group">
											<label for="dec2_cc_expmon_r">Expiration Month</label>
											<select name="dec2_cc_expmon_r" id="dec2_cc_expmon_r" class="form-control vCheck" required>
												<option selected value=1>1</option>
												<option value=2>2</option>
												<option value=3>3</option>
												<option value=4>4</option>
												<option value=5>5</option>
												<option value=6>6</option>
												<option value=7>7</option>
												<option value=8>8</option>
												<option value=9>9</option>
												<option value=10>10</option>
												<option value=11>11</option>
												<option value=12>12</option>
											</select>
										</div>
									</div>
									<div class="col-xs-12 col-sm-6">
										<div class="form-group">
											<label for="dec4_cc_expyear_r">Expiration Year</label>
											<select name="dec4_cc_expyear_r" id="dec4_cc_expyear_r" class="form-control vCheck" required>
												<?php echo $yearOpt; ?>
											</select>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 col-sm-6">
										<div class="form-group">
											<label for="dec_cc_ccv_r">CVV/CVV2</label>
											<input id="dec_cc_ccv_r" name="dec_cc_ccv_r" type="text" class="form-control vCheck" required>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 col-sm-6">
										<div class="form-group">
											<label><em>Accepted Payment Methods</em></label>
											<img src="/images/credit-cards.png" class="img-responsive">
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="signup__form-highlight" id="accountCreateInput">
						<div class="row">
							<div class="col-xs-12">
								<div class="signup__heading"><img src="/images/icon_lock_secure_48px.svg" class="lock-icon">Create Password</div>
								<div class="row">
									<div class="col-xs-12">
										<div class="form-group">
											<label for="ema_ltb_email_r">Login Email</label>
											<input type="email" name="ema_ltb_email_r" id="ema_ltb_email_r" class="vCheck form-control" required>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 col-xs-6">
										<div class="form-group">
											<label for="psw_ltb_password_r">Password</label>&nbsp;&nbsp;&nbsp;<span id="pwMatchError" style="display:none; color:tomato;"><span class="glyphicon glyphicon-exclamation-sign"></span> Passwords must match</span>
											<input type="password" name="psw_ltb_password_r" id="psw_ltb_password_r" class="vCheck form-control" required pattern=".{3,}" title="3 characters minimum">
										</div>
									</div>
									<div class="col-xs-12 col-xs-6">
										<div class="form-group">
											<label for="psw_ltb_password2_r">Confirm Password</label>&nbsp;&nbsp;&nbsp;<span id="pwMatchError2" style="display:none; color:tomato;"><span class="glyphicon glyphicon-exclamation-sign"></span> Passwords must match</span>
											<input type="password" name="psw_ltb_password2_r" id="psw_ltb_password2_r" class="vCheck form-control" required pattern=".{3,}" title="3 characters minimum">
										</div>
									</div>									
								</div>
							</div>
						</div>
					</div>	
					<div class="row">
						<div class="col-xs-12">
							<div class="signup__heading">Confirm and Place Order</div>
							<label>Membership Type</label>
							<div class="signup__form-highlight" id="accountCreateInput">
								<div class="row">
									<div class="col-xs-12">
									
										<strong><?php
											echo $data['Reseller']['Chosen_Pack']['prod_name'];										
										?></strong><br>
										<?php 
										if ($data['Reseller']['Chosen_Pack']['pk_terms'] === null) {
											echo '$'.$data['Reseller']['Chosen_Pack']['ppr_price'].'/mo. + $'.$data['Reseller']['Chosen_Pack']['ppr_setup'].' one time setup fee';
										}
										else {
											echo $data['Reseller']['Chosen_Pack']['pk_terms'];
										} 
										?>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-xs-12">
						<?php if ($data['Reseller']['Chosen_Pack']['pk_more_info']){ ?>
							<div class="row">
								<div class="col-xs-12">
									<?php echo $data['Reseller']['Chosen_Pack']['pk_more_info']; ?>
									<?php echo (floatval($data['Reseller']['Chosen_Pack']['ppr_setup']) * 1 == 0 ? 'Your credit card will be charged $0.01 today for authentication purposes.<br><br>':''); ?>
								</div>
							</div>
						<?php } else { ?>
							<div class="row">
								<div class="col-xs-12">
									<label class="signupLabel">Purchase Total</label>
							        <div class="signup__form-highlight">
								        <table class="purchase-breakdown" style="background:#fff;">
								          <tr>
								            <td>Monthly Membership Fee:</td>
								            <td><?php echo '$'.$data['Reseller']['Chosen_Pack']['ppr_price']; ?></td>
								          </tr>
								          <tr>
								            <td>One Time Setup Fee:</td>
								            <td><?php echo '$'.$data['Reseller']['Chosen_Pack']['ppr_setup']; ?></td>
								          </tr>
								          <tr style="color:green;">
								            <td><strong>Total Purchase Today:</strong></td>
								            <td><strong><?php 
											setlocale(LC_MONETARY, 'en_US');
											echo '$'.((floatval($data['Reseller']['Chosen_Pack']['ppr_setup']) + floatval($data['Reseller']['Chosen_Pack']['ppr_price'])) * 1 == 0  ? '0.01' : number_format((floatval($data['Reseller']['Chosen_Pack']['ppr_setup']) + floatval($data['Reseller']['Chosen_Pack']['ppr_price'])), 2, '.', ',')
																		); ?></strong></td>
								          </tr>
								        </table>
							        </div>
								</div>
							</div>
						<?php } ?>
						</div>
					</div>	
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<label><input type="checkbox" name="" required> I acknowledge that I have read and agree to the <a href="/terms" target="_blank">Terms and Conditions</a> and <a href="/privacy" target="_blank">Privacy Policy</a></label>
							</div>
						</div>
					</div>	
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<button type="submit" class="btn btn-success">Confirm Purchase</button>
							</div>
						</div>
					</div>								
				</form>
			</div>
		</div>
	</div>
</div>
</div>