/* ********check-form-inputs.js*******
*****jQuery is required to use this class*****
'r'   : Required 
'abc' : Just letters
'aon' : Alphabet or number
'dec' : Decimal
'ema' : Email
'int' : Integer
'wnu' : Integer
'pho' : Phone number
'url' : URL
'yon' : Y or N
'nam' : Name
'zip' : ZIP Code
'txt' : Address

add the class validate to the input you want to validate(required in order to validate it) and data-vtype the list of types (above list) you want to validate that input with.
//example the next input is required and integer
<input type="text" class="vCheck" data-vtype="r int">

//if you want the to check the length of the field just add data-vlength="min max", if only one value is set max will be it and min will be 1
//if data length is not set the we check for "maxlength", if maxlength is set then max = maxlength and min = 1
<input type="text" class="vCheck" data-vtype="r int" data-vlength="1 100">

//it will work as well with textareas
<areatext type="text" class="vCheck" data-vtype="r int"></areatext>

*/
 
var validateForm = function (aFormObj) {
	
	var removeNonLetters = function(anArr) {
	  var newArr=[];	
	  for (var i = 0; i < anArr.length; i++) {
		newArr[i] = anArr[i].replace(/[^a-zA-Z]/g, '');
	  }
	  return newArr;
	}
	
	var clean = function(anArr, deleteValue) {
	  var newArr=anArr;	
	  for (var i = 0; i < newArr.length; i++) {
		if (newArr[i] == deleteValue) {         
		  newArr.splice(i, 1);
		  i--;
		}
	  }
	  return newArr;
	}
	
    var HTMLObj=function (anHTMLObj, anObjType, aminLength, amaxLength){
		this.HTMLObj=anHTMLObj;
		this.Type=anObjType;
		this.minLength=aminLength;
		this.maxLength=amaxLength;
		this.Label=$('label[for='+$(anHTMLObj).attr('id')+']').length ==1? $('label[for='+$(anHTMLObj).attr('id')+']').text():0;
	}
	
	var Params = {};
	var errors = [];
	
	//setting default values
	var defaultParams = { validateObj: [], regExObj: {'txt': {regEx: /^[ A-Za-z0-9\;_@./!#()$?,\"'"%&+-.\n]*$/i, message: 'Incorrect format'}, 'zip': {regEx: /^(\d{5}(?:[-\s]\d{4})?)$/, message: 'Incorrect zip code format'}, 'nam': {regEx: /^[a-zA-Z ,.'-]+$/, message: 'Incorrect name format'}, 'yon': {regEx: /^[YN]{1}$/, message: 'Incorrect Y or N format'}, 'url': {regEx: /^(?:(?:https?|ftp):\/\/)?(?:\S+(?::\S*)?@)?(?:(?!10(?:\.\d{1,3}){3})(?!127(?:\.\d{1,3}){3})(?!169\.254(?:\.\d{1,3}){2})(?!192\.168(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z\u00a1-\uffff0-9]+-?)*[a-z\u00a1-\uffff0-9]+)(?:\.(?:[a-z\u00a1-\uffff0-9]+-?)*[a-z\u00a1-\uffff0-9]+)*(?:\.(?:[a-z\u00a1-\uffff]{2,})))(?::\d{2,5})?(?:\/[^\s]*)?$/i, message: 'Incorrect URL format'}, 'pho': {regEx: /^(()?\d{3}())?(-|\s)?\d{3}(-|\s)?\d{4}$/, message: 'Incorrect phone number format. Ex: 555-555-5555'}, 'wnu': {regEx: /^[0-9]+$/, message: 'Only numbers are allowed'}, 'int': {regEx: /^[0-9]+$/, message: 'Only numbers are allowed'}, 'ema': {regEx: /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/, message: 'Incorrect email format'}, 'abc': {regEx: /^[a-zA-Z]+$/, message: 'Only letters are allowed'}, 'aon': {regEx: /^[a-zA-Z0-9]+$/, message: 'Only letters and numbers are allowed'}, 'dec': {regEx: /^[0-9]*([.]?)([0-9]+)$/, message: 'Incorrect Decimal format'}}};	
	var FormObj = $('form');
	
	this.inicialiceObj=function (aFormObj){
		//if it is not define every form of the DOM will be checked
		if (aFormObj != undefined && typeof aFormObj=='object' && $(aFormObj).length > 0) { FormObj=$(aFormObj); }
		defaultParams.validateObj=[];
		//HTML Objects and type 
		$(FormObj).find('.vCheck').each(function (){
			var typeArr =[];
			if ($(this).attr("name") != undefined && $(this).attr("name") != ''){
			 var typeArr = $(this).attr("name").toString().split('_');			 
			}
			var minL=1; var maxL=1;		
			
			if (typeArr.length > 0){ var temp = typeArr[0].replace(/[^0-9]+/, ''); }			
			
			if (temp != undefined && temp != '' && !isNaN(temp)){
				maxL=parseInt(temp);
			}
			else if ( $(this).attr("maxlength") != undefined && $(this).attr("maxlength").length > 0 && $(this).attr("maxlength") != '' && !isNaN($(this).attr("maxlength")) ) { maxL=$(this).attr("maxlength"); }
			
			clean(typeArr, ''); removeNonLetters(typeArr);
		
			defaultParams.validateObj.push(new HTMLObj($(this), typeArr, minL, maxL));
		});
		Params = defaultParams;        
	}
	
	this.inicialiceObj(aFormObj);
	
	var validMinMax=function (varToCheck, i){
		if (Params.validateObj[i].minLength > 0 && Params.validateObj[i].minLength < Params.validateObj[i].maxLength){			
			
			return varToCheck.length <= Params.validateObj[i].maxLength;
		}
		return true;
	}	
	
	this.validInputs=function (returnErrorArr){
		errors=[]; var match=[];
		for (var i=0; i < Params.validateObj.length; i++){
			
			var validateText = $(Params.validateObj[i].HTMLObj).is("input")||$(Params.validateObj[i].HTMLObj).is("select")||$(Params.validateObj[i].HTMLObj).is("textarea")?$(Params.validateObj[i].HTMLObj).val():$(Params.validateObj[i].HTMLObj).text();
			
			for (var j=0; j < Params.validateObj[i].Type.length; j++){	
				//console.log(Params.validateObj[i].Type[j]);
				if (Params.validateObj[i].Type[j] == 'match' && match.indexOf(i) == -1) { match.push(i); } 			
				else if (Params.validateObj[i].Type[j] == 'r') { if ((validateText) == '') { errors.push((Params.validateObj[i].Label && Params.validateObj[i].Label != ''? Params.validateObj[i].Label+': ':'') + 'Required value'); } }
				else if ( validateText != '' && Params.regExObj[Params.validateObj[i].Type[j]] != undefined ){					
				
					//we can check this type					
					if (!Params.regExObj[Params.validateObj[i].Type[j]].regEx.test(validateText)){						
						errors.push((Params.validateObj[i].Label && Params.validateObj[i].Label != ''? Params.validateObj[i].Label+': ':'') + Params.regExObj[Params.validateObj[i].Type[j]].message);
					}
				}				
				
			}
			
			if (!validMinMax(validateText, i)) { errors.push((Params.validateObj[i].Label && Params.validateObj[i].Label != ''? Params.validateObj[i].Label+': ':'') + /*'Value must have at least ' + Params.validateObj[i].minLength +*/ 'Value must have less than '+ (Params.validateObj[i].maxLength+1) + ' characters'); }
			
		}
		
		if (match.length > 1){
			
			var str = ''; var err = '';var errorFlag=false;
			
			for (var i = 0; i < match.length; i++){ 
			
				var matchText = $(Params.validateObj[match[i]].HTMLObj).is("input")||(Params.validateObj[match[i]].HTMLObj).is("select")||(Params.validateObj[match[i]].HTMLObj).is("textarea")?$(Params.validateObj[match[i]].HTMLObj).val():$(Params.validateObj[match[i]].HTMLObj).text();
				
				if ( str == '' ) { str = matchText; }
				
				else if ((matchText) != str) { errorFlag=true; }
				
				if (errorFlag && i == (match.length-1)) { err+= (err == ''?'':' and ')+(Params.validateObj[match[i]].Label && Params.validateObj[match[i]].Label != ''? Params.validateObj[match[i]].Label+': ':'')+' must match'; errors.push(err); } 
				
				else { err+= (err == ''?'':', ')+(Params.validateObj[match[i]].Label && Params.validateObj[match[i]].Label != ''? Params.validateObj[match[i]].Label+': ':''); }
				
			}
		}	
		
		if (returnErrorArr) return errors; else return errors.length == 0;
		
	}
	
	this.buildMessage=function (){
		if (errors.length > 0){
			var str='<div class="alert alert-danger alert-error" role="alert"><a href="#" class="close" data-dismiss="alert">&times;</a><span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span><span class="sr-only">Error:</span> Please review the following.<ol>';
			for (var i=0; i<errors.length; i++){
				str+= '<li>'+errors[i]+'</li>';
			}	
			str+='</ol></div>';
			return str;
		}
		return '';
	}
	
	
}