// Example use:

// <form id="suggestKeywordForm">
// 	<div id="suggestKeywordInfo" style="display: none;"></div>
// 	<input type="text" name="suggestKeyword" id="suggestKeyword" value="">
// 	<button type="submit">Submit</button>
// </form>

// <script>
//     suggestKeyword(
//       {
//       	form: '#suggestKeywordForm',
//       	inputControl: '#suggestKeyword',
//          infoDiv: '#suggestKeywordInfo',
//          callUrl: '../ajax/ajax.suggest-keyword.php'
//       }
//     );
// </script>



var suggestKeyword = function (settings){

	var ourForm   = $(settings['form']);
	var ourInput = $(settings['inputControl']);
	var infoDiv  = $(settings['infoDiv']);
	var callUrl  = settings['callUrl'];
	// console.log(callUrl);
	ourForm.submit(function(event){
		event.preventDefault();

		var ourInputVal = ourInput.val().trim().toLowerCase();

		if (ourInputVal === '') {
			infoDiv.html('Enter a keyword suggestion before you submit!').show();
		} else {
			infoDiv.hide();
			var data = {};
			ourForm.find('input').each(function () {
				data[$(this).attr('name')]=$(this).val().trim().toLowerCase();
			})
			$.ajax({
				url: callUrl,
				global: false,
				type: "POST",      
				dataType: "JSON",      
				data: JSON.stringify(data),
				success: function (response){
					console.log(response);
					if (response['status'] !== 'success'){
						// display message
						infoDiv.html(response['msg']).show();
					} else {
						infoDiv.html(response['msg']).show();
						if ( typeof response['cat_id'] != 'undefined' && typeof settings['callBack'] != 'undefined' ){							
							settings['callBack']( response['cat_id'] );
						}	
						ourInput.val('');
					}
				},
				error: function(response){ 
					console.log('error in suggest-keyword ajax call');
					console.log(response);
					infoDiv.html('Error. Please contact support.').show();
				}
			});

		}
	});
}