<?php 
	// get admin login key and last activity timestamp
	$sql = "SELECT adm_key, adm_master, (UNIX_TIMESTAMP() - UNIX_TIMESTAMP(adm_last_activity))/60 AS time_expired FROM tbl_admin WHERE adm_id=:id LIMIT 1";
    $stmt = $dbo->prepare( $sql );
    $stmt->bindValue( ':id', $_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT );
    $stmt=execPDO( $stmt );
    $usr = $stmt->fetchAll( PDO::FETCH_ASSOC );
    $adm_key_check = $usr[0]["adm_key"];
	$adm_key_current = $_SESSION['user']['admin']['adm_key'];

	// has the time limit expired?
	$time_expired = $usr[0]["time_expired"] > 60;

	// do not log out on the chat page
	if (isset($_REQUEST['url1']) && $_REQUEST['url1'] === "chat") {
		$time_expired = false;
	}

	// if $time_expired is false, update adm_last_activity on page load
	if ($time_expired == false){
		$sql = "UPDATE tbl_admin SET adm_last_activity = CURRENT_TIMESTAMP WHERE adm_id=:id";
		$stmt = $dbo->prepare( $sql );
		$stmt->bindValue( ':id', $_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT );
		$stmt=execPDO( $stmt );
	}

	// log out if time is past 5:00PM EST
	if (!$time_expired && $adm_key_check == $adm_key_current) {
		date_default_timezone_set("US/Eastern");		
		if (date('H') > 17) {
			reset_logged_in();
		}
	}
	
	$_AccessFlag = false;
	if ($usr[0]["adm_master"]) {
		$_AccessFlag=true;
	}
	else{
		$stmt = $dbo->prepare( 'SELECT FST.*, ADG.adg_name
				FROM tbl_admin ADM
				INNER JOIN tbl_admin2file A2F ON ADM.adm_id=A2F.adm_id
				INNER JOIN tbl_file_structure FST ON FST.file_id=A2F.file_id
				INNER JOIN tbl_admin_group ADG ON ADG.adg_id=FST.adg_id
				WHERE ADM.adm_id=:adminid' );
		$stmt->bindValue( ':adminid', $_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT );
		$stmt=execPDO( $stmt );
		$QResultArr=array();
		while ($QResult = $stmt->fetch( PDO::FETCH_ASSOC )){
		 	$QResultArr[]=str_replace('.php','', str_replace('page-','',$QResult['file_name']));
		}
		$val_Temp=explode('/' ,$_SERVER[REQUEST_URI]);
		$_URLPage = explode('?',$val_Temp[count($val_Temp)-1])[0];
        if ( empty($_URLPage) || $_URLPage == 'login.php' || $_URLPage == 'reset-password.php') {$_AccessFlag=true;}else{$_AccessFlag= in_array($_URLPage,$QResultArr);}					
	}	
	
	if ( !$_AccessFlag ) header( "Location: /admin/" );
	
    if ( $adm_key_check != $adm_key_current ) {
		reset_logged_in();
    	$_SESSION['adm_error'] = '<br><br><div class="alert alert-danger" role="alert"><span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span> Connection terminated. You have logged in from a different location.</div>'; 
    	unset($_SESSION['user']['admin']);
		header("Location: login.php");
		exit();
	}
	
	if ($time_expired) {
		$_SESSION['adm_error'] = '<br><br><div class="alert alert-danger" role="alert"><span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span> Connection timeout. Your session has expired because of inactivity.</div>'; 
		reset_logged_in();	
    	unset($_SESSION['user']['admin']);
		header("Location: login.php");
		exit();
	}

    function reset_logged_in(){		
		global $dbo;
		$sql = "UPDATE tbl_admin SET adm_logged_in = 0 WHERE adm_id=:id";
		$stmt = $dbo->prepare( $sql );
		$stmt->bindValue( ':id', $_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT );
		$stmt=execPDO( $stmt );
	}	
	
?>

<!DOCTYPE html>
<html lang="en">
<head>

<meta charset="UTF-8">

	<meta name="robots" content="noindex">
	<meta name="googlebot" content="noindex">
	<title>Administration Area</title>

	<meta name="viewport" content="initial-scale=1, maximum-scale=1">
	<link rel="shortcut icon" href="/favicon.ico">

	<!-- plugins -->
	<link rel="stylesheet" href="/plugins/font-awesome/4.2.0/css/font-awesome.css">
	<link rel="stylesheet" href="/plugins/bootstrap/css/bootstrap.css">
	<link rel="stylesheet" href="/plugins/bootstrap/css/bootstrap-theme.css">
	<link rel="stylesheet" href="/plugins/datatables/1.10.7/dataTables.bootstrap.css">
	<link rel="stylesheet" href="/plugins/datatables/responsive/2.1.1/css/responsive.dataTables.min.css">
	



	<!-- styles -->
	<link rel="stylesheet" href="/admin/css/styles.css">
	<?php echo isset($pageCSS)? '<link rel="stylesheet" href="' . $pageCSS . '">': '';?>

	<!-- scripts -->
	<script type="text/javascript" src="/plugins/jquery/jquery-1.11.1.min.js"></script>
	<script type="text/javascript" src="/plugins/bootstrap/js/bootstrap.js"></script>


	<script type="text/javascript" charset="utf8" src="/plugins/datatables/1.10.7/jquery.dataTables.js"></script>
	<script type="text/javascript" charset="utf8" src="/plugins/datatables/1.10.7/dataTables.bootstrap.js"></script>
	<script type="text/javascript" charset="utf8" src="/plugins/datatables/responsive/2.1.1/js/dataTables.responsive.min.js"></script>



</head>
<body>


<header>
	<div class="fullBarWrap wrap">	   
		<div class="container">
			<div class="row topBar">				
					<span style="float:right;">
						<a href="/admin/">Home</a> <?php if( isset( $_SESSION['user']['admin'] ) ) { ?>| <a href="?logout=true">Logout</a><?php } ?>
					</span>				
			</div>
		  <h1 style="color:#fff;text-align:center;"><a href="/admin/">Administration Area</a></h1>	
		</div>
	</div>
</header>
