<?php

//-----------------------------------
// admin/global-msg.php

//-----------------------------------

require '../app/start_session.php';
$dbo=connect();
$_Max_Conversations=3;

require 'header.php';

// --- SEARCHING FOR OPENED CHAT CONVERSATION WITH THIS ADMIN --- //
$sql = 'SELECT * FROM tbl_admin WHERE adm_id=:admin LIMIT 1';

$qry = $dbo->prepare( $sql );

$qry->bindValue(":admin", $_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT);	 

$qry=execPDO($qry);

$_Result = $qry->fetchAll( PDO::FETCH_ASSOC );

?>

<style>

div#msg_character_count, div#subj_character_count {
 margin: 5px 0 10px;
 font-size: 11px;
}

/*Chat Styling*/
.chat-area-text{
 height:30px;
 resize: none;
}
.msg-chat-box p{margin:10px;}
.msg-chat-box p.admin-text{margin-left:30px;}
.msg-chat-box p.user-text{margin-right:30px;}
.msg-chat-box p span{max-width:100%; word-wrap:break-word;}
.msg-chat-box{ 
 padding:5px;
 margin:5px 0 5px 0;
 background-color:#fff;
 overflow-y:auto;
 height:300px;
 border-radius: 3px;
 border: 1px solid #ddd;
}

.out-chat-box{
 position: fixed;
 bottom: 0; 
 max-width: 400px;   
 z-index: 5000;
 padding:10px;
 background-color:#eee;
 border: 2px solid #ddd;
 border-radius: 10px;
}
#alert{
  text-align: center;
  position: fixed;
  top: 25%;
  z-index: 10;
  width: 50%;
  left: 25%;
  right: 50%;
  display: none;
  -webkit-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
  -moz-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
  box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
}
#msg_form {
  margin-bottom: 25px;
}
#msg_subject {
  height: 34px;
}
</style>
<div class="container" id="adm_body">
 <div id='main' class='container'>  
  <h1><span class='glyphicon glyphicon-comment'></span> Chat Messaging </h1>
  <span style="font-size:16px;margin-right:5px;color:#030303;font-weight:bold;">You <span style="color:red;" id="are_or_not"><?php echo ($_Result['adm_logged_in']?'ARE':'ARE NOT') ?></span> available for Consumers and Merchants to Chat</span><button id="admin_avilable" class="btn btn-<?php echo ($_Result['adm_logged_in']?'danger':'primary')?>"><?php echo ($_Result['adm_logged_in'] && $_Result['adm_logged_in']?'Make me Unavailable':'Make me Available')?></button>
  <div id="alert" class="alert alert-success" role="alert"></div>
  <div class='row'>    
    <div class='col-sm-12'>
      <label>Consumers waiting for chat response</label>
      <table id='conversation_requested' class='table table-bordered table-striped'>
        <thead>
          <tr>
            <th>First Name</th>
            <th>Last Name</th>
            <th>Email</th>
			<th></th>
          </tr>
        </thead>
        <tbody>
        </tbody>
      </table>
    </div>
  </div><!--end .row-->
  <div id="conversations" class='row'>    
 
  </div>	
</div><!--end #main .container-->
</div>

<audio id="audiotag" src="sounds/chatbell.wav" preload="auto"></audio>

<script type="text/javascript">

function play_single_sound() {
		document.getElementById('audiotag').play();
	}

function send_chat_msg(inp, e){
 if (e.keyCode === 13 && $(inp).val() != ''){  
  var json_var = {action : 'send_msg', cts_id : $(inp).attr('id').split('_')[1], cta_msg : $(inp).val()} 
  
   $(inp).val('');
   
   $(inp).parents('div:eq(3)').data('typing', '0');
   
   search_conversation(json_var);   
  
 }

}

function empty_value(inp, e){
 if (e.keyCode === 13){
  $(inp).val('');
  
 }
 else {
	 if ($(inp).val() == '')
		 $(inp).parents('div:eq(3)').data('typing', '0');
	 else
		 $(inp).parents('div:eq(3)').data('typing', '1');
 }
 
}

function search_conversation(json_var){
	
 var typingArr=[];
 
 $('.out-chat-box').each(function (){
	 
	typingArr[$(this).data('chatid')]=$(this).data('typing');
	
 });
 
 $.post('../api/api.chat.php', (typeof json_var=='undefined'?{action : 'search', adm_typing: typingArr}:json_var), function (data, status){
 
 if (status == 'success'){
   console.log(data);
   if (data['availability']) {
    
	$('#admin_avilable').removeClass('btn-primary').addClass('btn-danger').text('Make me Unavailable');
	
	$('#are_or_not').text('ARE');
   
   }
   else{
    
	$('#admin_avilable').removeClass('btn-danger').addClass('btn-primary').text('Make me Available');
	
	$('#are_or_not').text('ARE NOT');
	
   }
   
   //var data = jQuery.parseJSON(data1);
   
   if (typeof data['data']!='undefined'){
    
	table.fnClearTable();
    
    var ding_flag=true;	
	
    for (var Key in data['data']){
	 
	 if (ding_flag && !data['data'][Key]['adm_id']){
	 
	  play_single_sound();
	  
	  ding_flag=false;
	  
	 }
	
	 if (!isNaN(Key))
	 
	  table.fnAddData([
	  
	   (data['data'][Key]['csm_first_name']?data['data'][Key]['csm_first_name']:(data['data'][Key]['ltb_contact_name']?data['data'][Key]['ltb_contact_name'].split(" ")[0]:'Unknown'))
	  
	  ,(data['data'][Key]['csm_last_name']?data['data'][Key]['csm_last_name']:(data['data'][Key]['ltb_contact_name']?data['data'][Key]['ltb_contact_name'].split(" ")[data['data'][Key]['ltb_contact_name'].split(" ").length-1]:'Unknown'))
	  
	  ,(data['data'][Key]['csm_email']?data['data'][Key]['csm_email']:(data['data'][Key]['ltb_email']?data['data'][Key]['ltb_email']:'Unknown'))
	  
	  ,(!data['data'][Key]['adm_id']?'<div class="btn-group btn-group-sm" role="group" aria-label="...">'+

	   '<button type="button" id="chat_'+data['data'][Key]['cts_id']+'" title="Take chat conversation" onclick="take_chat(this)" class="btn btn-'+(data['data'][Key]['csm_email']?'info':(data['data'][Key]['ltb_email']?'primary':'default'))+'"><span class="glyphicon glyphicon-comment"></span></button>'+         

	  '</div>':'<span class="alert-danger"><strong> Picked </strong></span>')

	 ]);
   
   }
   
  }
  
  var Max_Conversations=<?php echo "{$_Max_Conversations}";?>;
  if (typeof data['chat']!='undefined'){    
    //check if there are any chat text waiting and update (if the chat box is not created we have to create it at this point)
  	
    for (var Result in data['chat']){	 
	  if (typeof conv_id=='undefined') {var conv_id=[];}	  
	  if (typeof cons_id=='undefined') {var cons_id=[];}
	  if (typeof merch_id=='undefined') {var merch_id=[];}
	  if (typeof csm_name=='undefined') {var csm_name=[];}
	  if (typeof company_name=='undefined') {var company_name=[];}
	  if (typeof conv_text=='undefined') {var conv_text=[];}
	  if (typeof client_typing=='undefined') {var client_typing=[];}
	  
	  client_typing[data['chat'][Result]['cts_id']]=data['chat'][Result]['client_typing'];	  
	  conv_id[data['chat'][Result]['cts_id']]=data['chat'][Result]['cts_id'];
	  cons_id[data['chat'][Result]['cts_id']]=data['chat'][Result]['csm_id'];
	  merch_id[data['chat'][Result]['cts_id']]=data['chat'][Result]['ltm_id'];
	 
	  csm_name[data['chat'][Result]['cts_id']]=data['chat'][Result]['csm_first_name'] && data['chat'][Result]['csm_last_name']? data['chat'][Result]['csm_first_name'] + ' ' + data['chat'][Result]['csm_last_name']:'';	  
	  company_name[data['chat'][Result]['cts_id']]=data['chat'][Result]['ltm_company_name']? data['chat'][Result]['ltm_company_name']:''; 	 
	  if (typeof conv_text[data['chat'][Result]['cts_id']]=='undefined') {conv_text[data['chat'][Result]['cts_id']]='';};
	  conv_text[data['chat'][Result]['cts_id']]+="<p class='alert"+(data['chat'][Result]['side']==1? " alert-warning admin-text":" alert-info user-text")+"'><span><strong>" + (data['chat'][Result]['side']==1? "Me: ":"Client: ")+ '</strong>' + escapeHtml(data['chat'][Result]['msg']) + "</span></p>";
	}
	if (typeof conv_id != 'undefined' && conv_id.length>0){
	var j=0;
	for (var n in conv_id){
	 if (++j<=Max_Conversations){
	  if ($('#conversation'+n).length == 0){ 
	  $('#conversations').append(
	  "<div data-chatid='"+conv_id[n]+"' data-typing='0' id='conversation"+n+"' class='out-chat-box col-sm-" + Math.floor( 12/Max_Conversations ) + "'>"+
	   "<span class='close' onclick='close_chat("+conv_id[n]+")' aria-label='Close'><span aria-hidden='true'>&times;</span></span>"+
	   "<div class='row'>"+
	    "<div class='col-sm-12'>"+     
		 "<div class='header-chat-box'>"+
	      "<span> "+(company_name[n]==''?(csm_name[n]==''?" Unknown Person":" <a href='consumer-edit?csm_id="+cons_id[n]+"' target='_blank'>Consumer: "+csm_name[n]+"</a>"):" <a href='merchant-search' target='_blank'>Merchant: "+company_name[n]+"</a>") + "<text class='is-typing'></text></span>"+
		 "</div>"+
		"</div>"+ 
	   "</div>"+
	    
	   "<div class='row'>"+
	    "<div class='col-sm-12'>"+
	     "<div id='msg_div"+n+"' class='msg-chat-box'>"+
	      conv_text[n]+
	     "</div>"+
		"</div>"+
	   "</div>"+
	   
       "<div class='row'>"+
	    "<div class='col-sm-12'>"+
	     "<div id='footer_div"+n+"' class='footer-chat-box'>"+
	      "<form onsubmit='event.preventDefault();'><textarea class='form-control chat-area-text' onkeyup='empty_value(this, event)' onkeydown='send_chat_msg(this, event)' id='conv_"+conv_id[n]+"'></textarea></form>"+
	     "</div>"+
		"</div>"+ 
	   "</div>"+	   
	  "</div>");
	  $('#msg_div'+n).animate({ scrollTop: $('#msg_div'+n)[0].scrollHeight}, 1000);
	   //$("#mydiv").scrollTop($('#msg_div'+j)[0].scrollHeight);
	   var right=(j-1)*400;
	   $('#conversation'+n).css({'right' : right});
	  }
	  else{
	   $("#conversation"+n).find('.header-chat-box').find('span:first').html((company_name[n]==''?(csm_name[n]==''?" Unknown Person":" <a href='consumer-edit?csm_id="+cons_id[n]+"' target='_blank'>Consumer: "+csm_name[n]+"</a>"):" <a href='merchant-search?ltm_id="+merch_id[n]+"' target='_blank'>Merchant: "+company_name[n])+"</a><text class='is-typing'></text>");
	   var bool=false;	    
        if($('#msg_div'+n)[0].scrollHeight - $('#msg_div'+n).scrollTop() == $('#msg_div'+n).outerHeight()-2) {
         bool=true;
        }       
	   $('#msg_div'+n).html(conv_text[n]);
	   if (bool){
	    //scroll all the way to the bottom
		$('#msg_div'+n).animate({ scrollTop: $('#msg_div'+n)[0].scrollHeight}, 100);
	   }
	  }
	  var right=(j-1)*400;
	  $('#conversation'+n).css({'right' : right});
     }
     else{
	  break;
	 }
     if ($('#conversation'+n).length > 0){ $('#conversation'+n).find('text.is-typing').text((client_typing[n]=='1'?" is typing...":""));}
	}
   }   
   
   $('#conversations').find('.out-chat-box').each(function (){  
    if (typeof conv_id != 'undefined'){
	 
	 var pos=conv_id.indexOf($(this).data('chatid').toString()); 
     if (pos == -1){
	  $(this).remove();
	 }
	}
    else{
	 $('#conversations').html('');
	}	
   });
   
  }
 }
 
 }, 'json')

}

function escapeHtml(text) {
  return text
      .replace(/&/g, "&amp;")
      .replace(/</g, "&lt;")
      .replace(/>/g, "&gt;")
      .replace(/"/g, "&quot;")
      .replace(/'/g, "&#039;");
}

function close_chat(cts_id){
	var r = confirm("It will finished this chat session. Do you want to continue?");
	if (r == true) {
	 //finish chat session
	 $('#conversations').html('');
	
	 var json_var = {action : 'close_chat_session', cts_id : cts_id}
     
     search_conversation(json_var);     
	 
	}
}

setInterval(function (){
 //check if there are ane chat waiting and add or delete it to(from) the table 
 search_conversation(); 
}, 5000);



var table = {}

$(document).ready(function(){

 $('#admin_avilable').click(function (){
 
  var json_var = {action : 'admin_activate_chat'} 
 
  search_conversation(json_var);
  
 });
 
 table = $('#conversation_requested').dataTable({

  "destroy": true

  });

 search_conversation(); 

});

function take_chat(btn){
 
 var json_var = {action : 'take_chat', cts_id : $(btn).attr('id').split('_')[1]}
 
 //console.log(json_var);
 
 $.post('../api/api.chat.php', json_var, function (data, status){
 
 if (status == 'success'){
	 
  search_conversation();  
  
 }
 
 }, 'json');
 
}

</script>

<?php

require 'footer.php';



/* EOF ?> */