<?php
require '../app/start_session.php';
require '../app/class.variables.php';
    /* Beging Functions */
	function get_Name($a_Key) {
			$tempArr = array(
						  'pho_csr_phone_number0' => 'Phone Number'
						, 'nam_csr_contact_name' => 'Contact Name'
						, 'url_csr_web_url' => 'Website URL'
						, 'zip_csr_zipcode' => 'ZIP Code'
						, 'abc_csr_state' => 'State'
						, 'nam_csr_city' => 'City'
						, 'txt_csr_address' => 'Address'
						, 'txt255_csr_description' => 'Description'
						, 'txt64_csr_company_name' => 'Company Name'
						, 'ema_csr_email_r' => 'Email'
						, 'none' => 'Ignore'
						, 'pho_rsr_phone_number0' => 'Phone Number'
						, 'pho_rsr_phone_ext00' => 'Phone Ext'
						, 'pho_csr_phone_ext00' => 'Phone Ext'
						, 'nam_rsr_category' => 'Category'
						, 'nam_rsr_source' => 'Source'
						, 'nam_rsr_name' => 'Full Name'
						, 'aon255_rsr_subdomain' => 'Subdomain'
						, 'ema_rsr_email_r' => 'Email'
						, 'url_rsr_web_url' => 'Website URL'
						, 'txt64_rsr_company_name' => 'Company Name'
						);
			return 	isset($tempArr[$a_Key])? $tempArr[$a_Key]: 'Ignore';
		}
	
	function addRecord( $adminId, $dataCSR, $table, $prefix, &$message) {
		$dbo = connect(); $message='';
		$values = "{$adminId},{$adminId},NOW()"; $fields = "adm_id,adm_holder_id,{$prefix}_registerdate";$update = '';
		foreach ($dataCSR as $key => $val) {
			if ( $key != "{$prefix}_id" && strpos($key, "{$prefix}_phone_number") === false  && strpos($key, "{$prefix}_phone_ext") === false ) {
				$fields .= ",{$key}" ;
				$values .= ",:{$key}" ;
				$update .= ( empty( $update )?'':',' )."{$key}=:{$key}" ;
			}			
		}
		
        if ( $dataCSR["{$prefix}_id"] == '0' )
			$stmt = $dbo->prepare( "INSERT IGNORE INTO {$table} ({$fields}) VALUES ({$values})" );
		else {
			$stmt = $dbo->prepare( "UPDATE IGNORE {$table} SET {$update} 
		                            WHERE {$prefix}_id=:{$prefix}_id 						
									" );				
		}							
		foreach ( $dataCSR as $key => $val ) {
			if ( ($dataCSR["{$prefix}_id"] != '0' || "{$prefix}_id" != $key) && strpos($key, "{$prefix}_phone_number") === false  && strpos($key, "{$prefix}_phone_ext") === false )
				$stmt->bindValue( ":{$key}", $val==''?null:$val, PDO::PARAM_STR );
		}
		
		$stmt->execute();
		
		$_i=0; $_where = ''; $_theId = $dataCSR["{$prefix}_id"]=='0'?$dbo->lastInsertId():$dataCSR["{$prefix}_id"];
		$_flag=false;
		while ( isset( $dataCSR["{$prefix}_phone_number" . $_i] ) ) {
			$_j=0;
			while ( isset( $dataCSR["{$prefix}_phone_ext" . $_i . $_j] ) ) {
				$tempFlag = addPhone("{$prefix}", $_theId, $dataCSR["{$prefix}_phone_number" . $_i], $dataCSR["{$prefix}_phone_ext" . $_i . $_j]);
				if (!$tempFlag && !belongPhoneLead($prefix, $_theId, $dataCSR["{$prefix}_phone_number" . $_i], $dataCSR["{$prefix}_phone_ext" . $_i . $_j]))
					$message .= ($message==''?'The following phone number(s) cannot be added: ':', ') . $dataCSR["{$prefix}_phone_number" . $_i] . ($dataCSR["{$prefix}_phone_ext" . $_i . $_j] != ''? ' Ext: ':'' ) . $dataCSR["{$prefix}_phone_ext" . $_i . $_j];
				$_flag = $_flag || $tempFlag;
				$_where .= ($_where == ''? ' WHERE ': ' AND ') . " NOT (pho_number='" . $dataCSR["{$prefix}_phone_number" . $_i]. "' AND pho_extension='" . $dataCSR["{$prefix}_phone_ext" . $_i . $_j] . "')";
				++$_j;
			}
			if ( $_j == 0 ) {
				$_where .= ($_where == ''? ' WHERE ': ' AND ') . " NOT (pho_number='" . $dataCSR["{$prefix}_phone_number" . $_i] . "' AND pho_extension='')";
				$tempFlag = addPhone("{$prefix}", $_theId, $dataCSR["{$prefix}_phone_number" . $_i]);
				if (!$tempFlag && !belongPhoneLead($prefix, $_theId, $dataCSR["{$prefix}_phone_number" . $_i], $dataCSR["{$prefix}_phone_ext" . $_i . $_j]))
					$message .= ($message==''?'The following phone number(s) cannot be added: ':', ') . $dataCSR["{$prefix}_phone_number" . $_i];
				$_flag = $_flag || $tempFlag;
			}
			++$_i;
		}
		if (!empty($_where))
			deletePhone($_where, "{$prefix}_id={$_theId}");
		$tempFlag = $dataCSR["{$prefix}_id"] == '0'? $_theId > 0 : $stmt->rowCount() > 0;
		if (!$tempFlag) $message .= (empty($message)?'':'. ')."The lead's email already exists";
		if (!($tempFlag || $_flag) && $message === '') $message = (empty($message)?'':'. ').'The lead account could not be '.($dataCSR["{$prefix}_id"] == '0'?'created' : 'edited');		
		if ($message !== '') $message .= '. It would generate unallowed duplicate values.'.( $dataCSR["{$prefix}_id"] != '0' ? " Or no change have been made to this lead.":"");
		return  $tempFlag || $_flag;
	}
	
	function addPhone($a_prefix, $an_Id, $a_Phone, $an_Ext = ''){
		if (!empty($a_Phone)){
			$dbo = connect();
			$stmt = $dbo->prepare( "INSERT IGNORE INTO tbl_csr_phone ({$a_prefix}_id, pho_number, pho_extension) VALUES (:id, :pho, :ext)" );
			$stmt->bindValue( ':id', $an_Id, PDO::PARAM_INT );		
			$stmt->bindValue( ':pho', $a_Phone, PDO::PARAM_STR );
			$stmt->bindValue( ':ext', $an_Ext, PDO::PARAM_STR );
			$stmt->execute();
			return $dbo->lastInsertId() > 0;
		}
		
		return false;
	}
	
	function belongPhoneLead($a_prefix, $an_Id, $a_Phone, $an_Ext = ''){
		if (!empty($a_Phone)){
			$dbo = connect();
			$stmt = $dbo->prepare( "SELECT * FROM tbl_csr_phone WHERE {$a_prefix}_id=:id AND pho_number=:pho". (!empty($an_Ext)?" AND pho_extension=:ext":"") );
			$stmt->bindValue( ':id', $an_Id, PDO::PARAM_INT );		
			$stmt->bindValue( ':pho', $a_Phone, PDO::PARAM_STR );
			if (!empty($an_Ext))
				$stmt->bindValue( ':ext', $an_Ext, PDO::PARAM_STR );
			$stmt->execute();
			return $_Result = $stmt->fetch(PDO::FETCH_ASSOC); 
		}
		
		return false;
	}
	
	function deletePhone($_where, $_id) {
		if (!empty($_where)) {
			$dbo = connect();
			$stmt = $dbo->prepare( "DELETE FROM tbl_csr_phone {$_where} AND {$_id}" );
			$stmt->execute();
			return $stmt->rowCount() > 0;
		}
		return false;
	}
	
	function signToAdmin( $adminId, $leadId, $table, $prefix ) {
		$dbo = connect();
		$stmt = $dbo->prepare( "UPDATE {$table} SET adm_id=:admid WHERE {$prefix}_id=:id" );
		$stmt->bindValue( ':id', $leadId, PDO::PARAM_INT );
		$stmt->bindValue( ':admid', $adminId, PDO::PARAM_INT );
		$stmt->execute();
		return $stmt->rowCount() > 0;
	}
	
	function deleteLead ( $adminId, $leadId, $table, $prefix ) {
		$dbo=connect();
		$isMaster = isAdminMaster ();
		$stmt = $dbo->prepare("
		DELETE LEAD.*, CTD.*, CRH.*, PHO.*
		FROM {$table} LEAD		
		LEFT JOIN tbl_csr_history CRH ON CRH.{$prefix}_id = LEAD.{$prefix}_id
		LEFT JOIN tbl_csr_todo CTD ON CTD.{$prefix}_id = LEAD.{$prefix}_id
		LEFT JOIN tbl_csr_phone PHO ON PHO.{$prefix}_id = LEAD.{$prefix}_id
		".(!$isMaster?"INNER JOIN tbl_admin ADM ON ADM.adm_id = LEAD.adm_id":"")."
		WHERE ".(!$isMaster?"ADM.adm_id=:admid AND ":"")."LEAD.{$prefix}_id=:id");
		$stmt->bindValue(':id', $leadId, PDO::PARAM_INT);
		if (!$isMaster)
			$stmt->bindValue(':admid', $adminId, PDO::PARAM_INT);
		$stmt->execute();
		return $stmt->rowCount() > 0;
	}
	
	function deleteLeadKeep ( $adminId, $leadId, $table, $prefix, $keep = true ) { 
		$dbo=connect();
		$isMaster = isAdminMaster ();
		if ($keep){
			$stmt = $dbo->prepare("
			UPDATE {$table} LEAD
			LEFT JOIN tbl_csr_history CRH ON CRH.{$prefix}_id = LEAD.{$prefix}_id
			LEFT JOIN tbl_csr_todo TDO ON TDO.{$prefix}_id = LEAD.{$prefix}_id
			".(!$isMaster?"INNER JOIN tbl_admin ADM ON ADM.adm_id = LEAD.adm_id":"")."
			" .( $prefix == 'csr' && $table == 'tbl_csr_merchant'?
			"INNER JOIN lt_member_merchants MMR ON MMR.ltb_email=LEAD.csr_email		
			 INNER JOIN lt_merchants MRC ON MMR.ltb_id=MRC.ltb_id		
			 SET CRH.ltm_id=MRC.ltm_id, TDO.ltm_id=MRC.ltm_id ":
			"INNER JOIN tbl_reseller RES ON RES.res_subdomain=LEAD.rsr_subdomain		
			 SET CRH.res_id=RES.res_id, TDO.res_id=RES.res_id " ) .
			"WHERE ".(!$isMaster?"ADM.adm_id=:admid AND ":"")."LEAD.{$prefix}_id=:id" );
			$stmt->bindValue(':id', $leadId, PDO::PARAM_INT);
			if (!$isMaster)
				$stmt->bindValue(':admid', $adminId, PDO::PARAM_INT);		
			$stmt->execute();
		}	
				
		$stmt = $dbo->prepare("
		UPDATE {$table} LEAD		
		".(!$isMaster?"INNER JOIN tbl_admin ADM ON ADM.adm_id = LEAD.adm_id":"")."
		SET LEAD.{$prefix}_active = 0
		WHERE ".(!$isMaster?"ADM.adm_id=:admid AND ":"")."LEAD.{$prefix}_id=:id");
		$stmt->bindValue(':id', $leadId, PDO::PARAM_INT);
		if (!$isMaster)
			$stmt->bindValue(':admid', $adminId, PDO::PARAM_INT);
		$stmt->execute();
		return $stmt->rowCount() > 0;
	}
	
	function isAdminMaster () { 		
		return isset($_SESSION['user']['admin']['adm_master']) && $_SESSION['user']['admin']['adm_master'] == 1;
	}
	
	function addToDo( $adminId, $merchId, $toDoTask, $aDate=null, $prefix ) {
		$dbo=connect();
		$stmt = $dbo->prepare("INSERT INTO tbl_csr_todo ({$prefix}_id, tdo_task, adm_id, tdo_date) VALUES (:id, :task, :admid, ".(!empty($aDate)?':tdodate':'NULL').")");
		if (!empty($aDate)) { $date=date_create($aDate); $stmt->bindValue(':tdodate', date_format($date, 'Y-m-d'), PDO::PARAM_STR);}
		$stmt->bindValue(':id', $merchId, PDO::PARAM_INT);
		$stmt->bindValue(':admid', $adminId, PDO::PARAM_INT);
		$stmt->bindValue(':task', $toDoTask, PDO::PARAM_STR);
		$stmt->execute();
		return $dbo->lastInsertId();
	}
	
	function addHistory( $merchId, $history, $prefix) {
		$dbo=connect();
		$stmt = $dbo->prepare("INSERT INTO tbl_csr_history ({$prefix}_id, mrh_notes, mrh_date) VALUES (:id, :history, NOW())");
		$stmt->bindValue(':id', $merchId, PDO::PARAM_INT);		
		$stmt->bindValue(':history', $history, PDO::PARAM_STR);
		$stmt->execute();
		return $dbo->lastInsertId();
	}
	
	function getCSR( $leadid, $table, $prefix ) {
		$dbo=connect();
		$stmt = $dbo->prepare("
		SELECT DISTINCT ADM.adm_email
		FROM {$table} LEAD		
		INNER JOIN (
			SELECT {$prefix}_email 
			FROM {$table} 
			WHERE {$prefix}_id = :id
		) TMP ON TMP.{$prefix}_email = LEAD.{$prefix}_email
		INNER JOIN tbl_admin ADM ON ADM.adm_id=LEAD.adm_id
		WHERE LEAD.{$prefix}_active");
		$stmt->bindValue(':id', $leadid, PDO::PARAM_INT);
		$stmt->execute();
		return $stmt->fetchAll( PDO::FETCH_ASSOC );
	}
	
	function getMerchants($adminId = null, $merchId = null){
		$dbo=connect();
		$isMaster = isAdminMaster ();
		$_WHERE = "";
		if (isset($_GET['csr_email']) && !empty($_GET['csr_email'])){
			$_WHERE = " AND CSR.csr_email LIKE :csremail";   
		}
		if ( isset($_GET['res_id']) && !empty($_GET['res_id']) && is_numeric($_GET['res_id']) && intval($_GET['res_id']) > 0 ) {
			$_WHERE .= " AND RES.res_id = :resId";   
		}
		if (isset($_GET['pho_number']) && !empty($_GET['pho_number'])){	
			$_WHERE .= " AND PHO.pho_number LIKE :csrphonenumber";
		}
		if (isset($_GET['csr_company_name']) && !empty($_GET['csr_company_name'])){
			$_WHERE .= " AND CSR.csr_company_name LIKE :csrcompanyname";
		}
		
		if (isset($_GET['csr_contact_name']) && !empty($_GET['csr_contact_name'])){
			$_WHERE .= " AND CSR.csr_contact_name LIKE :csrcontname";
		}
		
        if (isset($_GET['csr_id']) && !empty($_GET['csr_id']) && is_numeric($_GET['csr_id']) && intval($_GET['csr_id']) > 0){
			$_WHERE .= " AND CSR.csr_id = :csrId";
		}
		
		$stmt = $dbo->prepare("
		SELECT DISTINCT RES.res_id, RES.res_name, CSRNOT.mrh_date, (CASE WHEN CNT.csr_email IS NOT NULL AND CNT.AMNT > 1 THEN 1 ELSE 0 END) duplicates, PHO.pho_number, PHO.pho_extension, (CASE WHEN MRC.ltm_id IS NOT NULL THEN MRC.ltm_id ELSE 0 END) merchantMatch, CSR.csr_registerdate, CAT.cat_id, CAT.cat_name, CSR.csr_description, ".($isMaster?"'' AS adm_chat_name":"ADM1.adm_chat_name").", CSR.csr_web_url, CSR.csr_email, CSR.csr_contact_name, CSR.csr_company_name, CSR.csr_id, ".($isMaster?"{$_SESSION['user']['admin']['adm_id']} AS adm_id":"ADM.adm_id").", CSR.csr_address, CSR.csr_city, CSR.csr_state, CSR.csr_zipcode,
		(CASE WHEN CSR.csr_address IS NOT NULL AND CSR.csr_city IS NOT NULL AND CSR.csr_state IS NOT NULL AND CSR.csr_zipcode IS NOT NULL THEN CONCAT(CSR.csr_address, ' ', CSR.csr_city,', ', CSR.csr_state, ' ', CSR.csr_zipcode) ELSE '' END) AS csr_full_address  
		FROM tbl_csr_merchant CSR
		LEFT JOIN
		(
			SELECT COUNT(csr_id) AMNT, csr_email 
			FROM tbl_csr_merchant 
			WHERE csr_active GROUP BY csr_email
		) CNT ON CNT.csr_email = CSR.csr_email
		".($isMaster?"":"	
		INNER JOIN tbl_admin ADM ON ADM.adm_id=CSR.adm_id
		INNER JOIN tbl_admin ADM1 ON ADM1.adm_id=CSR.adm_holder_id		
		")."
		LEFT JOIN tbl_reseller RES ON RES.res_id=CSR.res_id
		LEFT JOIN tbl_csr_phone PHO ON PHO.csr_id=CSR.csr_id
		LEFT JOIN tbl_category CAT ON CAT.cat_id=CSR.cat_id
		LEFT JOIN lt_member_merchants MMR ON MMR.ltb_email=CSR.csr_email
		LEFT JOIN lt_merchants MRC ON MMR.ltb_id=MRC.ltb_id
		LEFT JOIN
		(
			SELECT CSR1.csr_id, HIST.mrh_date
			FROM tbl_csr_merchant CSR1
			INNER JOIN tbl_csr_history HIST ON HIST.csr_id=CSR1.csr_id
			ORDER BY HIST.mrh_date DESC
		) CSRNOT ON CSRNOT.csr_id = CSR.csr_id
		WHERE CSR.csr_active{$_WHERE}
		ORDER BY CSR.csr_id DESC
		LIMIT 200" .
		(isset($adminId) && !empty($adminId) && !$isMaster? " AND (ADM.adm_id=:admid".(isset($adminId) && !empty($adminId)?" OR (SELECT COUNT(adm_id) AS ISMASTER FROM tbl_admin WHERE adm_master AND adm_id=:admid) > 0 ":"").")" : "") .
		(isset($merchId) && !empty($merchId)? " AND CSR.csr_id=:id" : ""));
		
		
		
		if (isset($_GET['csr_email']) && !empty($_GET['csr_email'])){
			$stmt->bindValue(":csremail", preg_replace("/[^a-zA-Z0-9\@\.]/", '',$_GET['csr_email'])."%", PDO::PARAM_STR);			
		}
		if ( isset($_GET['res_id']) && !empty($_GET['res_id']) && is_numeric($_GET['res_id']) && intval($_GET['res_id']) > 0 ) {
			$stmt->bindValue(":resId", $_GET['res_id'], PDO::PARAM_INT);			
		}
		if (isset($_GET['pho_number']) && !empty($_GET['pho_number'])){
			$stmt->bindValue(":csrphonenumber", preg_replace("/[^0-9]/", '',$_GET['pho_number'])."%", PDO::PARAM_STR);			
		}
		if (isset($_GET['csr_company_name']) && !empty($_GET['csr_company_name'])){
			$stmt->bindValue(":csrcompanyname", preg_replace("/[^a-zA-Z0-9 ]/", '',$_GET['csr_company_name'])."%", PDO::PARAM_STR);
		}
		if (isset($_GET['csr_contact_name']) && !empty($_GET['csr_contact_name'])){
			$stmt->bindValue(":csrcontname", preg_replace("/[^a-zA-Z0-9 ]/", '',$_GET['csr_contact_name'])."%", PDO::PARAM_STR);			
		}
        if (isset($_GET['csr_id']) && !empty($_GET['csr_id']) && is_numeric($_GET['csr_id']) && intval($_GET['csr_id']) > 0){
			$stmt->bindValue(":csrId", $_GET['csr_id'], PDO::PARAM_INT);						
		}
		
		
		
		if (isset($merchId) && !empty($merchId))
			$stmt->bindValue(':id', $merchId, PDO::PARAM_INT);
		if (isset($adminId) && !empty($adminId) && !$isMaster)
			$stmt->bindValue(':admid', $adminId, PDO::PARAM_INT);
		$stmt->execute();
		return $stmt->fetchAll( PDO::FETCH_ASSOC );
	}
	
	function getReseller($adminId = null, $resId = null){
		$dbo=connect();
		$isMaster = isAdminMaster ();
		$_WHERE = "";
		
		if (isset($_GET['csr_email']) && !empty($_GET['csr_email'])){
			$_WHERE = " AND RSR.rsr_email LIKE :csremail";   
		}		
		if (isset($_GET['pho_number']) && !empty($_GET['pho_number'])){	
			$_WHERE .= " AND PHO.pho_number LIKE :csrphonenumber";
		}
		if (isset($_GET['csr_company_name']) && !empty($_GET['csr_company_name'])){
			$_WHERE .= " AND RSR.rsr_company_name LIKE :csrcompanyname";
		}		
		if (isset($_GET['csr_contact_name']) && !empty($_GET['csr_contact_name'])){
			$_WHERE .= " AND RSR.rsr_name LIKE :csrcontname";
		}		
        if (isset($_GET['csr_id']) && !empty($_GET['csr_id']) && is_numeric($_GET['csr_id']) && intval($_GET['csr_id']) > 0){
			$_WHERE .= " AND RSR.rsr_id = :rsrId";
		}
		
		$stmt = $dbo->prepare("
		SELECT DISTINCT RSRNOT.mrh_date, ".(isset($adminId) && !empty($adminId) && !$isMaster?"(SELECT COUNT(adm_id) AS ISMASTER FROM tbl_admin WHERE adm_master AND adm_id=:admid) AS ADM2, ":"")."(CASE WHEN CNT.rsr_email IS NOT NULL AND CNT.AMNT > 1 THEN 1 ELSE 0 END) duplicates, PHO.pho_number, PHO.pho_extension, (CASE WHEN RES.res_id IS NOT NULL THEN RES.res_id ELSE 0 END) resellerMatch, RSR.rsr_source, RSR.rsr_category, RSR.rsr_id, RSR.rsr_registerdate, ".($isMaster?"'' AS adm_chat_name":"ADM1.adm_chat_name").", RSR.rsr_name, RSR.rsr_email, RSR.rsr_subdomain, RSR.rsr_web_url, RSR.rsr_company_name
		FROM tbl_csr_reseller RSR
		LEFT JOIN
		(
			SELECT COUNT(rsr_id) AMNT, rsr_email FROM tbl_csr_reseller WHERE rsr_active GROUP BY rsr_email
		) CNT ON CNT.rsr_email = RSR.rsr_email
		".($isMaster?"":"	
		INNER JOIN tbl_admin ADM ON ADM.adm_id = RSR.adm_id		
		INNER JOIN tbl_admin ADM1 ON ADM1.adm_id = RSR.adm_holder_id		
		")."
		LEFT JOIN tbl_csr_phone PHO ON PHO.rsr_id = RSR.rsr_id
		LEFT JOIN tbl_reseller RES ON RES.res_subdomain = RSR.rsr_subdomain
		LEFT JOIN
		(
			SELECT RSR1.rsr_id, HIST.mrh_date
			FROM tbl_csr_reseller RSR1
			INNER JOIN tbl_csr_history HIST ON HIST.rsr_id=RSR1.rsr_id 
			ORDER BY HIST.mrh_date DESC
		) RSRNOT ON RSRNOT.rsr_id = RSR.rsr_id
		WHERE RSR.rsr_active{$_WHERE}
		ORDER BY RSR.rsr_id DESC
		LIMIT 200" .
		(isset($adminId) && !empty($adminId) && !$isMaster? " AND (ADM.adm_id=:admid".(isset($adminId) && !empty($adminId)?" OR (SELECT COUNT(adm_id) AS ISMASTER FROM tbl_admin WHERE adm_master AND adm_id=:admid) > 0 ":"").")" : "") . 
		(isset($resId) && !empty($resId)? " AND RSR.rsr_id=:id" : ""));
		if (isset($resId) && !empty($resId))
			$stmt->bindValue(':id', $resId, PDO::PARAM_INT);
		if (isset($adminId) && !empty($adminId) && !$isMaster)
			$stmt->bindValue(':admid', $adminId, PDO::PARAM_INT);
		
		if (isset($_GET['csr_email']) && !empty($_GET['csr_email'])){
			$stmt->bindValue(":csremail", preg_replace("/[^a-zA-Z0-9\@\.]/", '',$_GET['csr_email'])."%", PDO::PARAM_STR);			
		}
		if (isset($_GET['pho_number']) && !empty($_GET['pho_number'])){
			$stmt->bindValue(":csrphonenumber", preg_replace("/[^0-9]/", '',$_GET['pho_number'])."%", PDO::PARAM_STR);			
		}
		if (isset($_GET['csr_company_name']) && !empty($_GET['csr_company_name'])){
			$stmt->bindValue(":csrcompanyname", preg_replace("/[^a-zA-Z0-9 ]/", '',$_GET['csr_company_name'])."%", PDO::PARAM_STR);
		}
		if (isset($_GET['csr_contact_name']) && !empty($_GET['csr_contact_name'])){
			$stmt->bindValue(":csrcontname", preg_replace("/[^a-zA-Z0-9 ]/", '',$_GET['csr_contact_name'])."%", PDO::PARAM_STR);			
		}
        if (isset($_GET['csr_id']) && !empty($_GET['csr_id']) && is_numeric($_GET['csr_id']) && intval($_GET['csr_id']) > 0){
			$stmt->bindValue(":rsrId", $_GET['csr_id'], PDO::PARAM_INT);						
		}
		
		$stmt->execute();
		return $stmt->fetchAll( PDO::FETCH_ASSOC );
	}
	
	function get_Today_Tasks($adminId, $table, $prefix){
		$dbo=connect();
		$isMaster = isAdminMaster ();
		$stmt = $dbo->prepare("
		SELECT LEAD.*, CTD.*
		FROM {$table} LEAD
		".($isMaster?"":"
		INNER JOIN tbl_admin ADM ON ADM.adm_id=LEAD.adm_id
		")."
		INNER JOIN tbl_csr_todo CTD ON CTD.{$prefix}_id = LEAD.{$prefix}_id
		WHERE ".($isMaster?"":"ADM.adm_id=:admid AND ")."CTD.tdo_date IS NOT NULL AND DATEDIFF(CTD.tdo_date, NOW()) = 0
		ORDER BY LEAD.{$prefix}_id");
		if (!$isMaster)
			$stmt->bindValue(':admid', $adminId, PDO::PARAM_INT);
		$stmt->execute();
		return $stmt->fetchAll( PDO::FETCH_ASSOC );		
	}
	
	function get_CRM_Admin(){
		$dbo=connect();
		  $arr=array();	 
		  if ($stmt = $dbo->prepare("
			  SELECT ADM.adm_email, ADM.adm_id, ADM.adm_chat_name
			  FROM tbl_admin2file A2F 
			  INNER JOIN tbl_admin ADM ON ADM.adm_id=A2F.adm_id
			  INNER JOIN tbl_file_structure FLE ON FLE.file_id=A2F.file_id 
			  WHERE NOT ADM.adm_master AND ADM.adm_id <> :id
			  AND ADM.adm_active 
			  AND FLE.file_name = 'page-crm.php'
			  AND FLE.file_parent_id IN (
				   SELECT file_id 
				   FROM tbl_file_structure 
				   WHERE file_parent_id IN (
						SELECT file_id 
						FROM tbl_file_structure 
						WHERE file_parent_id IN (
									SELECT file_id 
											FROM tbl_file_structure 
											WHERE file_name = 'admin' 
											AND file_isdir 
											AND NOT file_parent_id
										  ) 
						AND file_name = 'app' 
						AND file_isdir
				   ) 
				   AND file_name = 'view' 
				   AND file_isdir 
			  )
		  ")){
			$stmt->bindValue(':id', $_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT);		  
			$stmt->execute();	
			while ($_Result=$stmt->fetch(PDO::FETCH_ASSOC)){	
			 array_push($arr, $_Result);
			}
		   } 
		   return $arr;
    }
	
	function getToDo( $leadId, $prefix ){
		$dbo=connect();
		$stmt = $dbo->prepare("
		SELECT * FROM tbl_csr_todo
		WHERE {$prefix}_id=:id
		ORDER BY tdo_date");
		$stmt->bindValue(':id', $leadId, PDO::PARAM_INT);		
		$stmt->execute();
		return $stmt->fetchAll( PDO::FETCH_ASSOC );
	}
	
	function getHistory( $leadId, $prefix ){
		$dbo=connect();
		$stmt = $dbo->prepare("
		SELECT * FROM tbl_csr_history
		WHERE {$prefix}_id=:id");
		$stmt->bindValue(':id', $leadId, PDO::PARAM_INT);		
		$stmt->execute();
		return $stmt->fetchAll( PDO::FETCH_ASSOC );
	}
	
	function deleteToDo( $toDoId ) {
		$dbo=connect();
		
		
		$stmt = $dbo->prepare("
		INSERT INTO tbl_csr_history (mrh_notes, res_id, rsr_id, ltm_id, csr_id, mrh_date)
		SELECT ( CASE WHEN TDO.tdo_date IS NULL THEN CONCAT('There was not an scheduled date for the task', '. It was marked as done by: ', ADM.adm_chat_name, '. The task was: ', TDO.tdo_task) ELSE CONCAT('This task was scheduled to be done on: ', TDO.tdo_date, '. It was marked as done by: ', ADM.adm_chat_name, '. The task was: ', TDO.tdo_task) END ), TDO.res_id, TDO.rsr_id, TDO.ltm_id, TDO.csr_id, NOW()
		FROM tbl_csr_todo TDO
		LEFT JOIN tbl_csr_reseller RES ON RES.rsr_id=TDO.rsr_id
		LEFT JOIN tbl_csr_merchant CSR ON CSR.csr_id=TDO.csr_id
		INNER JOIN tbl_admin ADM ON ADM.adm_id=RES.adm_id OR ADM.adm_id=CSR.adm_id
		WHERE TDO.tdo_id=:id");
		$stmt->bindValue(':id', $toDoId, PDO::PARAM_INT);		
		$stmt->execute();
		
		$stmt = $dbo->prepare("
		DELETE FROM tbl_csr_todo
		WHERE tdo_id=:id");
		$stmt->bindValue(':id', $toDoId, PDO::PARAM_INT);		
		$stmt->execute();
		return $stmt->rowCount() > 0;
	}
	
	function deleteHistory( $toNoteId ) {
		$dbo=connect();
		$stmt = $dbo->prepare("
		DELETE FROM tbl_csr_history
		WHERE mrh_id=:id");
		$stmt->bindValue(':id', $toNoteId, PDO::PARAM_INT);		
		$stmt->execute();
		return $stmt->rowCount() > 0;
	}
	
	function areAllValuesEmpty($all_Values) {
		$r=true;
		if (is_array($all_Values))
			foreach ($all_Values as $k=>$v)
				$r = $r && empty($v);
		return $r;		
	}
	
	function getResellerWeeklyReport($resId) {
		$Result = array(0=>array(
			'Company Name',
			'Address',
			'City',
			'State',
			'ZIP Code',
			'Date Registered',
			'Description',
			'Contact Name',
			'Contact Email',
			'Web URL',
			'Category',
			'Phones w/ Extensions',
			'Task List',
			'History'
		));
		$dbo=connect();
		$stmt = $dbo->prepare("
		SELECT DISTINCT
			DATE_FORMAT(CSRTDO.tdo_date,'%b %d %Y') AS tdo_date,
			CSRTDO.tdo_task,
			DATE_FORMAT(CSRNOT.mrh_date,'%b %d %Y') AS mrh_date,
			CSRNOT.mrh_notes,
			PHO.pho_number,
			PHO.pho_extension,
			DATE_FORMAT(CSR.csr_registerdate,'%b %d %Y %h:%i %p') AS csr_registerdate,
			CAT.cat_name,
			CSR.csr_description,
			CSR.csr_web_url,
			CSR.csr_email,
			CSR.csr_contact_name,
			CSR.csr_company_name,
			CSR.csr_id,
			CSR.csr_address,
			CSR.csr_city,
			CSR.csr_state,
			CSR.csr_zipcode 
		FROM tbl_csr_merchant CSR
		LEFT JOIN tbl_csr_phone PHO ON PHO.csr_id=CSR.csr_id
		LEFT JOIN tbl_category CAT ON CAT.cat_id=CSR.cat_id		
		LEFT JOIN
		(
			SELECT CSR1.csr_id, HIST.mrh_notes, HIST.mrh_date
			FROM tbl_csr_merchant CSR1
			INNER JOIN tbl_csr_history HIST ON HIST.csr_id=CSR1.csr_id
			WHERE DATEDIFF( NOW(), HIST.mrh_date ) <= 7
			ORDER BY HIST.mrh_date DESC
		) CSRNOT ON CSRNOT.csr_id = CSR.csr_id
		LEFT JOIN
		(
			SELECT CSR2.csr_id, TODO.tdo_task, TODO.tdo_date
			FROM tbl_csr_merchant CSR2
			INNER JOIN tbl_csr_todo TODO ON TODO.csr_id=CSR2.csr_id
			WHERE DATEDIFF( TODO.tdo_date, NOW() ) >= 0 AND DATEDIFF( TODO.tdo_date, NOW() ) <= 7
			ORDER BY TODO.tdo_date
		) CSRTDO ON CSRTDO.csr_id = CSR.csr_id		
		WHERE res_id=:resId AND CSR.csr_active AND ( CSRNOT.csr_id IS NOT NULL OR CSRTDO.csr_id IS NOT NULL OR DATEDIFF( NOW(), CSR.csr_registerdate ) <= 7 )");
		$stmt->bindValue(':resId', $resId, PDO::PARAM_INT);		
		$stmt->execute();
		while( $tmpResult = $stmt->fetch( PDO::FETCH_ASSOC )) {
			if (!isset($Result[$tmpResult['csr_id']])) {
				$Result[$tmpResult['csr_id']] = array(					
					'Company Name' => isset($tmpResult['csr_company_name'])? '"'.$tmpResult['csr_company_name'].'"' : ' ',
					'Address' => isset($tmpResult['csr_address'])? '"'.$tmpResult['csr_address'].'"' : ' ',
					'City' => isset($tmpResult['csr_city'])? $tmpResult['csr_city'] : ' ',
					'State' => isset($tmpResult['csr_state'])? $tmpResult['csr_state'] : ' ',
					'ZIP Code' => isset($tmpResult['csr_zipcode'])? $tmpResult['csr_zipcode'] : '',
					'Date Registered' => isset($tmpResult['csr_registerdate'])? $tmpResult['csr_registerdate'] : ' ',
					'Description' => isset($tmpResult['csr_description'])? '"'.$tmpResult['csr_description'].'"' : ' ',
					'Contact Name' => isset($tmpResult['csr_contact_name'])? $tmpResult['csr_contact_name'] : ' ',
					'Contact Email' => isset($tmpResult['csr_email'])? $tmpResult['csr_email'] : ' ',
					'Web URL' => isset($tmpResult['csr_web_url'])? $tmpResult['csr_web_url'] : ' ',
					'Category' => isset($tmpResult['cat_name'])? '"'.$tmpResult['cat_name'].'"' : ' ',	
					'Phones w/ Extensions' => array(),
					'Task List' => array(),
					'History' => array()
				);
			}
			
			if (isset($tmpResult['pho_number']) && !isset($Result[$tmpResult['csr_id']]['Phones w/ Extensions'][$tmpResult['pho_number']]))
				$Result[$tmpResult['csr_id']]['Phones w/ Extensions'][$tmpResult['pho_number']] = array();
							
			if ( isset( $tmpResult['pho_number'], $tmpResult['pho_extension'] ) )
				array_push($Result[$tmpResult['csr_id']]['Phones w/ Extensions'][$tmpResult['pho_number']], $tmpResult['pho_extension']);
			
			if ( isset( $tmpResult['tdo_date'], $tmpResult['tdo_task'] ) && !in_array( $tmpResult['tdo_task'] . ', Date: ' . $tmpResult['tdo_date'], $Result[$tmpResult['csr_id']]['Task List'] ) ) {
				array_push($Result[$tmpResult['csr_id']]['Task List'], $tmpResult['tdo_task'] . ', Date: ' . $tmpResult['tdo_date']);
			}
			
			if (isset($tmpResult['mrh_date'], $tmpResult['mrh_notes']) && !in_array($tmpResult['mrh_notes'] . ', Date: ' . $tmpResult['mrh_date'], $Result[$tmpResult['csr_id']]['History']) ) {
				 array_push($Result[$tmpResult['csr_id']]['History'], $tmpResult['mrh_notes'] . ', Date: ' . $tmpResult['mrh_date']);
			}
			
			
			
		}
		
		foreach ( $Result as $k => $v ) {
		
			if ( empty($v['Phones w/ Extensions']) ) {
				$Result[$k]['Phones w/ Extensions'] = ' ';
			}
			else {
				$tmpResultPhone = '';
				
				foreach ( $v['Phones w/ Extensions'] as $k1 => $v1) {
					$tmpResultPhone .= ( empty($tmpResultPhone)? '"' : "\n" ) .  "(" . substr($k1, 0, 3) . ") " . substr($k1, 3, 3) . "-" . substr($k1,6); ;
					$tmpResultExt = '';
					foreach ( $v1 as $k2 => $v2) {
						$tmpResultExt .= ( empty($tmpResultExt)? "\n" . ' Ext: ' : ', ' ) . $v2;
					}	
					$tmpResultPhone .= $tmpResultExt;
				}
				
				$Result[$k]['Phones w/ Extensions'] = $tmpResultPhone . ( empty($tmpResultPhone)? '' : '"' );	
				
			}
			
			if ( empty($v['Task List']) ) {
				$Result[$k]['Task List'] = ' ';
			}
			else {
				$tmpResultTask = '';
				
				foreach ( $v['Task List'] as $k1 => $v1) {
					$tmpResultTask .= ( empty($tmpResultTask)? '"' : "\n" ) . $v1;
				}
				
				$Result[$k]['Task List'] = $tmpResultTask . ( empty($tmpResultTask)? '': '"' );	
			}
			
			if ( empty($v['History']) ) {
				$Result[$k]['History'] = ' ';
			}
			else {
				$tmpResultHistory = '';
				
				foreach ( $v['History'] as $k1 => $v1) {
					$tmpResultHistory .= ( empty($tmpResultHistory)? '"' : "\n" ) . $v1;
				}
				$Result[$k]['History'] = $tmpResultHistory . ( empty($tmpResultHistory)? '': '"');	
			}
			
		}

		$Result = array_values($Result);
		return $Result;
	}
	
	function getLiveReseller( $a_Subdomain ){
		$dbo=connect();
		$stmt = $dbo->prepare("
		SELECT * FROM tbl_reseller
		WHERE res_subdomain=:subdom LIMIT 1");
		$stmt->bindValue(':subdom', $a_Subdomain, PDO::PARAM_STR);		
		$stmt->execute();
		return $stmt->fetch( PDO::FETCH_ASSOC );
	}
	
	function makePhoneList( $query_Result ) {
		$_Res=array(  ); 
		foreach ( $query_Result as $k=>$v ){
			$currentPho='';
			foreach ( $v as $k1=>$v1 ){				
				if ( ( $k1 == 'pho_number' || $k1 == 'pho_extension' ) && !empty( $v1 ) ){
					if ( $k1 == 'pho_number' ) {
						if ( !isset( $_Res[$v1] ) )
							$_Res[$v1] = array(  );
						$currentPho=$v1;
					}	
					else {
						if ( !empty($currentPho) )
							array_push( $_Res[$currentPho], $v1 );						
					}
				}
			}	
		}
		return $_Res;
	}
	
	function getLiveMerchant( $an_Email ) {
		$dbo=connect();
		$stmt = $dbo->prepare("
		SELECT MRC.ltm_id, MMC.ltb_id, MMC.ltb_phone_number, MMC.ltb_web_url, MMC.ltb_email, MMC.ltb_contact_name 
		FROM lt_merchants MRC
		INNER JOIN lt_member_merchants MMC ON MMC.ltb_id=MRC.ltb_id
		WHERE MMC.ltb_email=:ema LIMIT 1");
		$stmt->bindValue(':ema', $an_Email, PDO::PARAM_STR);		
		$stmt->execute();
		return $stmt->fetch( PDO::FETCH_ASSOC );
	}
	/*End Functions*/

/*Begin AJAX*/

$requestBody = null;

if ( $_SERVER['REQUEST_METHOD'] == 'POST' ){
	$requestBody = @json_decode( file_get_contents('php://input'), true );
}
	
if ( $requestBody !== null && json_last_error() == JSON_ERROR_NONE && isset($requestBody['resName'])) {
	$requestBody['resName'] = preg_replace("/[^a-zA-Z ]/", "",$requestBody['resName']);
	$resp = array();
	if ($stmt = $dbo->prepare("
		SELECT * FROM tbl_reseller RES WHERE res_active AND (res_name LIKE :resName OR :resName = '')")){
		$stmt->bindValue(":resName", $requestBody['resName'].'%', PDO::PARAM_STR);		
		$stmt->execute();
		$resp = $stmt->fetchAll( PDO::FETCH_ASSOC );
	}
	echo json_encode( $resp );
}
elseif ( $_SERVER['REQUEST_METHOD'] == 'POST' && isset( $_SESSION['user']['admin']['adm_id'], $_POST['action'] ) ) {
	$stmt = $dbo->prepare("UPDATE tbl_admin SET adm_last_activity = CURRENT_TIMESTAMP WHERE adm_id=:admin");
	$stmt->bindValue(":admin", $_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT);	
	$stmt->execute();
	$_response=array(  );
	$cv = new _variables(); // new instance
	// proccess json
	if ( $_POST['action'] == 'add_Merchant' || $_POST['action'] == 'add_Reseller' ){
		if ($_POST['action'] == 'add_Merchant'){
			
			$fields=array('wnu_cat_id'
						, 'wnu_csr_id_r'
						, 'nam_csr_contact_name'
						, 'url_csr_web_url'
						, 'zip_csr_zipcode'
						, 'abc_csr_state'
						, 'nam_csr_city'
						, 'txt_csr_address'
						, 'txt255_csr_description'
						, 'txt64_csr_company_name'
						, 'ema_csr_email_r');
			$_i=0;			
			while ( isset( $_POST['pho_csr_phone_number' . $_i] ) ) {				
				array_push($fields, 'pho_csr_phone_number' . $_i);
				$_j=0;
				while (isset($_POST['wnu_csr_phone_ext' . $_i . $_j])) {				
					array_push($fields, 'wnu_csr_phone_ext' . $_i . $_j++);
				}
				$_i++;
			}				
			if ( isset( $_POST['url_csr_web_url']) && !empty($_POST['url_csr_web_url']) && !preg_match('#^https?://#i', $_POST['url_csr_web_url']) ) {
				$_REQUEST['url_csr_web_url'] = "http://{$_POST['url_csr_web_url']}";
			}
		}
		else {
			
			$fields=array('wnu_rsr_id_r'
						, 'nam_rsr_category'
						, 'nam_rsr_source'						
						, 'nam_rsr_name'						
						, 'aon255_rsr_subdomain'
						, 'txt64_rsr_company_name'
						, 'url_rsr_web_url'
						, 'ema_rsr_email_r');
			$_i=0;			
			while ( isset( $_POST['pho_rsr_phone_number' . $_i] ) ) {				
				array_push( $fields, 'pho_rsr_phone_number' . $_i );
				$_j=0;			
				while ( isset( $_POST['wnu_rsr_phone_ext' . $_i . $_j] ) ) {				
					array_push( $fields, 'wnu_rsr_phone_ext' . $_i . $_j++ );					
				}
				$_i++;
			}	
			
			if ( isset( $_POST['url_rsr_web_url']) && !empty($_POST['url_rsr_web_url']) && !preg_match('#^https?://#i', $_POST['url_rsr_web_url']) ) {
				$_REQUEST['url_rsr_web_url'] = "http://{$_POST['url_rsr_web_url']}";
			}			
		}
		foreach($fields as $name=>$value) $cv->varible_in($value); //each variable is added to class by array loop
		$_v=$cv->get_cleaned_variables();
		$errors=$cv->get_bad_variables();
		if (!count($errors)) {
			if (!areAllValuesEmpty($_v)) {
				if ($_POST['action'] == 'add_Merchant'){
					$_response['status'] = addRecord( $_SESSION['user']['admin']['adm_id'], $_v , 'tbl_csr_merchant', 'csr', $msg);		
				}
				else{
					$_response['status'] = addRecord( $_SESSION['user']['admin']['adm_id'], $_v , 'tbl_csr_reseller', 'rsr', $msg);		
				}
				
				if ( $msg !== '' ) $_response['notify']= '<div class="alert alert-danger"><ol><li>'.$msg.'</li></div></ol>';					 
				
			}
			else{
				 $_response=array( 'status' => false );
				 $_response['notify']='<div class="alert alert-danger"><ol><li>All values are empty</li></div></ol>';					 
			}
		}	
	    else{
		 $_response=array( 'status' => false );
		 $_response['notify']='<div class="alert alert-danger"><ol>';
			 foreach ($errors as $k=>$v){
				$_response['notify'].='<li>'.get_Name($k).': '.$v.'</li>';
			 }
		 $_response['notify'].= '</div></ol>';
		} 
	}
	elseif ( $_POST['action'] == 'loadReport') {
		$fields = array('wnu_res_id_r');
		foreach($fields as $name=>$value) $cv->varible_in($value);
		$_v = $cv->get_cleaned_variables();
		$errors = $cv->get_bad_variables();	
		
		if ( !count( $errors ) && isset( $_v['res_id'] ) ) {
			$_response = getResellerWeeklyReport( $_v['res_id'] );
		}
		
	}
	else {
		$fields = array();
		if (isset($_POST['aon_value_r']))
			array_push($fields, 'aon_value_r');
		if (isset($_POST['ema_value_r']))
			array_push($fields, 'ema_value_r');
		if (isset($_POST['wnu_rsr_id_r']))
			array_push($fields, 'wnu_rsr_id_r');
		if (isset($_POST['dat_tdo_date']))
			array_push($fields, 'dat_tdo_date');
		if (isset($_POST['wnu_csr_id_r']))
			array_push($fields, 'wnu_csr_id_r');
		if (isset($_POST['wnu_adm_id_r']))
			array_push($fields, 'wnu_adm_id_r');
        if (isset($_POST['txt_todo_r']))
			array_push($fields, 'txt_todo_r');
		if (isset($_POST['txt_history_r']))
			array_push($fields, 'txt_history_r');
		if (isset($_POST['wnu_mrh_id_r']))
			array_push($fields, 'wnu_mrh_id_r');
		if (isset($_POST['wnu_tdo_id_r']))
			array_push($fields, 'wnu_tdo_id_r');
		foreach( $fields as $name=>$value ) $cv->varible_in( $value ); //each variable is added to class by array loop
		$_v = $cv->get_cleaned_variables();
		$errors = $cv->get_bad_variables();	
		if ( !count( $errors ) ){
		 switch ( $_POST['action'] ) {
			 case 'get_Reseller':
				$_Result = getReseller( $_SESSION['user']['admin']['adm_id'], $_v['rsr_id'] );
				$_Result[0]['pho_number'] = makePhoneList($_Result);
				$_response = isset( $_Result[0] ) ? $_Result[0] : array();
			 break;			 
			 case 'get_Merchant':
				$_Result = getMerchants( $_SESSION['user']['admin']['adm_id'], $_v['csr_id'] );
				$_Result[0]['pho_number'] = makePhoneList($_Result);
				$_response = isset( $_Result[0] ) ? $_Result[0] : array();
			 break;
			 case 'del_Keep': case 'inact_Lead':
				if (isset($_v['csr_id']))
					$_response['status'] = deleteLeadKeep( $_SESSION['user']['admin']['adm_id'], $_v['csr_id'], 'tbl_csr_merchant', 'csr', $_POST['action'] == 'inact_Lead'? false : true );
				else{
					$_response['status'] = deleteLeadKeep( $_SESSION['user']['admin']['adm_id'], $_v['rsr_id'], 'tbl_csr_reseller', 'rsr', $_POST['action'] == 'inact_Lead'? false : true );
				}				
			 break;
			 case 'del_Lead':
				//tbl_csr_merchant
				if (isset($_v['csr_id']))
					$_response['status'] = deleteLead( $_SESSION['user']['admin']['adm_id'], $_v['csr_id'], 'tbl_csr_merchant', 'csr' );
				else{
					$_response['status'] = deleteLead( $_SESSION['user']['admin']['adm_id'], $_v['rsr_id'], 'tbl_csr_reseller', 'rsr' );
				}
			 break;
			 case 'save_to_do':
				if (isset($_v['csr_id']))
					$_response['status'] = addToDo( $_SESSION['user']['admin']['adm_id'], $_v['csr_id'], $_v['todo'], isset($_v['tdo_date'])?$_v['tdo_date']:null , 'csr' );
				else 
					$_response['status'] = addToDo( $_SESSION['user']['admin']['adm_id'], $_v['rsr_id'], $_v['todo'], isset($_v['tdo_date'])?$_v['tdo_date']:null, 'rsr' );
			 break;
			 case 'get_CSR':
				if ( isset($_v['csr_id']) )
					$_Result = getCSR( $_v['csr_id'], 'tbl_csr_merchant', 'csr' );
				else 
					$_Result = getCSR( $_v['rsr_id'], 'tbl_csr_reseller', 'rsr' );
				$_response = isset( $_Result ) ? $_Result : array();
			 break;
			 
			 case 'get_LiveReseller':
				if ( isset($_v['value']) )
					$_Result = getLiveReseller( $_v['value'] );
				$_response = isset( $_Result ) ? $_Result : array();
			 break;
			 
			 
			 case 'get_LiveMerchant':
				if ( isset($_v['value']) )
					$_Result = getLiveMerchant( $_v['value'] );
				$_response = isset( $_Result ) ? $_Result : array();
			 break;
			 
			 
			 case 'save_history':
				if (isset($_v['csr_id']))
					$_response['status'] = addHistory( $_v['csr_id'], $_v['history'], 'csr');
				else
					$_response['status'] = addHistory( $_v['rsr_id'], $_v['history'], 'rsr');
			 break;
			 case 'get_to_do':
				if (isset($_v['csr_id']))
					$_Result = getToDo( $_v['csr_id'], 'csr' );
				else
					$_Result = getToDo( $_v['rsr_id'], 'rsr' );
				$_response = isset( $_Result ) ? $_Result : array();
			 break;
			 case 'get_history':
				if (isset($_v['csr_id']))
					$_Result = getHistory( $_v['csr_id'], 'csr' );
				else
					$_Result = getHistory( $_v['rsr_id'], 'rsr' );
				$_response = isset( $_Result ) ? $_Result : array();
			 break;
			 case 'del_todo':
				$_response['status'] = deleteToDo( $_v['tdo_id'] );				
			 break;
			 case 'del_history':
				$_response['status'] = deleteHistory( $_v['mrh_id'] );
			 break;
			 case 'signTo':
				if (isset($_v['csr_id']))
					$_response['status'] = signToAdmin( $_v['adm_id'], $_v['csr_id'], 'tbl_csr_merchant', 'csr' );
				else
					$_response['status'] = signToAdmin( $_v['adm_id'], $_v['rsr_id'], 'tbl_csr_reseller', 'rsr' );
			 break;
		 }
		} 
	    else
		 $_response=array( 'status' => false );
	}
	echo json_encode( $_response );
}/*End AJAX*/		
else{
	/*Begin Page Data*/
	$resList = null; $merchList = null; $_i=0; $str = ''; $phoneArr = array();
	if (isset($_REQUEST['data_select']) && $_REQUEST['data_select']=='rsr_id'){
		$resList = getReseller($_SESSION['user']['admin']['adm_id']);
		$TodayTasks = get_Today_Tasks($_SESSION['user']['admin']['adm_id'], 'tbl_csr_reseller', 'rsr'); $Task_StrList = "<h2>Today's Tasks</h2>";		
		foreach ($TodayTasks as $key => $v) {
			if ($v['rsr_id'] != $_i) { $_i = $v['rsr_id']; $str = '<div class="row"><div class="col-sm-3"><p><strong>Email: </strong>'.$v['rsr_email'].'</p></div><div class="col-sm-3"><p><strong>Full Name: </strong>'.$v['rsr_name'].'</p></div><div class="col-sm-3"><p><strong>Subdomain: </strong>'.$v['rsr_subdomain'].'</p></div><div class="col-sm-3"><p><strong>Phone: </strong>'.$v['rsr_phone'].'</p></div></div>'; }		
			$Task_StrList .= '<div id="'.$v['tdo_id'].'_task" class="alert alert-danger" role="alert"><a href="#" title="Mark as done" class="close"><span class="glyphicon glyphicon-ok"></span></a><br>'. $str .'<br>'.$v['tdo_task'].'</div>';
		}
	}	
	else{
		$merchList = getMerchants($_SESSION['user']['admin']['adm_id']);
		$TodayTasks = get_Today_Tasks($_SESSION['user']['admin']['adm_id'], 'tbl_csr_merchant', 'csr'); $Task_StrList = "<h2>Today's Tasks</h2>";		
		foreach ($TodayTasks as $key => $v) {
			if ($v['csr_id'] != $_i) { $_i = $v['csr_id']; $str = '<div class="row"><div class="col-sm-3"><p><strong>Email: </strong>'.$v['csr_email'].'</p></div><div class="col-sm-3"><p><strong>Company Name: </strong>'.$v['csr_company_name'].'</p></div><div class="col-sm-3"><p><strong>Contact Name: </strong>'.$v['csr_contact_name'].'</p></div><div class="col-sm-3"><p><strong>Phone: </strong>'.$v['csr_phone_number'].'</p></div></div>'; }		
			$Task_StrList .= '<div id="'.$v['tdo_id'].'_task" class="alert alert-danger" role="alert"><a href="#" title="Mark as done" class="close"><span class="glyphicon glyphicon-ok"></span></a><br>'. $str .'<br>'.$v['tdo_task'].'</div>';
		}
	}
	if ($Task_StrList == "<h2>Today's Tasks</h2>") $Task_StrList .= "<p><small>You don't have any task scheduled for Today</small></p>";
	
	$adminList = get_CRM_Admin(); $adm_StrList='<li disabled>CRM Admins</li>';
	
	foreach ($adminList as $key => $val)
		$adm_StrList.= "<li><a href='#' title='{$val['adm_email']}' class='signTo' data-id='{$val['adm_id']}'>{$val['adm_chat_name']}</a></li>";
	
	if(isset($_REQUEST['data_select']) && $_REQUEST['data_select']=='rsr_id'){
		
		if(empty($resList)) {
			$noResults = true;
		}	
		else{
			$results = ''; $idArr = array();
			
			foreach ( $resList as $k=>$v ) {
				//$_str = (empty($v['pho_number'])?'':'<br>' . "(".substr($v['pho_number'], -10, 3).") ".substr($v['pho_number'], -7, 3)."-".substr($v['pho_number'],-4)) . (empty($v['pho_extension'])?'':' Ext: ' . $v['pho_extension']);
				if (!isset($phoneArr['{%%Phone_String_'.$v['rsr_id'].'%%}'])) 
					$phoneArr['{%%Phone_String_'.$v['rsr_id'].'%%}'] = array();				
				if ( !empty($v['pho_number']) ){
					if (!isset( $phoneArr['{%%Phone_String_'.$v['rsr_id'].'%%}'][$v['pho_number']] )) {
						$phoneArr['{%%Phone_String_'.$v['rsr_id'].'%%}'][$v['pho_number']] = array();
					}
					if ( !empty( $v['pho_extension'] ) )
						array_push($phoneArr['{%%Phone_String_'.$v['rsr_id'].'%%}'][$v['pho_number']], $v['pho_extension']);					
				}	
					
				if ( !in_array( $v['rsr_id'], $idArr ) ){
					array_push($idArr, $v['rsr_id']);
					$results .= '<tr>';
					$results .=   '<td>'.$v['rsr_id'].'</td>';			
					$results .=   '<td>'.$v['rsr_company_name'].'</td>';
					$results .=   '<td>'.$v['rsr_name'].'</td>';
					$results .=   '<td>'.$v['rsr_email'] . ($v['duplicates']=='1'? ' <button title="This email is already in the CRM list." type="button" data-toggle="modal" data-target="#myDuplicateMatch" class="btn btn-warning btn-xs duplicateMatch"><span class="glyphicon glyphicon-warning-sign"></span></button>':'');
					$results .=	  '<td>{%%Phone_String_'.$v['rsr_id'].'%%}</td>';
					
					$results .=   '<td>'.$v['rsr_subdomain'] . ($v['resellerMatch'] > 0?' <button title="This subdomain was taken for a reseller account." type="button" data-toggle="modal" data-target="#myModalMatch" class="btn btn-danger btn-xs resellerMatch"><span class="glyphicon glyphicon-warning-sign"></span></button>':'') . '</td>';
					$results .=   '<td>' . (isset( $v['rsr_registerdate'] )? date( 'm-d-Y',strtotime($v['rsr_registerdate'] )): '') . '</td>';					
					$results .=   '<td>'.$v['rsr_category'].'</td>';
					$results .=   '<td>' . (isset($v['mrh_date'])? date( 'm-d-Y',strtotime($v['mrh_date'] )):'') . '</td>';
					$results .=   '<td>
									<div style="min-width:120px;" class="btn-group btn-group-xs" role="group" aria-label="...">
										<button title="Potential Merchant Details" aria-label="..." type="button" class="btn btn-info findPotRes" data-toggle="modal" data-target="#myModalReseller"><span class="glyphicon glyphicon-pencil"></span></button>
										<button title="To do for this Potential Merchant" aria-label="..." type="button" class="btn btn-default todoPotRes" data-toggle="modal" data-target="#myModalHT"><span class="glyphicon glyphicon-calendar"></span></button>
										<button title="Potential Merchant History" aria-label="..." type="button" class="btn btn-warning historyPotRes" data-toggle="modal" data-target="#myModalHT"><span class="glyphicon glyphicon-book"></span></button>
										<button title="Sign it to" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="glyphicon glyphicon-user"></span> <span class="caret"></span></button>
										 <ul class="dropdown-menu">' .
											$adm_StrList									
										 . '</ul>
										
									</div>	
								   </td>';
					$results .= '</tr>';
				}	
			}
				
		}
	} else {
		$results = ''; $idArr = array();
		$p_category = '<option value="">Select a category</option>';
		foreach ( $merchList as $k=>$v ) {
			if (!isset($phoneArr['{%%Phone_String_'.$v['csr_id'].'%%}'])) 
				$phoneArr['{%%Phone_String_'.$v['csr_id'].'%%}'] = array();				
			if ( !empty($v['pho_number']) ){
				if (!isset( $phoneArr['{%%Phone_String_'.$v['csr_id'].'%%}'][$v['pho_number']] )) {
					$phoneArr['{%%Phone_String_'.$v['csr_id'].'%%}'][$v['pho_number']] = array();
				}
				if ( !empty( $v['pho_extension'] ) )
					array_push($phoneArr['{%%Phone_String_'.$v['csr_id'].'%%}'][$v['pho_number']], $v['pho_extension']);					
			}
			if ( !in_array( $v['csr_id'], $idArr ) ){
				array_push($idArr, $v['csr_id']);
				$results .= '<tr>';
				$results .=   '<td>'.$v['csr_id'].'</td>';			
				$results .=   '<td>'.$v['csr_company_name'].'</td>';				
				$results .=   '<td>'.$v['csr_contact_name'].'</td>';
				$results .=   '<td>'.$v['csr_email'] . ($v['duplicates']=='1'? ' <button title="This email is already in the CRM list." type="button" data-toggle="modal" data-target="#myDuplicateMatch" class="btn btn-warning btn-xs duplicateMatch"><span class="glyphicon glyphicon-warning-sign"></span></button>' : ($v['merchantMatch'] > 0?' <button title="This email was taken for a merchant account." type="button" data-toggle="modal" data-target="#myModalMatch" class="btn btn-danger btn-xs merchantMatch"><span class="glyphicon glyphicon-warning-sign"></span></button>':'')) . '</td>';
				$results .=	  '<td>{%%Phone_String_'.$v['csr_id'].'%%}</td>';				
				$results .=   '<td>' . (isset( $v['csr_registerdate'] )?  date( 'm-d-Y',strtotime($v['csr_registerdate']) ) : ''). '</td>';
				$results .=   '<td>'. (isset( $v['mrh_date'] )? date( 'm-d-Y', strtotime($v['mrh_date'])) :'').'</td>';
				$results .=   '<td>'.$v['res_name'].'</td>';
				$results .=   '<td>
								<div style="min-width:120px;" class="btn-group btn-group-xs" role="group" aria-label="...">
									<button title="Potential Merchant Details" aria-label="..." type="button" class="btn btn-info findPotMech" data-toggle="modal" data-target="#myModal"><span class="glyphicon glyphicon-pencil"></span></button>
									<button title="To do for this Potential Merchant" aria-label="..." type="button" class="btn btn-default todoPotMech" data-toggle="modal" data-target="#myModalHT"><span class="glyphicon glyphicon-calendar"></span></button>
									<button title="Potential Merchant History" aria-label="..." type="button" class="btn btn-warning historyPotMech" data-toggle="modal" data-target="#myModalHT"><span class="glyphicon glyphicon-book"></span></button>
									<button title="Sign it to" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><span class="glyphicon glyphicon-user"></span> <span class="caret"></span></button>
									 <ul class="dropdown-menu">' .
										$adm_StrList									
									 . '</ul>
									
								</div>	
							   </td>';
				$results .= '</tr>';
			}		
			$sql = 'SELECT cat_id,cat_name,cat_slug,cat_parent_id FROM `tbl_category` WHERE cat_local=1 AND cat_active=1 ORDER BY cat_name';
			$qry = $dbo->prepare( $sql );
			$qry=execPDO($qry);
			$qry = $qry->fetchAll( PDO::FETCH_ASSOC );			
			if(!empty($qry)){			
				foreach ($qry as $value) {
				  $p_cat_sel = '';
				  if( isset( $_POST['p_category_selection'] ) ) { if ($_POST['p_category_selection'] != $value['cat_id']){$p_cat_sel = '';}else{ $p_cat_sel = ' selected';} }
				  $p_category .= '<option value="'.$value['cat_id'].'" '.$p_cat_sel.'>'.$value['cat_name'].'</option>';
				}
			}			
		}
	}
	if ( isset($results) && !empty( $results ) ){
		//echo "YES";
		
		//var_dump($phoneArr);
		
		foreach ( $phoneArr as $key=>$val ) {
			
			if ( count($val) == 0 ){				
				$results = str_replace( $key, '',$results);
			}	
			else {
				$_str = '';
				foreach ($val as $key1=>$val1) {					
					$_str .= ($_str===''?'':'<br>')."(".substr($key1, -10, 3).") ".substr($key1, -7, 3)."-".substr($key1,-4); $_str1 = '';
					foreach ($val1 as $key2=>$val2) {
						$_str1 .= ($_str1===''?' Ext: ':', ').$val2;	
					}
					$_str .= $_str1;
				}					
				$results = str_replace( $key, $_str,$results);
			}
		}
	}	
	
$resellerOptions = '<option disabled style="font-weight:bold;" value="0">Select a Reseller</option>';  	
$qry = $dbo->prepare( 'SELECT * FROM `tbl_reseller` WHERE res_active' );
$qry=execPDO($qry);
$resellerList = $qry->fetchAll( PDO::FETCH_ASSOC );

if(!empty($resellerList)){			
	foreach ($resellerList as $value) {
	  $resellerOptions .= '<option value="'.$value['res_id'].'">'.$value['res_name'].'</option>';
	}
}

require 'header.php';
?>
<div class='container'>
	<div class='row'>
		<div class='col-sm-12'>
			<h1><span class = 'glyphicon glyphicon-briefcase'></span><?php echo (isset($_REQUEST['data_select']) && $_REQUEST['data_select']=='rsr_id'?" CRM Potential Resellers":" CRM Potential Merchants");?></h1>			
		</div>	
	</div>
</div>

<div class="modal fade" id="myModalHT" tabindex="-1" role="dialog" aria-labelledby="myModalHTLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalHTLabel"><?php echo (isset($_REQUEST['data_select']) && $_REQUEST['data_select']=='rsr_id'? 'Potential Reseller History': 'Potential Merchant History');?></h4>
      </div>
      <div class="modal-body">
	    <div class="message"></div>
        <form id="htCSRMerchant">
			<input type="hidden" name="wnu_csr_id_r" value="0">
			<div></div>			
		</form>
	  </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>		
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="myModalMatch" tabindex="-1" role="dialog" aria-labelledby="myModalMatchLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalMatchLabel"><?php echo 'The <span id="lead-identity"></span> is being used by a live '.(isset($_REQUEST['data_select']) && $_REQUEST['data_select']=='rsr_id'?'Reseller':'Merchant'); ?></h4>
      </div>
      <div class="modal-body">
	    <div class="message"></div>
        <form id="removeCSRLead">
			<input type="hidden" name="wnu_csr_id_r" value="0">			
			<div></div>			
		</form>
	  </div>
      <div class="modal-footer">
        <button type="button " class="btn btn-default" data-dismiss="modal">Close</button>
		<button type="button" id="deleteAndLink" class="btn btn-primary">Link two contacts and remove prospect from active list</button>
		<button type="button" id="deleteAll" class="btn btn-danger">Remove prospect from active list</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="myDuplicateMatch" tabindex="-1" role="dialog" aria-labelledby="myDuplicateMatchLabel">
  <div class="modal-dialog modal-sm" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myDuplicateMatchLabel">CSR List</h4>
      </div>
      <div class="modal-body">
	    <div class="message"></div>        
	  </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>		
      </div>
    </div>
  </div>
</div>

<!-- Modal  CSR.csr_registerdate, CAT.cat_id, CAT.cat_name, CSR.csr_description, ADM.adm_chat_name, CSR.csr_web_url, CSR.csr_email, CSR.csr_phone_number, CSR.csr_contact_name, CSR.csr_company_name, CSR.csr_id, ADM.adm_id, CSR.csr_address, CSR.csr_city, CSR.csr_state, CSR.csr_zipcode, -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel">Update Potential Merchant Account</h4>
      </div>
      <div class="modal-body">
	    <div class="message"></div>
        <form id="changeCSRMerchant">
			<input type="hidden" id="csr_id" name="wnu_csr_id_r" value="0">
			<div class="form-group">
				<label for="csr_email">Email</label>
				<input type="text" id="csr_email" name="ema_csr_email_r" class="form-control"><span class='error'></span>
			</div>
			<div class="form-group">
				<label for="csr_company_name">Company Name</label>  
				<input type="text" id="csr_company_name" name="txt64_csr_company_name" class="form-control"><span class='error'></span>
			</div>
			<div class="form-group">
				<label for="csr_contact_name">Contact</label>
				<input type="text" id="csr_contact_name" name="nam_csr_contact_name" class="form-control"><span class='error'></span>
			</div>
			<div class="form-group">
				<label for="csr_phone_number">Contact Phone Numbers and Extensions</label>
				<div id="csr_phone_number_div" class="row"></div>				
			</div>
			<div class="form-group">
				<label for="csr_description">Company Description</label>
				<textarea id="csr_description" name="txt255_csr_description" class="form-control"></textarea><span class='error'></span>
			</div>			
			<div class="row">
			    <div class="form-group col-sm-4">
					<label for="csr_address">Address</label> 
					<input type="text" id="csr_address" name="txt_csr_address" class="form-control" required><span class='error'></span>
				</div>
				<div class="form-group col-sm-4">
					<label for="nam_csr_city">City</label>
					<input type="text" id="csr_city" name="nam_csr_city" class="form-control"><span class='error'></span>
				</div>	
				<div class="form-group col-sm-2">
					<label>State</label>
					<select name='abc_csr_state' id='csr_state' class='form-control'>
					    <option value=''>US States</option>
						<optgroup label='States' id="optgroup-states"></optgroup>
						<optgroup label='U.S. Territories' id="optgroup-terries"></optgroup>
					</select>
					<span class='error'></span>
				</div>
				<div class="form-group col-sm-2">
					<label for="csr_zipcode">Zipcode</label>
					<input type="text" id="csr_zipcode" name="zip_csr_zipcode" class="form-control"><span class='error'></span>
				</div>
			</div>
			<div class="form-group">
				<label for="csr_web_url">Website</label>
				<input type="text" id="csr_web_url" name="url_csr_web_url" class="form-control"><span class='error'></span>
			</div>
			<div class='form-group'>
				<label class="signupLabel" for="cat_id">Category</label>
				<select class="form-control" name="wnu_cat_id" id="cat_id">
					<?php echo (isset($p_category)? $p_category: ""); ?>
				</select>
				<span class='error'></span>
			</div>
		</form>
		<button type="button" id="btnNote_ToDo">Details</button>
		<div id="Note_ToDo" style="display:none;">		    
			<div class="row">
				<h2>Task List</h2>
				<div class="col-sm-12" id="fold_to_do">
				</div>
			</div>
			<div class="row"><h2>Notes</h2>
				<div class="col-sm-12" id="fold_history">
				</div>
			</div>			
		</div>
	  </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>		
        <button type="button" id="saveData" class="btn btn-primary">Save changes</button>
		<button type="button" id="deleteAllb" class="btn btn-danger">Delete</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="myModalReseller" tabindex="-1" role="dialog" aria-labelledby="myModalLabelRes">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabelRes">Update Potential Reseller Account</h4>
      </div>
      <div class="modal-body">
	    <div class="message"></div>
        <form id="changeCSRReseller">
			<input type="hidden" id="rsr_id" name="wnu_rsr_id_r" value="0">
			<div class="form-group">
				<label for="rsr_email">Email</label>
				<input type="text" id="rsr_email" name="ema_rsr_email_r" class="form-control"><span class='error'></span>
			</div>
			<div class="form-group">
				<label for="rsr_name">Full Name</label>
				<input type="text" id="rsr_name" name="nam_rsr_name" class="form-control"><span class='error'></span>
			</div>
			<div class="form-group">
				<label for="rsr_subdomain">Subdomain</label>  
				<input type="text" id="rsr_subdomain" name="aon255_rsr_subdomain" class="form-control"><span class='error'></span>
			</div>			
			<div class="form-group">
				<label for="rsr_phone">Phone Numbers and Extensions</label>
				<div id="rsr_phone_div" class="row"></div>
			</div>
			<div class="form-group">
				<label for="rsr_source">Source</label>
				<input type="text" id="rsr_source" name="nam_rsr_source" class="form-control"><span class='error'></span>
			</div>
			<div class="form-group">
				<label for="csr_company_name">Company Name</label>  
				<input type="text" id="rsr_company_name" name="txt64_rsr_company_name" class="form-control"><span class='error'></span>
			</div>
			<div class="form-group">
				<label for="csr_web_url">Website</label>
				<input type="text" id="rsr_web_url" name="url_rsr_web_url" class="form-control"><span class='error'></span>
			</div>
			<div class='form-group'>
				<label for="rsr_category">Category</label>
				<select class="form-control" name="nam_rsr_category" id="rsr_category">
				    <option value="">None</option>
					<option value="MSP">MSP</option>
					<option value="Marketing">Marketing</option>
					<option value="Benefit Organization">Benefit Organization</option>
					<option value="Processor">Processor</option>
					<option value="Current Client">Current Client</option>
					<option value="Rep">Rep</option>
					<option value="Non-Profit">Non-Profit</option>
					<option value="Foreign">Foreign</option>
					<option value="Potential Partner">Potential Partner</option>
					<option value="Potential Merchant">Potential Merchant</option>
					<option value="Merchant">Merchant</option>
				</select>
				<span class='error'></span>
			</div>
		</form>
		<button type="button" id="btnNoteRes_ToDo">Details</button>
		<div id="NoteRes_ToDo" style="display:none;">		    
			<div class="row">
				<h2>Task List</h2>
				<div class="col-sm-12" id="foldRes_to_do">
				</div>
			</div>
			<div class="row"><h2>Notes</h2>
				<div class="col-sm-12" id="foldRes_history">
				</div>
			</div>			
		</div>
	  </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>		
        <button type="button" id="saveResData" class="btn btn-primary">Save changes</button>
		<button type="button" id="deleteResAllb" class="btn btn-danger">Delete</button>
      </div>
    </div>
  </div>
</div>
<style>
#search_wrap{
	color:#fff; 
	background-color:#333;
	padding:25px 15px;
	margin: 0 200px;
	border-radius: 5px;
	margin-bottom: 15px;
}
.errors {color: red;font-size: 11px;display:inline-block;}
h1 {text-align: center;}
#results_table th {
	text-align:center !important;
}

</style>
<div class="container-fluid">
	<div class="row">
		<div class="col-xs-12">
			<div id="search_wrap">
			    <div class="row">
			    	<form method="get" id="search-form">
						<input type="hidden" id="res_id" name="res_id" value="<?php echo (isset($_GET['res_id'])?$_GET['res_id']:"");?>">
						<input type="hidden" name="data_select" value="<?php echo isset($_REQUEST['data_select'])? $_REQUEST['data_select']: 'csr_id'; ?>">
					    <div class="col-sm-1">
		    				<div class="form-group">
			    				<label for="email">Acct #</label>
			    				<input type="text" class="form-control input-sm" name="csr_id" value="<?php echo (isset($_GET['csr_id'])?$_GET['csr_id']:"")?>" placeholder="Acct #">
			    				
		    				</div>
						</div>
						<div class="col-sm-<?php echo isset($_REQUEST['data_select']) && $_REQUEST['data_select']=='rsr_id'? '3':'2'; ?>">
		    				<div class="form-group">
			    				<label for="comp_name">Company Name</label>
			    				<input class="form-control input-sm" type="text" value="<?php echo (isset($_REQUEST['csr_company_name'])?$_REQUEST['csr_company_name']:"")?>" placeholder="Company Name" id="csr_company_name" name="csr_company_name">			    				
		    				</div>
						</div>
						<div class="col-sm-<?php echo isset($_REQUEST['data_select']) && $_REQUEST['data_select']=='rsr_id'? '3':'2'; ?>">
		    				<div class="form-group">
			    				<label for="name">Contact</label>
			    				<input type="text" class="form-control input-sm" id="csr_contact_name" name="csr_contact_name" value="<?php echo (isset($_GET['csr_contact_name'])?$_GET['csr_contact_name']:"")?>" placeholder="Contact Name">
			    				
		    				</div>
						</div>
				    	<div class="col-sm-3">
		    				<div class="form-group">
			    				<label for="email">Email address</label>
			    				<input type="text" class="form-control input-sm" id="csr_email" name="csr_email" value="<?php echo (isset($_REQUEST['csr_email'])?$_REQUEST['csr_email']:"")?>" placeholder="Enter email">
			    				
		    				</div>
						</div>  
						<div class="col-sm-2">
		    				<div class="form-group">
			    				<label for="phone">Phone</label>
			    				<input class="form-control input-sm" type="text" id="pho_number" name="pho_number" value="<?php echo (isset($_GET['pho_number'])?$_GET['pho_number']:"")?>" placeholder="Phone Number">
			    				
		    				</div>
						</div> 
						
						<?php if (!(isset($_REQUEST['data_select']) && $_REQUEST['data_select']=='rsr_id')) { ?>
						
							<div class="col-sm-2">
								<div class="form-group">
									<label for="comp_name">Reseller</label>
									<input list="resellerNames" class="form-control input-sm" type="text" name="res_name" value="<?php echo (isset($_REQUEST['res_name'])?$_REQUEST['res_name']:"")?>" placeholder="Reseller Name" id="res_name"/>    								
									<datalist id="resellerNames">
										
									</datalist>			    				
								</div>
							</div>
						
						<?php } ?>	
						
				</div>
				    	<div class="row">
				    		<div class="col-sm-12">
								<input type="hidden" name="search" value="1">
								<button class="btn btn-sm btn-primary form-control"><span class='glyphicon glyphicon-search'></span> Search</button>
							</div>
						</div>
					</form>
			</div>
		</div>
		<div class="col-xs-4">
			<form action="/admin/crm" method="post">
				<div class="row">
					<div class="col-xs-12" style="margin: 10px 0 10px 0;">
						<select name="data_select" class="form-control" id="data_select">
							<option value="csr_id">Potential Merchant</option>
							<?php if (isset($_SESSION['user']['admin']['adm_in_house']) && $_SESSION['user']['admin']['adm_in_house']) { ?>
								<option value="rsr_id" <?php echo (isset($_REQUEST['data_select']) && $_REQUEST['data_select']=='rsr_id'?"selected":""); ?>>Potential Reseller</option>
							<?php } ?>
						</select>
					</div>
				</div>
			</form>	
		</div>
		<div class="col-xs-12">
			<table id="results_table" class="table table-bordered table-striped datatable" style="margin-top:15px;">
				<thead>
					<tr><?php echo (isset($_REQUEST['data_select']) && $_REQUEST['data_select']=='rsr_id'?"
						<th>Acct #</th>
						<th>Company Name</th>	
						<th>Contact</th>
						<th>Email</th>
						<th>Phone</th>
						
						
						<th>Subdomain</th>						
						<th>Date Added</th>
						<th>Category</th>
						<th>Recent Note</th>						
						<th>Options</th>"
						
						
						:
						
						
						"
						<th>Acct #</th>						
						<th>Company Name</th>
						<th>Contact</th>	
						<th>Email</th>
						<th>Phone</th>
						
						
						<th>Date Added</th>						
						<th>Recent Note</th>						
						<th>Reseller</th>
						<th>Options</th>
						");?>
					</tr>
				</thead>
				<tbody>
					<?php echo $results; ?>
				</tbody>
			</table>
		</div>
		<div class="col-xs-12">
			<?php
			if (isset($_SESSION['user']['admin']['adm_in_house']) && $_SESSION['user']['admin']['adm_in_house']) {
				//if (isset($_SESSION['user']['admin']['adm_master']) && $_SESSION['user']['admin']['adm_master'] && !(isset($_REQUEST['data_select']) && $_REQUEST['data_select']=='rsr_id')) {
					echo '
					<form id = "generateWeeklyReport">
						<div class="row">
							<div class="col-xs-4 col-xs-offset-4">								
								<label for="wnu_res_id_r">Resellers</label>
								<select id="wnu_res_id_r" name="wnu_res_id_r" class="form-control"> ' . $resellerOptions . ' </select>
								<p>A report will be generated with the new potential merchants added or modified data from a week now, as well as next week tasks or to do, under the selected re-seller account.</p>
								<button type="button" id="csv-pot-merchant-list" class="btn btn-block btn-default">Generate CSV file Report</button>
								<p style="display:none; margin: 10px 0;">To download the just created CSV file, please click <a href="#" class="download-csv-file">Download CSV File</a></p>
							</div>
						</div>	
					</form><br>';
				//}
				
				if (isset($_REQUEST['data_select']) && $_REQUEST['data_select']=='rsr_id') {
					echo
					'<a href="add-lead-list?data_select=rsr_id"><button title="Create Potential Reseller Accounts" type="button" class="btn btn-warning"><span class="glyphicon glyphicon-list"></span> Bulk Upload Potential Reseller List</button></a>			
					<button title="Create Potential Reseller Account" id="add_PotReseller" type="button" class="btn btn-primary" data-toggle="modal" data-target="#myModalReseller"><span class="glyphicon glyphicon-file"></span> Create Potential Reseller Account</button>';
				}
				else{
					echo '
					<a href="add-lead-list?data_select=csr_id"><button title="Create Potential Merchant Accounts" type="button" class="btn btn-warning"><span class="glyphicon glyphicon-list"></span> Bulk Upload Potential Merchant List</button></a>			
					<button title="Create Potential Merchant Account" id="add_PotMerchant" type="button" class="btn btn-primary" data-toggle="modal" data-target="#myModal"><span class="glyphicon glyphicon-file"></span> Create Potential Merchant Account</button>';				
				}
				
			}	
			?>	
		</div>
		<div class="col-xs-12">
			<?php echo $Task_StrList; ?>		
		</div>
	</div>
</div>
<style>
.change-color:hover {
	    background-color: #21608c !important;
}
.change-pho-color:hover{
	background-image: -webkit-linear-gradient(top, #d9edf7 0%, #a9cee0 100%) !important;
    background-image: -o-linear-gradient(top, #d9edf7 0%, #a9cee0 100%) !important;
    background-image: -webkit-gradient(linear, left top, left bottom, from(#d9edf7), to(#a9cee0)) !important;
    background-image: linear-gradient(to bottom, #d9edf7 0%, #a9cee0 100%) !important;
}
.modal-title, .modal-header, #myModalLabel, #myModalHTLabel, #myModalMatchLabel, .modal-footer{
	color:#fff; 
	background-color:#333;
}
span.error {color: red; font-size: 11px; display:inline;top:100% !important;left:15px !important;}
h1 {text-align: center;}
</style>
<script src="../plugins/check-form-inputs.js"></script>
<script>
$('#csv-pot-merchant-list').click(function (){
	$('.download-csv-file').parents('p:first').hide();
	var dataArr = {wnu_res_id_r: $('#wnu_res_id_r').val(), action : "loadReport"};
	$.post("/admin/crm", dataArr, function(value) {
		//console.log(value);
		var data = JSON.parse(value);		
		
		if (data.length > 1) {
			
			var csvContent = "data:text/csv;charset=utf-8,";
			data.forEach(function(infoArray, index){
			   //console.log(infoArray);
			   var dataString = '';
			   for (var i in infoArray) {
				   if (!infoArray.hasOwnProperty(i)) continue;
				   dataString += (dataString == ''? '' : ',') + (infoArray[i]?infoArray[i]:' ');
			   }
			   //var dataString = infoArray.join(",");
			   csvContent += index < data.length ? dataString+ "\n" : dataString;
			});	
			
			var encodedUri = encodeURI(csvContent);
			
			$('.download-csv-file').attr({'href' : encodedUri, 'download' : 'potential_merchants.csv'}).parents('p:first').show();
	
		}
		else {
			alert("There isn't any new or modified potential merchant data under the selected reseller account.");
		}
		
    });
})

$('#data_select').change(function () {
	$(this).parents('form:first').submit();
})

$('#btnNote_ToDo, #btnNoteRes_ToDo').click(function () {
	$(this).next().toggle();
})

// states and territories options
function settings_States(){
  $.get("../../api/api.lt.json.options.php",function(data){	
    $.each(data.options.state,function(k,v){
      $("#optgroup-states").append("<option value='"+k+"'>"+v+"</option>");
    });
    $.each(data.options.territory,function(k,v){
      $("#optgroup-terries").append("<option value='"+k+"'>"+v+"</option>");
    });
  })
}

settings_States();

$('#saveData, #saveResData').click(function () {
  $("form input, form textarea, form select").removeClass('vCheck');
  $(this).parents('div.modal-content').find("input").addClass('vCheck');	
  $(this).parents('div.modal-content').find("select").addClass('vCheck');
  $(this).parents('div.modal-content').find("textarea").addClass('vCheck');
  validForm.inicialiceObj($(this).parents('div.modal-content:first').find("form"));
  if (validForm.validInputs(false)){
	  var serializedForm = $(this).parents('div.modal-content:first').find("form").serializeArray(); var dataArr = {};
	  for (var i in serializedForm){  
		  if ( serializedForm[i].name != undefined && serializedForm[i].value != undefined)
			dataArr[serializedForm[i].name] = serializedForm[i].value;
	  }
      $(this).parents('div.modal-content:first').find("form input:first").attr("id") == 'rsr_id'? dataArr['action'] = 'add_Reseller': dataArr['action'] = 'add_Merchant';
	  $.post("/admin/crm", dataArr, function(data) {
		
        var value = JSON.parse(data);
		//console.log(value);
		if (value['status'] != undefined && value['status']) {
			if(value['notify'] != undefined) alert($(value['notify']).text() + " The rest of the lead's data was saved.");
			$('#data_select').parents('form:first').submit();
		}
		else if(value['notify'] != undefined) alert($(value['notify']).text());
	  });
  }
  else{
	 $('.message').html(validForm.buildMessage());
  }
})

$('.duplicateMatch').click(function () {
	var dataArr = {};
	dataArr['action'] = 'get_CSR';
	dataArr['wnu_'+$('#data_select').val()+'_r'] = $(this).parents('tr:first').find('td:first').text();
	$.post("/admin/crm", dataArr, function(data) {	  
	  var value = JSON.parse(data);
	  //console.log(value);
	  var str = "<h2>Duplicate in the following CSR's list:</h2>";
	    $.each(value, function(k,v) {		 
		  str += '<p>'+v['adm_email']+'</p>';		 
		});
		$('#myDuplicateMatch .modal-body .message').html(str);
	});
})

$( '#deleteAll, #deleteAndLink, #deleteAllb, #deleteResAllb' ).click( function () {
	var dataArr = {};
    if (  $( this ).attr('id') ===  'deleteAndLink' ) {
		dataArr['action'] = 'del_Keep';
		var message = 'We will delete the potential lead and link its history to the actual merchant account. Do you want to continue?';
	}
	else if( $( this ).attr('id') ===  'deleteAll' ){
		dataArr['action'] = 'inact_Lead';
		var message = 'We will inactivate the potential lead and its history. Do you want to continue?';
	}
	else{
		dataArr['action'] = 'del_Lead';
		var message = 'We will delete the potential lead and its history. Do you want to continue?';
	}
	
    if ( window.confirm( message ) ) {
		dataArr[$('#removeCSRLead').find('input:first').attr("name")] = $('#removeCSRLead').find('input:first').val();	  
		//console.log(dataArr);
		$.post("/admin/crm", dataArr, function(data) {
		  //console.log(data);	
		  var value = JSON.parse(data);
		  
		  if ( value['status'] != undefined && value[ 'status' ] ) {
			$( '#data_select' ).parents( 'form:first' ).submit();
		  }	
		});
	}	
})

$('.findPotMech, .findPotRes').click(function (){
	$($(this).hasClass('findPotMech')?'#myModal':'#myModalReseller').find('button:last').prop("disabled", false);
	$($(this).hasClass('findPotMech')?'#myModalLabel':'#myModalLabelRes').text('Update Potential '+($(this).hasClass('findPotMech')?'Merchant': 'Reseller')+' Account');
	$(this).hasClass('findPotMech')?get_PMerch($(this).parents('tr:first').find('td:first').text()):get_PRes($(this).parents('tr:first').find('td:first').text());
	loadValues( 'to_do', $(this).parents('tr:first').find('td:first').text(), $(this).hasClass('findPotMech')?'wnu_csr_id_r':'wnu_rsr_id_r' );
	loadValues( 'history', $(this).parents('tr:first').find('td:first').text(), $(this).hasClass('findPotMech')?'wnu_csr_id_r':'wnu_rsr_id_r' );
})

$( '.historyPotMech, .historyPotRes' ).click( function () {
	$('#myModalHTLabel').text($(this).hasClass('historyPotMech')?'Potential Merchant History':'Potential Reseller History');
	$('#htCSRMerchant').find('div:first').html(
	'<div class="row">'+($(this).hasClass('historyPotMech')?'<div class="col-sm-12"><h2>Merchant Info</h2></div><div class="col-sm-3"><strong>Email: </strong>'+$(this).parents('tr:first').find('td:eq(3)').text()+'</div><div class="col-sm-3"><strong>Company Name: </strong>'+$(this).parents('tr:first').find('td:eq(1)').text()+'</div><div class="col-sm-3"><strong>Phone Number: </strong>'+$(this).parents('tr:first').find('td:eq(4)').text()+'</div><div class="col-sm-3"><strong>Contact Name: </strong>'+$(this).parents('tr:first').find('td:eq(2)').text()+'</div>': '<div class="col-sm-12"><h2>Reseller Info</h2></div><div class="col-sm-3"><strong>Email: </strong>'+$(this).parents('tr:first').find('td:eq(3)').text()+'</div><div class="col-sm-3"><strong>Full Name: </strong>'+$(this).parents('tr:first').find('td:eq(2)').text()+'</div><div class="col-sm-3"><strong>Company Name: </strong>'+$(this).parents('tr:first').find('td:eq(1)').text()+'</div><div class="col-sm-3"><strong>Phone: </strong>'+$(this).parents('tr:first').find('td:eq(4)').text()+'</div>')+
	 '<div class="col-sm-12">'+
	  '<div class="row">'+
	   '<div class="col-sm-12" id="history_add">'+
		'<label for="history">Note</label>'+
		'<textarea class="form-control vCheck" name="txt_history_r"></textarea><span class="error"></span><button type="submit" class="btn btn-xs btn-primary"><span class="glyphicon glyphicon-book"></span> Add Note</button>'+
	   '</div>'+
	  '</div>'+
	  '<div class="row"><h2>Notes</h2>'+
	   '<div class="col-sm-12" id="history">'+	    
	   '</div>'+
	  '</div>'+
	 '</div>'+
	'</div>');
	
	$('#htCSRMerchant').find('input:first').attr('name', $(this).hasClass('historyPotMech')?'wnu_csr_id_r':'wnu_rsr_id_r');
	$('#htCSRMerchant').find('input:first').val( $(this).parents('tr:first').find('td:first').text() );	
	loadValues('history', $(this).parents('tr:first').find('td:first').text(), $(this).hasClass('historyPotMech')?'wnu_csr_id_r':'wnu_rsr_id_r' );
})

$( '.todoPotMech, .todoPotRes' ).click( function () {
	$('#myModalHTLabel').text($(this).hasClass('todoPotMech')?'Potential Merchant Tasks':'Potential Reseller Tasks');
	$('#htCSRMerchant').find('div:first').html(
	'<div class="row">'+($(this).hasClass('todoPotMech')?'<div class="col-sm-12"><h2>Merchant Info</h2></div><div class="col-sm-3"><strong>Email: </strong>'+$(this).parents('tr:first').find('td:eq(3)').text()+'</div><div class="col-sm-3"><strong>Company Name: </strong>'+$(this).parents('tr:first').find('td:eq(1)').text()+'</div><div class="col-sm-3"><strong>Phone: </strong>'+$(this).parents('tr:first').find('td:eq(4)').text()+'</div><div class="col-sm-3"><strong>Contact Name: </strong>'+$(this).parents('tr:first').find('td:eq(2)').text()+'</div>':'<div class="col-sm-12"><h2>Reseller Info</h2></div><div class="col-sm-3"><strong>Email: </strong>'+$(this).parents('tr:first').find('td:eq(3)').text()+'</div><div class="col-sm-3"><strong>Name: </strong>'+$(this).parents('tr:first').find('td:eq(2)').text()+'</div><div class="col-sm-3"><strong>Company Name: </strong>'+$(this).parents('tr:first').find('td:eq(1)').text()+'</div><div class="col-sm-3"><strong>Phone: </strong>'+$(this).parents('tr:first').find('td:eq(4)').text()+'</div>')+
	 '<div class="col-sm-12">'+
	  '<div class="row">'+
	   '<div class="col-sm-12" id="to_do_add">'+
	    '<div class="row">'+
		 '<div class="col-sm-4">'+
		  '<label for="tdo_date">Date</label>'+
          '<input type="date" required id="tdo_date" value="2016-01-01" name="dat_tdo_date" class="form-control  vCheck"><span class="error"></span>'+
		 '</div>'+ 
		 '<div class="col-sm-12">'+ 
		  '<label for="history">Task</label>'+
		  '<textarea class="form-control vCheck" name="txt_todo_r"></textarea><span class="error"></span><button type="submit" class="btn btn-xs btn-primary"><span class="glyphicon glyphicon-calendar"></span> Add Task</button>'+
		 '</div>'+ 
		'</div>'+ 
	   '</div>'+
	  '</div>'+ 
	  '<div class="row">'+
	   '<h2>Task List</h2>'+
	   '<div class="col-sm-12" id="to_do">'+
	   '</div>'+
	  '</div>'+
	 '</div>'+
	'</div>');
	$('#htCSRMerchant').find('input:first').attr('name', $(this).hasClass('todoPotMech')?'wnu_csr_id_r':'wnu_rsr_id_r');
	$('#htCSRMerchant').find('input:first').val( $(this).parents('tr:first').find('td:first').text() );
	loadValues( 'to_do', $(this).parents('tr:first').find('td:first').text(), $(this).hasClass('todoPotMech')?'wnu_csr_id_r':'wnu_rsr_id_r' );
})

$('#htCSRMerchant').submit( function ( e ){
	e.preventDefault();	
	validForm.inicialiceObj( $( this ) );
    if ( !validForm.validInputs( false ) ) {
		$('.message').html(validForm.buildMessage());
	}
	else {
		$('.message').html(''); saveValues( $('#htCSRMerchant #to_do').length > 0 ? 'to_do': 'history', $('#htCSRMerchant').find('input:first').val(),  $('#htCSRMerchant').find('textarea:first').val(), $('#htCSRMerchant #tdo_date').length > 0? $('#htCSRMerchant #tdo_date').val():null);
	}
})

$('.signTo').click(function (){
	var reqObj = {action: 'signTo', wnu_adm_id_r: $(this).data('id')};
	reqObj['wnu_'+$('#data_select').val()+'_r'] = $(this).parents('tr:first').find('td:first').text();
	//console.log(reqObj);
    $.post("/admin/crm", reqObj, function(data) {		
		var value = JSON.parse(data);
		//console.log(value);
		if ( value['status'] != undefined && value['status'] ) {			
			$('#data_select').parents('form:first').submit();
		}
	})
})

function convertDate(inputFormat) {
  return [inputFormat.split('-')[1], inputFormat.split('-')[2], inputFormat.split('-')[0]].join('/');
}

function saveValues( whatToSave, leadid, data, dateV ) {
   var str='';
   var dataObj = {
	   action: 'save_' + whatToSave
   }
   dataObj['wnu_'+$('#data_select').val()+'_r'] = leadid;
   dataObj ['txt_'+whatToSave.replace('_','')+'_r'] = data;
   if (dateV) dataObj ['dat_tdo_date'] = convertDate(dateV);   
   $.post("/admin/crm", dataObj, function(data) {
    var value = JSON.parse(data);
	//console.log(value);
	if ( value['status'] != undefined && value['status'] ) {
		loadValues( whatToSave, leadid, 'wnu_'+$('#data_select').val()+'_r');		
	}	
  })
}

function loadValues( whatToLoad, leadid, afield){
	var str=''; var reqObj = {};
	reqObj['action'] = 'get_'+whatToLoad; reqObj[afield] = leadid;
	//console.log(reqObj);
	$.post("/admin/crm", reqObj,function(data){	
	//console.log(data);
    var value = JSON.parse(data);
	//console.log(value);
	$.each(value, function(k,v) {
     if ( v['mrh_date'] != undefined && v['mrh_notes'] != undefined && v['mrh_id'] != undefined )	 
	  str += '<div id="'+v['mrh_id']+'_notes" class="alert alert-info" role="alert"><a href="#" class="close">&times;</a><br><span>'+v['mrh_date']+'</span><br><br>'+v['mrh_notes']+'</div>';
     else if ( v['tdo_task'] != undefined && v['tdo_id'] != undefined )	
      str += '<div id="'+v['tdo_id']+'_task" class="alert alert-danger" role="alert"><a href="#" title="Mark as done" class="close"><span class="glyphicon glyphicon-ok"></span></a><br><span>'+v['tdo_date']+'</span><br><br>'+v['tdo_task']+'</div>';
    });
	$('#'+whatToLoad+', #fold_'+whatToLoad).html(str==''?"<p><small>Empty</small></p>":str);
  })
}

function get_PMerch(csrid) {
  $('#removeCSRLead').find('input:first').val(csrid);
  $('#removeCSRLead').find('input:first').attr('name','wnu_csr_id_r');
  $.post("/admin/crm", {action: 'get_Merchant', wnu_csr_id_r: csrid},function(data){
    var value = JSON.parse(data);
	//console.log(value);
	//console.log(data);
	$('#csr_phone_number_div').html('');
	$('<div class="row"><div class="col-sm-12"><button type="button" style="margin:15px;" class="btn btn-primary"><span class="glyphicon glyphicon-phone"></span> Add Phone Number</button></div></div>').appendTo('#csr_phone_number_div');	
	$.each(value,function(k,v){
	  if (k == 'pho_id') var phoid = v;
	  if (k == 'pho_number'){
		build_Phone(v, '#csr_phone_number_div');		
	  }
	  else 	  
		$("#"+k).val(v);
    });	
  })
}

function get_PRes(rsrid) {
  $('#removeCSRLead').find('input:first').val(rsrid);
  $('#removeCSRLead').find('input:first').attr('name','wnu_rsr_id_r');
  $.post("/admin/crm", {action: 'get_Reseller', wnu_rsr_id_r: rsrid},function(data) {
    var value = JSON.parse(data);
	//console.log(value);
	//console.log(data);
	$('#rsr_phone_div').html('');
	$('<div class="row"><div class="col-sm-12"><button type="button" style="margin:15px;" class="btn btn-primary"><span class="glyphicon glyphicon-phone"></span> Add Phone Number</button></div></div>').appendTo('#rsr_phone_div');	
	$.each(value,function(k,v){
	  if (k == 'pho_id') var phoid = v;
	  if (k == 'pho_number'){
		build_Phone(v, '#rsr_phone_div');
	  }  
	  else	
		$("#"+k).val(v);
    });
  })
}

function build_Phone(value, anId){	
	var n=0;
	for (var i in value) {
		if (!isNaN(i)){
			var strExt = '<div class="row"><div class="col-sm-12"><button type="button" class="btn btn-primary">Add Ext</button></div>';
			for (var j in value[i]){
				if (!isNaN(j)){
					strExt += '<div class="col-sm-12"><div class="alert change-color"><a href="#" title="Delete Extension" class="close"><span class="glyphicon glyphicon-trash"></span></a><input type="text" name="wnu_'+(anId=='#csr_phone_number_div'?'c':'r')+'sr_phone_ext'+n+j+'" value="'+value[i][j]+'" class="form-control"><span class="error"></span></div></div>';
				}	
			}
			strExt += '</div>';				
			$('<div class="col-sm-4"><div class="alert alert-info change-pho-color"><div class="row"><div class="col-sm-7"><a href="#" title="Delete Phone Number and its Extensions" class="close"><span class="glyphicon glyphicon-trash"></span></a><input type="text" name="pho_'+(anId=='#csr_phone_number_div'?'c':'r')+'sr_phone_number'+(n++)+'" value="'+i+'" class="form-control"><span class="error"></span></div><div class="col-sm-5">'+strExt+'</div></div></div></div>').appendTo(anId);
		}		
	}

	//validForm = new validateForm();
	//validForm.inicialiceObj($(anId).parents('form:first'));
	
}

$('#csr_phone_number_div, #rsr_phone_div').on('click', 'a.close', function (){
	if ($(this).parents('div.col-sm-5').length == 1) {
		$(this).parents('div.col-sm-12:first').remove();
		correctNames();
		
	}	
	if ($(this).parents('div.col-sm-7').length == 1) {
		$(this).parents('div.col-sm-4:first').remove();
		// reorder input names Phone Numbers and Extensions
		correctNames();
	}	
})

function correctNames(){
	var HTMLElment=$('#csr_phone_number_div');
	if ($(HTMLElment).length !== 1){
		var HTMLElment = $('#rsr_phone_div');
	}
	var valPho=0; 
	if ($(HTMLElment).length === 1) {
		$(HTMLElment).find('div.col-sm-4').each(function () {
			$(this).find('div.col-sm-7').find('input').attr('name', $(this).find('div.col-sm-7').find('input').attr('name').replace(/[0-9]/g,'') + (valPho).toString());
			var valExt=0; var valFlag=false;
			$(this).find('div.col-sm-5').find('div.col-sm-12').each(function (){
				if (valFlag) {
					$(this).find('input').attr('name', $(this).find('input').attr('name').replace(/[0-9]/g,'') + (valPho).toString() + (valExt++).toString() );
				}
				else {valFlag = true;}
			})
			valPho++;
		})
	}
}

$('#csr_phone_number_div, #rsr_phone_div').on('click', 'button', function () {
	var _prefix = $(this).parents('div#csr_phone_number_div').length == 1 ? 'csr':'rsr';
	if ($(this).parents('div.col-sm-5').length == 1) {
		if ($(this).parents('div.row:first').find('div.col-sm-12').length == 1 || $(this).parents('div.row:first').find('input:last').val() != '') {
			$(this).parents('div.row:first').append('<div class="col-sm-12"><div class="alert change-color"><a href="#" title="Delete Extension" class="close"><span class="glyphicon glyphicon-trash"></span></a><input type="text" name="wnu_'+_prefix+'_phone_ext'+$(this).parents('div.row:eq(1)').find('div.col-sm-7').find('input').attr('name').replace(/[a-zA-Z_]/g, '')+($(this).parents('div.row:first').find('div.col-sm-12').length-1).toString()+'" value="" class="form-control"><span class="error"></span></div></div>');
			$(this).parents('div.row:first').find('input:last').val('').focus();			
		}
		else {$(this).parents('div.row:first').find('input:last').focus();}
	}	
	else if ($(this).parents('div.col-sm-12').length == 1) {
		if ($(this).parents('div.row:eq(1)').find('div.col-sm-4:last').find('div.col-sm-7').find('input:last').val() != '') {
			$('<div class="col-sm-4"><div class="alert alert-info change-pho-color"><div class="row"><div class="col-sm-7"><a href="#" title="Delete Phone Number and its Extensions" class="close"><span class="glyphicon glyphicon-trash"></span></a><input type="text" name="'+'pho_'+_prefix+'_phone_number'+($(this).parents('div.row:eq(1)').find('div.col-sm-4').length).toString()+'" value="" class="form-control"><span class="error"></span></div><div class="col-sm-5"><div class="row"><div class="col-sm-12"><button type="button" class="btn btn-primary">Add Ext</button></div></div></div></div></div></div>').appendTo($(this).parents('div.row:eq(1)'));
		}	
		else { $(this).parents('div.row:eq(1)').find('div.col-sm-4:last').find('div.col-sm-7').find('input:last').focus(); }
	}	
})

$('#htCSRMerchant, div.col-xs-12, #fold_history, #fold_to_do').on("click", 'a.close', function (){
	var idElm = $(this).parents('div.alert:first').attr("id");
    var refObj = $(this).parents('div.alert:first');
	if ( confirm( "This " + (idElm.split("_")[1] == 'notes'?'Note will be deleted':'To Do will be marked as done by moving it to history') + ". Do you want to continue?" ) ){		
		var dataObj={};
		dataObj['action'] = 'del_'+(idElm.split("_")[1] == 'notes'?'history':'todo');
		dataObj['wnu_'+(idElm.split("_")[1] == 'notes'?'mrh_id':'tdo_id')+'_r'] = idElm.split("_")[0];		
		$.post("/admin/crm", dataObj,function(data){			
			
			var value = JSON.parse(data);
			//console.log(value);
			if ( value['status'] != undefined && value['status'] ) {				
				$(refObj).hide();
			}		
		})
	}
})

var validForm=new validateForm();

// verify form inputs
$("form").on("change keyup select", "input, textarea, select", function(){
  //appVerify($(this)); // appVerify() defined in mystore_settings_menu.js
  $("form").find(".vCheck").removeClass("vCheck");
  $(this).addClass("vCheck");
  validForm.inicialiceObj($(this).parents('form:first'));
  var errArr = validForm.validInputs(true);
  if(errArr.length > 0) {$(this).css({"border-color":"#f88"}).next("span.error").text(errArr[0]).fadeIn();}
  else $(this).css({"border-color":"#ccc"}).next("span.error").empty().hide();
}); 

$('#add_PotMerchant').click(function (  ) {
	$('#csr_phone_number_div').html('');
	$('<div class="row"><div class="col-sm-12"><button type="button" style="margin:15px;" class="btn btn-primary"><span class="glyphicon glyphicon-phone"></span> Add Phone Number</button></div></div>').appendTo('#csr_phone_number_div');
	$('#changeCSRMerchant input, #changeCSRMerchant textarea').val(''); 
	$('#changeCSRMerchant input:first').val( '0' );
	$('#myModalLabel').text('Create Potential Merchant Account');
	$('#myModal').find('button:last').attr("disabled", "disabled");
})

$('#add_PotReseller').click(function (){
	$('#rsr_phone_div').html('');
	$('<div class="row"><div class="col-sm-12"><button type="button" style="margin:15px;" class="btn btn-primary"><span class="glyphicon glyphicon-phone"></span> Add Phone Number</button></div></div>').appendTo('#rsr_phone_div');
	$('#changeCSRReseller input, #changeCSRReseller textarea').val(''); 
	$('#changeCSRReseller input:first').val( '0' );
	$('#myModalLabelRes').text('Create Potential Reseller Account');
	$('#myModalReseller').find('button:last').attr("disabled", "disabled");
})

$('.merchantMatch, .resellerMatch').click(function () {
	$('#removeCSRLead').find('div:first').html(
		'<div class="row">'+
			'<div class="col-sm-6">'+				
				($(this).hasClass('resellerMatch')?
					'<h2>Potential Reseller Info</h2>'+
					'<p><strong>Email: </strong>'+$(this).parents('tr:first').find('td:eq(3)').text()+'</p>'+
					'<p><strong>Contact: </strong>'+$(this).parents('tr:first').find('td:eq(2)').text()+'</p>'+
					'<p><strong>Company Name: </strong>'+$(this).parents('tr:first').find('td:eq(1)').text()+'</p>'+
					'<p><strong>Phone: </strong>'+$(this).parents('tr:first').find('td:eq(4)').text()+'</p>'+
					'<p><strong>Website URL: </strong>'+$(this).parents('tr:first').find('td:eq(5)').text()+'</p>'+
					'<p><strong>Subdomain: </strong>'+$(this).parents('tr:first').find('td:eq(6)').text()+'</p>'
				:
					'<h2>Potential Merchant Info</h2>'+
					'<p><strong>Email: </strong>'+$(this).parents('tr:first').find('td:eq(3)').text()+'</p>'+
					'<p><strong>Company Name: </strong>'+$(this).parents('tr:first').find('td:eq(1)').text()+'</p>'+
					'<p><strong>Contact: </strong>'+$(this).parents('tr:first').find('td:eq(2)').text()+'</p>'+
					'<p><strong>Phone: </strong>'+$(this).parents('tr:first').find('td:eq(4)').text()+'</p>'+
					'<p><strong>Website URL: </strong>'+$(this).parents('tr:first').find('td:eq(5)').text()+'</p>')+
			'</div>'+
			'<div class="col-sm-6">'+				
				($(this).hasClass('resellerMatch')?'<h2>Live Reseller Info</h2>':'<h2>Live Merchant Info</h2>')+
				($(this).hasClass('resellerMatch')?get_Info('get_LiveReseller', 'aon_value_r', $(this).parents('tr:first').find('td:eq(6)').text().trim()):get_Info('get_LiveMerchant', 'ema_value_r', $(this).parents('tr:first').find('td:eq(3)').text().trim()))+
			'</div>'+
		'</div>'
	);
	$('#removeCSRLead').find('input:first').val( $(this).parents('tr:first').find('td:first').text() );	
	$(this).hasClass('resellerMatch')?$('#removeCSRLead').find('input:first').attr('name', 'wnu_rsr_id_r'):$('#removeCSRLead').find('input:first').attr('name', 'wnu_csr_id_r');
})

function get_Info (anAction, field, aMatch){
	var reqObj = {action: anAction}
	var str='';
	reqObj[field] = aMatch;		
	$.ajaxSetup({async: false, timeout: 3000});
	$.post("/admin/crm", reqObj, function(data){ 
		
		var value = JSON.parse(data);		
		
		//console.log(value);
		if (field == 'ema_value_r') {
			//build merchant
			/*ltb_id: "1", ltb_phone_number: "5619940441", ltb_web_url: "localthanks.net/", ltb_email: "orlando@loyaltysuperstore.com", ltb_contact_name: "Tatyana Pavlovich"*/
			$('#lead-identity').text(' "'+value['ltb_email']+'" email');
			<?php if (isset($_SESSION['user']['admin']['adm_in_house']) && $_SESSION['user']['admin']['adm_in_house']) { ?>
				str+= '<a href="/admin/merchant-search?ltm_id='+value['ltm_id']+'&search=1" target="_blank">See Account</a>';
			<?php } ?>
			str+= '<p><strong>Email: </strong>'+value['ltb_email']+'</p>';
			str+= '<p><strong>Contact: </strong>'+value['ltb_contact_name']+'</p>';
			str+= '<p><strong>Phone: </strong>'+(value['ltb_phone_number']!=undefined && value['ltb_phone_number']?value['ltb_phone_number'].replace(/(\d\d\d)(\d\d\d)(\d\d\d\d)/, '($1) $2-$3'):'')+'</p>';						
			str+= '<p><strong>Website URL: </strong><a href="http://'+value['ltb_web_url']+'" target="_blank">'+value['ltb_web_url']+'</a></p>'; 
		}
		else{
			//build reseller
			/*{"res_id":"2","res_name":"ITEX","res_subdomain":"itex","res_logo":"logo.jpeg","res_timestamp":"2016-01-22 09:54:15","res_email":"","res_password":"","res_csr_phone":null,"res_active":"1"}*/			
			$('#lead-identity').text(' "'+value['res_subdomain']+'" subdomain');
			<?php if (isset($_SESSION['user']['admin']['adm_in_house']) && $_SESSION['user']['admin']['adm_in_house']) { ?>				
				str+= '<a href="/admin/reseller-edit?res_id='+value['res_id']+'" target="_blank">See Account</a>';
			<?php } ?>
			str+= '<p><strong>Email: </strong>'+value['res_email']+'</p>';
			str+= '<p><strong>Contact: </strong>'+value['res_name']+'</p>';
			str+= '<p><strong>Phone: </strong>'+(value['res_csr_phone']!=undefined && value['res_csr_phone']?value['res_csr_phone'].replace(/(\d\d\d)(\d\d\d)(\d\d\d\d)/, '($1) $2-$3'):'')+'</p>';						
			str+= '<p><strong>Subdomain: </strong>'+value['res_subdomain']+'</p>';
		}
		
	  })
	  return str;
}

var resellerList = {};

$(document).ready(function(){
 
 $('#res_name').on("keyup focus", function () {
	var currentObj = $(this);
	
	var myData = JSON.stringify( {resName:currentObj.val()} );
	
	 $.ajax({
		   url: "/admin/merchant-search",
		   global: false,
		   type: "POST",
		   dataType: "json",
		   error:function (err){ console.log(err); },
		   data: myData,
		   success: function (myArray)
			{	
				var htmlToAdd = '';
				
				if (myArray.length) {
					for (var i in myArray) {
						resellerList[myArray[i]['res_name']] = myArray[i]['res_id'];
						htmlToAdd += '<option class="resNameDrop" value="'+ myArray[i]['res_name'] +'"></option>';
					}	
				}
				$('#resellerNames').html(htmlToAdd);				
			}
		   });	
 });

 $('#res_name').on("input", function () {
	 if (typeof resellerList[$(this).val()] != 'undefined') {
		 $('#res_id').val(resellerList[$(this).val()]);
	 }
	 else
		$('#res_id').val(''); 
 }); 	
	
 table = $('#results_table').dataTable({
	 "ordering": false
 });
});
</script>

<?php
require 'footer.php';
}/*Begin Page Data*/
?>