<?php


require '../app/start_session.php';
require '../app/class.discount-code.php';

$disCodeObj = new App\DiscountCode\discountCode($dbo);

/*Begin AJAX*/
$requestBody = null;

if ( $_SERVER['REQUEST_METHOD'] == 'POST' && isset( $_SESSION['user']['admin']['adm_id'] ) ) {
	$requestBody = @json_decode( file_get_contents('php://input'), true );
}

if ( $requestBody !== null && json_last_error() == JSON_ERROR_NONE ) {
	if ( isset( $requestBody['dsc_id'] ) ) {
		if ( isset($requestBody['dsc_discount_months'] ) ){			
			$_response['Done'] = $disCodeObj->editCode($requestBody, $_response['Error']);
		}
		elseif ( isset($requestBody['Delete'] ) ){			
			$_response['Done'] = $disCodeObj->deleteCode($requestBody['dsc_id']);
		}
		else {
			$_response['Result'] = $disCodeObj->findCode( $requestBody['dsc_id'] );
		}	
	}	
	else	
		$_response['Done'] = $disCodeObj->createCode( $requestBody, $_response['Error'] );
	
	echo json_encode( $_response );	
}

/*End AJAX*/

else{

/*Begin Page Data*/
if ( !isset($_GET['res_id']) ) {
	header('Location: /admin/reseller');
}

$resellerCodeList = $disCodeObj->getCodeValues( $_GET['res_id'] );
$resCodeRows = $disCodeObj->getTableRowsOutput ($_GET['res_id']);
/*
echo '<pre>';
var_dump($resellerCodeList);
echo '</pre>';
*/

$pageCSS = '/admin/css/discount-code.css';
require 'header.php';
?>
<div class='container'>
	<div class='row'>
		<div class='col-sm-12'>
			<h1 class="discountCodes">Discount Codes (Merchant Signup)</h1>
		</div>	
	</div>
</div>

<div class="modal fade" id="globalModal" tabindex="-1" role="dialog" aria-labelledby="globalModalLabel">
  <div class="modal-dialog modal-md" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="globalModalLabel"></h4>
      </div>
      <div class="modal-body">
	    <div id="resultMessage"></div>
		<div id="contentBody"></div>
	  </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>		
      </div>
    </div>
  </div>
</div>

<div class="container">
	<div class="row">
		<div class="col-xs-12">
			<table id="results_table" class="table table-bordered table-striped datatable" style="margin-top:15px;">
				<thead>
					<tr>
						<th>Code #</th>
						<th>Code</th>
						<th>Expiration Date</th>
						<th>Percent Off</th>
						<th>Amount Off</th>
						<th>Setup Fee</th>
						<th>Use Count</th>
						<th>Month Count</th>						
						<th>Options</th>
						
					</tr>
				</thead>
				<tbody>
					<?php 
						echo $resCodeRows;
					?>
				</tbody>
			</table>		
			<button class="btn btn-primary" id="createCodeBtn" aria-label="..." type="button" data-toggle="modal" data-target="#globalModal">Create New Code</button><br/><br/>
		</div>
	</div>
</div>
<script>

_pageObj = {
	page: 'discount-codes',
	get: <?php echo json_encode($_GET, true); ?>, 
	flag: false
};

//console.log(_pageObj);

</script>
<script src="../plugins/check-form-inputs.js"></script>
<script src="js/discount-code.js?v.1.0.1"></script>
<?php
require 'footer.php';
}/*End Page Data*/
?>