<?php
require '../app/start_session.php';
$errors = array();

// get email list
$old_email_structure = glob('../mail/localthanks/*/*/*.html');   // Example: ../mail/localthanks/website/merchant_payment_welcome/merchant_payment_welcome.html
$new_email_structure = glob('../mail/localthanks/*/*/*/*.html'); // Example: ../mail/localthanks/misc/2016/0920-afe_followup/afe_followup.html

foreach ($old_email_structure as $k=>$v){
	$full_path = $v;
	$parts = explode('/', $v);
	$email_type = $parts[3];
	$email_name = implode(' ', explode('_', preg_replace('/\.html.*/', '', end($parts))));
	$emailList .= '<tr><td><input type="radio" id="em_o'.$k.'" name="email_select" value="'.$full_path.'" '.($_POST['email_select']===$full_path?'checked':'').'></td><td><label for="em_o'.$k.'">'.$email_name.'</label></td><td>'.$email_type.'</td></tr>';
}

foreach ($new_email_structure as $k=>$v){
	$full_path = $v;
	$parts = explode('/', $v);
	$email_type = $parts[3];
	$email_name = implode(' ', explode('_', preg_replace('/\.html.*/', '', end($parts))));
	$emailList .= '<tr><td><input type="radio" id="em_n'.$k.'" name="email_select" value="'.$full_path.'" '.($_POST['email_select']===$full_path?'checked':'').'></td><td><label for="em_n'.$k.'">'.$email_name.'</label></td><td>'.$email_type.'</td></tr>';
}

if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['email_select'])){
	$ema_body = file_get_contents($_POST['email_select']);
	$raw_email = $ema_body;
	($_POST['email_send']===''?'':$ema_email=$_POST['email_send']);
	($_POST['set_merchant']===''?'':$ema_ltm_id=$_POST['set_merchant']);

	include '../app/build-email.php';

	if (isset($_POST['email_send']) && $_POST['email_send']!=''){
		$to       = $ema_email;
		$subject  = 'Local Thanks Test Email';
		$message  = $ema_body;
		$headers  = "From: noreply@localthanks.com\r\n";
		$headers .= "Reply-To: noreply@localthanks.com\r\n";
		$headers .= "MIME-Version: 1.0\r\n";
		$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
		if (mail($to, $subject, $message, $headers))
		{
			$_GET['success'] = 1;
		}
		else
		{
			array_push($errors, 'Email send error.');
		}
	}
}

// $sql = "SELECT LTM.ltm_company_name, LTM.ltm_id FROM lt_merchants LTM INNER JOIN lt_member_merchants LTB ON LTM.ltb_id = LTB.ltb_id WHERE LTB.pty_id>2 ORDER BY LTM.ltm_company_name ASC";
// $stmt = $dbo->prepare( $sql );
// $stmt=execPDO($stmt);
// $res=$stmt->fetchAll(PDO::FETCH_ASSOC);
// $merchList = '<option value="1">Local Thanks</option>';
// foreach($res as $k=>$v){
// 	$merchList .= '<option value="'.$v['ltm_id'].'" '.($_POST['set_merchant']===$v['ltm_id']?'selected':'').'>'.$v['ltm_company_name'].'</option>';
// }

require 'header.php';
?>

<style>
	#ema_body {
		padding: 35px;
		background: lightgray;
		border-radius: 4px;
	}
	tbody#email-list {
		text-transform: capitalize;
	}
	#alert{
	  text-align: center;
	  position: fixed;
	  top: 25%;
	  z-index: 10;
	  width: 50%;
	  left: 25%;
	  right: 50%;
	  display: none;
	  -webkit-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
	  -moz-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
	  box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
	}
	div#merch_character_count {
		margin: 5px 0 10px;
		font-size: 11px;
	}
</style>
<div class='container'>
	<div class='row'>
		<div class="col-xs-12">
			<h1><span class='glyphicon glyphicon-eye-open'></span> Email Preview</h1>
			<div id="alert" class="alert alert-success" role="alert"></div>
			<?php 
				if (count($errors)) { 
					echo "<div class='alert alert-danger'><span class='glyphicon glyphicon-exclamation-sign'></span> <strong>Please check the error messages below:</strong><ul>"; 
					foreach($errors as $key => $value) { 
						$error_msg .= '<li>' . $value . '</li>'; 
					} 
					echo $error_msg . "</ul></div>"; 
				} 
			?>
			<?php if(isset($ema_body)) { ?>
				<div id="ema_body">
					<?php echo $ema_body; ?>
					<br><br>
					Mandrake HTML:
					<textarea><?php echo str_replace('{%%tld%%}', 'com', $raw_email); ?></textarea>
					End Product HTML:
					<textarea><?php echo $ema_body; ?></textarea>
				</div>
			<?php } ?>
			<ul>
				<li>Select an email template and click 'Preview Email'.</li>
				<li>Add a recipient email and they will receive a copy.</li>
				<li>Select a merchant to preview the email with that merchant's header.</li>
			</ul>
			<div class="row">
				<form method="POST">
					<div class="col-md-12">
						<label>Email Templates:</label>
						<!-- Nav tabs -->
						<ul class="nav nav-tabs" role="tablist">
							<li role="presentation" class="active"><a href="#lt_mail" aria-controls="lt_mail" role="tab" data-toggle="tab">Local Thanks</a></li>
							<li role="presentation"><a href="#res_mail" aria-controls="res_mail" role="tab" data-toggle="tab">Resellers</a></li>
						</ul>
						<br>
						<!-- Tab panes -->
						<div class="tab-content">
							<div role="tabpanel" class="tab-pane active" id="lt_mail">
								<div class="row">
									<div class="col-md-8">
										<table class="table table-striped table-bordered" id="email-list">
											<thead>
												<th></th>
												<th>Name</th>
												<th>Type</th>
											</thead>
											<tbody>
												<?php echo $emailList; ?>
											</tbody>
										</table>
									</div>
									<div class="col-md-4">
										<div class="form-group">
											<label for="email_send">Recipient Email:</label>
											<input type="text" id="email_send" name="email_send" class="form-control" placeholder="your@email.com" value="<?php echo $_POST['email_send'] ?>">
										</div>
										<div class="form-group">
											<label for="merchant_search">Search Merchants:</label>
											<input type="text" name="merchant_search" id="merchant_search" placeholder="Enter Merchant Name" value="<?php echo $_POST['merchant_search'] ?>" class="form-control">
											<div id='merch_character_count'></div>
										</div>
										<div class="form-group">
											<label>Selected Merchant:</label><br>
											<select class="form-control" id="set_merchant" name="set_merchant">
												<option value="1">Local Thanks</option>
											</select>
										</div>
										<button class="btn btn-primary form-control" id="preview_btn" style="vertical-align: baseline;" disabled>Select an Email First</button>
									</div>
								</div>
							</div>
							<div role="tabpanel" class="tab-pane" id="res_mail">2</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div><!-- end .row -->
</div><!-- end .container -->

<script>

function characterCountdown() {
	var remaining = 3 - $.trim($('#merchant_search').val()).length;
	if (remaining < 3 && !($.trim($('#merchant_search').val()).length >= 3)) {
		$('#merch_character_count').css('color', 'red');
		$('#merch_character_count').html('Enter '+remaining + ' more characters.');
	} else {
		$('#merch_character_count').css('color', 'inherit');
		$('#merch_character_count').html('');
	}
}

characterCountdown();

$(document).ready(function(){
	checkEmailSelect();
	if ($('#merchant_search').val().trim() !==''){
		merchantSearch($('#merchant_search').val().trim());
	}
});

var merchantSearch = function(merchant_query){
  $.ajax({
    url: "../api/api.lt.get-merchant.php",
    global: false,
    type: "POST",       
    dataType: "HTML",
    data:  "merchant_search="+merchant_query,
    error: function (){ alert('error');},
    success: function (response){
      //alert('success');
      // console.log(response);
      merchants = JSON.parse(response);
      formatMerchant(merchants);
    }
  });
}
// access get variables with javascript
var $_POST = <?php echo json_encode($_POST); ?>;

var formatMerchant = function(merchants){
	$('#set_merchant').html('');
	merchant_list = '';
	if (merchants != 0){
		$.each(merchants, function(k, v){
			merchant_list += '<option value="'+v.ltm_id+'" '+($_POST['set_merchant']==v.ltm_id?'selected':'')+'>'+v.ltm_company_name+'</option>';
			$('#set_merchant').html(merchant_list);
			// console.log(v.ltm_id);
		});
	} else {
		$('#set_merchant').html('<option value="1">No results.</option>');
	}
}

$('#merchant_search').on('change keyup', function(){
	if ($('#merchant_search').val().trim()!=='' && $('#merchant_search').val().trim().length>=3){
		merchantSearch($('#merchant_search').val());
	}
	characterCountdown();
});

$('[name="email_select"]').on('change', function(){
	checkEmailSelect();
});

$('#email-list').dataTable({
  "columns": [
      { "orderable": false},
      null,
      null
      ],
  "order": [[ 1, 'asc' ]]
});

// function for showing alert
function showAlert (alert_text) {
  $('#alert').html(alert_text);
  $('#alert').show();
      setTimeout(function() {
      $('#alert').fadeOut('slow');
  }, 1800); 
}

// access get variables with javascript
var $_GET = <?php echo json_encode($_GET); ?>;

// show success alert
if ($_GET['success'] === 1) {
  showAlert('<span class="glyphicon glyphicon-thumbs-up"></span> Success! Email Sent.');
}

// handle form btn
function checkEmailSelect(){
	if($('[name="email_select"]').is(':checked')) { 
		$('#preview_btn').attr('disabled', false).html('Preview Selected Email');
	} else {
		$('#preview_btn').attr('disabled', true).html('Select an Email First');
	}
}
</script>
<?php

require 'footer.php';

/* EOF ?> */