<?php
$tables = array ( 
"Resellers" => array ("tbl" =>"tbl_reseller","id"=>"res_id","pid"=>"","nam"=>"res_name","active"=>"res_active","subfolders"=>"Merchants,Plans","url"=>"/admin/reseller-edit?res_id="),
"Merchants" => array ("tbl"=>"lt_member_merchants","id"=>"ltb_id","pid"=>"res_id","nam"=>"ltb_slug","active"=>"ltb_active","subfolders"=>"Merchant locations,Promotions"),
"Plans" => array ("tbl"=>"tbl_package PACK",
    "join"=>"
	INNER JOIN tbl_product PROD ON PACK.pk_id=PROD.prod_id 
	INNER JOIN tbl_prod2reseller P2R ON PROD.prod_id=P2R.prod_id 
	INNER JOIN tbl_reseller RES ON P2R.res_id=RES.res_id",
    "id"=>"PACK.pk_id","pid"=>"RES.res_id","nam"=>"PROD.prod_name","active"=>"PROD.prod_active","url"=>"/admin/packages?search=1&pk_id="),
"Merchant locations" => array ("tbl"=>"lt_merchants","id" => "ltm_id", "pid"=>"ltb_id","nam"=>"ltm_nickname","active"=>"ltm_active","subfolders"=>"Customers","url"=>"/admin/merchant-search?search=1&ltm_id="),
"Customers" => array ("tbl" =>"tbl_consumer","id"=>"csm_id","pid"=>"ltm_id","nam"=>"CONCAT(csm_first_name,' ',csm_last_name)","active"=>"csm_active","url"=>"/admin/consumer-edit?csm_id="),
"Promotions" => array ("tbl"=>"lt_promos","id"=>"ltp_id","pid"=>"ltb_id","nam"=>"ltp_headline","active"=>"ltp_active"),
);

function q_table ($table, $row_id, $limit=0){
    global  $dbo;
    $sql = 'SELECT '.
    $table['id'].' AS row_id, '.
    $table['nam'].' AS row_name 
    FROM '.$table['tbl'].
    ($table['join']? ' '.$table['join']:'').
    ' WHERE 1=1 '.
    ($row_id? 'AND '.$table['pid'].'='.$row_id:'').
    ($table['active']? ' AND '.$table['active'].'=1':'').
    ' ORDER BY '.$table['nam'].' '.
    ($limit? ' LIMIT '.$limit:'');
    $qry = $dbo->prepare( $sql );
    $qry = execPDO($qry);
    $rows = $qry->fetchAll(PDO::FETCH_ASSOC);
    //if (!$limit) echo $sql.'<br>';
    return $rows;
}

function check_folders ($table,$row_id){
    global $tables;
    $folders = array();
    $folders_to_check=explode(",", $table['subfolders']); 
    foreach($folders_to_check as $folder){    
        $table=$tables[$folder];
        $rows=q_table($table,$row_id,1);
        if(count($rows)){$folders[]=$folder;}
    }
    if(count($folders)) 
        return implode(",", $folders);
    else
        return '';
}



if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    //stop if bad data
    if (!array_key_exists($_POST['group'], $tables)){exit();}
    if ( !((int)$_POST['row_id'] == $_POST['row_id'] && (int)$_POST['row_id'] >= 0) ){exit();}
    $table=$tables[$_POST['group']];

    
    //GET RECORDS FOR THIS FOLDER
    $rows=q_table($table,$_POST['row_id']);
    for($i=0; $i<count($rows); $i++){

        if($table['subfolders']){ 

            $subfolders=check_folders($table,$rows[$i]['row_id']);
            
            if($subfolders)
                echo '
                <li data-folders="'.$subfolders.'">
                <input type="checkbox" id="'.$_POST['div_id'].'-'.$i.'" data-rowid="'.$rows[$i]['row_id'].'"/>
                <label for="'.$_POST['div_id'].'-'.$i.'">'.($table['url']?'<a href="'.$table['url'].$rows[$i]['row_id'].'" target="_blank">':'').$rows[$i]['row_name'].($table['url']?'</a>':'').'</label>
                </li>';
            else
                echo'<li style="padding-left:40px; font-weight:bold;">'.($table['url']?'<a href="'.$table['url'].$rows[$i]['row_id'].'" target="_blank">':'').$rows[$i]['row_name'].($table['url']?'</a>':'').'</li>';
        }
        else 
            echo'<li>'.($table['url']?'<a href="'.$table['url'].$rows[$i]['row_id'].'" target="_blank">':'').$rows[$i]['row_name'].($table['url']?'</a>':'').'</li>';
    }


    exit();
}


include 'app/view/header.php';
?>

<style>
/* https://css-tricks.com/snippets/css/nested-expandable-folders/ */
.css-treeview {margin: 50px 5px}
.css-treeview ul,.css-treeview li{padding:0;margin:0;list-style:none;}
.css-treeview input{position:absolute;opacity:0;}
.css-treeview{font:normal 11px "Segoe UI", Arial, Sans-serif; -moz-user-select: none; -webkit-user-select: none; user-select: none;}
.css-treeview a{color: #00f;text-decoration: none;}
.css-treeview a:hover{text-decoration: underline;}
.css-treeview input + label + ul{margin: 0 0 0 22px;}
.css-treeview input ~ ul{display: none;}
.css-treeview label,.css-treeview label::before{cursor: pointer;}
.css-treeview input:disabled + label{cursor: default;opacity: .6;}
.css-treeview input:checked:not(:disabled) ~ ul{display: block;}
.css-treeview label,.css-treeview label::before{background: url("images/icons.png") no-repeat;}
.css-treeview label,.css-treeview a,.css-treeview label::before{display: inline-block;height: 16px;line-height: 16px;vertical-align: middle;}
.css-treeview label{background-position: 18px 0;}
.css-treeview label::before{content: "";width: 16px;margin: 0 22px 0 0;vertical-align: middle;background-position: 0 -32px;}
.css-treeview input:checked + label::before{background-position: 0 -16px;}
/* webkit adjacent element selector bugfix */
@media screen and (-webkit-min-device-pixel-ratio:0){.css-treeview
	{-webkit-animation: webkit-adjacent-element-selector-bugfix infinite 1s;}
    @-webkit-keyframes webkit-adjacent-element-selector-bugfix{from {padding: 0;} to { padding: 0;}
    }
}
</style>

<div class="css-treeview">
    <ul>
        <li data-group="Resellers" class="group">
            <input type="checkbox" id="item-0" data-rowid="0" checked="checked" />
            <label for="item-0">RESELLERS</label>
        </li>
    </ul>
</div>


<script>
$(".css-treeview").on("click", "input",function(){
    e=$(this);
    if(e.parent().children().length==2){

        $(this).prop( "checked", true ); 

        if (e.parent().attr('data-folders')) {

            var fldrs = e.parent().data( "folders" ).split(',');
            data='';
            for (i = 0; i < fldrs.length; i++)
                data+='<li data-group="'+fldrs[i]+'" class="group"><input type="checkbox" id="'+this.id+'-'+i+'" data-rowid="'+e.data("rowid")+'"/><label for="'+this.id+'-'+i+'">'+fldrs[i].toUpperCase()+'</label></li>';
            e.parent().append('<ul>'+data+'</ul>');

        }else{

            $.post( "", { 
                group: e.parent().data( "group" ), 
                row_id: e.data("rowid"), 
                div_id: this.id 
            })
            .done(function( data ) {
                e.parent().append('<ul>'+data+'</ul>');
            });
        }
    }
});
 
</script>



<?php
include 'app/view/footer.php';
?>
