<?php

//-----------------------------------

// admin/global-msg.php

//-----------------------------------

require '../app/start_session.php';

$dbo=connect();

// adding a new message
if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['htm_msg_content_r']) && isset($_POST['txl128_msg_subject_r'])){
  //CHECK IF FIELDS WERE POSTED - redirect away if any missing
  $fields=array('txl128_msg_subject_r', 'htm_msg_content_r');
  //check the values of passed variables
  include '../app/class.variables.php';
  $cv = new _variables(); // new instance
  foreach($fields as $name=>$value) $cv->varible_in($value); //each varible is added to class by array loop
  $_v=$cv->get_cleaned_variables();
  $errors=$cv->get_bad_variables();
  
  if (!count($errors)){
    $sql = 'INSERT INTO `tbl_messages` (msg_subject, msg_msg, msg_date, ltb_id) VALUES (:msg_subject, :msg_msg, '.(isset($_REQUEST['no-date'])?'null':'Now()').', null)';
    $qry = $dbo->prepare($sql);
    $qry->bindValue(':msg_subject', $_v['msg_subject'], PDO::PARAM_STR);
    $qry->bindValue(':msg_msg', $_v['msg_content'], PDO::PARAM_STR);
    $qry=execPDO($qry);
    unset($error);
    unset($_POST['htm_msg_content_r']);
    unset($_POST['txl128_msg_subject_r']);
    header('Location: global-msgs?success=1');
  } else {
    // the user has javascript turned off or bypassed the front-end validation in some way
    $error['msg_len'] = 'Your message is either empty or over the character limit. For best results, use a JavaScript enabled browser.';
  }
}

// delete a message
if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete_msg_id']) && is_numeric($_POST['delete_msg_id'])){
  $sql = "DELETE FROM tbl_messages WHERE msg_id=:msg_id; OPTIMIZE TABLE tbl_messages";
  $qry = $dbo->prepare($sql);
  $qry->bindValue(':msg_id', $_POST['delete_msg_id'], PDO::PARAM_INT);
  $qry=execPDO($qry);
  unset($_POST['delete_msg_id']);
  header('Location: global-msgs?deleted=1');
}

// --- QUERY MESSAGING HISTORY --- //
$sql = 'SELECT DISTINCT msg_id, msg_subject, msg_msg, msg_date FROM tbl_messages WHERE ltb_id IS NULL ORDER BY msg_date DESC LIMIT 100';
$qry = $dbo->prepare( $sql );
$qry=execPDO($qry);
$qry = $qry->fetchAll( PDO::FETCH_ASSOC );
if(empty($qry)){
  $noHistory = true;
} else {
  foreach ($qry as $value) {
    $pushHistory[] .= '<tr><td>'.$value['msg_id'].'</td><td><strong>'.$value['msg_subject'].'</strong><br>'.$value['msg_msg'].'</td><td>'.date('M-d-Y h:i A', strtotime($value['msg_date'])).'</td><td><button data-msg-id="'.$value['msg_id'].'" class="btn btn-danger delete_msg"><span class="glyphicon glyphicon-trash"></span></button></td></tr>';
  }
}

require 'header.php';
?>

<style>
div#msg_character_count, div#subj_character_count {
  margin: 5px 0 10px;
  font-size: 11px;
}
#alert{
  text-align: center;
  position: fixed;
  top: 25%;
  z-index: 10;
  width: 50%;
  left: 25%;
  right: 50%;
  display: none;
  -webkit-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
  -moz-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
  box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
}
#msg_form {
  margin-bottom: 25px;
}
#msg_subject {
  height: 34px;
}
</style>
<div id="adm_body">
<div id='main' class='container'>
  <h1><span class='glyphicon glyphicon-send'></span> Global Messaging</h1>
  <div class="alert alert-danger"><span class="glyphicon glyphicon-exclamation-sign"></span> Warning: any messages sent from this tool will be sent to <strong>ALL</strong> Local Thanks Consumers!</div>
  <div id="alert" class="alert alert-success" role="alert"></div>
  <?php 
    if (is_Array($error)) { 
      echo "<div id='push_errors' class='alert alert-danger'><span class='glyphicon glyphicon-exclamation-sign'></span> <strong>Please check the error messages below:</strong><ul>"; 
      foreach($error as $key => $value) { 
        $error_msg .= '<li>' . $value . '</li>'; 
      } 
      echo $error_msg . "</ul></div>"; 
    } 
  ?>
  <div class='row'>
    <div class='col-sm-4'>
      <form method='POST' id='msg_form'>
        <label for='msg_subject'>Message subject:</label>
        <textarea name='txl128_msg_subject_r' id='msg_subject' maxlength='128' placeholder='Maximum 128 Characters' class='form-control'><?php echo $_POST['txl128_msg_subject_r']; ?></textarea>
        <div id='subj_character_count'></div>
        <label for='msg_content'>Message body:</label>
        <textarea name='htm_msg_content_r' id='msg_content' maxlength='255' placeholder='Maximum 255 Characters' class='form-control'><?php echo $_POST['htm_msg_content_r']; ?></textarea>
        <div id='msg_character_count'></div>
        <label class="alert alert-warning"><input type='checkbox' name='no-date' id='no-date'> Non-time sensitive message.<br>Checking this box will show this message to all consumers no matter what their join date is. Example where this would make sense: A welcome message for new consumers.</label> 
        <input type='submit' value='Send Message' id='msg_submit' class='form-control btn btn-primary'>
      </form>
    </div>
    <div class='col-sm-8'>
      <label>Messaging History</label>
      <table id='msg_history' class='table table-bordered table-striped'>
        <thead>
          <tr>
            <th>ID</th>
            <th>Message</th>
            <th style="width:80px;">Date</th>
            <th>Delete?</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($noHistory == false) { foreach ($pushHistory as $pushes){ echo $pushes; } } ?>
        </tbody>
      </table>
      <form id="delete_msg" method="post">
        <input type="hidden" name="delete_msg_id" id="delete_msg_id" value="">
      </form>
    </div>
  </div><!--end .row-->
</div><!--end #main .container-->
</div>
<script>
  $(document).ready(function(){
    // access get variables with javascript
    var $_GET = <?php echo json_encode($_GET); ?>;

    // delete a message
    $('.delete_msg').on('click', function(){
      $('#delete_msg_id').val($(this).data('msg-id'));
      if (confirm('Permanently delete message?')){
        $('#delete_msg').submit();
      }
    });

    function characterCountdown() {
      // 128 character max length - subject
      var subj_remaining = 128 - $.trim($('#msg_subject').val()).length;
      $('#subj_character_count').html(subj_remaining + ' characters remaining.');
      if (subj_remaining < 31) {
        $('#subj_character_count').css('color', 'red');
      } else {
        $('#subj_character_count').css('color', 'inherit');
      }

      // 255 character max length - message
      var msg_remaining = 255 - $.trim($('#msg_content').val()).length;
      $('#msg_character_count').html(msg_remaining + ' characters remaining.');
      if (msg_remaining < 61) {
        $('#msg_character_count').css('color', 'red');
      } else {
        $('#msg_character_count').css('color', 'inherit');
      }
    }

    // initialize character countdown
    characterCountdown();

    // countdown on change & keyup
    $('#msg_content, #msg_subject').on('change keyup', function(){
      characterCountdown();
    });

    // front end form validation && duplicate entry prevention
    $('#msg_submit').click(function(e){
      $('#msg_submit').attr("disabled", true).val('Sending Message...');
      var msgContent = $.trim($('#msg_content').val());
      var msgSubject = $.trim($('#msg_subject').val());
      if (msgContent != '' && msgContent.length <= 255 && msgSubject !='' && msgSubject.length <= 128){
        if($('#no-date').prop('checked')){
          if(confirm('Are you sure you want to set a non-time sensitive message?')){
            $('#msg_form').submit();
          } else {
            e.preventDefault();
            alert('Uncheck the box!');
            $('#msg_submit').attr("disabled", false).val('Send Message');
          }
        } else {
          $('#msg_form').submit();
        }
      } else {
        e.preventDefault();
        if (msgSubject =='' || msgSubject.length > 128){
          alert('Error: Message subject cannot be empty & must be under 128 characters long.');
          $('#msg_submit').attr("disabled", false).val('Send Message');
        } else if (msgContent == '' || msgContent.length > 255) {
          alert('Error: Message contents cannot be empty & must be under 255 characters long.');
          $('#msg_submit').attr("disabled", false).val('Send Message');
        }
      }
    });

    // function for showing alert
    function showAlert (alert_text) {
      $('#alert').html(alert_text);
      $('#alert').show();
          setTimeout(function() {
          $('#alert').fadeOut('slow');
      }, 1800); 
    }
    
    // show success alert
    if ($_GET['success'] == 1) {
      showAlert('<span class="glyphicon glyphicon-thumbs-up"></span> Success! Message sent.');
    } else if ($_GET['deleted'] == 1){
      showAlert('<span class="glyphicon glyphicon-thumbs-up"></span> Success! Message deleted.');
    }

    $('#msg_history').dataTable({
      "columns": [
          null,
          { "orderable": false, "width":"550px"},
          null
          ],
      "order": [[ 0, 'desc' ]]
    });

  });
</script>

<?php

require 'footer.php';



/* EOF ?> */