<?php
require '../app/start_session.php';
$_Message_type='danger';
$_Message='';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])){// ajax call to get categories

	$response['status']='EMPTY';
	$response['message']='Unknown error: We could not complete your request';
	$response['type']='danger';
	
	if ($_POST['action'] == 'get'){
		$sql="	SELECT `cat_id`,`cat_parent_id`,`cat_name`,`cat_icon`,`cat_slug`,`cat_active`,
				(
				    SELECT 
				    GROUP_CONCAT(key_word) 
				    FROM tbl_keywords KW
				    INNER JOIN tbl_c2keyword C2K ON KW.key_id=C2K.key_id
				    WHERE C2K.cat_id=CAT.cat_id
				    AND key_type='active'
				    ORDER BY key_word ASC
				) AS keywords
				FROM tbl_category CAT 
				WHERE `cat_local`=1 
				ORDER BY `keywords` DESC";

		if ($stmt = $dbo->prepare($sql)){
			$stmt->execute();
			$response=$stmt->fetchAll(PDO::FETCH_ASSOC);
			$response['status']='OK';
		}
	}
	echo json_encode($response);


}else{//display as usual

	$_Default_Selected='0';
	$_Message_type='danger';$_Message='';
	include '../app/class.variables.php';
	$_checkObj = new _variables();
	if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_GET['wnu11_cat_id_r'])){
		
		$cv_array=array('wnu11_cat_id_r');
		foreach($cv_array as $name=>$value) $_checkObj->varible_in($value); //each varible is added to class by array loop

		$clean=$_checkObj->get_cleaned_variables();
		$errors=$_checkObj->get_bad_variables();

		if (!count($errors)){ 
          $_Default_Selected=$clean['cat_id'];
		}
		
	}
	
	if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['edit_create'])){
		function bind_Query_Values($stmt, $_Values_Array, $_action){ 
			foreach($_Values_Array as $Key=>$Value){
				if ($Key!='keywords' && ($Key!='cat_id' || strpos($_action, 'UPDATE') !== false)){
					if ($Value == '0' || $Value == '1'){
						$stmt->bindValue($Key, (bool) $Value, PDO::PARAM_INT);
					}else{
						$stmt->bindValue($Key, $Value, PDO::PARAM_STR);		 
					}
				} 
			}
		}//end function
		
		function update_keywords($cat_id,$kw_list){	   
		global $dbo;        
		//clean data
		$_kw_list      = strtolower($kw_list); //make all incoming keywords lower case	
		$kw_array      = array_unique(
		                             array_map('trim', 
									                  explode(",", $_kw_list)
								     )
					     ); //creates unique keyword array from keyword list
		$_kw_list  = implode ("','",$kw_array); // updates keyword list from values of array
		//throw new Exception("Value must be 1 or below");
		$Insrt_kw_list  = implode ("'),('",$kw_array); // updates keyword list from values of array
        
		//remove items not in keyword array
		$stmt = $dbo->prepare("
		DELETE C2K.* 
		FROM tbl_c2keyword C2K		
		INNER JOIN tbl_keywords KW ON C2K.key_id=KW.key_id 
		WHERE KW.key_word NOT IN ('".$_kw_list."') AND C2K.cat_id=:catid");
		$stmt->bindValue(":catid", $cat_id, PDO::PARAM_INT);
		$stmt->execute();
        
		//inserting new items into tbl_keywords
		$stmt = $dbo->prepare("
		INSERT IGNORE INTO tbl_keywords (key_word) VALUES ('".$Insrt_kw_list."')");		
		$stmt->execute();
		
		//activating new keywords
		$stmt = $dbo->prepare("
		UPDATE tbl_keywords SET key_type='active' WHERE key_word IN ('".$_kw_list."')");
		$stmt->execute();
		
		//inserting new items into tbl_keywords
		$stmt = $dbo->prepare("
		 INSERT INTO tbl_c2keyword (key_id, cat_id)
		 SELECT * FROM (
		                SELECT key_id, :catid 
						FROM tbl_keywords 
						WHERE key_word IN ('".$_kw_list."')
						) AS tmp
		 WHERE NOT EXISTS (
		  SELECT * 
		  FROM tbl_c2keyword 
		  WHERE cat_id=:catid 
		   AND tmp.key_id IN (
		    SELECT C2KEY.key_id 
			FROM tbl_c2keyword C2KEY 
			INNER JOIN tbl_keywords TBLKEY ON C2KEY.key_id=TBLKEY.key_id
			WHERE C2KEY.cat_id=:catid 
			AND TBLKEY.key_word IN ('".$_kw_list."')
		   )
		 )"
		);
        $stmt->bindValue(":catid", $cat_id, PDO::PARAM_INT);		
		$stmt->execute();
		
	}
	
		function get_Query_Body($_Values_Array, $_action){ 
			$_SQL=$_comma=$_val=$_keys='';
			foreach($_Values_Array as $Key=>$Value){
				if ($Key!='cat_id' && $Key!='keywords'){
					if ($_action == 'UPDATE'){
						$_SQL.="{$_comma}{$Key}=:{$Key}";
					}else{
						$_val.="{$_comma}:{$Key}";
						$_keys.="{$_comma}{$Key}";
						$_SQL="({$_keys}) VALUES ({$_val})";
					}  		  
					$_comma=',';
				} 		 
			}
			return $_SQL;	
		}//end function

		function process_Image(&$msg, $cat_id){
			$msg=''; $_image_Size=120;
			if (isset($_FILES['file_uploaded']) && is_uploaded_file($_FILES['file_uploaded']['tmp_name'])) {
				//include 'inc/function.image-upload.php'; 				
				$validImageFileFlag = @exif_imagetype($_FILES['file_uploaded']['tmp_name']);
				if ($validImageFileFlag === false) {
					$msg = ' <span style="color:red;">Incorrect image file.</span>';//<script>alert("Please upload image smaller than 500KB")</script>
				}
				else {
					list( $orig_w, $orig_h ) = getimagesize( $_FILES['file_uploaded']['tmp_name'] );
					$valid = array(/*'jpeg', 'jpg', */'png'/*, 'gif'*/); // allowed extensions
					$sizes = array( $_image_Size => $_image_Size );
					if ($orig_w < $_image_Size || $orig_h < $_image_Size ){
						$msg = ' <span style="color:red;">Image must be at least 32px wide and 32px hight.</span>';  
					}else{
						if( $_FILES['file_uploaded']['size'] < 1024 * 100 ) { // max upload is 100kb
							$ext = strtolower( pathinfo( $_FILES['file_uploaded']['name'], PATHINFO_EXTENSION ) ); //get file extension
							if( in_array( $ext, $valid ) ){
								//process image 
								if (!isset($cat_id)){ return false; }				 				 
								$watermark = new Imagick($_FILES['file_uploaded']['tmp_name']);
								$watermark->scaleImage( $_image_Size , $_image_Size );
								$watermark->writeImage('../images/categories/cat_icon_'.$cat_id.'.png');
								return true;
							}else{
								$msg = ' <span style="color:red;">Unsupported or empty file.</span>';					
							}
						}else{
							$msg = ' <span style="color:red;">Image must be smaller than 100KB.</span>';
						}
					} 	
				}	
				return false;	
			}
			return false;
		}//end function

		$cv_array=array('wnu11_cat_id', 'wnu11_cat_parent_id_r', 'txl64_cat_name_r', 'txl64_cat_slug', 'bit_cat_active', 'lst255_keywords');
		foreach($cv_array as $name=>$value) $_checkObj->varible_in($value); //each varible is added to class by array loop

		$clean=$_checkObj->get_cleaned_variables();
		$errors=$_checkObj->get_bad_variables();

		if (!count($errors)){	 

			//EDIT
			if ($_POST['edit_create'] == 'edit'){
				$set_image=process_Image($_Message, $clean['cat_id'], 'UPDATE');
				$sql='UPDATE tbl_category SET '.get_Query_Body($clean,'UPDATE').($set_image?', cat_icon=:cat_icon':'').'  WHERE cat_id=:cat_id';
				if ($stmt = $dbo->prepare($sql)){
					bind_Query_Values($stmt, $clean, 'UPDATE');
					if ($set_image)
						$stmt->bindValue(':cat_icon', 'cat_icon_'.$clean['cat_id'].'.png', PDO::PARAM_STR); 
					$stmt->execute();
				}
				update_keywords($clean['cat_id'],$clean['keywords']);
				$_Default_Selected=$clean['cat_id'];

			}
			//CREATE NEW
			elseif ($_POST['edit_create'] == 'create'){        
			
				if ($stmt = $dbo->prepare('INSERT IGNORE INTO tbl_category '.get_Query_Body($clean, 'INSERT'))){
					bind_Query_Values($stmt, $clean, 'INSERT');
					$stmt->execute();
					$_Default_Selected=$dbo->lastInsertId();
					
					if ($_Default_Selected && process_Image($_Message, $_Default_Selected)){
						if ($stmt = $dbo->prepare('UPDATE tbl_category SET cat_icon=:cat_icon WHERE cat_id=:cat_id')){
							$stmt->bindValue(':cat_id', $_Default_Selected, PDO::PARAM_INT);
							$stmt->bindValue(':cat_icon', 'cat_icon_'.$_Default_Selected.'.png', PDO::PARAM_STR); 
							$stmt->execute();
							
							update_keywords($_Default_Selected,$clean['keywords']);
						}
					}
					else {$_Message='The category slug already exists!';}
				}	   
			}

		} else { $_Message=reset($errors); }

	}
	
	require 'header.php';

?>


<div class="container" id="adm_body" style="padding-top:20px;">
	<center><h1>Manage Local Categories</h1></center>

	<?php 
	if (!empty($_Message))
	echo "
	<div class='notifydiv'>
		<div class='alert alert-{$_Message_type} alert-error' role='alert'><a href='#' class='close' data-dismiss='alert'>&times;</a><span class='glyphicon glyphicon-exclamation-sign' aria-hidden='true'></span><span class='sr-only'>".($_Message_type=='danger'?"Error":"Info").":</span> {$_Message}</div>  
	</div>";

	if ($stmt = $dbo->prepare("SELECT `cat_id`,`cat_name`,`cat_parent_id` FROM tbl_category CAT WHERE `cat_local`=1 ORDER BY `cat_name`")){	
		
		$stmt->execute();
		$str_Display=''; $str_Rad="";

		if ($Result = $stmt->fetchAll(PDO::FETCH_ASSOC)){

			$str_Display.="
			<div class='row'>
				<div class='col-sm-3' style='height:550px; overflow: auto;'>";

			foreach($Result as $Key=>$Value){
				if (!$Value['cat_parent_id']){

					$str_Rad.="
					<div class='cat-local'>
						<input type='radio' value='{$Value['cat_id']}' class='parent-rad' name='parent' id='rad_{$Value['cat_id']}'> {$Value['cat_name']}<hr style='margin-top:2px;margin-bottom:2px;'>
					</div>";	

					$str_Display.="
					<span class='parent' style='font-weight:bold;text-transform: uppercase' id='cat_{$Value['cat_id']}'>{$Value['cat_name']} 
						<span class='glyphicon glyphicon-edit'></span>
					</span>
					<div class='child_box' style='display:none;'>";
					
					foreach($Result as $Keychild=>$Valuechild){
						if ($Valuechild['cat_parent_id']==$Value['cat_id']){
							$str_Display.="
							<span class='child' id='cat_{$Valuechild['cat_id']}'>
								{$Valuechild['cat_name']} 
								<span class='glyphicon glyphicon-edit'></span>
							</span>";
						}
					}
					$str_Display.="
					</div>";
				
				}	
			}

			$str_Display.="
			</div>


			

			<!-- start 2nd col -->
			<div class='col-sm-9' style='padding:20px;background-color:#333; color:#fff; border-radius:5px;'>

				<div class='row'>

					<form id='edit_create' enctype='multipart/form-data' method='post'>
	
						<div class='col-sm-8'>	
							<input type='hidden' value='' id='cat_id' name='wnu11_cat_id'>
							<input type='hidden' value='edit' id='form_action' name='edit_create'>	 
							<input type='hidden' value='' id='cat_parent_id' name='wnu11_cat_parent_id_r'>	 

							<div class='btn-group btn-md'>
								<button type='button' id='edit_btn' class='btn btn-primary'><span class='glyphicon glyphicon-edit'></span> Edit Category </button>
								<button type='button' id='create_btn' class='btn btn-default'><span class='glyphicon glyphicon-floppy-save'></span> Create Category </button>
							</div>

							<div class='form-group' style='padding-top:20px;'>
								<label for='cat_name'>Name</label>
								<input type='text' maxlength='64' class='form-control' name='txl64_cat_name_r' id='cat_name' placeholder='Enter Category Name'>
							</div>

							<div class='form-group'>
								<label for='cat_slug'>Slug (Matching Google Types)</label>
								<input type='text' maxlength='64' class='form-control' name='txl64_cat_slug' id='cat_slug' placeholder='Enter Google Type'>
							</div>

							<div class='form-group'>
								<label for='keywords'>Keywords</label>
								<input type='text' maxlength='255' class='form-control' name='lst255_keywords' id='keywords' placeholder='Enter Keywords'>
							</div>


							<div class='form-group'>
								<input type='hidden' id='cat_active' value='0' name='bit_cat_active'>
								<input type='checkbox'> Active
							</div>

							<img src='images/clear_pix.gif' id='uploaded_image' alt='Uploaded Image'/>

							<div class='form-group'>
								<label for='phone'>Icon</label>        
								<input class='form-control' id='cat_icon' name='file_uploaded' type='file' placeholder='Enter Category Icon' >		
							</div>

							<button class='btn btn-primary form-control' disabled type='submit' id='edit_update_submit'>Submit</button>
						</div>	  

						<div class='col-sm-4'>

							<div class='input-group'>
								<span class='input-group-btn'><button id='searching-addon' class='btn btn-default' type='button'>Go!</button></span>
								<input type='text' class='form-control' placeholder='Search for...'>		  
							</div>

							<div id='parent_selection'>
								<center><h3 style='color:#fff;font-weight:bold;'><span class='glyphicon glyphicon-ok'></span> Parent Selection</h3></center>
								{$str_Rad}
							</div>
						</div> 
					</form>

				</div> 
			</div>";

		}
		echo $str_Display;
	}

?>
</div>


<style>
.child, .parent{color:darkblue;padding-left:20px;margin-top:5px;cursor:pointer;display: block;}
.parent{color:blue;padding-left:0;}
.parent-rad, .cat-check{transform: scale(1.2); margin: 20px; display:inline-block;}
.errors {color: red;font-size: 80%;top:60px;right: 10px;position: absolute;z-index:101;}
</style>



<script>
//******* NEW ********

$('#edit_create').submit(function (){
	if ($('#ready').val()==''){
		preventDefault();
	}
})

$('#searching-addon').click(function (e){
	e.preventDefault();
	CategoryObj.Search_By_Str($(this).parents('span:first').next().val());
});

function select_Cat(Cat_Id){
	$('.parent').css({'color':'blue'});
	$('.child').css({'color':'darkblue'});
	$('#cat_'+Cat_Id).css({'color':'red'});
	$('#cat_id').val(Cat_Id);
	$('#form_action').val('edit'); 
	$('#edit_create').find('button:last').attr('disabled', 'disabled');  
	CategoryObj.Elements[CategoryObj.Index].cat_name? $('#cat_name').val(CategoryObj.Elements[CategoryObj.Index].cat_name): $('#cat_name').val(''); 
	CategoryObj.Elements[CategoryObj.Index].cat_slug? $('#cat_slug').val(CategoryObj.Elements[CategoryObj.Index].cat_slug): $('#cat_slug').val(''); 
	CategoryObj.Elements[CategoryObj.Index].keywords? $('#keywords').val(CategoryObj.Elements[CategoryObj.Index].keywords): $('#keywords').val(''); 
	d = new Date();

	CategoryObj.Elements[CategoryObj.Index].cat_icon && CategoryObj.Elements[CategoryObj.Index].cat_icon != ''? $('#uploaded_image').attr('src', '../images/categories/'+CategoryObj.Elements[CategoryObj.Index].cat_icon+'?'+d.getTime()): $('#uploaded_image').attr('src','images/clear_pix.gif'); 

	if (CategoryObj.Elements[CategoryObj.Index].cat_active && CategoryObj.Elements[CategoryObj.Index].cat_active!='0'){
		$('#cat_active').next().prop('checked', true);
		$('#cat_active').val(CategoryObj.Elements[CategoryObj.Index].cat_active);
	}else{
		$('#cat_active').next().prop('checked', false);
		$('#cat_active').val('0');
	}

	if (CategoryObj.is_Parent(Cat_Id)){
		$('.parent').next('.child_box').slideUp();
		$('#cat_'+Cat_Id).next('.child_box').toggle();
		//$('#parent_selection').hide(); 
	}else{  
		$('.parent-rad').prop('checked', false).attr('disabled', false);
		//$('#parent_selection').show();
		$('#cat_'+Cat_Id).parents('.child_box:first').show();
	}
	fix_side_Col();
}

function fix_side_Col(){
	if ($('#edit_btn').hasClass('btn-primary')){
		if (CategoryObj.Elements[CategoryObj.Index].cat_parent_id!='0'){
			$('#rad_'+CategoryObj.Elements[CategoryObj.Index].cat_parent_id).prop('checked', true);
			$('#cat_parent_id').val(CategoryObj.Elements[CategoryObj.Index].cat_parent_id);   
		}else{
			$('.parent-rad').prop('checked', false).attr('disabled', 'disabled');
			$('#cat_parent_id').val('0');
		} 
	}
}

var CategoryObj={
	Elements : [],
	Index : 0,
	Selected : <?php echo $_Default_Selected;?>,
	is_Parent:
		function (Cat_Id){
			for (var i in this.Elements){
				if ( this.Elements[i].cat_id == Cat_Id){return this.Elements[i].cat_parent_id == '0'}
			}
			return false;
		},

	Select_Element:
		function (Element){
			switch (Element){
				case 'First':
					for (var i in this.Elements){
						this.Selected = this.Elements[i].cat_id;
						this.Index = i;
						select_Cat(this.Selected);
						return true;	  
					}
					break;
				default:
					for (var i in this.Elements){
						if (Element == this.Elements[i].cat_id){
							this.Selected = Element;
							this.Index = i;
							select_Cat(this.Selected);
							return true;
						}
					}
			}
			return false;	
		},
	
	Search_By_Str:
		function (str){
			var current=this.Selected; var Flag=false;
			for (var i in this.Elements){	 
				if (Flag && 
					(this.Elements[i].cat_slug && (this.Elements[i].cat_slug.indexOf(str) > -1 || this.Elements[i].cat_slug.toLowerCase().indexOf(str) > -1) || (this.Elements[i].cat_name && (this.Elements[i].cat_name.indexOf(str) > -1 || this.Elements[i].cat_name.toLowerCase().indexOf(str) > -1)))){ 
					this.Selected = this.Elements[i].cat_id;
					this.Index = i;
					select_Cat(this.Selected);
					return true;	  
				}

				if (current == this.Elements[i].cat_id){ Flag=true; }
			}	   
		},

	//ajax call		
	Search : 
		function (Id){
			var request_JSON={action: 'get'}
			if (typeof Id != 'undefined'){request_JSON.cat_id=Id;} 
			$.post( location.href, request_JSON, function(data, status){
			console.log(data);
			if (status == 'success'){
				for (var i in data){	
					if (!isNaN(i)){
						$.each(data[i], function(k, v){
							if (typeof CategoryObj.Elements[i] == 'undefined'){CategoryObj.Elements[i] = {};}	
							CategoryObj.Elements[i][k]=data[i][k];		  
						});
					} 
				}	   
			}	 
			console.log(CategoryObj.Elements);	
			if (CategoryObj.Selected == 0){CategoryObj.Select_Element('First');}else{CategoryObj.Select_Element(CategoryObj.Selected);}	 
		}, 

	'json');
	
	}
}


//******* END NEW ******** 


$('input').keyup(function (){
	check_input($(this), false);  
	check_form($(this).parents('form:first'));
})

$('input').blur(function (){
	check_input($(this), true);  
})

$('.parent, .child').click(function (){
	CategoryObj.Select_Element($(this).attr('id').split('_')[1]);
})

$('.parent-rad').change(function (){
	$('#cat_parent_id').val($(this).attr('id').split('_')[1]);
	//$('#edit_create').find('button:last').attr('disabled', false);
	check_form($('#edit_create'));
})

$('input[type=checkbox]').change(function (){
	if ($(this).hasClass('cat-check')){
		if ($('#edit_btn').hasClass('btn-primary')){
			fix_side_Col();
		}   
	}  
	//$('#cat_parent_id').val(CategoryObj.Elements[CategoryObj.Index].cat_parent_id); 

	this.checked?$(this).prev().val('1'):$(this).prev().val('0');
	check_form($('#edit_create'));
})


$('input[type=file]').change(function (){  
	//$(this).val()!=''? $('#cat_icon').val('cat_icon_'+CategoryObj.Elements[CategoryObj.Index].cat_id+'.png'):'';  
	if ($(this).val()!='')	check_form($('#edit_create'));
})


function check_input(inp, show_mess){

	var show_error_flag=false;

}


function check_form(formObj){
	$('#ready').val('1');
	$('#edit_update_submit').attr("disabled", false);  
	$(formObj).find('input').each(function (){
		check_input($(this), true);   
	})
}

$(document).ready(function (){
	CategoryObj.Search();
})

$('#edit_btn').click(function (){
	CategoryObj.Select_Element(CategoryObj.Selected);
	$(this).removeClass('btn-default').addClass('btn-primary');
	$(this).next().addClass('btn-default').removeClass('btn-primary');
})

$('#create_btn').click(function (){
	$('.parent').next('.child_box').slideUp();  
	$('.parent-rad').prop('checked', false).attr('disabled', false);
	$('#cat_parent_id').val('0');
	$('.parent').css({'color':'blue'});
	$('.child').css({'color':'darkblue'}); 
	$('#cat_id').val('');

	$('#cat_local').next().prop('checked', false);
	$('#cat_local').val('0');
	$('#form_action').val('create'); 
	$('#cat_name').val(''); 

	$('#cat_slug').val('');
	$('#cat_icon').val(''); 
	$('#keywords').val(''); 
	$('#uploaded_image').attr('src','images/clear_pix.gif');

	$('input[type=checkbox]').prop('checked', false).prev().val('0');

	$(this).prev().addClass('btn-default').removeClass('btn-primary');
	$(this).removeClass('btn-default').addClass('btn-primary');

	$('.cat-local').show();
	$('.cat-national').show();
})

</script>

<?php require 'footer.php'; } ?>
