<?php

//-----------------------------------

// admin/admins.php

//-----------------------------------

require '../app/start_session.php';

$dbo=connect(); 

$_Message_type='danger';

$_Message='';

function correct_Categories($key_id, $cat_id_selection){
 
 $dbo=connect();
 
 $_id_Array=explode(',',$cat_id_selection);
 
  $select_STR='';$select_STR='';
  foreach ($_id_Array as $Key => $Value){
   $select_STR.=($select_STR!=''?" UNION ALL ":"")."SELECT :key_id AS keyid, :cat_id_{$Key} AS catid";
   //$Query_STR.=($Query_STR==''?" WHERE dic_word LIKE tmp.word";
  }
  if ($stmt = $dbo->prepare("
   INSERT INTO tbl_c2keyword (key_id, cat_id)
   SELECT * FROM (
    {$select_STR}
   ) tmp 
   WHERE NOT EXISTS (
    SELECT key_id, cat_id FROM tbl_c2keyword WHERE key_id = tmp.keyid AND cat_id = tmp.catid
   )
  ")){
   $stmt->bindValue(":key_id", $key_id, PDO::PARAM_INT);       
   foreach ($_id_Array as $Key => $Value){  
    $stmt->bindValue(":cat_id_{$Key}", $Value, PDO::PARAM_INT);       
   } 
     
   $stmt->execute(); 
  }
 
}

function exists_Keywords($_Phrase){
 
 $dbo=connect();

  if ($stmt = $dbo->prepare("SELECT key_id FROM tbl_keywords WHERE key_word =:key_word")){
   
   $stmt->bindValue(":key_word", $_Phrase, PDO::PARAM_STR);       
        
   $stmt->execute(); 
   
   if ($Result = $stmt->fetch(PDO::FETCH_ASSOC))
    return true;
   
  }
 
 return false;
 
}

function remove_Categories($key_id, $cat_id_selection){
 
 $dbo=connect();

  if ($stmt = $dbo->prepare("
   DELETE FROM tbl_c2keyword WHERE key_id =:key_id AND cat_id NOT IN ({$cat_id_selection})  
  ")){
   
   $stmt->bindValue(":key_id", $key_id, PDO::PARAM_INT);       
        
   $stmt->execute(); 
  }
 
}

function clean_Array($_Phrase){
  $_words=explode(' ', $_Phrase);
  $_words_Array=array_intersect_key(
  
                     array_filter($_words),
					 
                     array_unique(array_map("StrToLower",array_filter($_words)))
					 
                );
  return $_words_Array;			
}

function add_to_Dictionary($_Phrase){
  $dbo=connect();
  $_words_Array=clean_Array($_Phrase);
 
  $select_STR='';
  foreach ($_words_Array as $Key => $Value){
   $select_STR.=($select_STR!=''?" UNION ALL ":"")."SELECT :dic_word_{$Key} AS word";
   //$Query_STR.=($Query_STR==''?" WHERE dic_word LIKE tmp.word";
  }
  
  if ($stmt = $dbo->prepare("
   INSERT INTO tbl_dictionary (dic_word)
   SELECT * FROM (
    {$select_STR}
   ) tmp 
   WHERE NOT EXISTS (
    SELECT dic_word FROM tbl_dictionary WHERE dic_word LIKE tmp.word
   )
  ")){
   foreach ($_words_Array as $Key => $Value){  
    $stmt->bindValue(":dic_word_{$Key}", $Value, PDO::PARAM_STR);       
   } 
     
   $stmt->execute(); 
  } 
}

function check_Dictionary($_Phrase, &$Arr_Message){
  $dbo=connect();
  $Arr_Message['status']='ERROR';
  $Arr_Message['message']='Unknown error: We could not complete your request';
  $_words_Array=clean_Array($_Phrase);
  $Query_STR='';
  foreach ($_words_Array as $Key => $Value){
   $Query_STR.=($Query_STR==''?" WHERE ":" OR ")."dic_word LIKE :dic_word_{$Key}";
  }
  if ($stmt = $dbo->prepare("SELECT COUNT(DISTINCT(dic_id)) AS word_Amount FROM tbl_dictionary{$Query_STR}")){
   foreach ($_words_Array as $Key => $Value){
    $stmt->bindValue(":dic_word_{$Key}", $Value, PDO::PARAM_STR);    
   }
   $stmt->execute();
   if ($Result=$stmt->fetch(PDO::FETCH_ASSOC)){    
    if ($Result['word_Amount'] == count($_words_Array)){
	 $Arr_Message['message']='Every words are in the dictionary';
	 $Arr_Message['status']='OK';
     return true;	 
	}
    else{
	 $Arr_Message['message']='The Keyword or Phrase you are trying to enter has word(s) that is(are) not in our Dictionary';
     $Arr_Message['status']='NOT_FOUND';
    }
   }
   else{
    $Arr_Message['status']='WRONG';
   }
  }
  return false;
}

if ( $_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && ($_POST['action']=='check_dictionary' || $_POST['action']=='get_categories') ){// ajax call to get categories
 
 if ($_POST['key_word'] && preg_match('/[\w\p{L}\p{N}\p{Pd}]/u' ,$_POST['key_word'])){
 
  check_Dictionary($_POST['key_word'], $Arr_Message);
 
  $response=$Arr_Message;
   
  
 }
 elseif (preg_match('/^[0-9]{1,11}/' , $_POST['key_id'])){
  
  if ($stmt = $dbo->prepare("SELECT DISTINCT cat_id FROM tbl_c2keyword WHERE key_id=:key_id")){
   
   $stmt->bindValue(":key_id", $_POST['key_id'], PDO::PARAM_INT);
   
   $stmt->execute(); 

   while ($Result = $stmt->fetch(PDO::FETCH_ASSOC)){
    $response['cat_id'][]=$Result['cat_id'];
   }
   
   $response['status']='OK';   
            
  }
  
 }

 echo json_encode($response);

}

else{//display as usual
$Result=null;
$_Cat_Id=0;
$_Key_Active='NULL';
$_Key_sign=' IS ';
$_Message_type='danger';$_Message='';
if ($_SERVER['REQUEST_METHOD'] == 'POST'){
  if (isset($_POST['key_active'])){ 
   if ($_POST['key_active']=='1' || $_POST['key_active']=='0'){
    $_Key_sign='=';
    $_Key_Active=$_POST['key_active'];
   }  
  } 
  
  if (isset($_POST['cat_id'])) {$_POST['cat_id']!=0?$_Cat_Id=$_POST['cat_id']:$_Cat_Id=0; }
  
  include '../app/class.variables.php';
  
  $cv_array=array();
  
  if (isset($_POST['action'])){
   
   if ($_POST['action']=='disapprove' || $_POST['action']=='set_active')
   
    $cv_array=array('wnu11_key_id');

   if ($_POST['action']=='edit')	
   
    $cv_array=array('wnu11_key_id', 'txt_key_word_r');
	
   if ($_POST['action']=='create')	
   
    $cv_array=array('txt_key_word_r');	
		
    $_checkObj = new _variables();  
	
	foreach($cv_array as $name=>$value) $_checkObj->varible_in($value); //each varible is added to class by array loop
  
    $clean=$_checkObj->get_cleaned_variables();
	 
    $errors=$_checkObj->get_bad_variables();
	 
    if (!count($errors)){
	 
	 $_flag=$get_flag=false;
     
	 if ($_POST['action']=='disapprove'){
	 
	  if ($stmt = $dbo->prepare('UPDATE tbl_keywords SET key_active=0 WHERE key_id=:key_id')){       
		
	   $stmt->bindValue(':key_id', $clean['key_id'], PDO::PARAM_INT);
	   
	   $_flag=true;  
	  
	  }
	 
	 }
	 elseif ($_POST['action']=='set_active'){	  
	 
	  if ($stmt = $dbo->prepare('UPDATE tbl_keywords SET key_active = (CASE WHEN key_active IS NULL OR NOT key_active THEN 1 ELSE 0 END) WHERE key_id=:key_id')){
	    
	   $stmt->bindValue(':key_id', $clean['key_id'], PDO::PARAM_INT);
	   
	   $_flag=true;  
	  
	  }
	  
	 }
	 
	 elseif (isset($_POST['cat_id_selection']) && $_POST['action']=='edit'){
	  	  
	  add_to_Dictionary($clean['key_word']);
	  
	  remove_Categories($clean['key_id'], $_POST['cat_id_selection']);
	  
	  correct_Categories($clean['key_id'], $_POST['cat_id_selection']);
	   	  
	  if ($stmt = $dbo->prepare('UPDATE tbl_keywords SET key_word=:key_word WHERE key_id=:key_id')){
	    
	   $stmt->bindValue(':key_id', $clean['key_id'], PDO::PARAM_INT);
	   
	   $stmt->bindValue(':key_word', $clean['key_word'], PDO::PARAM_STR);
	   
	   $_flag=true;  
	  
	  }	  
	  
	 }
	 
	 elseif (isset($_POST['cat_id_selection']) && $_POST['action']=='create'){
	  	  
	  add_to_Dictionary($clean['key_word']);
	  
	  if (!exists_Keywords($clean['key_word'])){
	   if ($stmt = $dbo->prepare("INSERT INTO tbl_keywords (key_word, key_active) VALUES (:key_word, 1)")){	   
	   
	    $stmt->bindValue(':key_word', $clean['key_word'], PDO::PARAM_STR);
	    		
	    $stmt->execute();
		
		$_Id=$dbo->lastInsertId();
	    
		correct_Categories($_Id, $_POST['cat_id_selection']);
				
	   } 
      }
      else{
	   $_Message='The Keyword or Phrase you are trying to create is already created';
	  }	  
	  
	 }
	 
	 if ($_flag) $stmt->execute();
	 
    }
    else {
	
     $_Message=reset($errors);
	 
    }
  
   }
}

require 'header.php';

?>

<center><h1>Manage Keywords</h1></center>

<?php 

if ($stmt = $dbo->prepare("
 SELECT DISTINCT KYW.*
 FROM tbl_c2keyword C2K
 INNER JOIN tbl_keywords KYW ON KYW.key_id=C2K.key_id
 INNER JOIN tbl_category CAT ON CAT.cat_id=C2K.cat_id
 WHERE KYW.key_active{$_Key_sign}{$_Key_Active}".($_Cat_Id?" AND CAT.cat_id=:catid":"")." ORDER BY key_count")){
 if ($_Cat_Id) $stmt->bindValue(':catid', $_Cat_Id, PDO::PARAM_INT);
 $stmt->execute();
 $str_body='';
  while ($Result = $stmt->fetch(PDO::FETCH_ASSOC)){
    $str_body.="
	 <tr>
	 
	  <td id='id-{$Result['key_id']}'>{$Result['key_id']}</td>
	  
	  <td id='word-{$Result['key_id']}'>{$Result['key_word']}</td>
	  
	  <td>".(!$Result['key_count']?"0":$Result['key_count'])."</td>
	  
	  <td><form method='post'><input type='hidden' name='wnu11_key_id' value='{$Result['key_id']}'><input class='cat_id' type='hidden' value='{$_Cat_Id}' name='cat_id'><input type='hidden' class='key_active' value='{$_Key_Active}' name='key_active'><input type='hidden' name='action' value='set_active'><input style='transform:scale(2);' class='key-active' type='checkbox'".($_Key_Active=='1'?" checked":"")."></form></td>
	  
	  <td>
	  
	   <form method='post'>
	   
	    <input class='cat_id' type='hidden' value='{$_Cat_Id}' name='cat_id'>
		
		<input type='hidden' class='key_active' value='{$_Key_Active}' name='key_active'>
	   
	    <input type='hidden' name='action' value='disapprove'>
		
		<input type='hidden' name='wnu11_key_id' value='{$Result['key_id']}'>
		
	    <div class='btn-group btn-group-sm' role='group' aria-label='...'>

		 ".($_Key_Active=='NULL'?"<button title='Globally Disapprove Keyword or Phrase: {$Result['key_word']}' type='submit' class='btn btn-danger'><span class='glyphicon glyphicon-trash'></span></button>":"")."         
		 
		 <button title='Edit Keyword or Phrase: {$Result['key_word']}' id='btn_{$Result['key_id']}' onclick='copy_to_edit(this)' type='button' class='btn btn-default'><span class='glyphicon glyphicon-edit'></span></button>

        </div>
		
	   </form>	
		
	  </td>
	  
	 </tr>
	";	
   }
  }

 if ($stmt = $dbo->prepare("
  SELECT DISTINCT CAT.cat_id, CAT.cat_name
  FROM tbl_c2keyword C2K
  INNER JOIN tbl_keywords KYW ON KYW.key_id=C2K.key_id
  INNER JOIN tbl_category CAT ON CAT.cat_id=C2K.cat_id")){
  $stmt->execute();
  $str_options='';$cat_checkboxes='<div style="max-height:200px;overflow-y:auto;" id="cat_list_sel"><div class="row">';
  
  /*
  
  <div class="col-lg-6">
    <div class="input-group">
      <span class="input-group-addon">
        <input type="checkbox" aria-label="...">
      </span>
      <input type="text" class="form-control" aria-label="...">
    </div><!-- /input-group -->
  </div><!-- /.col-lg-6 -->
  
  */
  
  
  while ($Result = $stmt->fetch(PDO::FETCH_ASSOC)){
   $cat_checkboxes.="
    <div class='col-sm-4'>
	 <div class='input-group'>
	  <span class='input-group-addon'>
	   <input type='checkbox' class='cat-sel' aria-label='...' id='catsel_{$Result['cat_id']}'>
	  </span>
	  <input type='text' readonly class='form-control' value='{$Result['cat_name']}' aria-label='...'>
	</div>
   </div>";
   $str_options.="<option ".($Result['cat_id']==$_Cat_Id?"selected":"")." value='{$Result['cat_id']}'>{$Result['cat_name']}</option>";
  }
  $cat_checkboxes.='</div></div>';
 }

 echo
 " 
  <div class='notifydiv'".(empty($_Message)?" style='display:none;'":"").">

   <div class='alert alert-{$_Message_type} alert-error' role='alert'><a href='#' class='close' data-dismiss='alert'>&times;</a><span class='glyphicon glyphicon-exclamation-sign' aria-hidden='true'></span><span class='sr-only'>".($_Message_type=='danger'?"Error":"Info").":</span> <text id='global_message'>{$_Message}</text></div>

  </div>  
  
<div class='row'>

<div class='col-sm-6'>

<form id='filters' method='post'>

<fieldset class='field-set'>
 
 <legend>General Filters</legend>
 
 <div class='row'>
 
  <div class='col-sm-6'>  
  
   <div class='form-group'>
    
	<label for='key_active'>Keyword Status</label>
  
    <select class='form-control' id='key_active' name='key_active'>
   
     <option value='NULL'>Waiting for Approval</option>
	
     <option ".($_Key_Active=='1'?"selected":"")." value='1'>Approved</option>
	
	 <option ".($_Key_Active=='0'?"selected":"")." value='0'>Disapproved</option>
	
    </select>
	
   </div>
   
  </div>
  
  
  
  <div class='col-sm-6'>
  
   <div class='form-group'>

    <label for='cat_id'>Categories</label>
   
    <select class='form-control' id='cat_id' name='cat_id'>
   
     <option value='0'>All</option>
	
     {$str_options}
	
    </select>
	
   </div>
  
  </div>  
  
 </div>
 
</fieldset> 

</form>

</div>


<div class='col-sm-6'>

<form id='edit_create' onsubmit='check_ready(event)' method='post'>

<fieldset class='field-set'>
 
 <legend>Create new Keyword or Phrase</legend>
 
 <input value='create' type='hidden' id='form_action' name='action'>
 
 <input type='hidden' id='key_id' name='wnu11_key_id' value=''>
 
 <input class='cat_id' type='hidden' value='{$_Cat_Id}' name='cat_id'>
 
 <input type='hidden' value='{$_Key_Active}' name='key_active'>
 
 <input value='' type='hidden' id='this_form_ready'>
 
 <input value='' type='hidden' id='cat_id_selection' name='cat_id_selection'>
 
 <div class='row'> 
  
  <div class='col-sm-6'>  
  
   <div class='form-group'>
    
	<label for='key_word'>Keyword or Phrase</label>     
   
    <input class='form-control' id='key_word' name='txt_key_word_r' value=''>
	
   </div>
   
  </div>
  
  
  
  <div class='col-sm-6'>
  
   <div class='form-group'>
    
	<input id='key_id' type='hidden' name='key_id' value=''>

    <button class='btn btn-primary col-sm-12' style='margin-top:22px' type='submit'>Submit</button>
	
	<button class='btn btn-default col-sm-6' onclick='cancel_edit_form(this)' style='margin-top:22px;display:none;' type='button'>Cancel</button>
	
   </div>
  
  </div>  
  
  
 </div>
 
 {$cat_checkboxes}
 
</fieldset> 

</form>

</div>

</div>

";

  $str_Display="<div class='row'><div class='col-sm-12'>
  <table class='display table' width='100%' id='keywords'>
  <thead>  
  <tr>  
	<th>Id</th>  
    <th>Keyword or Phrase</th>
	<th>Coincident Amount</th>
	<th>Globally Approved</th> 
	<th>Options</th>
  </tr>  
  </thead><tbody>{$str_body}</tbody></table></div></div>";
 
 echo $str_Display;

 
?>

<style>
  
  .field-set{
    margin-bottom:20px;
	background-color:#eee;
    -moz-border-radius: 0px 0px 5px 5px;
	-webkit-border-radius: 0px 0px 5px 5px;
	border-radius: 0px 0px 5px 5px;
  }

  .errors {

	color: red;

	font-size: 80%;

    top:60px;	

	right: 10px;

	position: absolute;

	z-index:101;

  }

</style>



<script>

function check_ready(e){
 if ($('#this_form_ready').val()!='1'){
  e.preventDefault();
  check_Words();
 }
}

function cancel_edit_form(btn){
 $(btn).hide();
 $('#key_id').val('');
 $('#edit_create').find('legend').text('Create new Keyword or Phrase');
 $(btn).prev().removeClass('col-sm-6').addClass('col-sm-12');
 $('#this_form_ready').val(''); 
 $('#form_action').val('create');
 $('#key_word').val('');
 $('#cat_id_selection').val('');
 $('.cat-sel').prop('checked', false);
}

$('select, input.key-active[type=checkbox]').change(function (){
 $(this).parents('form:first').submit();
})
  
var table = {}

$(document).ready(function(){

 table = $('#keywords').DataTable(); 

});

function check_Words (){
$('#this_form_ready').val(''); 
if ($('#cat_id_selection').val()==''){
 $('#global_message').html('The Keyword or Phrase has to be related at least with one Category');
 $('.notifydiv').show();
}
else if ($('#key_word').val()==''){
 $('#global_message').html('The Keyword or Phrase can not be an empty value');
 $('.notifydiv').show();
}
else{
 request_JSON={action: 'check_dictionary',key_word: $('#key_word').val()}
 $.post( location.href, request_JSON, function(data, status){
  if (status == 'success'){
   if (data['status']=='OK'){
    //it ok you can save the word or phrase into tbl_keywords
	$('#this_form_ready').val('1');	
	$('#edit_create').submit();
   }
   else if (data['status']=='WRONG'){
    //there are words that are not in the data base show confirmation message
	$('#global_message').html('Invalid data entered');
	$('.notifydiv').show();
   }
   else if(data['status']=='NOT_FOUND'){    
    $('#global_message').html(data['message']+'. Do you want to save the Keyword or Phrase any ways?<button style="margin-left:20px;" onclick="submit_edit_create()" type="button" class="btn btn-danger">ok</button></div><button style="margin-left:20px;" onclick="hide_message()" type="button" class="btn btn-default">cancel</button>');
	$('.notifydiv').show();
   }
   else{
    //unknown error
	$('#global_message').html(data['message']);
	$('.notifydiv').show();
   }
  }	 
  //console.log(data);	  
 }, 'json');
} 
}

function get_cat_ofKey (Key_id){ 
 request_JSON={action: 'get_categories', key_id: Key_id}
 $.post( location.href, request_JSON, function(data, status){
  if (status == 'success'){
   if (data['status']=='OK'){   
    $('#cat_id_selection').val('');
	$('.cat-sel').prop('checked', false);
	var comma='';
	for (var i in data['cat_id']){
	 $('#catsel_'+data['cat_id'][i]).prop('checked', true);
	 $('#cat_id_selection').val($('#cat_id_selection').val()+comma+data['cat_id'][i]);
	 comma=',';
	} 
	
   } 
   console.log(data);   
  }	 
  	  
 }, 'json');
}

function submit_edit_create(){
 $('#this_form_ready').val('1');
 $('#edit_create').submit(); 
}

function hide_message(){
 $('.notifydiv').hide(); 
}



function copy_to_edit(btn){ 
 $('#edit_create').find('button:last').show();
 $('#edit_create').find('button:last').prev().removeClass('col-sm-12').addClass('col-sm-6');
 $('#key_word').val(  table.cell('#word-'+$(btn).attr('id').split('_')[1]).data() ); 
 $('#edit_create').find('legend').text('Edit new Keyword or Phrase');
 $('#key_id').val( table.cell('#id-'+$(btn).attr('id').split('_')[1]).data() );
 $('#this_form_ready').val(''); 
 $('#form_action').val('edit');
 get_cat_ofKey(table.cell('#id-'+$(btn).attr('id').split('_')[1]).data());
}


 $('input.cat-sel[type=checkbox]').change(function (){
  $('#cat_id_selection').val('');
  $('.cat-sel').each(function (){   
   if ($(this).prop('checked')){
    var temp=$('#cat_id_selection').val();
    $('#cat_id_selection').val(temp+(temp==''?'':',')+$(this).attr('id').split('_')[1])
   }
  })
 })

</script>

<?php

require 'footer.php';

}

/* EOF ?> */