<?php
require '../app/start_session.php';
require '../app/global.php';
require '../app/model/twilio/Twilio/autoload.php';
use Twilio\Rest\Client;
require 'header.php';

// Your Account Sid and Auth Token from twilio.com/user/account
$sid   = SMS_TEXT_SID;
$token = SMS_TEXT_TOKEN;
$client = new Client($sid, $token);
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['phoneSID'])) {
	$client->incomingPhoneNumbers($_POST['phoneSID'])->delete();
}

?>


<div id='main' class='container'>
  <h1><span class='glyphicon glyphicon-phone'></span> Manage Twilio Phone Numbers</h1>

  <div class='row'>
    <div class='col-sm-12'>
		<div class='notifydiv'>
		   <div class='alert alert-danger alert-error' role='alert'><a href='#' class='close' data-dismiss='alert'>&times;</a><span class='glyphicon glyphicon-exclamation-sign' aria-hidden='true'></span> When you click the "Delete" button the phone number will be deleted right away from twilio</div>
		</div>
		<div class="table-responsive">
		<table id="twilioPhoneNumbers" class="display table table-bordered" width="100%">
		<thead>  
		  <tr> 
			<th>Friendly Name</th>
			<th>Number</th>
			<th>SID</th>
			<th>Created Date</th>
			<th>Updated Date</th>
			<th>Options</th>
		  </tr>  
		</thead>  
		<tbody>  
		 <?php 
		  foreach ($client->incomingPhoneNumbers->read() as $number) {
		   echo"
		   <tr>   
			<td>{$number->friendlyName}</td>
			<td>{$number->phoneNumber}</td>	
			<td>{$number->sid}</td>	
			<td>{$number->dateUpdated->format('m/d/Y H:i:s')}</td>
			<td>{$number->dateCreated->format('m/d/Y H:i:s')}</td>	
			<td>
			<form action='' method='post'>
			 <input type='hidden' name='phoneSID' value='{$number->sid}'>	
			 <button type='submit' title='Delete nhone number: {$number->friendlyName} from Twilio' class='btn btn-danger delete_phone'><span class='glyphicon glyphicon-trash'></span> Delete</button>
			</form>
			</td>
		   </tr>";  
		  } 
		 ?>
		</tbody>
		</table>
		</div>
		
    </div>
  </div>
</div>
<script>
$(document).ready(function(){
    $('#twilioPhoneNumbers').dataTable({
        responsive: true,
        "dom": "<lf<t>ip>"
    });	
});
</script>
<?php require 'footer.php'; ?>