<?php
require '../app/start_session.php';
require '../app/function.get-subdir.php';
//include '../app/class.variables.php';
$dbo=connect();

$requestBody = null;

if ( $_SERVER['REQUEST_METHOD'] == 'POST' && $_SESSION["user"]["admin"]["adm_master"] ){
	$requestBody = @json_decode( file_get_contents('php://input'), true );
}
	
if ( $requestBody !== null && json_last_error() == JSON_ERROR_NONE) {
	$resp = array(); $flagEncode = true;
	if (isset($requestBody['reseller_id'])) {
		$requestBody['res_id'] = preg_replace("/[^0-9]/", "",$requestBody['reseller_id']);
		if ($stmt = $dbo->prepare(
			"SELECT LMP.*
			FROM lt_merchant_plans LMP 
			INNER JOIN lt_plans2reseller P2R ON LMP.lmp_id = P2R.lmp_id
			WHERE P2R.res_id = :res_id AND LMP.lmp_active = 1"
		)){
			$stmt->bindValue(":res_id", $requestBody['res_id'], PDO::PARAM_INT);		
			$stmt->execute();
			$resp = $stmt->fetchAll( PDO::FETCH_ASSOC );
		}
	}
	elseif (isset($requestBody['address'])) {
		$flagEncode = false;
		$strURL='https://maps.googleapis.com/maps/api/geocode/json?key=AIzaSyAL3gq7mq6CJGxFVtZCzqavimeUUkOc7PU&address='.urlencode($requestBody['address']);
		// Get cURL resource
		$curl = curl_init();
		// Set some options
		curl_setopt_array($curl, array(
			CURLOPT_RETURNTRANSFER => 1,
			CURLOPT_URL => $strURL
		));
		$resp = curl_exec($curl);
		curl_close($curl);
	}
	
	echo $flagEncode? json_encode( $resp ): $resp;
	exit();
}
else {
	$message="";
	$tmpl_url = ROOT_URL;
	$resellers = array();
	$selectedResId = 0;
	$selectedPlanId = 0;
	$obj = json_decode( file_get_contents( "{$tmpl_url}/api/api.lt.json.options.php" ) );
	$states = $territory = '';

	foreach( $obj->options->state as $k => $v ) {
		$states.= "<option value='{$k}'>{$v}</option>";
	}

	foreach( $obj->options->territory as $k => $v ) {
		$territory.= "<option value='{$k}'>{$v}</option>";
	}
	if ($stmt = $dbo->prepare("
		SELECT * FROM tbl_reseller RES WHERE res_active")){
		$stmt->execute();
		$resellers = $stmt->fetchAll( PDO::FETCH_ASSOC );
	}
	
	if (isset($resellers[0]['res_id'])) {
		$selectedResId = $resellers[0]['res_id'];
	}
	
	if ($_SERVER['REQUEST_METHOD'] == 'POST' && $_SESSION["user"]["admin"]["adm_master"]){
	
	//require $_SERVER['DOCUMENT_ROOT'] . '/app/function.connect.php';
	//require $_SERVER['DOCUMENT_ROOT'] . '/app/start_session.php';
	//include '../app/start_session.php';
	
	//require $_SERVER['DOCUMENT_ROOT'] . '/app/global.php';
	include '../app/global.php';
	
	//require $_SERVER['DOCUMENT_ROOT'] . '/app/class.variables.php';
	include '../app/class.variables.php';
	
	//require $_SERVER['DOCUMENT_ROOT'] . '/reseller/app/model/class.reseller.php';
	include '../reseller/app/model/class.reseller.php';
	//require $_SERVER['DOCUMENT_ROOT'] . '/app/class.discount-code.php';
	//require $_SERVER['DOCUMENT_ROOT'] . '/app/class.prismpay.php';	
	//require $_SERVER['DOCUMENT_ROOT'] . '/app/class.member-merchant.php';
	include '../app/class.member-merchant.php';
	$memberMerchant = new App\MemberMerchant\MemberMerchant ($dbo, false);
	
	require_once '../app/class.mailgun.php';
	require '../app/model/crypt.php';
	
	//$discountCode = new App\DiscountCode\discountCode ( $dbo );
	
	// class variables
	$cv = new _variables();
	$fields=array(
	    //'adn64_discountCode',
		//'abc_cc_ltm_state',
		'abc_ltm_state_r',
		//'adn_ccnum_r',
		'ema_ltb_email_r',
		/*'dec2_cc_expmon_r',
		'dec4_cc_expyear_r',
		'dec_cc_ccv_r',
		'nam_cc_cardholder_r',
		'nam_cc_ltm_city',*/
		'nam_ltb_contact_first_name_r',
		'nam_ltb_contact_last_name_r',
		'nam_ltm_city_r',
		'pho_ltm_phone_number_r',
		'psw_ltb_password2_r',
		'psw_ltb_password_r',
		'txt64_ltm_company_name_r',
		'txt64_ltm_google_id',
		//'txt_cc_ltm_address',
		'txt_ltm_address_r',
		//'zip_cc_ltm_zipcode',
		'zip_ltm_zipcode_r',
		'dec_lmp_id_r',
		'dec_ltm_lat_r',
		'dec_ltm_lng_r',
		'dec_res_id_r',
		'nam_referring_agent',
		'nam_sales_agent'
	);

	if (isset($_POST['bit_ltm_hide_address'])){
		array_push($fields, 'bit_ltm_hide_address');
	}

	foreach( $fields as $name=>$value ) { $cv->varible_in($value); }
	$_v = $cv->get_cleaned_variables(  );
	$errors = $cv->get_bad_variables(  );
	
	if ( $_POST['psw_ltb_password_r'] !== $_POST['psw_ltb_password2_r'] ) {
		$errors['psw_ltb_password_r'] = 'Passwords must match';
	}	
		
	if ( $memberMerchant->merchantExists( $_v['ltb_email'], $errorMsg ) && empty( $errorMsg ) ) {
		$errors['ema_ltb_email_r'] = 'Email already registered';
		//array_push($errors, array('ema_ltb_email_r' => 'Email already registered'));
	}
		
	$resellerObj = new App\Reseller\Reseller ($dbo, $_v['res_id']);
	$chosen_plan = $resellerObj->getPlansFromId($_v['res_id'], $_v['lmp_id']);
	
	if( empty( $chosen_plan ) ) {
		$errors['dec_lmp_id_r'] = 'Plan Does Not Exist';
		//array_push($errors, array('dec_lmp_id_r' => 'Plan Does Not Exist'));	
	} 
	
	if (!$errors) {
		$selectedResId = $_v['res_id'];
		$selectedPlanId = $_v['lmp_id'];
		$message = '<div class="alert alert-success" role="alert">
					  Merchant Account successfully created.
					</div>';
		// encrypt the password
			$crypt   = new Crypt( $_v['ltb_email'] );
			$cryptck = $crypt->encode( $_v['ltb_password'] );

		    $sql = "INSERT INTO `lt_member_merchants`(res_id,lmp_id,pty_id,ltb_slug,ltb_phone_number,ltb_contact_name,ltb_email,ltb_password,ltb_datecreated,ltb_timestamp,ltb_active, ltb_referring_agent, ltb_salesperson) 
		    VALUES (:res_id,:lmp_id,:pty_id,:slug,:ltm_phone_number,:ltb_contact_name,:ltb_email,:ltb_password,now(),now(),1, :ltb_referring_agent, :ltb_salesperson)";
		    $qry = $dbo->prepare( $sql );
		    $qry->bindValue(':res_id', $_v['res_id'], PDO::PARAM_INT);
		    $qry->bindValue(':pty_id', $chosen_plan['pty_id'], PDO::PARAM_INT);
		    $qry->bindValue(':lmp_id', $chosen_plan['lmp_id'], PDO::PARAM_INT);
		    $qry->bindValue(':ltm_phone_number', $_v['ltm_phone_number'], PDO::PARAM_STR);
		    $qry->bindValue(':ltb_referring_agent', ($_v['referring_agent'] ? $_v['referring_agent'] : NULL), PDO::PARAM_STR);
		    $qry->bindValue(':ltb_salesperson', ($_v['sales_agent'] ? $_v['sales_agent'] : NULL), PDO::PARAM_STR);
		    $qry->bindValue(':ltb_contact_name', ucwords( strtolower( $_v['ltb_contact_first_name'].' '.$_v['ltb_contact_last_name'] ) ), PDO::PARAM_STR);
		    $qry->bindValue(':ltb_email', $_v['ltb_email'], PDO::PARAM_STR);
		    $qry->bindValue(':slug', strtolower(preg_replace("/[^A-Za-z0-9 ]/", '', $_v['ltb_email'])), PDO::PARAM_STR); // momentary placeholder until we get lastInsertId();
		    $qry->bindValue(':ltb_password', $cryptck, PDO::PARAM_STR);
		    $qry=execPDO($qry);
		    $ltb_id = $dbo->lastInsertId();

			// add store
			$sql = "INSERT INTO `lt_merchants` (ltm_hide_address,ltb_id,ltm_google_id,ltm_company_name,ltm_lat,ltm_long,ltm_address,ltm_city,ltm_state,ltm_zipcode,ltm_phone_number,ltm_registerdate,ltm_active) VALUES (:ltm_hide_address,:ltb_id,:ltm_google_id,:ltm_company_name,:ltm_lat,:ltm_long,:ltm_address,:ltm_city,:ltm_state,:ltm_zipcode,:ltm_phone_number,now(),1)";
			$qry = $dbo->prepare( $sql );
			$qry->bindValue(':ltb_id', $ltb_id, PDO::PARAM_STR);
			$qry->bindValue(':ltm_hide_address', isset($_POST['ltm_hide_address'])? 1: 0, PDO::PARAM_INT );
			$qry->bindValue(':ltm_google_id', $_v['ltm_google_id'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_company_name', $_v['ltm_company_name'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_lat', $_v['ltm_lat'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_long', $_v['ltm_lng'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_address', $_v['ltm_address'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_city', $_v['ltm_city'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_state', $_v['ltm_state'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_zipcode', $_v['ltm_zipcode'], PDO::PARAM_STR);
			$qry->bindValue(':ltm_phone_number', $_v['ltm_phone_number'], PDO::PARAM_STR);    
			$qry=execPDO($qry);
			$ltm_id = $dbo->lastInsertId();

			// begin slug creation
			function checkMerchantSlug($_slug, $dbo){
			  // check if URL slug already exists in our system
			  // global $dbo;
			  $sql = "SELECT LTB.ltb_slug, BS.bs_slug FROM `lt_member_merchants` LTB, `lt_bad_slugs` BS WHERE ltb_slug=:slug OR bs_slug=:slug LIMIT 1";
			  $qry = $dbo->prepare( $sql );
			  $qry->bindValue(':slug', $_slug, PDO::PARAM_STR);
			  $qry=execPDO($qry);
			  $qry = $qry->fetchAll( PDO::FETCH_ASSOC );
			  if(empty($qry)){
			    return true; // available
			  } else {
			    return false; // taken
			  }
			}
			$our_slug = strtolower(preg_replace("/[^A-Za-z0-9 ]/", '', $_v['ltm_company_name']));
			$our_slug = str_replace(" ","-",$our_slug);
			$check_slug = checkMerchantSlug($our_slug, $dbo);
			if ($check_slug===false){
			  // duplicate slug, add ltb_id to end, check if under 64 characters, if not, minus ltb_id.length from slug then add ltb_id
			  $new_slug = $our_slug.'-'.$ltb_id;
			  if (strlen($new_slug)>64){
			    // new slug is over 64 characters long, trim it
			    $slug_overlap = strlen($new_slug)-64;
			    $new_slug = substr($our_slug, 0, ($slug_overlap*-1)); // remove the # of overlap characters from the initial slug to make it fit into 64 characters
			    $our_slug = $new_slug.'-'.$ltb_id;
			  } else {
			    $our_slug = $new_slug;
			  }
			}

			// update slug
			$qry = $dbo->prepare( "UPDATE `lt_member_merchants` SET ltb_slug=:slug WHERE ltb_id=:id LIMIT 1" );
			$qry->bindValue(':id', $ltb_id, PDO::PARAM_INT);
			$qry->bindValue(':slug', $our_slug, PDO::PARAM_STR);
			$qry = execPDO($qry);
		    
		    // set a default category
		    $sql = "INSERT INTO `lt_m2cat` (ltb_id,cat_id) VALUES (:ltb_id, 543)";
		    $qry = $dbo->prepare( $sql );
		    $qry->bindValue(':ltb_id', $ltb_id, PDO::PARAM_STR);  
		    $qry=execPDO($qry);

			// update merchant feature counts
			foreach ($chosen_plan['lmp_features'] as $k=>$v){
			    switch ($v['lpf_id']){
			      //case 9:  // catalog points
			      case 13: // monthly emails
			      case 14: // sms texts
			      case 15: // push notifications
			        $qry = $dbo->prepare( "INSERT INTO `lt_feature_cnt` (lfc_count, lpf_id, ltb_id) VALUES (:count, :lpf_id, :ltb_id)" );
			        $qry->bindValue(':ltb_id', $ltb_id, PDO::PARAM_INT);
			        $qry->bindValue(':lpf_id', $v['lpf_id'], PDO::PARAM_INT);
			        $qry->bindValue(':count', $v['mfc_count'], PDO::PARAM_INT);
			        $qry = execPDO($qry);           
			      break;
			      default:
			      break;
			    }
			}

			// welcome merchant email
			$email_settings = array();

			if ($chosen_plan['tem_id'] == NULL){
				$email_settings['ema_body'] = file_get_contents($tmpl_url.'/mail/localthanks/website/merchant_payment_welcome/merchant_payment_welcome.html');
			}
			else {
				$email_settings['ema_body'] = file_get_contents($tmpl_url.$chosen_plan['tem_path']);	
			}

			$email_settings['ema_email'] =  $_v['ltb_email'];
			$email_settings['ema_ltm_id'] = $ltm_id;

			$email_settings['ema_message'] = '<p>Welcome to Local Thanks!</p><p>Your <span style="color: #0079FE; font-weight: bold;">'.$chosen_plan['lmp_name'].' Membership</span> is now active under the following email address:</p><p style="margin: 0;"><span style="color: #0079FE; font-weight: bold;">'.$_v['ltb_email'].'</span></p>';
			$email_settings['ema_subject'] = 'Welcome to Local Thanks!';
			
			$mailgun = new App\Mailgun\mailgun($dbo);
			$mailgun->sendEmail($email_settings);
	}
}

if ($stmt = $dbo->prepare(
	"SELECT LMP.*
	FROM lt_merchant_plans LMP 
	INNER JOIN lt_plans2reseller P2R ON LMP.lmp_id = P2R.lmp_id
	WHERE P2R.res_id = :res_id AND LMP.lmp_active = 1"
)){
	$stmt->bindValue(":res_id", $selectedResId, PDO::PARAM_INT);		
	$stmt->execute();
	$plans = $stmt->fetchAll( PDO::FETCH_ASSOC );
}

if ($selectedPlanId === 0 && isset($plans[0]['lmp_id'])) {
	$selectedPlanId = $plans[0]['lmp_id'];
}

require 'header.php';
?>
<style>
#search_wrap{
	color:#fff; 
	background-color:#333;
	padding:25px 15px;
	margin: 0 200px;
	border-radius: 5px;
	margin-bottom: 15px;
}
.errors {color: red;font-size: 11px;display:inline-block;}
h1 {text-align: center;}

</style>

<div class="container-fluid">
	<div class="row">
		<div class="col-xs-12">
			<h1><a href="merchant-add"><span class='glyphicon glyphicon-add'></span> Add Local Merchant</a></h1>
			<?php echo $message; ?>
			<form id="businessAddressForm" method="POST" action=''>
				<input type="hidden" name="txt64_ltm_google_id" value="">
				<div class="row">
					<div class="col-xs-12">
						<div class="signup__heading"><h2>Reseller and Plan</h2></div>
					</div>
					<div class="col-xs-12 col-sm-6">
						<div class="form-group">
							<label for="nam_ltb_contact_first_name_r">Contact First Name</label>
							<input type="text" name="nam_ltb_contact_first_name_r" id="nam_ltb_contact_first_name_r" class="form-control" required value="<?php echo (isset($_REQUEST['nam_ltb_contact_first_name_r'])?$_REQUEST['nam_ltb_contact_first_name_r']:"")?>">
							<span class="errors"><?php echo (isset($errors['nam_ltb_contact_first_name_r'])?$errors['nam_ltb_contact_first_name_r']:"")?></span>
						</div>
					</div>
					<div class="col-xs-12 col-sm-6">
						<div class="form-group">
							<label for="nam_ltb_contact_last_name_r">Contact Last Name</label>
							<input type="text" name="nam_ltb_contact_last_name_r" id="nam_ltb_contact_last_name_r" class="form-control" required value="<?php echo (isset($_REQUEST['nam_ltb_contact_last_name_r'])?$_REQUEST['nam_ltb_contact_last_name_r']:"")?>">
							<span class="errors"><?php echo (isset($errors['nam_ltb_contact_last_name_r'])?$errors['nam_ltb_contact_last_name_r']:"")?></span>
						</div>
					</div>
					<div class="col-xs-12 col-sm-6">
						<div class="form-group">
							<label for="dec_lmp_id_r">Plan</label>
							<select name="dec_lmp_id_r" id="dec_lmp_id_r" class="form-control">
								<?php
									foreach ($plans as $plan) {
										echo '<option value="'.$plan['lmp_id'].'"' . ($plan['lmp_id'] === $selectedPlanId? ' selected ': '').'>'.$plan['lmp_name'].' ('.$plan['lmp_price'].')'.'</option>';
									}		 
								?>
							</select>
							<span class="errors"><?php echo (isset($errors['dec_lmp_id_r'])?$errors['dec_lmp_id_r']:"")?></span>
						</div>
					</div>
					<div class="col-xs-12 col-sm-6">
						<div class="form-group">
							<label for="dec_res_id_r">Reseller</label>
							<select name="dec_res_id_r" id="dec_res_id_r" class="form-control">
								<?php
									foreach ($resellers as $reseller) {
										echo '<option value="'.$reseller['res_id'].'" ' . ($reseller['res_id'] === $selectedResId? ' selected ': '').'>'.$reseller['res_name'].'</option>';
									}	 
								?>
							</select>
							<span class="errors"><?php echo (isset($errors['dec_res_id_r'])?$errors['dec_res_id_r']:"")?></span>
						</div>
					</div>
				</div>
				
				
				<div class="row">
					<div class="col-xs-12">
						<div class="signup__heading"><h2>Business Information</h2></div>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 col-sm-7">
						<div class="form-group">
							<label for="txt64_ltm_company_name_r">Business Name</label>
							<input type="text" name="txt64_ltm_company_name_r" id="txt64_ltm_company_name_r" class="form-control" required value="<?php echo (isset($_REQUEST['txt64_ltm_company_name_r'])?$_REQUEST['txt64_ltm_company_name_r']:"")?>">
							<span class="errors"><?php echo (isset($errors['txt64_ltm_company_name_r'])?$errors['txt64_ltm_company_name_r']:"")?></span>
						</div>
					</div>
					<div class="col-xs-12 col-sm-5">
						<div class="form-group">
							<label for="pho_ltm_phone_number_r">Business Phone Number</label>
							<input type="text" name="pho_ltm_phone_number_r" id="pho_ltm_phone_number_r" class="form-control" required value="<?php echo (isset($_REQUEST['pho_ltm_phone_number_r'])?$_REQUEST['pho_ltm_phone_number_r']:"")?>">
							<span class="errors"><?php echo (isset($errors['pho_ltm_phone_number_r'])?$errors['pho_ltm_phone_number_r']:"")?></span>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 col-sm-4">
						<div class="form-group">
							<label for="txt_ltm_address_r">Street Address</label>
							<input type="text" name="txt_ltm_address_r" id="txt_ltm_address_r" class="vCheck form-control" required value="<?php echo (isset($_REQUEST['txt_ltm_address_r'])?$_REQUEST['txt_ltm_address_r']:"")?>">
							<span class="errors"><?php echo (isset($errors['txt_ltm_address_r'])?$errors['txt_ltm_address_r']:"")?></span>
						</div>
					</div>
					<div class="col-xs-12 col-sm-3">
						<div class="form-group">
							<label for="nam_ltm_city_r">City</label>
							<input type="text" id="nam_ltm_city_r" name="nam_ltm_city_r" class="form-control" required value="<?php echo (isset($_REQUEST['nam_ltm_city_r'])?$_REQUEST['nam_ltm_city_r']:"")?>">
							<span class="errors"><?php echo (isset($errors['nam_ltm_city_r'])?$errors['nam_ltm_city_r']:"")?></span>
						</div>
					</div>
					<div class="col-xs-12 col-sm-3">
						<div class="form-group">
							<label for="abc_ltm_state_r">State</label>
							<select id="abc_ltm_state_r" name="abc_ltm_state_r" class="form-control" required>
								<option value="" selected disabled>Select State</option>
								<optgroup label='States'><?php echo $states; ?></optgroup>
								<optgroup label='U.S. Territories'><?php echo $territory; ?></optgroup>
							</select>
							<span class="errors"><?php echo (isset($errors['abc_ltm_state_r'])?$errors['abc_ltm_state_r']:"")?></span>
						</div>
					</div>
					<div class="col-xs-12 col-sm-2">
						<div class="form-group">
							<label for="zip_ltm_zipcode_r">Postal Code</label>
							<input type="text" name="zip_ltm_zipcode_r" id="zip_ltm_zipcode_r" class="form-control" required value="<?php echo (isset($_REQUEST['zip_ltm_zipcode_r'])?$_REQUEST['zip_ltm_zipcode_r']:"")?>">
							<span class="errors"><?php echo (isset($errors['zip_ltm_zipcode_r'])?$errors['zip_ltm_zipcode_r']:"")?></span>
						</div>
					</div>
					
					
					<div class="col-xs-12 col-sm-5">
						<div class="form-group">
							<label for="dec_ltm_lat_r">Latitude</label>
							<input type="text" name="dec_ltm_lat_r" id="dec_ltm_lat_r" class="form-control" required value="<?php echo (isset($_REQUEST['dec_ltm_lat_r'])?$_REQUEST['dec_ltm_lat_r']:"")?>">
							<span class="errors"><?php echo (isset($errors['dec_ltm_lat_r'])?$errors['dec_ltm_lat_r']:"")?></span>
						</div>
					</div>
					
					<div class="col-xs-12 col-sm-5">
						<div class="form-group">
							<label for="dec_ltm_lng_r">Longitude</label>
							<input type="text" name="dec_ltm_lng_r" id="dec_ltm_lng_r" class="form-control" required value="<?php echo (isset($_REQUEST['dec_ltm_lng_r'])?$_REQUEST['dec_ltm_lng_r']:"")?>">
							<span class="errors"><?php echo (isset($errors['dec_ltm_lng_r'])?$errors['dec_ltm_lng_r']:"")?></span>
						</div>
					</div>
					
					<div class="col-xs-12 col-sm-2">
						
						<div class="form-group">
							<button style="margin-top: 20px;" type="button" class="btn btn-info btn-small" id="searchBusinessSubmit">Find Location</button>
						</div>
					</div>
					<div class="col-xs-12">
					<p>Please, fill up the Address, City, State and Postal Code before trying to find the location</p>
					<br/><br/>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12">
						<div class="form-group">
							<label>
								<input type="checkbox" value="1" name="bit_ltm_hide_address">
								Hide Business Address to Consumers
							</label>							
						</div>
					</div>
				</div>	
					<!-- referral agent, salesperson -->
					<div class="row" style="margin-bottom:20px;">
						<div class="col-xs-12 col-sm-6" <?php echo ($_SESSION['reseller']['subdomain'] == 'merchant' ? '' : 'style="display:none"'); ?>>
							<label for="nam_referring_agent">Referring Agent</label>
							<input type="text" name="nam_referring_agent" id="nam_referring_agent" placeholder="Enter Referring Agent Name" class="form-control" value="<?php echo (isset($_REQUEST['nam_referring_agent'])?$_REQUEST['nam_referring_agent']:"")?>">
							<span class="errors"><?php echo (isset($errors['nam_referring_agent'])?$errors['nam_referring_agent']:"")?></span>
						</div>

						<div class="col-xs-12 col-sm-6">
							<label for="nam_sales_agent">Salesperson</label>
							<input type="text" name="nam_sales_agent" id="nam_sales_agent" placeholder="Enter Salesperson Name" class="form-control" value="<?php echo (isset($_REQUEST['nam_sales_agent'])?$_REQUEST['nam_sales_agent']:"")?>">
							<span class="errors"><?php echo (isset($errors['nam_sales_agent'])?$errors['nam_sales_agent']:"")?></span>
						</div>
					</div>
					<div class="signup__form-highlight" id="accountCreateInput">
						<div class="row">
							<div class="col-xs-12">
								<div class="signup__heading"><h2>Create Password</h2></div>
								<div class="row">
									<div class="col-xs-12">
										<div class="form-group">
											<label for="ema_ltb_email_r">Login Email</label>
											<input type="email" name="ema_ltb_email_r" id="ema_ltb_email_r" class="form-control" required value="<?php echo (isset($_REQUEST['ema_ltb_email_r'])?$_REQUEST['ema_ltb_email_r']:"")?>">
											<span class="errors"><?php echo (isset($errors['ema_ltb_email_r'])?$errors['ema_ltb_email_r']:"")?></span>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12 col-xs-6">
										<div class="form-group">
											<label for="psw_ltb_password_r">Password</label>&nbsp;&nbsp;&nbsp;<span id="pwMatchError" style="display:none; color:tomato;"><span class="glyphicon glyphicon-exclamation-sign"></span> Passwords must match</span>
											<input type="password" name="psw_ltb_password_r" id="psw_ltb_password_r" class="form-control" required pattern=".{3,}" title="3 characters minimum" value="<?php echo (isset($_REQUEST['psw_ltb_password_r'])?$_REQUEST['psw_ltb_password_r']:"")?>">
											<span class="errors"><?php echo (isset($errors['psw_ltb_password_r'])?$errors['psw_ltb_password_r']:"")?></span>
										</div>
									</div>
									<div class="col-xs-12 col-xs-6">
										<div class="form-group">
											<label for="psw_ltb_password2_r">Confirm Password</label>&nbsp;&nbsp;&nbsp;<span id="pwMatchError2" style="display:none; color:tomato;"><span class="glyphicon glyphicon-exclamation-sign"></span> Passwords must match</span>
											<input type="password" name="psw_ltb_password2_r" id="psw_ltb_password2_r" class="vCheck form-control" required pattern=".{3,}" title="3 characters minimum" value="<?php echo (isset($_REQUEST['psw_ltb_password2_r'])?$_REQUEST['psw_ltb_password2_r']:"")?>">
											<span class="errors"><?php echo (isset($errors['psw_ltb_password2_r'])?$errors['psw_ltb_password2_r']:"")?></span>
										</div>
									</div>									
								</div>
							</div>
						</div>
					</div>
					
					<div class="row">
						<div class="col-xs-12">
							<div class="form-group">
								<button type="submit" class="btn btn-success">Submit</button>
							</div>
						</div>
					</div>							
				</form>
		</div>
	</div>
</div>
<script>
function findLongLat() {
   var data = {
		address: $('#txt_ltm_address_r').val() + ' ' + $('#nam_ltm_city_r').val() + ', ' + $('#abc_ltm_state_r').val() + ' ' + $('#zip_ltm_zipcode_r').val(),
	};
   $.ajax({
	   url: "/admin/merchant-add",
	   global: false,
	   type: "POST",		   
	   dataType: "JSON",		   
	   data: JSON.stringify(data),
	   error:function (err){ console.log(err); },   
	   success: function (response)
		{ 
		  if (response.status=="OK" && response.results.length>0){	  
			$('#dec_ltm_lat_r').val(response.results[0]["geometry"]["location"].lat);
			$('#dec_ltm_lng_r').val(response.results[0]["geometry"]["location"].lng);
		  }
		}
   });
}   

function loadPlans () {
	var data = {
		reseller_id: $('#dec_res_id_r').val(),
	};
	
	$.ajax({
		url: "/admin/merchant-add",
		global: false,
		type: "POST",		   
		dataType: "JSON",		   
		data: JSON.stringify(data),
		success: function (response){
			var lmpSelect = $("#dec_lmp_id_r");
			var lmpSelectValue = lmpSelect.val();
			var html = '';
			for (var i in response) {
				html += '<option value="'+response[i]['lmp_id']+'"' + (response[i]['lmp_id'] === lmpSelectValue? ' selected ': '')+'>'+response[i]['lmp_name']+' ('+response[i]['lmp_price']+')'+'</option>';
			}	
			lmpSelect.html(html); 
		},
		error: function (e){
			console.log(e, 'error')
		}
	});
}
$(document).ready(function(){
	loadPlans();
	$("#dec_res_id_r").on("change", function (){
		loadPlans();
	});
	$("#searchBusinessSubmit").on("click", function (){
		findLongLat();
	});
	
});
</script>
<?php 
	require 'footer.php';
	} 
?>
