<?php
//use App\Prismpay;
//use App\DiscountCode;

// http://secure.localthanks.net/admin/merchant-edit?wnu_ltb_id=2
require '../app/start_session.php';
include '../app/class.variables.php';
require '../app/class.cakemail.php';
require '../app/function.processpayment.php'; /*This line goes away when the class.prismpay is done*/

require '../app/class.prismpay.php';
require '../app/class.discount-code.php';
require '../app/class.member-merchant.php';

function insertPlanFeatures($ltb_id, $lpf_id, $mfc_count, $dbo){
	$qry = $dbo->prepare( "INSERT INTO `lt_feature_cnt` (lfc_count, lpf_id, ltb_id) VALUES (:count, :lpf_id, :ltb_id)" );
	$qry->bindValue(':ltb_id', $ltb_id, PDO::PARAM_INT);
	$qry->bindValue(':lpf_id', $lpf_id, PDO::PARAM_INT);
	$qry->bindValue(':count', $mfc_count, PDO::PARAM_INT);
	$qry = execPDO($qry);    
}

function update_MailAmount($_ltmid, $_emailamount, $dbo){ 
	//updating cakemail email limit	        
	// $dbo = connect();
	$CakeAPI = new CakeMail( '828108c6dc7cafe6bac1a669aefe006b' );
	$_found_Flag = $CakeAPI->get_Account( $_Result, $_ltmid, $dbo );
	if ( $_found_Flag && isset( $_Result['cml_client_id'] ) && !empty( $_Result['cml_client_id'] ) ) {
		switch ( _env()['env_name'] ) {
		 case 'LIVE':
		  $_Parent=array('site'=>'com', 'client_id'=>283002, 'client_key'=>'584e5332424e6fb9d90cc4429d77f061', 'user_key'=>'bd27330e079bc35b9af4991e2877d62d', 'user_id'=>320259, 'email'=>'cakemail@localthanks.com', 'password'=>'prod');
		 break; 
		 case 'QA':
		  $_Parent=array('site'=>'org', 'client_id'=>282999, 'client_key'=>'f2a34b4247aac1d62600ea66cf0b7991', 'user_key'=>'d0c315537ba67b9b08a2b0aa422a643a', 'user_id'=>320257, 'email'=>'cakemail@localthanks.org', 'password'=>'qa');
		 break;
		 default:
		  $_Parent=array('site'=>'net', 'client_id'=>282842, 'client_key'=>'5acd8e77e331578797583e8578c54e70', 'user_key'=>'71fc105a95c7a2ee12036088f5b91c72', 'user_id'=>520033, 'email'=>'cakemail@localthanks.net',  'password'=>'dev');
		}
		$_Params=array( 'user_key'=>$_Parent['user_key'], 'client_id'=>$_Result['cml_client_id'], 'month_limit' => $_emailamount );
		try {		   
		   $CakeAPI->call_API( 'Client_SetInfo', $_Params, true );
		} 
		catch (Exception $e){
		   //do nothing
		}
	}
}

function getMerchInfo($ltb_id) {
	global $dbo;
	$sql="	SELECT LTM.ltm_id, LTB.lmp_id, LTB.pty_id, LTM.ltm_company_name, LTB.res_id, LTB.ltb_text_to_signup, LTB.ltb_active, LTB.ltb_slug, LTB.lmp_id, LTB.ltb_referring_agent, LTB.ltb_salesperson
			FROM lt_member_merchants LTB
			INNER JOIN lt_merchants LTM ON LTB.ltb_id=LTM.ltb_id
			WHERE LTB.ltb_id=:mm_id LIMIT 1";
    $_q2 = $dbo->prepare($sql);
    $_q2->bindValue(':mm_id', $ltb_id, PDO::PARAM_INT);
    return execPDO($_q2);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_REQUEST['mystore_login']) && isset($_REQUEST['ltm_id']) && preg_match('/^[0-9]+$/',$_REQUEST['ltm_id'])){
	$qry = $dbo->prepare( "
		SELECT MMR.*
		FROM lt_merchants MRC
		INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=MRC.ltb_id
		WHERE MRC.ltm_id=:id LIMIT 1" );

		$qry->bindValue(':id', $_REQUEST['ltm_id'], PDO::PARAM_INT);

		$qry->execute();

	if ($usr = $qry->fetch(PDO::FETCH_ASSOC)){	

		$m = $dbo->prepare( 'SELECT ltm_id,ltm_company_name FROM `lt_merchants` WHERE ltb_id=:id' );

		$m->bindValue( ':id', $usr['ltb_id'], PDO::PARAM_INT );

		$m->execute();

		$merchant = $m->fetch(PDO::FETCH_ASSOC);

		$r = $dbo->prepare( 'SELECT res_name FROM `tbl_reseller` WHERE res_id=:id' );

		$r->bindValue( ':id', $usr['res_id'], PDO::PARAM_INT );

		$r->execute();

		$reseller = $r->fetch(PDO::FETCH_ASSOC);

		$c = $dbo->prepare( 'SELECT COUNT(ltb_id) FROM `lt_promos` WHERE ltb_id=:id' );

		$c->bindValue( ':id', $usr['ltb_id'], PDO::PARAM_INT );

		$c->execute();

		$count = $c->fetch(PDO::FETCH_ASSOC);

		// new plan structure
		$p = 'SELECT LMP.lmp_id, LMP.lmp_name, LMP.pty_id, LPF.lpf_feature, LPF.lpf_id, MFC.mfc_count
		FROM lt_merchant_plans LMP 
		INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id 
		LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
		WHERE LMP.lmp_id = :lmp_id AND LPF.lpf_active = 1 AND (MFC.ltb_id IS NULL OR MFC.ltb_id = :ltb_id) ORDER BY MFC.ltb_id ASC';
		$p = $dbo->prepare( $p );
		$p->bindValue(':lmp_id', $usr['lmp_id'], PDO::PARAM_INT);
		$p->bindValue(':ltb_id', $usr['ltb_id'], PDO::PARAM_INT);
		$p->execute();
		$p = $p->fetchAll(PDO::FETCH_ASSOC);
		foreach ($p as $k => $v) {
		  if (!$results){
		    $results = array(
		      'lmp_id'                => $v['lmp_id'],
		      'pty_id'                => $v['pty_id'],
		      'lmp_name'              => $v['lmp_name'],
		    );
		    $results['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
		  } 
		  else {
		    // this will overwrite the default plan values with custom merchant values 
		    $results['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
		  }
		}
		$plan = $results;

		$_SESSION['user']['merchant']['ltm_id']               = $merchant['ltm_id'];
		$_SESSION['user']['merchant']['ltm_company_name']     = $merchant['ltm_company_name'];
		$_SESSION['user']['merchant']['res_name']             = $reseller['res_name'];
		$_SESSION['user']['merchant']['res_id']               = $usr['res_id'];
		$_SESSION['user']['merchant']['tmp_id']               = $usr['tmp_id'];
		$_SESSION['user']['merchant']['promo_count']          = $count['COUNT(ltb_id)'];
		$_SESSION['user']['merchant']['plan']                 = $plan;
		$_SESSION['user']['merchant']['date']                 = date( 'm/d/Y' );
        $_SESSION['user']['merchant']["ltb_id"]               = $usr["ltb_id"];
		$_SESSION['user']['merchant']["ltb_email"]            = $usr["ltb_email"];

		header('Location: /mystore/add_member-list_v2.php');
	}
}

$cv = new _variables(); // new instance

if ($_SERVER['REQUEST_METHOD'] == 'POST')
	if (isset($_REQUEST['cancel_next_billing']))
		$fields=array('wnu_ltb_id_r');
	elseif (isset($_REQUEST['wnu_link_merchant_r'], $_REQUEST['wnu_ltb_id_r'])) {
		$fields=array('wnu_link_merchant_r', 'wnu_ltb_id_r');
	}	
	elseif (isset($_REQUEST['aon_ltb_text_to_signup'], $_REQUEST['wnu_ltb_id_r'])) {
		$fields=array('aon_ltb_text_to_signup', 'wnu_ltb_id_r');
	}
	else	
		$fields=array('wnu_ltb_id', 'adn_ltb_slug_r', 'wnu_lmp_id');
if ($_SERVER['REQUEST_METHOD'] == 'GET')
	$fields=array('wnu_ltb_id');
foreach($fields as $name=>$value) $cv->varible_in($value); //each variable is added to class by array loop
$_v=$cv->get_cleaned_variables();
$error=$cv->get_bad_variables();
$ltm_id=0;

function getCurrentBilling ( $dboObj, $ltbId ) {
	$sql = "
	SELECT BILL.bill_id, BILL.bill_name, BILL.bill_orderid, BILL.lmp_id, BILL.bill_date, BILL.bill_cyclestart, BILL.bill_cycleend, BILL.bill_active 

	FROM lt_merchant_billing BILL 
	
	INNER JOIN lt_merchants MRC ON BILL.ltm_id = MRC.ltm_id
	
	INNER JOIN lt_member_merchants MMC ON MRC.ltb_id=MMC.ltb_id 
	
	WHERE MMC.ltb_id = :ltb_id AND BILL.bill_active = 1 
	
	ORDER BY BILL.bill_date DESC 
	
	LIMIT 1";

	$qry = $dboObj->prepare( $sql );

	$qry->bindValue(':ltb_id',$ltbId, PDO::PARAM_INT);

	$qry = execPDO($qry); 

	return $qry->fetchAll(PDO::FETCH_ASSOC);
}

function updateBillingPiriod($dboObj, $ltbId) {
	$my_bill = getCurrentBilling ( $dboObj, $ltbId );
	
	if( isset( $my_bill[0]['bill_orderid'] ) ) { 
		
		// cancel previous recurring sub
		foreach ($my_bill as $val){
			$uri = array(
			
				'action' => 'recur_cancel',
				'orderkeyid' => $val['bill_orderid'],
				'canceltype' => 1 //next billin period
				
			);

			// process cancelation

			$thisPay =  _appProcessPayment( $uri );

			// check cancel status
			if( $thisPay['status'] == "Declined" ) {
				$reason = explode( ':', str_replace('..', '', $thisPay['reason']) );
				// show errors
				array_push($errors, 'There was a problem canceling your current subscription: "'. $reason[2]);
			} elseif ( $thisPay['status'] == "Accepted" ) {

				//deactivate bill
				$qry = $dboObj->prepare("
					UPDATE `lt_merchant_billing`
					SET bill_cycleend = 
						(
							CASE 
								WHEN DATE_ADD(bill_cyclestart, INTERVAL FLOOR(DATEDIFF(CURDATE(), bill_cyclestart) / 31) MONTH) > CURDATE() 
								THEN DATE_ADD(bill_cyclestart, INTERVAL FLOOR(DATEDIFF(CURDATE(), bill_cyclestart) / 31) MONTH) 
								ELSE DATE_ADD(bill_cyclestart, INTERVAL (FLOOR(DATEDIFF(CURDATE(), bill_cyclestart) / 31) + 1) MONTH )
							END 
						)
					WHERE bill_id = :bill_id"
				);
				
				$qry->bindValue(':bill_id', $val["bill_id"], PDO::PARAM_INT);
				$qry->execute();
				
			} else {
				array_push($errors, 'Your transaction could not be completed at this time.');
			}
		}	
	}
}

if( !empty($_v['ltb_id']) && $_v['ltb_id']!=1 ) {
	
	if (isset($_POST['cancel_next_billing']) && empty($error) && $_SERVER['REQUEST_METHOD'] == 'POST'){
		updateBillingPiriod ( $dbo, $_v['ltb_id'] );
	}
	elseif(isset($_v['ltb_text_to_signup']) && empty($error) && $_SERVER['REQUEST_METHOD'] == 'POST') {		
		$textError = '';
		if (empty($_v['ltb_text_to_signup'])) {
			$_v['ltb_text_to_signup'] = null;
		}
		else{
			$_v['ltb_text_to_signup'] = strtolower($_v['ltb_text_to_signup']);
			if (preg_match('/^(lt)([0-9]{1,11})$/i', $_v['ltb_text_to_signup'])) {
				$textError = 'The text to signup string is not valid. It cannot be "lt" followed by a number.';
			}
		}
		if ( empty( $textError ) ){
			$p = 'UPDATE IGNORE lt_member_merchants SET ltb_text_to_signup = :ltb_text_to_signup WHERE ltb_id = :ltbid';
			$p = $dbo->prepare( $p );
			$p->bindValue(':ltb_text_to_signup', $_v['ltb_text_to_signup'], PDO::PARAM_INT);
			$p->bindValue(':ltbid', $_v['ltb_id'], PDO::PARAM_INT);
			$p->execute();
			if (!$p->rowCount() && $_v['ltb_text_to_signup'] !== null) {
				$textError = 'The text to signup is already taken.';
			}
		}	
	}
	elseif (isset($_REQUEST['aon_ltb_text_to_signup'])){
		$textError = 'The text to signup string is not valid.';
	}
	elseif(isset($_v['link_merchant']) && empty($error) && $_SERVER['REQUEST_METHOD'] == 'POST') {
		
		if (isset($_POST['link_merchant_option'])) {
			switch ($_POST['link_merchant_option']) {
				case '0':
					//what ever mall was selected					
				break;
				case '1': case '2':
					$_v['link_merchant']='1'; //our mall is the reseller its reseller has a mall it will be linked to it otherwise will be linked to our mall
				break;
			}
		}
		
		$p = 'UPDATE tbl_mall SET ltb_id = 1 WHERE ltb_id = :ltbid';
		$p = $dbo->prepare( $p );
		$p->bindValue(':ltbid', $_v['ltb_id'], PDO::PARAM_INT);
		$p->execute();
		$p = 'UPDATE tbl_mall SET ltb_id = :ltbid WHERE mall_id = :mallid';
		$p = $dbo->prepare( $p );
		$p->bindValue(':mallid', $_v['link_merchant'], PDO::PARAM_INT);
		$p->bindValue(':ltbid', $_v['ltb_id'], PDO::PARAM_INT);
		$p->execute();
		
	}

	elseif(empty($error) && $_SERVER['REQUEST_METHOD'] == 'POST') {
		
		// UPDATE CHANGES
		// Update Plan
		if(!empty($_v['ltb_id'])){
			
			// handle active/inactive
			
			
			if ( !isset( $_POST['ltb_active'] ) ) {
				
				$sql = "
					UPDATE IGNORE lt_member_merchants MMC 
					INNER JOIN lt_merchants MRC ON MRC.ltb_id=MMC.ltb_id 
					LEFT JOIN tbl_consumer CSM ON CSM.ltm_pick_id=MRC.ltm_id 
					SET CSM.ltm_pick_id = 1, MMC.ltb_active = 0 
					WHERE MMC.ltb_id=:ltb_id
				";
				
				
				$_q  = $dbo->prepare($sql);
		    	$_q->bindValue(':ltb_id', $_v['ltb_id'], PDO::PARAM_INT);
		    	
				execPDO( $_q );
				
				updateBillingPiriod ( $dbo, $_v['ltb_id'] );	
				
			}
			else {
				
				$sql = "
						SELECT * FROM lt_member_merchants
						WHERE ltb_id = :ltb_id AND NOT ltb_active LIMIT 1
					";
				$_q = $dbo->prepare($sql);
				$_q->bindValue(':ltb_id', $_v['ltb_id'], PDO::PARAM_INT);
				$_q->execute();
				
				if ($qry = $_q->fetchAll(PDO::FETCH_ASSOC)) {
					
					//make sure this user is activated on a free account
					//finding a free plan "lmp_id"
					$sql='
						SELECT LMP.lmp_id
						FROM lt_merchant_plans LMP 					
						WHERE lmp_active AND LMP.lmp_price = 0 AND LMP.lmp_fee = 0
						ORDER BY LMP.lmp_id ASC
						LIMIT 1
					';
					
					$_q = $dbo->prepare( $sql );
					$_q->bindValue( ':ltb_id', $_v['ltb_id'], PDO::PARAM_INT );
					$_qFreePlan=execPDO( $_q );
					
					if( $freePlan = $_qFreePlan->fetch( PDO::FETCH_OBJ ) ) {
						
						$sql = "
							UPDATE IGNORE lt_member_merchants SET ltb_active = 1, lmp_id = :lmp_id 
							WHERE ltb_id = :ltb_id AND ltb_id > 1 AND NOT ltb_active LIMIT 1
						";
						
						$_q = $dbo->prepare($sql);
						$_q->bindValue(':ltb_id', $_v['ltb_id'], PDO::PARAM_INT);
						$_q->bindValue(':lmp_id', $freePlan->lmp_id, PDO::PARAM_INT);
						$_q->execute();
						
					}
					else {
						
						$error = array(0=>'There isn\'t any free plan available, the merchant could not be activated.');
						$message = $error[0];
						
					}
				}	
			}
			
			//get merchant current info
			$oldRecord = getMerchInfo( $_v['ltb_id'] );
			$oldRow = $oldRecord->fetch(PDO::FETCH_OBJ);

			
			
			
			//if plan changed
			if ( $oldRow->lmp_id != $_v['lmp_id'] ) {
				
				$sql = '
				SELECT DISTINCT
				LMP.lmp_id, 
				LMP.lmp_name, 
				LMP.lmp_admin_name, 
				LMP.pty_id, 
				LMP.lmp_price, 
				LMP.lmp_fee, 
				LMP.lmp_billing_delay,
				LMP.lmp_description, 
				LMP.lmp_custom_terms, 
				LMP.lmp_custom_breakdown, 
				LPF.lpf_feature, 
				LPF.lpf_id, 
				MFC.mfc_count
				
				  FROM (
					SELECT LMP1.*
					FROM lt_merchant_plans LMP1
					INNER JOIN lt_plans2reseller P2R ON LMP1.lmp_id = P2R.lmp_id
					WHERE (LMP1.lmp_active > 0 AND P2R.res_id = :res_id) OR LMP1.lmp_id=1
				  ) LMP 
				  
				  INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id 
				  LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
				  WHERE LMP.lmp_id = :lmp_id AND LMP.lmp_active = 1 
				  ORDER BY LMP.lmp_price DESC';

				$qry = $dbo->prepare($sql);

				$qry->bindValue(':lmp_id', $_v['lmp_id'], PDO::PARAM_INT);

				$qry->bindValue(':res_id', $oldRow->res_id, PDO::PARAM_INT);

				$qry = execPDO($qry);

				$qry = $qry->fetchAll(PDO::FETCH_ASSOC);
				
				if($qry){
					foreach ($qry as $k => $v) {
				      if (!$results){
				        $results = array(
				          'lmp_id'                => $v['lmp_id'],
				          'pty_id'        		  => $v['pty_id'],
				          'lmp_name'              => $v['lmp_name'],
				          'lmp_price'             => $v['lmp_price'],
				          'lmp_fee'               => $v['lmp_fee'],
				          'lmp_billing_delay'     => $v['lmp_billing_delay'],
				          'lmp_description'       => $v['lmp_description'],
				          'lmp_custom_terms'      => $v['lmp_custom_terms'],
				          'lmp_custom_breakdown'  => $v['lmp_custom_breakdown']
				        );				
				      	$results['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
				      } 
				      else {
				        $results['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
				      }
				    }
					$selected_plan = $results;
				}
				
			    if( $selected_plan ) {
					$prismPay = new App\Prismpay\prismPay($dbo);
					$merchObj = new App\MemberMerchant\MemberMerchant($dbo, true, $_v['ltb_id']);
					$scheduledBillings = $merchObj->getScheduledBillings (  );
					$updatedBillings = false;	
					if ( floatval($selected_plan['lmp_price']) == 0 ) {
						//canceling next billings, its a free plan
						
						foreach ($scheduledBillings as $k=>$v) {
							$updatedBillings = $prismPay->cancelBilling( $v['bill_orderid'], 1 );
							if ( !$updatedBillings ) {
								break;
							}
							else {
								//cancel billing in our DB
								
								$merchObj->updateBillingPeriod ( $v['bill_id'], null, 0 );
							}
						}
					}
					
					else {
				
						$discCode = new App\DiscountCode\discountCode( $dbo );
						//floatval( $selected_plan['lmp_price'] )
						
						foreach ( $scheduledBillings as $k=>$v ) {
							$planPrice = floatval( $selected_plan['lmp_price'] );
							$billingPrice = floatval( $v['bill_price'] );
							
							if ( isset( $v['dsc_id'] ) ) { $planPrice = $discCode->applyCodeToPrice ( $v['dsc_id'], $planPrice ); }
							
							if ( $billingPrice != $planPrice ) {
								$updatedBillings = $prismPay->updateBillingAmount( $v['bill_orderid'], $planPrice );
								if ( !$updatedBillings ) {
									break;
								}
								else {
									//update billing amount in our DB									
									$merchObj->updateBillingPeriod ( $v['bill_id'], $planPrice );
								}
							}
							
						}
						
					}
					
					//$oldRow->lmp_id != $_v['lmp_id']
					if ( $updatedBillings ) {
						$sql="UPDATE lt_member_merchants SET lmp_id=:lmp_id, pty_id=:pty_id WHERE ltb_id=:ltb_id AND ltb_id <> 1 LIMIT 1";
						$_q = $dbo->prepare($sql);
						$_q->bindValue(':lmp_id', $selected_plan['lmp_id'], PDO::PARAM_INT);
						$_q->bindValue(':pty_id', $selected_plan['pty_id'], PDO::PARAM_INT);
						$_q->bindValue(':ltb_id', $_v['ltb_id'], PDO::PARAM_INT);			
						execPDO($_q);

						$sql = 'DELETE FROM lt_feature_cnt WHERE ltb_id=:ltb_id;';
						$qry = $dbo->prepare($sql);
						$qry->bindValue(':ltb_id', $_v['ltb_id'], PDO::PARAM_INT);
						execPDO($qry);  	

						$sql = 'OPTIMIZE TABLE lt_feature_cnt';
						$qry = $dbo->prepare($sql);
						execPDO($qry);

						//update merchant feature counts
						foreach ( $selected_plan['lmp_features'] as $k=>$v ) {
							switch ($v['lpf_id']){
							  case 9:  // catalog points
							  case 14: // sms texts
							  case 15: // push notifications
									insertPlanFeatures($_v['ltb_id'], $v['lpf_id'], $v['mfc_count'], $dbo);              
							  break;
							  case 13: // monthly emails
									insertPlanFeatures($_v['ltb_id'], $v['lpf_id'], $v['mfc_count'], $dbo);
									update_MailAmount($_v['ltb_id'], $v['mfc_count'], $dbo);
							  break;
							  default:
							  break;
							}
						}
					}
					else {
						$error = array( 0=>'There isn\'t any free plan available, the merchant could not be activated.' );
						$message = $error[0];
					}	
			    }

			}

			//updating the slug
			if ($oldRow->ltb_slug != $_v['ltb_slug']) {
				
				$sql="UPDATE IGNORE lt_member_merchants SET ltb_slug = :ltb_slug WHERE ltb_id = :ltb_id AND ltb_id > 1 LIMIT 1";
				$_q = $dbo->prepare($sql);
				$_q->bindValue(':ltb_id', $_v['ltb_id'], PDO::PARAM_INT);
				$_q->bindValue(':ltb_slug', $_v['ltb_slug'], PDO::PARAM_STR);
				$_q->execute();
				if ( !$_q->rowCount()){ 
					$message = 'The slug you are trying to enter is already taken.';
				} else {
					//make an entry in the table admin_history and 301_redirect
					$afterChange = getMerchInfo( $_v['ltb_id'] );
					if( $afterChange->rowCount() ) {				
						$changedRow = $afterChange->fetch(PDO::FETCH_OBJ);
						$sql="INSERT INTO tbl_admin_history (adm_id, adh_notes) VALUES (:adm_id, :adh_notes)";
						$_q = $dbo->prepare($sql);
						$_q->bindValue(':adm_id', $_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT);
						$_q->bindValue(':adh_notes', 'The merchant (' . $changedRow->ltm_company_name . ') slug changed from :' . $changedRow->ltb_slug . ' to: ' . $oldRow->ltb_slug, PDO::PARAM_STR);
						$_q->execute();
						
						$sql="INSERT IGNORE INTO tbl_301_redirect (301_new, 301_old) VALUES (:new, :old)";
						$_q = $dbo->prepare($sql);
						$_q->bindValue(':new', $changedRow->ltb_slug, PDO::PARAM_STR);
						$_q->bindValue(':old', $oldRow->ltb_slug, PDO::PARAM_STR);
						$_q->execute();	
					}				
				}
			}
		}
	} else {
		$message = $error[0];
	}
	
	// Query this merchant's info	
    $_q2=getMerchInfo( $_v['ltb_id'] );
	$_active = false;
    if( $_q2->rowCount( ) ) {
		$row = $_q2->fetch(PDO::FETCH_OBJ);
		$merchant_name = $row->ltm_company_name;
		$textToSignUp = $row->ltb_text_to_signup;
		$current_plan = $row->lmp_id;
		$reseller_id = $row->res_id;
		$_active = $row->ltb_active;
		$slug = $row->ltb_slug;
		$ltmId = $row->ltm_id;
		$salesPerson = $row->ltb_salesperson;
		$referringAgent = $row->ltb_referring_agent;	
	}
	
	$merchObj = new App\MemberMerchant\MemberMerchant($dbo, true, $_v['ltb_id']);
	$promoCodeUsed = $merchObj->getDiscountCodeUsed (  );
	$hasSetupBilling = getCurrentBilling ( $dbo, $_v['ltb_id'] );
	
	//Query plan types
    $sql='
		SELECT DISTINCT LMP.lmp_id, LMP.lmp_name, LMP.lmp_price, LMP.lmp_fee
		FROM lt_merchant_plans LMP 
		INNER JOIN lt_plans2reseller P2R ON  LMP.lmp_id = P2R.lmp_id 
		WHERE (LMP.lmp_active > 0 AND P2R.res_id = :res_id) OR LMP.lmp_id=1 
		ORDER BY lmp_id ASC
	';
	$_q = $dbo->prepare( $sql );
	$_q->bindValue( ':res_id', $reseller_id, PDO::PARAM_INT );
	$_qPlans=execPDO($_q);
	
	$plan_options='';
	while( $plan = $_qPlans->fetch( PDO::FETCH_OBJ ) ) {
		if ($current_plan==$plan->lmp_id)
			$currentPlanRec = $plan;
		$plan_options .= '<option '.($current_plan==$plan->lmp_id?' selected ':'').' value="'.$plan->lmp_id.'">'.$plan->lmp_name . ' - $'. $plan->lmp_price .'</option>';
	}
}

if (!empty($_v['ltb_id'])){
	$sql="	SELECT LTM.ltm_id, LTB.ltb_email
			FROM lt_member_merchants LTB
			INNER JOIN lt_merchants LTM ON LTB.ltb_id=LTM.ltb_id
			WHERE LTB.ltb_id=:mm_id LIMIT 1";
    $_q2 = $dbo->prepare($sql);
    $_q2->bindValue(':mm_id', $_v['ltb_id'], PDO::PARAM_INT);
    $_q2=execPDO($_q2);
    if($_q2->rowCount()){
		$row = $_q2->fetch(PDO::FETCH_OBJ);
		$ltm_id = $row->ltm_id;	
		$ltb_email = $row->ltb_email;	
	}
}

$mallOptions = '';
$selectedMall = 0;
$reselerMall = 0;

if ( !empty( $_v['ltb_id'] ) ) {
	$sql="SELECT MALL.mall_id, MALL.mall_name, (CASE WHEN MALL.ltb_id = :ltbid THEN 1 ELSE 0 END) AS Selected
		  FROM tbl_mall MALL";
    $_q2 = $dbo->prepare($sql);
    $_q2->bindValue(':ltbid', $_v['ltb_id'], PDO::PARAM_INT);
    $_q2 = execPDO($_q2);
    if( $_q2->rowCount(  ) ) {
		while ( $row = $_q2->fetch( PDO::FETCH_OBJ ) ) {
			if ( $row->Selected=='1' ) $selectedMall = intval( $row->mall_id );
			$mallOptions .= '<option'.( $row->Selected=='1' ? ' selected':'' ).' value="' . $row->mall_id . '">' . $row->mall_name . '</option>'; 
		}
	}
	
	$sql="SELECT 
			MALL.mall_id
		  FROM tbl_mall MALL
		  INNER JOIN tbl_reseller RES ON RES.mall_id = MALL.mall_id
		  INNER JOIN lt_member_merchants MMR ON MMR.res_id = RES.res_id
		  WHERE MMR.ltb_id=:ltbid AND MALL.mall_id > 1 LIMIT 1";
    $_q2 = $dbo->prepare($sql);
    $_q2->bindValue(':ltbid', $_v['ltb_id'], PDO::PARAM_INT);
    $_q2=execPDO($_q2);
    if($_q2->rowCount()){
		if ($row = $_q2->fetch(PDO::FETCH_OBJ)){
			$reselerMall = intval($row->mall_id);
		}		
	}
	
}

 require 'header.php';
?>

<div class="container">
	<h1 style="text-align:center;">Edit Local Merchant</h1>
	<div class="row">
		<div class="col-sm-4">
			<?php if (!$textError) echo ( isset($message)?"<div class='alert alert-danger'><span class='glyphicon glyphicon-warning-sign'></span> {$message}</div>":(empty($error) && $_SERVER['REQUEST_METHOD'] == 'POST'?"<div class='alert alert-info'><span class='glyphicon glyphicon-ok'></span> The merchant info was updated correctly</div>":""));?>
			<form method="post">
				<div style="font-weight:bold;font-size:18px;">
					<?php echo $merchant_name; ?>
				</div>
				<div class="form-group">
					<label>URL Slug:</label><small> http://localthanks.com/</small>
					<input type="text" name="adn_ltb_slug_r" value="<?php echo $slug;?>">
				</div>
				<div class="form-group">
				    <div>
						<label>Promo Code Used to Signup:</label>
						<?php echo (!empty($promoCodeUsed) ? $promoCodeUsed : 'none'); ?>
					</div>
					<div>
						<label>Referring Agent:</label>
						<?php echo ($referringAgent ? $referringAgent : 'none'); ?>
					</div>
					<div>
						<label>Salesperson:</label>
						<?php echo ($salesPerson ? $salesPerson : 'none'); ?>
					</div>
				</div>
				<br>
				<?php
				
				$showHideDropDown = ' style="display:none;"';
				if ( isset($hasSetupBilling[0]['bill_orderid']) && $_active ) {
					$showHideDropDown = '';
				}
				elseif ( $_active ) {
					echo '<p>In order to upgrade this merchant\'s account just log in his mystore and follow the pre-established process for doing so. <a href="/admin/merchant-search?res_id=&ltm_id='.$ltmId.'&ltb_email=&ltb_contact_name=&ltb_phone_number=&ltm_company_name=&res_name=&search=1">Find merchant</a></p>';
				}
				
				echo '<label'.$showHideDropDown.'>
					Plan
					<select class="form-control" name="wnu_lmp_id">
						'.$plan_options.'
					</select>
				</label>
				<br>';
				
				?>
				<label>
					Active
					<input <?php echo ($_active?' checked':''); ?> style=" transform:scale(1.5); margin-left:5px;" type="checkbox" name="ltb_active">
				</label>
				
				<p>By <strong>unchecking</strong>  the above box and saving (below button), the merchant account will be deactivated rightaway and its recurring payments will be deactivated on the next billing period.</p>
				<p>By <strong>checking</strong>  the above box and saving (below button), the merchant account will be activated rightaway.</p>
				<input type="hidden" name="wnu_ltb_id" value="<?php echo $_v['ltb_id']; ?>">
				<input type="submit" id="updateMerchantAccount" value="Save" class="btn btn-primary">
			</form>
			<br>
			<hr>			
			<form method="post">
				<input type="hidden" name="wnu_ltb_id_r" value="<?php echo $_v['ltb_id']; ?>">
				<input type="hidden" name="cancel_next_billing" value="1">
				<input type="submit" value="Cancel Next Billing Period" class="btn btn-primary">
				<br><br>
				<p>By <strong>clicking</strong> on the above button, the merchant account will be deactivated on the next billing period as well as its recurring payments.</p>
			</form>
			<br>
			<hr>
			<form method="POST" style="display:inline-block;margin-top:20px;margin-bottom:20px;">
				<input type="hidden" name="mystore_login" value="1"><input type="hidden" name="ltm_id" value="<?php echo "{$ltm_id}";?>"><button type="submit" class="btn btn-primary">Bulk Member Upload</button>
			</form>
			<br>
			<hr>
			<form>
				<h2>Lost Welcome Email</h2>
				<button id="resendWelcome" type="submit" class="btn btn-warning">Resend Welcome Email</button>
				<input type="hidden" id="resend_ltb_email" name="ltb_email" value="<?php echo $ltb_email; ?>">
				<input type="hidden" id="resend_ltm_id" name="ltm_id" value="<?php echo $ltm_id; ?>">
			</form>
			<br>
			<hr>
		</div>
		
		<div class="col-sm-4">
			<form action="" method="post">
				<h4>Link Merchant to a National Mall</h4>
			
				<label>National Mall Jumping Options</label>
				<div class="row">
					<div class="col-sm-8">						
						<select name="link_merchant_option" id="link_merchant_option" class="form-control">
							<option value="0">Private</option>
							<?php echo $reselerMall? '<option value="1"'.( !$selectedMall? ' selected': '' ).'>Reseller</option>':''; ?>
							<option <?php echo  !$selectedMall && !$reselerMall? ' selected': '' ; ?> value="2">Ours</option>
						</select>
					</div>
					<div class="col-sm-4"></div>
				</div>
				<div id="selectMallList" <?php echo  $selectedMall? '': 'style="display:none;"' ; ?>>
					<br/>
					<label>Mall List</label>
					<div class="row">
						<div class="col-sm-8">
							<input type="hidden" name="wnu_ltb_id_r" value="<?php echo (empty($_v['ltb_id']) ? '0' : $_v['ltb_id']); ?>"/>
							<select name="wnu_link_merchant_r" id="wnu_link_merchant_r" class="form-control">
								<?php echo $mallOptions; ?>
							</select>
						</div>
						<div class="col-sm-4">
							<button type="submit" class="btn btn-primary">Save Link</button>
						</div>
					</div>
				</div>	
			</form>
			<br/>
			<hr/>
			
			<form action="" method="post">
				<h4>Merchant text to signup</h4>
				<label>Text</label>
				<div class="row">
					<div class="col-sm-8">
						<?php if ($textError) echo '<div class="alert alert-danger">'.$textError.'</div>'; ?>
						<input type="hidden" name="wnu_ltb_id_r" value="<?php echo (empty($_v['ltb_id']) ? '0' : $_v['ltb_id']); ?>">
						<input type="text" class="form-control" maxlength="12" name="aon_ltb_text_to_signup" value="<?php echo (empty($textToSignUp) ? '' : $textToSignUp); ?>">						
						<p>Allowed characters are alpha-numeric. <?php echo (empty($_v['ltb_id']) ? '' : 'If no value is entered the following text should be used instead: lt' . $_v['ltb_id']); ?></p>
					</div>
					<div class="col-sm-4">
						<button type="submit" class="btn btn-primary">Save Text</button>
					</div>
				</div>
			</form>
		</div>
	</div>
	
</div>

<script src="/plugins/success-msg.js"></script>

<script>
$(document).ready(function(){
	$('#wnu_link_merchant_r').find('option[value="1"]').remove(); //removing our mall, it will be default if no mall is selected
});

$("#link_merchant_option").change(function (){
	//alert(this.value);
	if (this.value == '0') {
		$('#selectMallList').show();
	}
	else {
		$('#selectMallList').hide();
	}
});

// lost welcome email
$('#resendWelcome').on('click', function(e){
	// prevent form from submitting
	e.preventDefault();

	// get data from form inputs
	var $resend_ltm_id = $('#resend_ltm_id').val();
	var $resend_ltb_email = $('#resend_ltb_email').val();

	// confirm they want to send the email
	if (confirm('Send '+$resend_ltb_email+' a welcome email?')){
		// resend welcome email
		var data = {
			ltm_id: $resend_ltm_id,
			ltb_email: $resend_ltb_email,
		};
		$.ajax({
			url: "../ajax/ajax.resend-ltb-welcome-email-v1.php",
			global: false,
			type: "POST",		   
			dataType: "JSON",		   
			data: data,
			success: function (response){
				if (response['status'] === 'success'){
					// alert that email has been sent
					LocalThanksSuccessMsg('Email Sent!');
				} else {
					alert(response['status']);
				}
			}
		});
	}
});
</script>

<?php
require 'footer.php';
?>