<?php
require '../app/start_session.php';
$dbo=connect();

// redirect to admin home if no adm_id is set
if (!isset($_SESSION['user']['admin']['adm_id'])){
	header('Location: /admin');
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_REQUEST['end_of_call'], $_REQUEST['cst_id'])){
	// echo '<pre>'; var_dump($_SESSION); echo '</pre>';
	// echo '<pre>'; var_dump($_REQUEST); echo '</pre>';

	// update CSR ticket
	$sql = 'UPDATE lt_merchant_cs_time SET cst_end_time=NOW(), cst_seconds=:time_spent, cst_call_summary = :call_summary WHERE cst_id=:cst_id';
	$qry = $dbo->prepare($sql);
	$qry->bindValue(':time_spent', $_REQUEST['time_spent'], PDO::PARAM_INT );
	$qry->bindValue(':call_summary', trim($_REQUEST['call_summary']), PDO::PARAM_STR);
	$qry->bindValue(':cst_id', $_REQUEST['cst_id'], PDO::PARAM_INT );
	$qry=execPDO($qry);

	// unset the merchant session
	unset($_SESSION['user']['merchant']);

	// redirect back to merchant search page
	header('Location: merchant-search');
}

// var_dump($_SERVER);
require 'header.php';
?>
<style>
	#call_history {
		max-height: 300px;
		overflow-y: scroll;
	}
	table.call-history-table tbody td {
		text-align: left;
	}
</style>
<div class='container-fluid'>
	<div class='row'>
		<div class='col-sm-12'>
			<div class="row">
				<div id="controlWrap" class="col-lg-2" style="display:none;">
					<div id="CountDownTimer" data-timer="" style="width: 250px;"></div>
					<button class="btn btn-success startTimer">Start Timer</button>
		        	<button class="btn btn-danger stopTimer">Pause</button>
		        	<!-- <button class="btn btn-warning btn-xs restartTimer">Restart Timer</button> -->
	        		<button class="btn btn-primary endCall">End Call</button>
		        	<br><br>
		        	<strong>Call summary/notes:</strong> <br><textarea name="call_summary" id="call_summary" style="width:100%;"></textarea>
		        	<br><br>
		        	<strong>History:</strong><div id="call_history"></div>
		        	<br><br>
				</div>

				<div id="main_div" class="col-lg-10">
					<h2>Entering '<?php echo $_REQUEST['ltm_company_name']; ?>' MyStore</h2>
					<div id="notify_div" class="alert alert-danger" style="display:none;"></div>
					<form method="post" id="mystore_jump_form">
						<label>Reason:
							<textarea id="reason_for_entry" name="reason_for_entry"></textarea>
						</label>
						<br><br>	
						<button type="button" id="save_and_start">Enter MyStore</button>
						<input type="hidden" name="ltm_id" value="<?php echo $_REQUEST['ltm_id']; ?>">
						<input type="hidden" name="mystore_login" value="1">
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
<br><br>

<!-- TimeCircles plugin -->
<script type="text/javascript" src="../plugins/TimeCircles/TimeCircles.js"></script>
<link rel="stylesheet" href="../plugins/TimeCircles/TimeCircles.css">

<script>
$(document).ready(function(){
	$('#save_and_start').on('click', function() {
		var data = $('#mystore_jump_form').serialize();
		$.ajax({
			url: "inc/api.csr-mystore-login-v1.php",
			global: false,
			type: "POST",		   
			dataType: "html",		   
			data: data,
			success: function (response){
				//console.log(response);
				csr_response = jQuery.parseJSON(response);
				
				// call history
				// console.log(csr_response['time_left']);
				//console.log(csr_response);
				var call_history = '<table class="table table-striped table-bordered call-history-table" style="font-size:11px;"><thead><th>Call Details</th><thead><tbody>';
				$.each(csr_response['call_history'], function( index, value ) {
					if (index != 0){
						call_history += '<tr><td><strong>Date:</strong> '+ new Date(value['cst_start_time'].replace(/-/g,'/')).toLocaleString()+'<br><br><strong>Reason:</strong> '+value['cst_entry_reason']+'<br><br><strong>Summary:</strong> '+(value['cst_call_summary']==null?'N/A':value['cst_call_summary'])+'<br><br><strong>CSR:</strong> '+value['adm_chat_name']+'</td></tr>';
					}
				});
				call_history += '</tbody></table>'
				$('#call_history').html(call_history);

				// console.log(response['status']);
				// console.log(csr_response['time_left']);
				if (csr_response['status'] != 'success'){
					$('#notify_div').text(csr_response['status']).show(); // display error message
				} else {
					var timer_div = $("#CountDownTimer");
					(csr_response['time_left']<=0?csr_response['time_left']=3:'');
					timer_div.data('timer', csr_response['time_left']);
		          	timer_div.TimeCircles({ time: { Days: { show: false }, Hours: { show: false } }, total_duration: csr_response['time_left'], /*start: false,*/ count_past_zero: false}).addListener(function(unit, amount, total){
		                // console.log('unit: '+unit);
		                // console.log('amount: '+amount);
		                // console.log('total: '+total);
						// update time spent as time passes in case CSR ends call unexpectedly
						var time_spent = (total - csr_response['time_left']);
						var data = {
							time_spent: time_spent,
							cst_id: csr_response['cst_id']
						};
						$.ajax({
							url: "inc/api.csr-update-time-spent.php",
							global: false,
							type: "POST",		   
							dataType: "html",		   
							data: data,
							success: function (response){
								// console.log(response);
							}
						});
						// should we do something here? prompt to buy more time?
						if (total <= 0){
		                    alert('This merchant has no customer service time left.'); // this merchant has run out of time
		                }
		            });

		            // Start, restart and stop are methods applied on the public TimeCircles instance
		            $(".startTimer").click(function() {
		                timer_div.TimeCircles().start();
		            });
		            $(".stopTimer").click(function() {
		                timer_div.TimeCircles().stop();
		            });
		            // $(".restartTimer").click(function() {
		            // 	if (confirm('Are you sure you want to restart the timer?')){
		            //     	timer_div.TimeCircles().restart().stop();
		            // 	}
		            // });

		            // show controls (start timer, stop timer, end call)
		            $('#controlWrap').show();

            		// height of viewport for the iFrame
					var vheight = (Math.max(document.documentElement.clientHeight, window.innerHeight || 0) - 140);
					// open mystore now that the session is set
					$('#main_div').html('<iframe id="theFrame" src="//<?php echo $_SERVER['SERVER_NAME']; ?>/mystore/" style="width:100%;height:'+vheight+'px;" frameborder="0"></iframe>');

					// console.log(Math.ceil(timer_div.TimeCircles().getTime()));

					// handle end of call
					$('.endCall').on('click', function(){
						if (confirm('Are you sure you want to end this call?')){
							
							// stop timer
							timer_div.TimeCircles().stop();

							// remove iFrame
							$('#theFrame').remove();

							// get length of call and remaining time left
							var time_remaining = Math.ceil(timer_div.TimeCircles().getTime());
							var time_spent = (time_remaining - csr_response['time_left']);
							// add end of call form
							var build_form = '<br>';
							build_form += '<div class="panel panel-primary">';
							build_form += '<div class="panel-heading"><h3 class="panel-title">End of Call Notes</h3></div>';
							build_form += '<div class="panel-body">';
							build_form += '<form method="post" id="end_of_call_form">';
							build_form += '<dl class="dl-horizontal">';
							// build_form += 		'<dt>Call ID: </dt><dd>'+csr_response['cst_id']+'</dd><br>';
							build_form += 	 "<dt>Merchant: </dt><dd><?php echo $_REQUEST["ltm_company_name"] ?></dd><br>";
							// build_form += 		'<dt>Length of Call: </dt><dd>'+secondsToHms(time_spent)+'</dd><br>';
							// build_form += 		'<dt>Time Remaining: </dt><dd>'+secondsToHms(time_remaining)+'</dd><br>';
							// build_form += 		'<dt>Reason for entry: </dt><dd>'+csr_response['reason_for_entry']+'</dd><br>';
							build_form += 		'<dt>Call summary/notes: </dt><dd><textarea name="call_summary" id="call_summary" style="width:100%;">'+$('#call_summary').val()+'</textarea></dd><br>';
							build_form += 		'<dt><button type="button" class="btn btn-success" id="save_and_end">Save Call Notes</button></dt>';
							build_form += '</dl>';
							build_form += '<input type="hidden" name="end_of_call" value="1">';
							build_form += '<input type="hidden" name="cst_id" value="'+csr_response['cst_id']+'">';
							build_form += '<input type="hidden" name="time_spent" value="'+time_spent+'">';
							build_form += '</form>';
							build_form += '</div></div>';
							$('#controlWrap').html(build_form).removeClass('col-lg-2').addClass('col-lg-3');

							// end of call notes submit
							$('#save_and_end').on('click', function(){
								if ($('#call_summary').val().trim().length == 0){
									alert('Include a call summary');
								} else {
									$('#end_of_call_form').submit();
								}
							});							
						}
					});
				}
			}
		});
	});
	
	// window.onbeforeunload = function(){
	//   return 'Are you sure you want to exit? Your call record will be incomplete!';
	// };
	// function that takes seconds and formats to H:M:S
	// function secondsToHms(d) {
	// 	d = Number(d);
	// 	var h = Math.floor(d / 3600);
	// 	var m = Math.floor(d % 3600 / 60);
	// 	var s = Math.floor(d % 3600 % 60);
	// 	return ((h > 0 ? h + ":" + (m < 10 ? "0" : "") : "") + m + ":" + (s < 10 ? "0" : "") + s); 
	// }
});
</script>
<?php require 'footer.php'; ?>