<?php 
require '../app/start_session.php'; 

$sql = 'SELECT lpf_id, lpf_feature, lpf_description
        FROM lt_plan_features
        WHERE lpf_display AND lpf_active
        ORDER BY lpf_id ASC';
$qry = $dbo->prepare( $sql );
$qry->execute();
$qry = $qry->fetchAll(PDO::FETCH_ASSOC);
if(empty($qry)){
  echo '<h1>ERROR! Check SQL statement on this page.</h1>';
} else {
  $features = $qry;
}

require 'header.php';
?>
 
<div class="container">
  <div class='row'>
    <div class='col-md-12'>
      <h1><span class='glyphicon glyphicon-list-alt'></span> Plan Feature Descriptions</h1>
      <p>Use the form below to add a short description to each plan feature.</p>
    </div>
  </div>
    <?php 
      $i = 1;
      $FEATURE_PER_ROW = 2;
      $COLUMN_SIZE = 12 / $FEATURE_PER_ROW;
  
      foreach ($features as $feature){
        if ($i % $FEATURE_PER_ROW != 0){
          echo '<div class="row">';
        }
    ?>
    <div class="col-md-<?php echo $COLUMN_SIZE; ?>">
      <div class="form-group">
        <h3><?php echo $feature['lpf_feature']; ?></h3>
        <textarea class="form-control feature-description" rows="3"><?php echo trim($feature['lpf_description']); ?></textarea>
      </div>
      <div class="form-group">
        <button class="btn btn-sm btn-primary feature-save"  type="button" disabled data-lpf-id="<?php echo $feature['lpf_id']; ?>">Save</button>
        <button class="btn btn-sm btn-default feature-reset" type="button" disabled data-original-desc="<?php echo $feature['lpf_description']; ?>">Reset</button>
      </div>
    </div>
    <?php
        if ($i % $FEATURE_PER_ROW == 0){
          echo '</div>';
        }
        $i++; 
      } // end foreach $features
    ?>
</div>

<script>
$(document).ready(function(){

  $('.feature-description').on('change keyup', function(){
    // activate buttons when description is edited
    $(this).parent().siblings().children('button').prop('disabled', false);
  });

  // reset textarea with original feature description
  $('.feature-reset').on('click', function(){
    var $originalDesc = $(this).data('originalDesc');
    $(this).parent().siblings().children('textarea').val($originalDesc);
    // disable save/reset buttons
    $(this).parent().children('button').prop('disabled', true);
  });

  // save feature description
  $('.feature-save').on('click', function(){
    
    // set that to this so we can use it in the AJAX callback function
    var that = $(this);
    
    // set POST data
    var data = {
      lpf_id: $(this).data('lpfId'),
      lpf_description: $(this).parent().siblings().children('textarea').val()
    };

    // run AJAX
    $.ajax({
      url: "../ajax/ajax.update-plan-feature-description.php",
      global: false,
      type: "POST", 
      dataType: "json",      
      data:  data,
      error: function (response){ alert('error, check console'); console.error('ERROR:', response); },
      success: function (response){
        if (response.status === 'success'){
          // disable save/reset buttons
          that.parent().children('button').prop('disabled', true);
          // set original description to the new saved description so that the next time 'reset' is pressed, we show the updated description
          that.siblings('.feature-reset').data('originalDesc', data.lpf_description);
          // success message popup
          showSuccessMsg();
        } else {
          alert('Something went wrong... check console');
          console.log(response);
        }
      }
    });
  });

  function showSuccessMsg(){
    var div = document.createElement("div");
    div.style.display = "none";
    div.style.position = "fixed";
    div.style.left = "50%";
    div.style.top = "10%";
    div.style.width = "60%";
    div.style.textAlign = "center";
    div.style.transform = "translate(-50%, 0)";
    div.className = "alert alert-success temporary-div";
    div.innerHTML = "<span class='glyphicon glyphicon-saved'></span> Feature Description Saved!";
    document.body.appendChild(div);
    $('.temporary-div').show();
    setTimeout(function(){
      $('.temporary-div').hide('slow', function(){
        $(this).remove();
      });
    }, 3000);
  }

});
</script>
<?php 
require 'footer.php'; 
?>