<?php
require '../app/start_session.php';

function loadFeature($lpfId, &$addedMerPlans) {
	global $dbo;
	//finding plan feature
	$pSQL = '
	SELECT LPF.*, POF.*
	FROM lt_plan_features LPF
	INNER JOIN tbl_plan_offerer POF ON POF.rpo_id=LPF.rpo_id
	WHERE LPF.lpf_id=:pfId
	LIMIT 1
	';

	$pF = $dbo->prepare( $pSQL );
	$pF->bindValue(':pfId', $lpfId, PDO::PARAM_INT);
	$pF->execute();
	if ($tmpObj = $pF->fetch(PDO::FETCH_ASSOC)){
		$tmpObj['Merchant_Plans'] = loadMerchantPlans($lpfId, $addedMerPlans);
		return $tmpObj;
	}
	return null;
	
}

function loadMerchantPlans($lpfId, &$addedMerPlans) {
	global $dbo; $tmpObj=array(); $addedMerPlans = array();
	//finding plan feature
	$pSQL = '
		SELECT MRP.*, MFC.mfc_count, MFC.mfc_id
		FROM lt_plan_features LPF
		INNER JOIN lt_max_feature_cnt MFC ON MFC.lpf_id=LPF.lpf_id
		INNER JOIN lt_merchant_plans MRP ON MRP.lmp_id=MFC.lmp_id
		WHERE LPF.lpf_id=:pfId
	';
	$pF = $dbo->prepare( $pSQL );
	$pF->bindValue(':pfId', $lpfId, PDO::PARAM_INT);
	$pF->execute();
	while ($tmpDbObj = $pF->fetch(PDO::FETCH_ASSOC)){
		array_push($addedMerPlans, $tmpDbObj['lmp_id']);
		$tmpObj[$tmpDbObj['lmp_id']] = $tmpDbObj;
	}
	return $tmpObj;
}

//setting selected offered id default: rpo_company = Localthanks, rpo_id = 1
$planOffererId = isset($_GET['rpo_id']) && is_numeric($_GET['rpo_id']) && intval($_GET['rpo_id']) > 0? intval($_GET['rpo_id']) : 1;
$currentFeaturePlans = array();
$currentPlanFeature = null;
$errors = null;
//handeling form submition
if ( $_SERVER['REQUEST_METHOD'] == 'POST' && isset($_SESSION['user']['admin']['adm_id']) ){
	
	if ( isset($_POST['wnu_lmp_id_r'], $_POST['txt_mfc_count_r'], $_POST['wnu_lpf_id_r']) ) {
		//process add or edit lt_max
		
		$arrayValidate['txt_mfc_count_r'] = $_POST['txt_mfc_count_r'];
		$arrayValidate['wnu_lpf_id_r'] = $_POST['wnu_lpf_id_r'];
		$fields = array('wnu_lpf_id_r', 'txt_mfc_count_r');		
		
		$lmpIdArr = explode(',',$_POST['wnu_lmp_id_r']);
		$tmp = 0;
		foreach ($lmpIdArr as $k => $v) {
			if (intval($v) > 0) {				
				array_push($fields, "wnu_lmp_id" . ($tmp == 0? '': $k) . "_r");
				$arrayValidate["wnu_lmp_id" . ($tmp == 0? '': $k) . "_r"] = $v;
				$tmp++;
			}
		}
		
		
		//check the values of passed variables
		include '../app/class.variables.php';
		$cv = new _variables($arrayValidate); //new instance
		foreach($fields as $name=>$value) $cv->varible_in($value); //each variable is added to class by array loop
		$_v=$cv->get_cleaned_variables();
		$errors=$cv->get_bad_variables();
		
		if ( empty($errors) ) {
			
			
			
			$errors = null;		
			
			if (isset($_POST['delete_ckeckbox'])) {
				$pSQL = "
				DELETE FROM lt_max_feature_cnt WHERE lmp_id=:lmp_id AND lpf_id=:lpf_id
				";
				$pO = $dbo->prepare( $pSQL );
				$pO->bindValue(':lpf_id', $_v['lpf_id'], PDO::PARAM_INT);
				$pO->bindValue(':lmp_id', $_v['lmp_id'], PDO::PARAM_INT);
				$pO->execute();
			}
			else {
				// if ( is_numeric($_v['mfc_count']) ) {
				// 	if (intval($_v['mfc_count']) <= 0)
				// 		$_v['mfc_count'] = null;
				// 	else {
				// 		$_v['mfc_count'] = intval($_v['mfc_count']);
				// 	}
				// }	
				// else{
				// 	$_v['mfc_count'] = null;
				// }

				if ($_v['mfc_count'] == "0"){
					$_v['mfc_count'] = null;
				}
				
				$pSQL = "INSERT IGNORE lt_max_feature_cnt (lmp_id, mfc_count, lpf_id) VALUES ";
				$flag = false; $str = '';
				foreach ( $_v as $f => $v ) {
					if ( $f != 'mfc_count' && $f != 'lpf_id' ){
						$pSQL .= "{$str} (:{$f}, :mfc_count, :lpf_id)";
						if (!$flag) {$str = ','; $flag = true;}
					}
				}
				
				$pO = $dbo->prepare( $pSQL );				
				
				$pO->bindValue(':lpf_id', $_v['lpf_id'], PDO::PARAM_INT);			
				$pO->bindValue(':mfc_count', $_v['mfc_count'], PDO::PARAM_STR);
				
				foreach ($_v as $f => $v) {
					if ($f != 'mfc_count' && $f != 'lpf_id'){						
						$pO->bindValue(":{$f}", $v, PDO::PARAM_INT);
					}	
				}
				
				$pO->execute();
				
				if ( !$dbo->lastInsertId() ) {
					$pSQL = "UPDATE lt_max_feature_cnt SET mfc_count=:mfc_count WHERE lmp_id=:lmp_id AND lpf_id=:lpf_id";
					$pO = $dbo->prepare( $pSQL );
					$pO->bindValue(':lpf_id', $_v['lpf_id'], PDO::PARAM_INT);			
					$pO->bindValue(':mfc_count', $_v['mfc_count'], PDO::PARAM_STR);
					$pO->bindValue(':lmp_id', $_v['lmp_id'], PDO::PARAM_INT);
					$pO->execute();
				}
			}
		}	
		
	}	
	else {
		if ( !isset($_REQUEST['bit_lpf_active'])) $_REQUEST['bit_lpf_active'] = 0;
		elseif ($_REQUEST['bit_lpf_active'] == 'on')  $_REQUEST['bit_lpf_active'] = 1;
		
		if ( !isset($_REQUEST['bit_lpf_display']) ) $_REQUEST['bit_lpf_display'] = 0;
		elseif ($_REQUEST['bit_lpf_display'] == 'on')  $_REQUEST['bit_lpf_display'] = 1;
		
		$fields = array('wnu_lpf_id_r', 'bit_lpf_active', 'bit_lpf_display', 'txt255_lpf_description', 'txt255_lpf_feature_r');
		
		//check the values of passed variables
		include '../app/class.variables.php';
		$cv = new _variables(); // new instance
		foreach($fields as $name=>$value) $cv->varible_in($value); //each variable is added to class by array loop
		$_v=$cv->get_cleaned_variables();
		$errors=$cv->get_bad_variables();
		
		if ( empty($errors) ) {
			$errors = null;		
			if (intval($_v['lpf_id']) > 0) {
				//we are updating the plan feature			
				
				$pSQL = "
				UPDATE lt_plan_features SET rpo_id=:rpo_id,lpf_display=:lpf_display,lpf_active=:lpf_active,lpf_description=:lpf_description,lpf_feature=:lpf_feature WHERE lpf_id=:lpf_id
				";
				$pO = $dbo->prepare( $pSQL );
				$pO->bindValue(':lpf_id', $_v['lpf_id'], PDO::PARAM_INT);
				$pO->bindValue(':rpo_id', $planOffererId, PDO::PARAM_INT);			
				$pO->bindValue(':lpf_active', intval($_v['lpf_active']), PDO::PARAM_INT);
				$pO->bindValue(':lpf_display', intval($_v['lpf_display']), PDO::PARAM_INT);
				$pO->bindValue(':lpf_description', $_v['lpf_description'], PDO::PARAM_STR);
				$pO->bindValue(':lpf_feature', $_v['lpf_feature'], PDO::PARAM_STR);
				$pO->execute();
			}
			else{
				//we are adding a new plan feature
				$fields = 'rpo_id'; $values = ':rpo_id';
				unset($_v['lpf_id']);
				foreach ($_v as $k => $v) {
					
					$fields .= ',' . $k;
					$values .= ',:' . $k;
					
				}
				
				$pSQL = "INSERT INTO lt_plan_features ({$fields}) VALUES ({$values})";
				
				$pO = $dbo->prepare( $pSQL );
				
				$_v['rpo_id'] = $planOffererId;
				
				foreach ($_v as $k => $v) {
					$pO->bindValue(":{$k}", is_numeric($v)? intval($v): $v , is_numeric($v)? PDO::PARAM_INT : PDO::PARAM_STR);
				}	
				$pO->execute();
			}
		}	
	}
	
	$currentPlanFeature = loadFeature($_POST['wnu_lpf_id_r'], $currentFeaturePlans);	
}

//getting plan feature if any selected
if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_SESSION['user']['admin']['adm_id'], $_REQUEST['lpf_id']) && is_numeric($_REQUEST['lpf_id']) && intval($_REQUEST['lpf_id']) > 0){
	$currentPlanFeature = loadFeature($_REQUEST['lpf_id'], $currentFeaturePlans);	
}

/*getting plan offerers*/
$planOffererLogo = ''; $planOffererCompany = '';
$pSQL = '
SELECT POF.* 
FROM tbl_plan_offerer POF
';
$pO = $dbo->prepare( $pSQL );
$pO->bindValue(':pId', $planOffererId, PDO::PARAM_INT);
$pO->execute();
$pOArray = array();
while ($tmpObj = $pO->fetch(PDO::FETCH_ASSOC)){
	if ($planOffererId == $tmpObj['rpo_id']) $planOffererLogo = $tmpObj['rpo_logo'];
	if ($planOffererId == $tmpObj['rpo_id']) $planOffererCompany = $tmpObj['rpo_company'];
	array_push($pOArray, $tmpObj);
}

/*getting plan offerer features*/
$pSQL = '
SELECT LPF.*, POF.*
FROM lt_plan_features LPF
INNER JOIN tbl_plan_offerer POF ON POF.rpo_id=LPF.rpo_id
WHERE POF.rpo_id=:pId
ORDER BY LPF.lpf_feature
';

$pF = $dbo->prepare( $pSQL );
$pF->bindValue(':pId', $planOffererId, PDO::PARAM_INT);
$pF->execute();
$pFArray = array();

while ($tmpObj = $pF->fetch(PDO::FETCH_ASSOC)){	
	array_push($pFArray, $tmpObj);
}

/*getting merchant plans All of them*/
$merchantPlanArray = array();
$pSQL = '
SELECT MPL.* FROM lt_merchant_plans MPL
';
$pF = $dbo->prepare( $pSQL );
$pF->execute();
while ($tmpObj = $pF->fetch(PDO::FETCH_ASSOC)){	
	$merchantPlanArray[$tmpObj['lmp_id']] = $tmpObj;
}

//echo '<pre>';
//var_dump($pFArray);
//echo '</pre>';

require 'header.php';

?>

<style>
table input{
	max-width: 80px;
}

.addMerchantPlanBtn {
	margin: 20px 0;
}

.odd {color: #000 !important;}

#plan_merchant_plans_info {display: none;}

#plan_merchant_plans_div .input-sm{
	max-width: 80px;
}

h1{
	text-align: center;
}

#alert{
  text-align: center;
  position: fixed;
  top: 25%;
  z-index: 10;
  width: 50%;
  left: 25%;
  right: 50%;
  display: none;
  -webkit-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
  -moz-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
  box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
}
#add_plan_features_form {
  margin-bottom: 25px;
}
.sub-label {
  font-size: 85%;
}
</style>

<div id="adm_body">
  <div id='main' class='container'>
    <div class='row'>
      <div class='col-sm-12'>
        <h1>Plan Features</h1>
        <?php
          if (isset($_GET['success']) && $_GET['success'] == 1) {
            echo '<div class="alert alert-success" role="alert" style="font-size:175%;">Success! Plan Features added. <a href="plan_features-edit?res_id='.$_GET['res_id'].'">Click here to continue setup.</a></div>';
          }
          if (is_Array($errors)) { 
            echo "<div id='push_errors' class='alert alert-danger'><span class='glyphicon glyphicon-exclamation-sign'></span> <strong>Please check the error messages below:</strong><ul>"; 
            foreach($errors as $key => $value) { 
              $error_msg .= '<li>' . $value . '</li>'; 
            } 
            echo $error_msg . "</ul></div>"; 
          } 

          $_host = parse_url('http://'.$_SERVER['HTTP_HOST']);
          preg_match('/ (.*?)((\.co)?.[a-z]{2,4})$/i', $_host['host'], $_m);
          $_ext = isset($_m[2]) ? $_m[2]: '';
          // var_dump($_ext);
        ?>
      </div>
    </div>    
      <div class="row">
        <div class="col-sm-4">		
		  <div class="row">
			<div class="col-sm-12" style="padding: 20px; background-color: #333; color: #fff; border-radius: 5px;">	
			  <h3><?php echo (isset($currentPlanFeature['lpf_id'])?'Edit Plan Feature: <small>'.$currentPlanFeature['lpf_feature'].'</small>':'Add a New Plan Feature'); ?></h3>
			  <form id="plan_features_form" method="POST">         
				<input type="hidden" name="wnu_lpf_id_r" value="<?php echo (isset($currentPlanFeature['lpf_id'])?$currentPlanFeature['lpf_id']:'0'); ?>" class="form-control"/>
				<label for="txt255_lpf_feature_r">Plan Feature</label>
				<input required type="text" maxlength="255" name="txt255_lpf_feature_r" id="txt255_lpf_feature_r" value="<?php echo (isset($currentPlanFeature['lpf_id'])?$currentPlanFeature['lpf_feature']:''); ?>" class="form-control"/>
				<br><label for="txt255_lpf_feature_r">Description</label>
				<textarea name="txt255_lpf_description" maxlength="255" id="txt255_lpf_description" class="form-control"><?php echo (isset($currentPlanFeature['lpf_id'])?$currentPlanFeature['lpf_description']:''); ?></textarea>
				<br><label for="bit_lpf_display"><input type="checkbox" name="bit_lpf_display" id="bit_lpf_display" value="1" <?php echo (isset($currentPlanFeature['lpf_id']) && $currentPlanFeature['lpf_display'] == 1? 'checked':''); ?>/> Display</label>
				<br><label for="bit_lpf_active"><input type="checkbox" name="bit_lpf_active" id="bit_lpf_active" value="1" <?php echo (isset($currentPlanFeature['lpf_id']) && $currentPlanFeature['lpf_active'] == 1? 'checked':''); ?>/> Active</label>
				<?php echo isset($currentPlanFeature['lpf_id'])? '<br><a href="plan-features?rpo_id=' . $currentPlanFeature['rpo_id'] . '"><button type="button" id="plan_features_cancel" class="btn btn-xs btn-default">Cancel Edit</button></a><br><br>':'<p>The new plan feature will be added under the current selected plan offerer: <strong>"' . $planOffererCompany . '"</strong></p>';?>
				<input type="submit" id="plan_features_submit" value="<?php echo (isset($currentPlanFeature['lpf_id'])?'Edit':'Add'); ?> Plan Feature" class="form-control"/>			
			  </form>          
			</div>
			
			<?php if (isset($currentPlanFeature['lpf_id'])) { ?>
			
			<div class="col-sm-12" id="plan_merchant_plans_div" style="margin-top: 20px; padding: 20px; background-color: #333; color: #fff; border-radius: 5px;">	
			  <h5><?php echo '<strong>'.$currentPlanFeature['lpf_feature'].':</strong> Merchant Plan List'; ?></h5>
			  <button id="merchnat_plan_btn" class="btn btn-default btn-block addMerchantPlanBtn">Add Merchant Plan</button>
			  <table class="table table-striped table-bordered" id="plan_merchant_plans">
				<thead>
				  
				  <th>Name</th>
				  <th>Count</th>				  
				  <th></th>
				  
				</thead>
				<?php 
				if (is_array($currentPlanFeature['Merchant_Plans'])) {
				  //var_dump($currentPlanFeature['Merchant_Plans']);
				  foreach($currentPlanFeature['Merchant_Plans'] as $key => $value){ 
					//'.$value['lmp_id'].'	
				    echo 
						'<tr>
						  
						  <td>'.$value['lmp_name'].' ($'.$value['lmp_price'].')'.'</td>
						  <td><input class="form-control saveMPlanBtn_'.$value['lmp_id'].'" value="'.(empty($value['mfc_count'])?'0':$value['mfc_count']).'"/></td>
						  <td>
						    	<button type="button" title="Save data" data-lmpid="'.$value['lmp_id'].'" class="btn btn-info btn-xs saveMPlanBtn"><span class="glyphicon glyphicon-ok"></span></button>
								<button type="button" title="Remove merchant plan" data-lmpid="'.$value['lmp_id'].'" class="btn btn-danger btn-xs deleteMPlanBtn"><span class="glyphicon glyphicon-remove"></span></button>							
						  </td>
						  
						</tr>';
				  }
				}
				  ?>
			  </table>
			  <button id="merchnat_plan_btn" class="btn btn-default btn-block addMerchantPlanBtn">Add Merchant Plan</button>
			</div>
			
			<?php } ?>
			
		  </div>		
        </div>
		
        <div class="col-sm-8">
		  <div class="row" style="margin-bottom: 20px;">
		    <div class="col-sm-12">
				<h2><?php echo 'Selected Plan Offerer: <strong>' . $planOffererCompany . '</strong>'; ?></h2>
			</div>
			<div class="col-sm-4">	
			  <img class="img-responsive" alt="Plan Offerer Logo" src="<?php echo empty($planOffererLogo)? '/admin/images/clear_pix.gif': $planOffererLogo; ?>">	
			</div>  
			<div class="col-sm-8">  
			  
				<label for="plan_feature_offerer">Plan Offeres</label>
				<select type="submit" id="plan_feature_offerer" class="form-control">
				<?php 
				 foreach ( $pOArray as $k => $v ) {
					 echo '<option '.($planOffererId ==$v['rpo_id']? 'selected ':'').'value="'.$v['rpo_id'].'">'.$v['rpo_company'].'</option>';
				 }
				?>
				</select>
			  
			</div>  
		  </div>
          <table class="table table-striped table-bordered" id="plan_features_table">
            <thead>
              <th>ID</th>
              <th>Feature</th>
              <th>Description</th>
              <th>Display?</th>
              <th>Active?</th>
              <th></th>
            </thead>
            <?php foreach($pFArray as $key => $value){ 
              echo 
                '<tr>
				  
                  <td>'.$value['lpf_id'].'</td>
                  <td>'.$value['lpf_feature'].'</td>
                  <td>'.$value['lpf_description'].'</td>
                  <td>'.($value['lpf_display'] == 1?'<span style="color:green">Yes</span>':'<span style="color:red">No</span>').'</td>
                  <td>'.($value['lpf_active'] == 1?'<span style="color:green">Yes</span>':'<span style="color:red">No</span>').'</td>
                  <td><a href="plan-features?rpo_id='.$value['rpo_id'].'&lpf_id='.$value['lpf_id'].'">select</a></td>
				  
                </tr>';
            } ?>
          </table>
        </div>
      </div>
  </div><!--end #main .container-->
</div>

<?php if (isset($currentPlanFeature['lpf_id'])) { ?>

<div class="modal fade" id="myModalHT" tabindex="-1" role="dialog" aria-labelledby="myModalHTLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header" style="background-color: #333; color: #fff;">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: #fff;"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalHTLabel">Merchant Plan List</h4>
      </div>
      <div class="modal-body">
	    
		
		<table class="table table-striped table-bordered" id="merchnat_plan_table">
            <thead>
              <th>ID</th>
              <th>Name</th>
              <th>Description</th>
              <th>Price</th>
              <th>Fee</th>
              <th><center><button class="btn btn-default" id="selectMPBtn">Add Plans</button></center></th>
            </thead>
            <?php 
			foreach($merchantPlanArray as $key => $value){ 
			  if (!in_array($key, $currentFeaturePlans))
				echo 
					'<tr>
					  
					  <td>'.$value['lmp_id'].'</td>
					  <td>'.$value['lmp_name'].'</td>
					  <td>'.$value['lmp_description'].'</td>
					  <td>$'.$value['lmp_price'].'</td>
					  <td>$'.$value['lmp_fee'].'</td>
					  <td><input type="checkbox" class="btn btn-default selectMP" data-lmpid="'.$value['lmp_id'].'" data-lmpid="'.$value['lmp_id'].'"/></td>
					  
					</tr>';
            } ?>
          </table>
		  
        
	  </div>
      <div class="modal-footer" style="background-color: #333; color: #fff;">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>		
      </div>
    </div>
  </div>
</div>

<form id="merchantPlanFeatureForm" method="POST">
	<input type="hidden" name="wnu_lpf_id_r" value="<?php echo $currentPlanFeature['lpf_id']; ?>"/>
	<input type="hidden" name="wnu_lmp_id_r"/>
	<input type="hidden" name="txt_mfc_count_r" value="0"/>
	<div style="display:none;">
		<input name="delete_ckeckbox" id="deleteCkeckbox" type="checkbox"/>
	</div>
</form>

<?php } ?>

<script>
$('.addMerchantPlanBtn').click(function (){
	//show popup with the list of merchant plan that have not been selected by the feature	
	$('#myModalHT').modal('show');
})

$('.saveMPlanBtn').click(function (){
	if (confirm("This action will link this merchant plan to the current selected plan feature. Do you want to continue?")){
		var currentForm = $('#merchantPlanFeatureForm');		
		currentForm.find('input:eq(1)').val($(this).data('lmpid'));
		currentForm.find('input:eq(2)').val( $('.saveMPlanBtn_'+$(this).data('lmpid')).val() );
		currentForm.submit();
	}
})

var planIdList = [0];

$('#selectMPBtn').click(function (){
	if (confirm("This action will link these merchant plans to the current selected plan feature. Do you want to continue?")){
		var currentForm = $('#merchantPlanFeatureForm');		
		//currentForm.find('input:eq(1)').val($(this).data('lmpid'));
		currentForm.find('input:eq(2)').val(0);
		currentForm.submit();
	}
})

$('.selectMP').click(function (){	
	var actualCheckBox = $(this);
	if (actualCheckBox.is(':checked')){
		
		planIdList.push(actualCheckBox.data('lmpid'));
		
	}
	else {
		for ( var i = 0; i < planIdList.length; i++ ) {
			if (typeof planIdList[i] != 'undefined' && planIdList[i] == actualCheckBox.data('lmpid')) {
				delete planIdList[i];
			}
		}
	}
	$('#merchantPlanFeatureForm').find('input:eq(1)').val(planIdList.toString());
})

$('.deleteMPlanBtn').click(function (){
	if (confirm("This action will remove the current selected plan feature from this merchant plan. Do you want to continue?")){
		var currentForm = $('#merchantPlanFeatureForm');		
		currentForm.find('input:eq(1)').val($(this).data('lmpid'));
		currentForm.find('input:eq(2)').val('0');
		currentForm.find('#deleteCkeckbox').prop('checked', true);
		currentForm.submit();
	}
})

$("#plan_feature_offerer").change(function () {
	window.location.href = "plan-features?rpo_id="+$(this).val();
})

$(document).ready(function(){
  // access get variables with javascript
  var $_GET = <?php echo json_encode($_GET); ?>;
  
  $('#plan_merchant_plans').dataTable({
    "columns": [
        null,
        null,        
        {'orderable': false, 'sortable': false}
        ],
	"bPaginate": false,	
    "order": [[ 1, 'asc' ]]
  });
	
  $('#merchnat_plan_table').dataTable({
    "columns": [
        null,
        null,
        null,
        null,
        null,
        {'orderable': false, 'sortable': false}
        ],
    "order": [[ 1, 'asc' ]]
  });	
  
  $('#plan_features_table').dataTable({
    "columns": [
        null,
        null,
        null,
        null,
        null,
        {'orderable': false, 'sortable': false}
        ],
    "order": [[ 1, 'asc' ]]
  });
});
</script>

<?php
require 'footer.php';
/* EOF ?> */