<?php
require '../app/start_session.php';
require '../app/class.variables.php';


if ( $_SERVER['REQUEST_METHOD'] == 'POST' && isset( $_SESSION['user']['admin']['adm_master'] ) && $_SESSION['user']['admin']['adm_master'] ) {
	if ( isset( $_POST['justSetNewDbSession'] ) ) {
		$_SESSION['NewDatabase'] = isset($_SESSION['NewDatabase'])? !$_SESSION['NewDatabase'] :true;
	}
	else {
		/*Populating tbl_product and price form lt_plan_features*/	
		$qry = $dbo->prepare( '
		
			DELETE FROM `tbl_product`;
			DELETE FROM `tbl_package`;
			DELETE FROM `tbl_prod_price`;
			DELETE FROM `tbl_prod_offerer`;
			DELETE FROM `tbl_transaction`;
			DELETE FROM `tbl_prod2trans`;
			DELETE FROM `tbl_prod2pack`;
			DELETE FROM `tbl_prod2reseller`;
			DELETE FROM `tbl_use_count`;
			ALTER TABLE tbl_product AUTO_INCREMENT = 1;
			ALTER TABLE tbl_package AUTO_INCREMENT = 1;
			ALTER TABLE tbl_prod_price AUTO_INCREMENT = 1;
			ALTER TABLE tbl_prod_offerer AUTO_INCREMENT = 1; 
			ALTER TABLE tbl_transaction AUTO_INCREMENT = 1;		
			UPDATE lt_merchant_billing SET tr_id = NULL;
			' );	
		$qry->execute();
		
		$qry = $dbo->prepare( '
			SELECT * FROM `lt_plan_features`' );	
		$qry->execute();
		$pList = $qry->fetchAll( PDO::FETCH_ASSOC );
		$tmpLtPlanFeatureArr = array(); $merchantTransactions = [];
		if( !empty( $pList ) ) {
			foreach ( $pList as $k => $value ) {
				$qry = $dbo->prepare( '
					INSERT IGNORE INTO `tbl_product` ( prod_keyword, lpf_id, prod_active, prod_name, prod_descript, ofr_id ) VALUES ( :keyword, :id, :act, :name, :desc, :offid )' );
				$qry->bindValue( ':name', $value['lpf_feature'], PDO::PARAM_STR );	
				$qry->bindValue( ':id', $value['lpf_id'], PDO::PARAM_INT );	
				$qry->bindValue( ':desc', $value['lpf_description'], PDO::PARAM_STR );	
				$qry->bindValue( ':offid', $value['rpo_id'], PDO::PARAM_INT );	
				$qry->bindValue( ':act', intval($value['lpf_active']), PDO::PARAM_INT );
				$qry->bindValue(':keyword', $value['lpf_keyword'], PDO::PARAM_STR);	
				$qry->execute();
				
				$prodId = $dbo->lastInsertId();

				if ($prodId) {
					$tmpLtPlanFeatureArr[$value['lpf_id']] = $prodId;
				}
			}
			
		}
		
		$qry = $dbo->prepare( 'SELECT FCN.* FROM `lt_feature_cnt` FCN INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=FCN.ltb_id' );
		$qry->execute();
		$pList = $qry->fetchAll( PDO::FETCH_ASSOC );
		
		if( !empty( $pList ) ) {
			foreach ( $pList as $k => $value ) {
				
				if ( isset( $tmpLtPlanFeatureArr[$value['lpf_id']] ) ) {			
					$qry = $dbo->prepare( '
						INSERT IGNORE INTO `tbl_use_count` ( prod_id, ltb_id, use_count ) VALUES ( :prod_id, :ltb_id, :use_count )' );
					$qry->bindValue( ':prod_id', $tmpLtPlanFeatureArr[$value['lpf_id']], PDO::PARAM_INT );
					$qry->bindValue( ':ltb_id', $value['ltb_id'], PDO::PARAM_INT );
					$qry->bindValue( ':use_count', $value['lfc_count'], PDO::PARAM_INT );
					$qry->execute();
				}
				
			}
			
		}
		
		$qry = $dbo->prepare( '
			SELECT POF.* FROM tbl_plan_offerer POF' );	
		$qry->execute();
		$pList = $qry->fetchAll( PDO::FETCH_ASSOC );
		
		if( !empty( $pList ) ) {
			foreach ( $pList as $k => $value ) {
				$qry = $dbo->prepare( '
					INSERT INTO `tbl_prod_offerer` ( ofr_id, ofr_company, ofr_logo ) VALUES ( :id, :name, :logo )' );
				$qry->bindValue(':id', $value['rpo_id'], PDO::PARAM_INT);
				$qry->bindValue(':name', $value['rpo_company'], PDO::PARAM_STR);
				$qry->bindValue(':logo', $value['rpo_logo'], PDO::PARAM_STR);				
				$qry->execute();
			}	
		}
		
		$qry = $dbo->prepare( '
			SELECT OFRC.OffCount, T4MY.lmp_id AS T4MY_lmp_id, POF.*, PLF.lpf_id, PLF.lpf_display, PLF.lpf_active, PLF.lpf_keyword, MFC.mfc_count, MPL.lmp_custom_terms, MPL.lmp_custom_breakdown, MPL.lmp_featured, MPL.lmp_billing_delay, MPL.lmp_admin_name, MPL.lmp_active, MPL.lmp_price, MPL.lmp_id, MPL.lmp_fee, MPL.lmp_name, MPL.lmp_description
			FROM lt_max_feature_cnt MFC
			INNER JOIN lt_plan_features PLF ON PLF.lpf_id = MFC.lpf_id
			INNER JOIN tbl_plan_offerer POF ON PLF.rpo_id = POF.rpo_id
			INNER JOIN lt_merchant_plans MPL ON MPL.lmp_id = MFC.lmp_id
			LEFT JOIN (
				SELECT DISTINCT P2R.lmp_id
				FROM lt_plans2reseller P2R
				INNER JOIN tbl_reseller RES ON P2R.res_id=RES.res_id
				INNER JOIN tbl_4mystore T4M ON RES.res_id=T4M.res_id
			) T4MY ON T4MY.lmp_id = MPL.lmp_id
			LEFT JOIN (
				SELECT COUNT(DISTINCT lt_plan_features.rpo_id) AS OffCount, lt_merchant_plans.lmp_id
				FROM lt_max_feature_cnt 
				INNER JOIN lt_plan_features  ON lt_plan_features.lpf_id = lt_max_feature_cnt.lpf_id			
				INNER JOIN lt_merchant_plans  ON lt_merchant_plans.lmp_id = lt_max_feature_cnt.lmp_id
				GROUP BY lt_merchant_plans.lmp_id
			) OFRC ON OFRC.lmp_id = MPL.lmp_id
			ORDER BY MPL.lmp_id' );	
		$qry->execute();
		$pList = $qry->fetchAll( PDO::FETCH_ASSOC );
		
		if( !empty( $pList ) ) {
			
			/*Entering plans to tbl_product, tbl_prod2pack, tbl_prod_price*/
			
			$tmpLmpArr = array(); $tmpRpoArr = array(); $tmpLmpRpoArr = array(); $tmpRpoLpfArr=array(); $tmpLmpLpfArr=array();
			
			foreach ( $pList as $k => $value ) {			
				
				if ( isset( $value['lmp_id'] ) && !isset( $tmpLmpArr[$value['lmp_id']] ) ) {				
					$qry = $dbo->prepare( '
						INSERT IGNORE INTO `tbl_product` ( lmp_id, prod_name, prod_active, prod_descript, ofr_id ) VALUES ( :id, :name, :act, :desc, :offid )' );
					$qry->bindValue(':id', $value['lmp_id'], PDO::PARAM_INT);
					$qry->bindValue(':name', $value['lmp_name'], PDO::PARAM_STR);
					$qry->bindValue(':desc', $value['lmp_description'], PDO::PARAM_STR);
					$qry->bindValue(':act', intval($value['lmp_active']), PDO::PARAM_INT);
					$qry->bindValue(':offid', $value['rpo_id'], PDO::PARAM_INT);				
					$qry->execute();				
					
					//$tmpLmpArr[$value['lmp_id']] = 0;
					$prodId = $dbo->lastInsertId();
					
					if ($prodId) {
						$qry = $dbo->prepare( '
							INSERT IGNORE INTO `tbl_package` ( pk_id, tem_id, pk_terms, pk_more_info, pk_internal_name ) VALUES ( :id, :temId, :lmp_custom_terms, :lmp_custom_breakdown, :lmp_admin_name )' );
						$qry->bindValue(':id', $prodId, PDO::PARAM_INT);				
						$qry->bindValue(':temId', $value['tem_id'], PDO::PARAM_INT);
						$qry->bindValue(':lmp_admin_name', empty($value['lmp_admin_name'])?null:$value['lmp_admin_name'], PDO::PARAM_STR);
						$qry->bindValue(':lmp_custom_terms', $value['lmp_custom_terms'], PDO::PARAM_STR);
						$qry->bindValue(':lmp_custom_breakdown', $value['lmp_custom_breakdown'], PDO::PARAM_STR);				
						$qry->execute();
						
						//updating the pk_id value in "lt_member_merchants" from the plan they are currently under
						$qry = $dbo->prepare( '
							UPDATE lt_member_merchants SET pk_id = :pk_id WHERE lmp_id=:lmp_id' );
						$qry->bindValue(':pk_id', $prodId, PDO::PARAM_INT);				
						$qry->bindValue(':lmp_id', $value['lmp_id'], PDO::PARAM_INT);				
						$qry->execute();
						
						$tmpLmpArr[$value['lmp_id']] = $prodId;
						
						if ( !empty( $value['lmp_price'] ) && !empty( $value['lmp_fee'] ) ) {
							
							$qry = $dbo->prepare( '
								INSERT INTO `tbl_prod_price` ( prod_id, ppr_price, ppr_setup ) VALUES ( :id, :price, :setup )' );
							$qry->bindValue(':id', $prodId, PDO::PARAM_INT); 	
							$qry->bindValue(':price', $value['lmp_price'], PDO::PARAM_STR);
							$qry->bindValue(':setup', $value['lmp_fee'], PDO::PARAM_STR);					
							$qry->execute();
							$prodPriceId = $dbo->lastInsertId();
							
							/*Query the table lt_merchant_billing using the lmp_id and populate table tbl_transaction and tbl_prod2trans from there*/					
							
							$qry = $dbo->prepare( '
								SELECT BILL.*, MER.ltb_id
								FROM lt_merchant_billing BILL
								INNER JOIN lt_merchants MER ON BILL.ltm_id = MER.ltm_id
								WHERE BILL.lmp_id = :id
								ORDER BY MER.ltb_id, BILL.bill_cyclestart' );
							$qry->bindValue(':id', $value['lmp_id'], PDO::PARAM_INT);	
							$qry->execute();
							$billingList = $qry->fetchAll( PDO::FETCH_ASSOC );
							
							if( !empty( $billingList ) ) {
								foreach ( $billingList as $billKey => $billValue ) {
									$flag = true;
									if (isset($merchantTransactions[$billValue['ltb_id']]))
										foreach ($merchantTransactions[$billValue['ltb_id']] as $billId => $billArr) {
											if ( $billArr['bill_cycleend'] == $billValue['bill_cyclestart'] && $prodPriceId == $merchantTransactions[$billValue['ltb_id']][$billId]['ppr_id']) {
												//same transaction different billing
												
												$cartId = $merchantTransactions[$billValue['ltb_id']][$billId]['tr_id'];
												$flag = false;
												break;
												
											}
										}
									if ($flag) {
										$qry = $dbo->prepare( '
											INSERT INTO tbl_transaction (ltb_id, tr_session_id, tr_type) VALUES (:ltb_id, :sId, "checkout")' );
										$qry->bindValue(':sId', uniqId(), PDO::PARAM_STR);	
										$qry->bindValue(':ltb_id', $billValue['ltb_id'], PDO::PARAM_INT);
										$qry->execute();							
										$cartId = $dbo->lastInsertId();
										$merchantTransactions[$billValue['ltb_id']][$billValue['bill_id']]['bill_cycleend'] = $billValue['bill_cycleend'];
										$merchantTransactions[$billValue['ltb_id']][$billValue['bill_id']]['tr_id'] = $cartId;
										$merchantTransactions[$billValue['ltb_id']][$billValue['bill_id']]['ppr_id'] = $prodPriceId? $prodPriceId: 0;
									}	
									
									
									if ( $cartId && $prodPriceId ) {
										$qry = $dbo->prepare( '
										INSERT IGNORE INTO tbl_prod2trans (dsc_id, tr_id, ppr_id, p2t_prod_count, p2t_datetime, bill_id) VALUES (:dscid, :cid, :pid , 1, NOW(), :bid)' );
										$qry->bindValue(':cid', $cartId, PDO::PARAM_INT);
										$qry->bindValue(':pid', $prodPriceId, PDO::PARAM_INT);
										$qry->bindValue(':bid', $billValue['bill_id'], PDO::PARAM_INT);
										$qry->bindValue(':dscid', $billValue['dsc_id'], PDO::PARAM_INT);
										$qry->execute();
									}
									
									if ( $cartId ) {
										$qry = $dbo->prepare( '
										UPDATE lt_merchant_billing SET tr_id=:cid WHERE bill_id =:bid' );
										$qry->bindValue(':cid', $cartId, PDO::PARAM_INT);	
										$qry->bindValue(':bid', $billValue['bill_id'], PDO::PARAM_INT);
										$qry->execute();
									}
									
								}
								
								//populate the tables tbl_transaction and tbl_prod2trans
								
							}
							
							/*End table tbl_transaction and tbl_prod2trans population from "lt_merchant_billing"*/
							
						}
					}		
				}
				
				/*
				if ( intval( $tmpLmpArr[$value['lmp_id']] ) !== intval( $prodId ) )
					$qry = $dbo->prepare( '
						INSERT IGNORE INTO `tbl_prod2pack` ( prod_id, pk_id, ppk_count ) VALUES ( :id, :id, 1 )' );
					$qry->bindValue(':id', $prodId, PDO::PARAM_INT); 					
					$qry->execute();
				*/
				
				if ( 
						isset($value['rpo_id'],$value['T4MY_lmp_id'], $tmpLmpArr[$value['lmp_id']])
					&& !isset($tmpRpoArr[$value['rpo_id']])
					) {
					
					$tmpRpoArr[$value['rpo_id']] = 0;
					
					$qry = $dbo->prepare( '
						INSERT INTO `tbl_product` ( rpo_id, prod_name, prod_descript, ofr_id ) VALUES ( :id, :name, :desc, :offid )' );
					$qry->bindValue(':id', $value['rpo_id'], PDO::PARAM_INT);		
					$qry->bindValue(':name', $value['rpo_company'], PDO::PARAM_STR);	
					$qry->bindValue(':desc', null, PDO::PARAM_STR);	
					$qry->bindValue(':offid', $value['rpo_id'], PDO::PARAM_INT);	
					$qry->execute();
					
					$prodId = $dbo->lastInsertId();
					
					if ( $prodId ) {
						
						$tmpRpoArr[$value['rpo_id']] = $prodId;
						
						/*There is not price set for the offerer package
						$qry = $dbo->prepare( '
							INSERT IGNORE INTO `tbl_prod_price` ( prod_id ) VALUES ( :id )' );
						$qry->bindValue(':id', $prodId, PDO::PARAM_INT); 	
						$qry->execute();
						*/
						
						$qry = $dbo->prepare( '
							INSERT IGNORE INTO `tbl_package` ( pk_id ) VALUES ( :id )' );
						$qry->bindValue(':id', $prodId, PDO::PARAM_INT);
						$qry->execute();					
						
					}
				}
				
				if ( intval( $value['OffCount'] ) > 1 && isset($tmpLmpArr[$value['lmp_id']], $tmpRpoArr[$value['rpo_id']]) && !isset( $tmpLmpRpoArr[$value['rpo_id'].'_'.$value['lmp_id']] ) ) {
					$tmpLmpRpoArr[$value['rpo_id'] . '_' . $value['lmp_id']] = 1;
					$qry = $dbo->prepare( '
					INSERT IGNORE INTO `tbl_prod2pack` ( prod_id, pk_id, p2p_count, p2p_display_order ) VALUES ( :id, :pid, 1, :ord )' );
					$qry->bindValue(':id', $tmpRpoArr[$value['rpo_id']], PDO::PARAM_INT);
					$qry->bindValue(':pid', $tmpLmpArr[$value['lmp_id']], PDO::PARAM_INT);						
					echo $value['rpo_sort'] . '<br>';
					//$tmpLmpRpoOrderArr[$tmpLmpArr[$value['lmp_id']]] = $value['rpo_sort'];
					$qry->bindValue(':ord', $value['rpo_sort'], PDO::PARAM_INT);
					
					$qry->execute();
				}		
				
				if ( intval($value['OffCount']) > 1 && isset( $tmpRpoArr[$value['rpo_id']], $tmpLtPlanFeatureArr[$value['lpf_id']] ) ) {
					//PLF.lpf_display
					!isset($tmpRpoOrderArr[$tmpRpoArr[$value['rpo_id']]]) ? $tmpRpoOrderArr[$tmpRpoArr[$value['rpo_id']]] = 1: ++$tmpRpoOrderArr[$tmpRpoArr[$value['rpo_id']]];
					$qry = $dbo->prepare( '
						INSERT IGNORE INTO `tbl_prod2pack` ( prod_id, pk_id, p2p_count, p2p_show_in_pack, p2p_display_order) VALUES ( :id, :pid, :count, :disp, :ord)' );
					$qry->bindValue(':id', $tmpLtPlanFeatureArr[$value['lpf_id']], PDO::PARAM_INT);
					$qry->bindValue(':pid', $tmpRpoArr[$value['rpo_id']], PDO::PARAM_INT);						
					$qry->bindValue(':disp', $value['lpf_display'], PDO::PARAM_STR);
					$qry->bindValue(':count', $value['mfc_count'], PDO::PARAM_STR);				
					$qry->bindValue(':ord', $tmpRpoOrderArr[$tmpRpoArr[$value['rpo_id']]], PDO::PARAM_INT);
					$qry->execute();
				}elseif ( intval($value['OffCount']) <= 1 && isset( $tmpLmpArr[$value['lmp_id']], $tmpLtPlanFeatureArr[$value['lpf_id']] ) ) {
					!isset($tmpLmpOrderArr[$tmpLmpArr[$value['rpo_id']]]) ? $tmpLmpOrderArr[$tmpLmpArr[$value['lmp_id']]] = 1: ++$tmpLmpOrderArr[$tmpLmpArr[$value['lmp_id']]];
					$qry = $dbo->prepare( '
						INSERT IGNORE INTO `tbl_prod2pack` ( prod_id, pk_id, p2p_count, p2p_show_in_pack, p2p_display_order ) VALUES ( :id, :pid, :count, :disp, :ord)' );
					$qry->bindValue(':id', $tmpLtPlanFeatureArr[$value['lpf_id']], PDO::PARAM_INT);
					$qry->bindValue(':pid', $tmpLmpArr[$value['lmp_id']], PDO::PARAM_INT);
					$qry->bindValue(':disp', intval($value['lpf_display']), PDO::PARAM_INT);
					$qry->bindValue(':count', $value['mfc_count'], PDO::PARAM_INT);
					$qry->bindValue(':ord', $tmpLmpOrderArr[$tmpLmpArr[$value['lmp_id']]], PDO::PARAM_INT);
					
					$qry->execute();
				}
				
			}
			
			/*Populating table "tbl_prod2reseller"*/

			$qry = $dbo->prepare( '
			SELECT DISTINCT RES.res_id, T4M.fms_id, P2R.lmp_id, MPL.lmp_featured
			FROM lt_plans2reseller P2R
			INNER JOIN lt_merchant_plans MPL ON MPL.lmp_id = P2R.lmp_id
			INNER JOIN tbl_reseller RES ON P2R.res_id = RES.res_id
			LEFT JOIN tbl_4mystore T4M ON RES.res_id = T4M.res_id' );
			$qry->execute();
			$pList = $qry->fetchAll( PDO::FETCH_ASSOC );
			
			if( !empty( $pList ) ) {
				
				foreach ( $pList as $k => $value ) {
					if (isset($tmpLmpArr[$value['lmp_id']])) {
						$qry = $dbo->prepare( '
						INSERT IGNORE INTO `tbl_prod2reseller` ( prod_id, res_id, p2r_placement, p2r_featured ) VALUES ( :pid, :rid, :repl, :p2r_featured )' );
						$qry->bindValue(':pid', $tmpLmpArr[$value['lmp_id']], PDO::PARAM_INT);
						$qry->bindValue(':p2r_featured', intval($value['lmp_featured']), PDO::PARAM_INT);
						$qry->bindValue(':rid', $value['res_id'], PDO::PARAM_INT); 
						$qry->bindValue(':repl', !isset($value['fms_id'])? 'msp' : '4my.store', PDO::PARAM_STR);
						$qry->execute();
					}
				}
				
			}
			
			
			/*Populating table "tbl_featured_prod"*/
			/*
			$qry = $dbo->prepare( '
			SELECT T4MY.res_id, MPL.lmp_id
			FROM lt_merchant_plans MPL
			LEFT JOIN (
				SELECT DISTINCT P2R.lmp_id, RES.res_id
				FROM lt_plans2reseller P2R
				INNER JOIN tbl_reseller RES ON P2R.res_id=RES.res_id
				LEFT JOIN tbl_4mystore T4M ON RES.res_id=T4M.res_id	
			) T4MY ON T4MY.lmp_id = MPL.lmp_id
			WHERE MPL.lmp_featured AND T4MY.res_id IS NOT NULL' );
			$qry->execute();
			$pList = $qry->fetchAll( PDO::FETCH_ASSOC );
			
			if( !empty( $pList ) ) {			
				foreach ( $pList as $k => $value ) {
					if (isset($tmpLmpArr[$value['lmp_id']])) {					
						$qry = $dbo->prepare( '
							INSERT IGNORE INTO `tbl_featured_prod` ( prod_id, res_id ) VALUES (  :prodid, :resid  )' );
						$qry->bindValue(':prodid', $tmpLmpArr[$value['lmp_id']], PDO::PARAM_INT);
						$qry->bindValue(':resid', $value['res_id'], PDO::PARAM_INT);
						$qry->execute();
					}
				}
				
			}
			*/
			
		}
	}	
}

require 'header.php';

?>

<div class='container'>
	<div class='row'>
		<div class='col-sm-12'>
			<h1 style="text-align: center;">Populate new cart DB structure</h1>			
		</div>	
	</div>
</div>

<div class="container-fluid">
	<div class="row">
		<div class="col-xs-12">
			<form id="populateCartDB" method="post">
				<div class="row">
					<div class="col-xs-6">
						<button type="submit" name="justSetNewDbSession" class="btn btn-block btn-danger">Turn <?php echo isset($_SESSION['NewDatabase']) && $_SESSION['NewDatabase']?'Off':'On';?> New DB</button>
					</div>
					<div class="col-xs-6">
						<button type="submit" id="populateCartDBBtn" class="btn btn-block btn-default">Populate New DB</button>
					</div>
				</div>	
			</form><br>';
		</div>
	</div>
</div>

<?php

	require 'footer.php';
	
?>