<?php
require '../app/start_session.php';
require '../app/class.product.php';

$productObj = new App\Product\product($dbo);

/*if (isset($_GET['search']))*/ $productObj->filterProducts($_GET);

/*Begin AJAX*/
$requestBody = null;

if ( $_SERVER['REQUEST_METHOD'] == 'POST' && isset( $_SESSION['user']['admin']['adm_id'] )  ) {
	$requestBody = @json_decode( file_get_contents('php://input'), true );
}

if ( $requestBody !== null && json_last_error() == JSON_ERROR_NONE ) {
	if ( isset( $requestBody['offererName'] ) ) {
		$_response = $productObj->getProductOfferers($requestBody['offererName']); 
	}	
	elseif (isset($requestBody['ppr_id'])) {
		$productObj->deletePrice( $requestBody['ppr_id'] );		
	}
	elseif (isset($requestBody['prod_id'], $requestBody['prod_name'], $requestBody['prod_descript'], $requestBody['prod_count_type'])) {		
		$_response['updated'] = $productObj->updateProduct($requestBody, $_response['Error']);
	}
	elseif ( isset( $requestBody['prod_id'], $requestBody['ofr_id'] ) ) {
		$_response['updated'] = $productObj->changeProvider($requestBody['prod_id'], $requestBody['ofr_id'], $_response['Error']);				
	}
	elseif ( isset( $requestBody['prod_id'], $requestBody['ppr_price'], $requestBody['ppr_setup'] ) ) {	
		$_response['added'] = $productObj->addPrice($requestBody, $requestBody['prod_id'], $_response['Error']);
		
	}
	elseif ( isset( $requestBody['prod_id'] ) ) {
		$productObj->filterProducts($requestBody, true);
		$tmpResponse = $productObj->getRecords();			
		$_response = array();
		foreach ($tmpResponse as $v) {
			$_response = $v;
		}
		if (isset($requestBody['get_ofrs']) && $requestBody['get_ofrs']) {
			$_response['providers'] = $productObj->getProviders();
		}
		
		if (isset($requestBody['get_prices']) && $requestBody['get_prices']) {
			$_response['prices'] = $productObj->getPrices($requestBody['prod_id']);
		}
		
	}
	
	echo json_encode( $_response );
	
}

/*End AJAX*/

else{
/*Begin Page Data*/

$pageCSS = '/admin/css/products.css'; //this css is included in the header
require 'header.php';
?>
<div class='container'>
	<div class='row'>
		<div class='col-sm-12'>
			<h1>Products</h1>			
		</div>	
	</div>
</div>

<div class="modal fade" id="globalModal" tabindex="-1" role="dialog" aria-labelledby="globalModalLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="globalModalLabel"></h4>
      </div>
      <div class="modal-body">
	    <div id="resultMessage"></div>
		<div id="contentBody"></div>
	  </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>		
      </div>
    </div>
  </div>
</div>

<div class="container-fluid">
	<div class="row">
		<div class="col-xs-12">
			<div id="search_wrap">
			    <div class="row">
			    	<form method="get" id="search-form">
						<input type="hidden" id="ofr_id" name="ofr_id" value="<?php echo (isset($_GET['ofr_id'])?$_GET['ofr_id']:"");?>">						
					    <div class="col-sm-2">
		    				<div class="form-group">
			    				<label for="prod_id">Product #</label>
			    				<input type="text" class="form-control input-sm" id="prod_id" name="prod_id" value="<?php echo (isset($_GET['prod_id'])?$_GET['prod_id']:"")?>" placeholder="Product #">
			    				
		    				</div>
						</div>
						<div class="col-sm-4">
		    				<div class="form-group">
			    				<label for="prod_name">Product Name</label>
			    				<input class="form-control input-sm" type="text" value="<?php echo (isset($_GET['prod_name'])?$_GET['prod_name']:"")?>" placeholder="Product Name" id="prod_name" name="prod_name">			    				
		    				</div>
						</div>
						<div class="col-sm-4">
		    				<div class="form-group">
			    				<label for="prod_keyword">Product Keyword</label>
			    				<input type="text" class="form-control input-sm" id="prod_keyword" name="prod_keyword" value="<?php echo (isset($_GET['prod_keyword'])?$_GET['prod_keyword']:"")?>" placeholder="Product Keyword">			    				
		    				</div>
						</div>
						<div class="col-sm-2">
							<div class="form-group">
								<label for="ofr_company">Offerer</label>
								<input list="offererNames" class="form-control input-sm" type="text" name="ofr_company" value="<?php echo (isset($_GET['ofr_company'])?$_GET['ofr_company']:"")?>" placeholder="Offerer Name" id="ofr_company"/>
								<datalist id="offererNames"></datalist>			    				
							</div>
						</div>
											
				</div>
				    	<div class="row">
				    		<div class="col-sm-12">
								<input type="hidden" name="search" value="1">
								<button class="btn btn-sm btn-primary form-control"><span class='glyphicon glyphicon-search'></span> Search</button>
							</div>
						</div>
					</form>
			</div>
		</div>
		
		<div class="col-xs-12">
			<table id="results_table" class="table table-bordered table-striped datatable" style="margin-top:15px;">
				<thead>
					<tr>
						<th>Product #</th>
						<th>Product Name</th>	
						<th>Product Description</th>
						<th>Keyword</th>
						<th>Count Type</th>
						<th>Active</th>
						<th>Options</th>
						
					</tr>
				</thead>
				<tbody>
					<?php $currentParams= isset($_GET)? $_GET: '{}'; if (isset($currentParams['url1'])) unset($currentParams['url1']); $currentParams = empty($currentParams)? '{}' : json_encode($currentParams); echo $productObj->getTableRowsOutput (); ?>
				</tbody>
			</table>
		</div>
	</div>
</div>
<script>
	_pageObj = {
		page: 'products',
		get:<?php echo $currentParams; ?>, 
		flag: false,
		buildUrl: function () {
			var str='';
			for (var i in this.get) {
				if ( this.get.hasOwnProperty(i) ) {
					str += (str==''?'?':'&')+i+'='+this.get[i];
				}
			}
			console.log(str);
			return str;
		}
	};

</script>
<script src="../plugins/check-form-inputs.js"></script>
<script src="js/products.js"></script>

<?php
require 'footer.php';
}/*End Page Data*/
?>