<?php
require '../app/start_session.php';
require '../app/function.get-subdir.php';
$dbo=connect();

if ( $_SERVER['REQUEST_METHOD'] == 'GET' ){
	/* Handle Merchant Search */
	if ($stmt = $dbo->prepare("
	SELECT 
	LTM.ltm_company_name, LTM.ltm_id, LTM.ltb_id, CONCAT(LTM.ltm_city,', ', LTM.ltm_state) AS ltm_state,
	MMR.ltb_email, MMR.ltb_phone_number, MMR.ltb_contact_name, MMR.ltb_header_image,
	RES.res_name,
	LMP.lmp_name,
	BILL.bill_date 
	
	FROM lt_merchants LTM
	INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=LTM.ltb_id
	INNER JOIN tbl_reseller RES ON RES.res_id=MMR.res_id
	INNER JOIN lt_merchant_plans LMP ON LMP.lmp_id=MMR.lmp_id 
	INNER JOIN lt_merchant_billing BILL ON LTM.ltm_id=BILL.ltm_id 
	ORDER BY BILL.bill_id DESC

	LIMIT 100")){
		$stmt->execute();
		$stmt = $stmt->fetchAll( PDO::FETCH_ASSOC );

		$results = '';
		foreach ($stmt as $k=>$v){
			$results .= '<tr>';
			$results .=   '<td>'.$v['ltm_id'].'</td>';
			$results .=   '<td>'.$v['ltm_company_name'].'</td>';
			$results .=   '<td>'.$v['ltb_contact_name'].'</td>';
			$results .=   '<td>'.$v['ltb_email'].'</td>';
			$results .=   '<td>'.$v['ltb_phone_number'].'</td>';
			$results .=   '<td>'.$v['lmp_name'].'</td>';
			$results .=   '<td>'.date('Y-m-d', strtotime($v['bill_date'])).'</td>';
			$results .=   '<td>'.$v['res_name'].'</td>';					
			$results .=   '<td>'.($_SESSION["user"]["admin"]["adm_master"]?'<form method="POST" style="display:inline-block;"><input type="hidden" name="ltm_id" value="'.$v['ltm_id'].'"><input type="hidden" name="mystore_login" value="1"><button type="submit" class="btn btn-danger btn-xs"><span class="glyphicon glyphicon-home"></span></button></form> ':'').'<form method="POST" action="mystore-csr-jump" style="display:inline-block;"><input type="hidden" name="ltm_company_name" value="'.$v['ltm_company_name'].'"><input type="hidden" name="ltm_id" value="'.$v['ltm_id'].'"><button type="submit" class="btn btn-primary btn-xs"><span class="glyphicon glyphicon-home"></span></button></form> <a href="merchant-edit?wnu_ltb_id='.$v['ltb_id'].'"><button type="button" class="btn btn-primary btn-xs"><span class="glyphicon glyphicon-edit"></span></button></a></td>';
			$results .= '</tr>';
		}
	}
}

/* Handle MyStore login */
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_REQUEST['mystore_login']) && isset($_REQUEST['ltm_id']) && preg_match('/^[0-9]+$/',$_REQUEST['ltm_id']) && $_SESSION["user"]["admin"]["adm_master"]){


	$qry = $dbo->prepare( "
		SELECT MMR.*
		FROM lt_merchants LTM
		INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=LTM.ltb_id
		WHERE LTM.ltm_id=:id LIMIT 1" );
		$qry->bindValue(':id', $_REQUEST['ltm_id'], PDO::PARAM_INT);
		$qry->execute();
	if ($usr = $qry->fetch(PDO::FETCH_ASSOC)){
		$m = $dbo->prepare( 'SELECT ltm_id,ltm_company_name FROM `lt_merchants` WHERE ltb_id=:id' );
		$m->bindValue( ':id', $usr['ltb_id'], PDO::PARAM_INT );
		$m->execute();
		$merchant = $m->fetch(PDO::FETCH_ASSOC);
		$r = $dbo->prepare( 'SELECT res_name FROM `tbl_reseller` WHERE res_id=:id' );
		$r->bindValue( ':id', $usr['res_id'], PDO::PARAM_INT );
		$r->execute();
		$reseller = $r->fetch(PDO::FETCH_ASSOC);
		$c = $dbo->prepare( 'SELECT COUNT(ltb_id) FROM `lt_promos` WHERE ltb_id=:id' );
		$c->bindValue( ':id', $usr['ltb_id'], PDO::PARAM_INT );
		$c->execute();
		$count = $c->fetch(PDO::FETCH_ASSOC);

		// new plan structure
		$p = 'SELECT LMP.lmp_id, LMP.lmp_name, LMP.pty_id, LPF.lpf_feature, LPF.lpf_id, MFC.mfc_count
		FROM lt_merchant_plans LMP 
		INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id 
		LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
		WHERE LMP.lmp_id = :lmp_id AND LPF.lpf_active = 1 AND (MFC.ltb_id IS NULL OR MFC.ltb_id = :ltb_id) ORDER BY MFC.ltb_id ASC';
		$p = $dbo->prepare( $p );
		$p->bindValue(':lmp_id', $usr['lmp_id'], PDO::PARAM_INT);
		$p->bindValue(':ltb_id', $usr['ltb_id'], PDO::PARAM_INT);
		$p->execute();
		$p = $p->fetchAll(PDO::FETCH_ASSOC);
		foreach ($p as $k => $v) {
		  if (!$results){
		    $results = array(
		      'lmp_id'                => $v['lmp_id'],
		      'pty_id'                => $v['pty_id'],
		      'lmp_name'              => $v['lmp_name'],
		    );
		    $results['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
		  } 
		  else {
		    // this will overwrite the default plan values with custom merchant values 
		    $results['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
		  }
		}
		$plan = $results;

		$_SESSION['user']['merchant']['ltm_id']               = $merchant['ltm_id'];
		$_SESSION['user']['merchant']['ltm_company_name']     = $merchant['ltm_company_name'];
		$_SESSION['user']['merchant']['res_name']             = $reseller['res_name'];
		$_SESSION['user']['merchant']['res_id']               = $usr['res_id'];
		$_SESSION['user']['merchant']['tmp_id']               = $usr['tmp_id'];
		$_SESSION['user']['merchant']['promo_count']          = $count['COUNT(ltb_id)'];
		$_SESSION['user']['merchant']['plan']                 = $plan;
		$_SESSION['user']['merchant']['date']                 = date( 'm/d/Y' );
        $_SESSION['user']['merchant']["ltb_id"]               = $usr["ltb_id"];
		$_SESSION['user']['merchant']["ltb_email"]            = $usr["ltb_email"];

		header('Location: /mystore');
	}
}


require 'header.php';
?>
<style>
.errors {color: red;font-size: 11px;display:inline-block;}
h1 {text-align: center;}
#results_table th {
	text-align:center !important;
}

</style>
<div class='container-fluid'>
	<div class='row'>
		<div class='col-sm-12'>
			<h1><a href="merchant-search"><span class='glyphicon glyphicon-search'></span> Recient Merchant Signups</a></h1>
		</div>
	</div>
</div>

<div class="container-fluid">
	<div class="row">
		<div class="col-xs-12">
			<table id="results_table" class="table table-bordered table-striped datatable" style="margin-top:15px;">
				<thead class = "dt-head-center">
					<tr>
						<th>Acct #</th>
						<th>Company Name</th>
						<th>Contact</th>
						<th>Email</th>
						<th>Phone</th>						
						<th>Plan Type</th>
						<th>Sign up Date</th>
						<th>Reseller</th>
						<th>Options</th>
					</tr>
				</thead>
				<tbody>
					<?php echo $results; ?>
				</tbody>
			</table>
		</div>
	</div>
</div>

<script>
$(document).ready(function(){
	table = $('#results_table').dataTable({
		"order": [[ 6, "desc" ]]
	});
});
</script>

<?php require 'footer.php'; ?>
