<?php
require '../app/start_session.php';
$dbo=connect();

function checkPlanFeatures($lpf_id, $features_array, $dbo){
  $results = array('hasFeature'=> false, 'count'=> $features_array[$lpf_id]['mfc_count'], 'name'=> $features_array[$lpf_id]['lpf_feature']);
  $present = array_search($lpf_id, array_map(function($v){return $v['lpf_id'];}, $features_array));
  if ($present) {
    $results['hasFeature'] = true;
  }
  return $results;
}


if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_SESSION['user']['admin']['adm_id'], $_REQUEST['lmp_id']) && is_numeric($_REQUEST['lmp_id'])){
  // get possible welcome emails
  $qry = 'SELECT TEM.tem_id, TEM.tem_path, TEM.tem_label FROM tbl_emails TEM';
  $qry = $dbo->prepare($qry);
  $qry->execute();
  $welcome_emails = $qry->fetchAll(PDO::FETCH_ASSOC);

  // echo '<pre>';
  // var_dump($welcome_emails);
  // echo '</pre>';

  // get plan
  $p = 'SELECT LMP.lmp_id, LMP.lmp_name, LMP.lmp_admin_name, LMP.lmp_active, LMP.pty_id, LMP.lmp_price, LMP.lmp_fee, LMP.lmp_billing_delay, LMP.lmp_description, LMP.lmp_featured, LPF.lpf_feature, LPF.lpf_id, MFC.mfc_count, TEM.tem_id, TEM.tem_path, TEM.tem_label
  FROM lt_merchant_plans LMP
  INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id
  LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
  LEFT JOIN tbl_emails TEM ON LMP.tem_id = TEM.tem_id
  WHERE LMP.lmp_id = :lmp_id AND LPF.lpf_active = 1 AND MFC.ltb_id IS NULL ORDER BY MFC.ltb_id ASC';
  $p = $dbo->prepare( $p );
  $p->bindValue(':lmp_id', $_REQUEST['lmp_id'], PDO::PARAM_INT);
  $p->execute();
  $p = $p->fetchAll(PDO::FETCH_ASSOC);
  foreach ($p as $k => $v) {
    if (!$results){
      $results = array(
        'lmp_id'                => $v['lmp_id'],
        'pty_id'                => $v['pty_id'],
        'lmp_name'              => $v['lmp_name'],
        'lmp_admin_name'        => $v['lmp_admin_name'],
        'lmp_price'             => $v['lmp_price'],
        'lmp_fee'               => $v['lmp_fee'],
        'lmp_billing_delay'     => $v['lmp_billing_delay'],
        'lmp_description'       => $v['lmp_description'],
        'lmp_featured'          => $v['lmp_featured'],
        'lmp_active'            => $v['lmp_active'],
        'tem_id'                => $v['tem_id'],
        'tem_path'              => $v['tem_path'],
        'tem_label'             => $v['tem_label']
      );
      $results['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
    }
    else {
      $results['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
    }
  }
  $res = $results;


  $plan_features = array(
    'offers_site'  => checkPlanFeatures(1, $res['lmp_features'], $dbo),
    'phone_app'  => checkPlanFeatures(2, $res['lmp_features'], $dbo),
    'geo_location'  => checkPlanFeatures(3, $res['lmp_features'], $dbo),
    'business_listing'  => checkPlanFeatures(4, $res['lmp_features'], $dbo),
    'marketing_materials' => checkPlanFeatures(5, $res['lmp_features'], $dbo),
    'national_mall' => checkPlanFeatures(6, $res['lmp_features'], $dbo),
    'service_time' => checkPlanFeatures(7, $res['lmp_features'], $dbo),
    'consumer_reports' => checkPlanFeatures(8, $res['lmp_features'], $dbo),
    // 'catalog_pts'  => checkPlanFeatures(9, $res['lmp_features'], $dbo),
    'screcials'  => checkPlanFeatures(10, $res['lmp_features'], $dbo),
    'max_promos' => checkPlanFeatures(11, $res['lmp_features'], $dbo),
    'signup_incentives'  => checkPlanFeatures(12, $res['lmp_features'], $dbo),
    'max_emails'   => checkPlanFeatures(13, $res['lmp_features'], $dbo),
    'max_texts'   => checkPlanFeatures(14, $res['lmp_features'], $dbo),
    'max_push'     => checkPlanFeatures(15, $res['lmp_features'], $dbo),
    // 'max_cat'  => checkPlanFeatures(16, $res['lmp_features'], $dbo),
    'max_key'    => checkPlanFeatures(17, $res['lmp_features'], $dbo),
    'max_drafts' => checkPlanFeatures(18, $res['lmp_features'], $dbo),
    'displayed_active_promos' => checkPlanFeatures(19, $res['lmp_features'], $dbo)
  );

} else {
  header('Location: /admin');
}

require 'header.php';
?>
<style>
#alert{
  text-align: center;
  position: fixed;
  top: 25%;
  z-index: 10;
  width: 50%;
  left: 25%;
  right: 50%;
  display: none;
  -webkit-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
  -moz-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
  box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
}
.lt_alerts{
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  background: rgba(5,155,5,1);
  color: #fff;
  text-align: center;
  padding: 10px;
  font-size: 32px;
}
</style>
<div id="adm_body">
  <div id='main' class='container'>
    <div class='row'>
      <div class='col-md-12'>
        <h1><a href="reseller-manage-plans"><span class='glyphicon glyphicon-tower'></span> Manage Reseller Plans</a></h1>
        <?php
          if (is_Array($error)) {
            echo "<div id='push_errors' class='alert alert-danger'><span class='glyphicon glyphicon-exclamation-sign'></span> <strong>Error:</strong><ul>";
            foreach($error as $key => $value) {
              $error_msg .= '<li>' . $value . '</li>';
            }
            echo $error_msg . "</ul></div>";
          }
        ?>
        <div class="row">
          <div class="col-md-4">
            <h2>Editing <?php echo $res['lmp_name']; ?></h2>
            <form method="post" id="edit_plan_form">
              <div class="form-group"><label for="txt_lmp_name_r">Display Name</label><input type="text" name="txt_lmp_name_r" id="txt_lmp_name_r" class="form-control" placeholder="Plan's Front-end Display Name" value="<?php echo $res['lmp_name'] ?>" required></div>
              <div class="form-group"><label for="txt_lmp_admin_name">Inhouse Display Name</label><input type="text" name="txt_lmp_admin_name" id="txt_lmp_admin_name" class="form-control" placeholder="Plan's Inhouse Name" value="<?php echo $res['lmp_admin_name'] ?>"></div>
              <div class="form-group">
                <label for="wnu_pty_id">Plan Type</label>
                <select name="wnu_pty_id" id="wnu_pty_id" class="form-control">
                  <option value="1" <?php echo ($res['pty_id'] == 1?'selected':''); ?>>Free</option>
                  <option value="3" <?php echo ($res['pty_id'] == 3?'selected':''); ?>>Self-Service</option>
                  <option value="4" <?php echo ($res['pty_id'] == 4?'selected':''); ?>>Full-Service</option>
                </select>
              </div>
              <div class="form-group"><label for="dec_lmp_price">Monthly Fee</label><input type="number" name="dec_lmp_price" id="dec_lmp_price" class="form-control" min="0" max="9000" step=".01" value="<?php echo $res['lmp_price']; ?>" required></div>
              <div class="form-group"><label for="dec_lmp_fee">Setup Fee</label><input type="number" name="dec_lmp_fee" id="dec_lmp_fee" class="form-control" min="0" max="1000" step=".01" value="<?php echo $res['lmp_fee']; ?>" required></div>
              <div class="form-group">
                <label for="wnu_lmp_billing_delay">Delay First Bill? (months)</label>
                <select name="wnu_lmp_billing_delay" id="wnu_lmp_billing_delay" class="form-control" required>
                  <?php
                    for ($i = 0; $i<13; $i++){
                      echo '<option value="'.$i.'" '.($res['lmp_billing_delay']==$i?'selected':'').'>'.$i.'</option>';
                    }
                  ?>
                </select>
              </div>
              <div class="form-group">
                <label for="txt_lmp_description_r">Description</label>
                <input type="text" name="txt_lmp_description_r" id="txt_lmp_description_r" class="form-control" placeholder="Plan's Description" value="<?php echo $res['lmp_description']; ?>" required>
              </div>
              <div class="form-group">
                <label for="bit_lmp_featured">Featured Plan?</label>
                <select name="bit_lmp_featured" id="bit_lmp_featured" class="form-control">
                  <option value="1" <?php echo ($res['lmp_featured']  ? 'selected' : '') ?>>Yes</option>
                  <option value="0" <?php echo ($res['lmp_featured'] == false ? 'selected' : '') ?>>No</option>
                </select>
              </div>
              <div class="form-group">
                <label for="bit_lmp_active">Plan status</label>
                <select name="bit_lmp_active" id="bit_lmp_active" class="form-control">
                  <option value="1" <?php echo ($res['lmp_active']  ? 'selected' : '') ?>>Active</option>
                  <option value="0" <?php echo ($res['lmp_active'] == false ? 'selected' : '') ?>>Inactive</option>
                </select>
              </div>
              <!--
              <div class="form-group">
                <label for="wnu_lmp_max_drafts">Max Promotion Drafts</label>
                <select name="wnu_lmp_max_drafts" id="wnu_lmp_max_drafts" class="form-control" required>
                  <?php
                    for ($i = 0; $i<17; $i++){
                      echo '<option value="'.$i.'" '.($plan_features['max_drafts']['hasFeature'] ? ($plan_features['max_drafts']['count']==$i?'selected':''):'').'>'.$i.'</option>';
                      $i++;
                    }
                  ?>
                </select>
              </div>
              <div class="form-group">
                <label for="wnu_lmp_max_promos">Max Active Promotions</label>
                <select name="wnu_lmp_max_promos" id="wnu_lmp_max_promos" class="form-control" required>
                  <?php
                    for ($i = 0; $i<17; $i++){
                      echo '<option value="'.$i.'" '.($plan_features['max_drafts']['hasFeature'] ? ($plan_features['max_promos']['count']==$i?'selected':''):'').'>'.$i.'</option>';
                      $i++;
                    }
                  ?>
                </select>
              </div>
              <div class="form-group">
                <label for="wnu_lmp_displayed_active_promos">Displayed Active Promotions</label>
                <select name="wnu_lmp_displayed_active_promos" id="wnu_lmp_displayed_active_promos" class="form-control" required>
                  <?php
                    for ($i = 0; $i<17; $i++){
                      echo '<option value="'.$i.'" '.($plan_features['displayed_active_promos']['hasFeature'] ? ($plan_features['displayed_active_promos']['count']==$i?'selected':''):'').'>'.$i.'</option>';
                      $i++;
                    }
                  ?>
                </select>
              </div>
              <div class="form-group">
                <label for="wnu_lmp_max_key">Max # of Keywords</label>
                <select name="wnu_lmp_max_key" id="wnu_lmp_max_key" class="form-control" required>
                  <?php
                    for ($i = 2; $i<11; $i++){
                      echo '<option value="'.$i.'" '.($plan_features['max_key']['hasFeature'] ? ($plan_features['max_key']['count']==$i?'selected':''):'').'>'.$i.'</option>';
                      $i++;
                    }
                  ?>
                </select>
              </div>
              <div class="form-group"><label for="wnu_lmp_service_time">Customer Service Time (minutes)</label><input type="number" name="wnu_lmp_service_time" id="wnu_lmp_service_time" class="form-control" min="0" max="1000" step="1" value="<?php echo ($plan_features['service_time']['hasFeature'] ? $plan_features['service_time']['count']:0); ?>" required></div>
              <div class="form-group">
                <label for="wnu_lmp_catalog_points">Bonus Catalog Points</label><input type="number" name="wnu_lmp_catalog_points" id="wnu_lmp_catalog_points" class="form-control" min="0" max="10000" step="1" value="<?php echo ($plan_features['catalog_pts']['hasFeature'] ? $plan_features['catalog_pts']['count']:0); ?>">
                <input type="checkbox" id="catalog_unlimited" name="catalog_unlimited" value="1" <?php echo ($plan_features['catalog_pts']['hasFeature'] ? ($plan_features['catalog_pts']['count'] === null ? 'checked' : ''):''); ?>> <label for="catalog_unlimited">Unlimited Bonus Catalog Points</label>
              </div> 
              <div class="form-group"><label for="wnu_lmp_incentives">Sign Up Incentives</label><input type="number" name="wnu_lmp_incentives" id="wnu_lmp_incentives" class="form-control" min="0" max="10" step="1" value="<?php echo ($plan_features['signup_incentives']['hasFeature'] ? $plan_features['signup_incentives']['count']:0); ?>" required></div>
              <div class="form-group"><label for="wnu_lmp_emails">Emails per Month</label><input type="number" name="wnu_lmp_emails" id="wnu_lmp_emails" class="form-control" min="0" max="5000" step="1" value="<?php echo ($plan_features['max_emails']['hasFeature'] ? $plan_features['max_emails']['count']:0); ?>" required></div>
              <div class="form-group"><label for="wnu_lmp_sms_texts">SMS Texts per Month</label><input type="number" name="wnu_lmp_sms_texts" id="wnu_lmp_sms_texts" class="form-control" min="0" max="5000" step="1" value="<?php echo ($plan_features['max_texts']['hasFeature'] ? $plan_features['max_texts']['count']:0);; ?>" required></div>
              <div class="form-group"><label for="wnu_lmp_push_msgs">Push Notifications/Messages per Month</label><input type="number" name="wnu_lmp_push_msgs" id="wnu_lmp_push_msgs" class="form-control" min="0" max="5000" step="1" value="<?php echo ($plan_features['max_push']['hasFeature'] ? $plan_features['max_push']['count']:0); ?>" required></div> 
              <div class="form-group">
                <input type="checkbox" name="bit_lmp_push_msgs" id="bit_lmp_push_msgs" value="1" <?php echo ($plan_features['max_push']['hasFeature'] ? 'checked':''); ?>>
                <label for="bit_lmp_push_msgs">Push Notifications</label>
              </div>
              <div class="form-group">
                <input type="checkbox" name="bit_lps_branded_site" id="bit_lps_branded_site" value="1" <?php echo ($plan_features['offers_site']['hasFeature'] ? 'checked':''); ?>>
                <label for="bit_lps_branded_site">Branded Offers Site</label>
              </div>
              <div class="form-group">
                <input type="checkbox" name="bit_lps_phone_app" id="bit_lps_phone_app" value="1" <?php echo ($plan_features['phone_app']['hasFeature'] ? 'checked':''); ?>>
                <label for="bit_lps_phone_app">Branded Phone App</label>
              </div>
              <div class="form-group">
                <input type="checkbox" name="bit_lps_geo_location" id="bit_lps_geo_location" value="1" <?php echo ($plan_features['geo_location']['hasFeature'] ? 'checked':''); ?>>
                <label for="bit_lps_geo_location">GeoLocation Service</label>
              </div>
              <div class="form-group">
                <input type="checkbox" name="bit_lps_business_listing" id="bit_lps_business_listing" value="1" <?php echo ($plan_features['business_listing']['hasFeature'] ? 'checked':''); ?>>
                <label for="bit_lps_business_listing">Business Listing</label>
              </div>
              <div class="form-group">
                <input type="checkbox" name="bit_lps_marketing_materials" id="bit_lps_marketing_materials" value="1" <?php echo ($plan_features['marketing_materials']['hasFeature'] ? 'checked':''); ?>>
                <label for="bit_lps_marketing_materials">In-Store Marketing Materials</label>
              </div>
              <div class="form-group">
                <input type="checkbox" name="bit_lps_national_mall" id="bit_lps_national_mall" value="1" <?php echo ($plan_features['national_mall']['hasFeature'] ? 'checked':''); ?>>
                <label for="bit_lps_national_mall">National Mall</label>
              </div>
              <div class="form-group">
                <input type="checkbox" name="bit_lps_screcials" id="bit_lps_screcials" value="1" <?php echo ($plan_features['screcials']['hasFeature'] ? 'checked':''); ?>>
                <label for="bit_lps_screcials">Screcials</label>
              </div>
              <div class="form-group">
                <input type="checkbox" name="bit_lps_consumer_reports" id="bit_lps_consumer_reports" value="1" <?php echo ($plan_features['consumer_reports']['hasFeature'] ? 'checked':''); ?>>
                <label for="bit_lps_consumer_reports">Analytics and Consumer Reports</label>
              </div>
              -->
              <h3>Welcome Email</h3>
              <div class="form-group">
                <table>
                  <tr>
                    <td>
                      <input type="radio" id="em_default" name="wnu_tem_id" value="0" <?php echo (is_null($res['tem_id']) ? 'checked':''); ?>>&nbsp;
                    </td>
                    <td><label for="em_default">Default</label></td>
                  </tr>
                  <?php 
                    foreach($welcome_emails as $email){ 
                      echo 
                      '<tr>
                        <td>
                          <input type="radio" id="em_o'.$email['tem_id'].'" name="wnu_tem_id" value="'.$email['tem_id'].'" '.($email['tem_id']===$res['tem_id']?'checked':'').'>&nbsp;
                        </td>
                        <td>
                          <label for="em_o'.$email['tem_id'].'"> '.$email['tem_label'].'</label>
                        </td>
                      </tr>';
                    } 
                  ?>
                </table>
              </div>            
              <input type="hidden" name="editPlan" value="1">
              <input type="hidden" name="lmp_id" value="<?php echo $_REQUEST['lmp_id']; ?>">
              <button class="btn btn-success" type="submit" id="edit_plan_btn">Save Plan Changes</button> <button class="btn btn-danger cancelBtn" type="button">Cancel</button>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div><!--end #main .container-->
</div>

<script>
$(document).ready(function(){

  $('#edit_plan_form').on('submit', function(e){
    var that = $(this);
    e.preventDefault();
    $('#edit_plan_btn').prop('disabled', true).text('Editing plan...');
    // edit plan
    var data = $(this).serialize();
    $.ajax({
      url: "../ajax/ajax.edit-reseller-plan.php",
      global: false,
      type: "POST",
      dataType: "JSON",
      data: data,
      success: function (response){
        // console.log(response);
        if (response['status'] === 'success'){
          console.log(response);
          window.location.href = 'reseller-manage-plans';
        } else {
          console.log(response);
        }
      },
      error: function(response){
        console.log(response);
      }
    });
  });

  // refresh page when a cancel button is clicked
  $('.cancelBtn').on('click', function(){
    window.location.href = window.location.href;
  });

});
</script>
<?php
require 'footer.php';
/* EOF ?> */
