<?php 
//-----------------------------------
//  admin/reseller-edit.php
//-----------------------------------
require '../app/start_session.php';
$dbo=connect();

function getResellerSwitches ($resId) {
	global $dbo; $resSet = array();
	$sql = '
	SELECT RSW.rss_name, RSW.rss_id
	FROM tbl_reseller2switch R2S
	INNER JOIN tbl_reseller RES ON R2S.res_id = RES.res_id
	INNER JOIN tbl_reseller_switches RSW ON R2S.rss_id = RSW.rss_id
	WHERE RES.res_id = :res_id';
	$qry = $dbo->prepare( $sql );
	$qry->bindValue(':res_id', $resId, PDO::PARAM_INT);
	$qry=execPDO($qry);
	while ($res = $qry->fetch( PDO::FETCH_ASSOC )) {
		$resSet[$res['rss_name']] = $res['rss_id'];
	}
	return $resSet;
}
function getResellerFiles ($resId) {
	$_i = 0; $subId = substr( $resId, $_i, 2 ); $fullPath = '../merchant-custom-files'; $Result = '<li>No files found</li>'; $tmpResult = '';
	if ( !empty( $resId ) ) {
		do {
			$fullPath.= ($fullPath===''?'':'/') . $subId;
			$tmpResult .= ( $tmpResult == ''? '': '/' ) . $subId;
			$_i+=2;
			$subId = substr( $resId, $_i, 2 );
		}
		while ( $subId != '' );
	}			
	
	if ( file_exists( $fullPath . '/_reseller_files/marketing' ) ) {
		
		$tmpResult = glob( $fullPath . '/_reseller_files/marketing/*.pdf' );
		$tmpResult = array_merge ( $tmpResult, glob( $fullPath . '/_reseller_files/marketing/*.html' ));
		if ( !empty($tmpResult) ) {$Result = '';}
		foreach ( $tmpResult as $k => $f ) {
			$v = explode ('/', $f);
		
			if (count($v) > 0) {
				$Result .= '<li>' . $v[count($v) - 1] . '</li>';
			}
			else
				$Result .= '<li></li>';
		}
	}
	return	$Result;	
}

function getAllPlans($dbo){
  $sql = 'SELECT LMP.lmp_id, LMP.lmp_name, LMP.lmp_admin_name, LMP.pty_id, LMP.lmp_price, LMP.lmp_fee, LMP.lmp_billing_delay,
  LMP.lmp_description, LMP.pty_id, LPF.lpf_feature, LPF.lpf_id, MFC.mfc_count
  FROM lt_merchant_plans LMP
  INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id
  LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
  WHERE LMP.lmp_active = 1 AND LPF.lpf_active = 1 AND MFC.ltb_id IS NULL ORDER BY LMP.lmp_id';
  $qry = $dbo->prepare( $sql );
  $qry->execute();
  $qry = $qry->fetchAll(PDO::FETCH_ASSOC);
  if(empty($qry)){
    // set array to avoid errors
    $results = array();
  }
  else {
    foreach ($qry as $k => $v) {
      if (!$results[$v['lmp_id']]){
        $results[$v['lmp_id']] = array(
          'lmp_id'                => $v['lmp_id'],
          'pty_id'                => $v['pty_id'],
          'lmp_name'              => $v['lmp_name'],
          'lmp_admin_name'        => $v['lmp_admin_name'],
          'lmp_price'             => $v['lmp_price'],
          'lmp_fee'               => $v['lmp_fee'],
          'lmp_billing_delay'     => $v['lmp_billing_delay'],
          'lmp_description'       => $v['lmp_description']
        );

        $results[$v['lmp_id']]['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);

        if ($v['lmp_price'] == 0 && $v['pty_id'] > 1) {
          $results[$v['lmp_id']]['lmp_no_price'] = 1;
        }
      }
      else {
        $results[$v['lmp_id']]['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
      }
    }
  }
  return $results;
}

function checkPlanFeatures($lpf_id, $features_array, $dbo){
  $results = array('hasFeature'=> false, 'count'=> $features_array[$lpf_id]['mfc_count'], 'name'=> $features_array[$lpf_id]['lpf_feature']);
  $present = array_search($lpf_id, array_map(function($v){return $v['lpf_id'];}, $features_array));
  if ($present) {
    $results['hasFeature'] = true;
  }
  return $results;
}

$update4MyStore = false; $resellerID = $_REQUEST['res_id']; $fourMyStoreError = false; $tmpFourMystoreId = 0;
//-----------------------------------
//  UPDATE 4MyStore
//-----------------------------------
if ($_SERVER['REQUEST_METHOD'] == 'POST' && $_POST['adn32_4mymtore_prismpay_subid_r'] && $_POST['htm512_4mymtore_description_r']){
	  $fields=array('adn32_4mymtore_prismpay_subid_r', 'htm512_4mymtore_description_r');

    // check if user added google analytics ID
    if (isset($_POST['txt_fms_google_analytics'])){
      array_push($fields, 'txt_fms_google_analytics');
      $checkVar['txt_fms_google_analytics'] = $_POST['txt_fms_google_analytics'];
    }

	  $checkVar['adn32_4mymtore_prismpay_subid_r'] = $_POST['adn32_4mymtore_prismpay_subid_r'];
	  $checkVar['htm512_4mymtore_description_r'] = $_POST['htm512_4mymtore_description_r'];

	  //check the values of passed variables
	  require_once '../app/class.variables.php';
	  $cv = new _variables($checkVar); // new instance
	  foreach($fields as $name=>$value) $cv->varible_in($value); //each variable is added to class by array loop
	  $_v=$cv->get_cleaned_variables();
	  $errors=$cv->get_bad_variables();
	  if (empty($errors)) {
		    $sql = 'INSERT IGNORE INTO `tbl_4mystore` (res_id, fms_description, fms_prismpay_subid, '.(isset($_v['fms_google_analytics']) ? 'fms_google_analytics' : '').') VALUES (:res_id, :desc, :subid, '.(isset($_v['fms_google_analytics']) ? ':fms_google_analytics' : '').')';
			$qry = $dbo->prepare($sql);			
			$qry->bindValue(':res_id', $resellerID, PDO::PARAM_INT);
			$qry->bindValue(':desc', $_v['4mymtore_description'], PDO::PARAM_STR);
			$qry->bindValue(':subid', $_v['4mymtore_prismpay_subid'], PDO::PARAM_STR);
			(isset($_v['fms_google_analytics']) ? $qry->bindValue(':fms_google_analytics', $_v['fms_google_analytics'], PDO::PARAM_STR) : '');
			$qry->execute();
			$tmpFourMystoreId = $dbo->lastInsertId();
			if (!$tmpFourMystoreId) {
				 $sql = 'UPDATE `tbl_4mystore` SET fms_description=:desc, fms_prismpay_subid=:subid, '.(isset($_v['fms_google_analytics']) ? 'fms_google_analytics=:fms_google_analytics' : '').' WHERE res_id=:res_id';
				 $qry = $dbo->prepare($sql);			
				 $qry->bindValue(':res_id', $resellerID, PDO::PARAM_INT);
				 $qry->bindValue(':desc', $_v['4mymtore_description'], PDO::PARAM_STR);
				 $qry->bindValue(':subid', $_v['4mymtore_prismpay_subid'], PDO::PARAM_STR);
				(isset($_v['fms_google_analytics']) ? $qry->bindValue(':fms_google_analytics', $_v['fms_google_analytics'], PDO::PARAM_STR) : '');
				 $qry->execute();
				 
				$sql = 'SELECT * FROM `tbl_4mystore` WHERE res_id = :res_id LIMIT 1';
				$qry1 = $dbo->prepare( $sql );
				$qry1->bindValue(':res_id', $resellerID, PDO::PARAM_INT);
				$qry1=execPDO($qry1);
				$_4MyStore = $qry1->fetchAll( PDO::FETCH_ASSOC );
				
				if (isset($_4MyStore[0]['fms_id'])) $tmpFourMystoreId = $_4MyStore[0]['fms_id'];
			}

			$update4MyStore = true;
	  }
	  else {
		  $fourMyStoreError = true;
	  }
}

// 4my.store secondary logo
$update4MySecondLogo = false;
if ( $_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['4mystore_second_logo'], $_FILES['uploaded_img']) ){
	$update4MyStore = true;
	$update4MySecondLogo = true;

	$sql = 'SELECT fms_id FROM `tbl_4mystore` WHERE res_id = :res_id LIMIT 1';
	$qry1 = $dbo->prepare( $sql );
	$qry1->bindValue(':res_id', $resellerID, PDO::PARAM_INT);
	$qry1=execPDO($qry1);
	$_4MyStore = $qry1->fetchAll( PDO::FETCH_ASSOC );
	if (isset($_4MyStore[0]['fms_id'])) $tmpFourMystoreId = $_4MyStore[0]['fms_id'];
}


//-----------------------------------
//  UPLOAD LOGO
//-----------------------------------

include 'inc/function.image-upload.php';
$msg=" Image will be resized to 300x70. New uploads will delete the former image.";
if( isset( $_FILES['uploaded_img'] ) && !$fourMyStoreError) {
  $validImageFileFlag = @exif_imagetype($_FILES['uploaded_img']['tmp_name']);
  if ($validImageFileFlag === false) {
	$msg = ' <span style="color:red;">Incorrect image file.</span>';//<script>alert("Please upload image smaller than 500KB")</script>
  }
  else {
	  list( $orig_w, $orig_h ) = getimagesize( $_FILES['uploaded_img']['tmp_name'] );
	  $valid = array('jpeg', 'jpg', 'png', 'gif'); // allowed extensions
	  $sizes = $update4MyStore? array(0 => 0) :array(120 => 120, 300 => 70);
	  if ($orig_w < 300 && $orig_h < 70 && $update4MySecondLogo == false) {
		$msg = ' <span style="color:red;">Image must be at least 300px wide & 70px tall.</span>';
	  }
	  else {
		if($_FILES['uploaded_img']['size'] < (1024 * 500)) { // max upload is 500kb
		  $ext = strtolower( pathinfo( $_FILES['uploaded_img']['name'], PATHINFO_EXTENSION ) ); // get file extension
		  if( in_array( $ext, $valid ) ){
			foreach( $sizes as $w => $h ) $files[] = appResize( $sizes, $update4MyStore, $tmpFourMystoreId, $update4MySecondLogo); // resize image function
			header('Location: '.$_SERVER['REQUEST_URI']);
		  }
		  else {
			$msg = ' <span style="color:red;">Unsupported or empty file.</span>';//<script>alert("Unsupported or empty file")</script>
		  }
		}
		else {
		  $msg = ' <span style="color:red;">Image must be smaller than 500KB.</span>';//<script>alert("Please upload image smaller than 500KB")</script>
		}
	  }
  }
}

if (!$fourMyStoreError && $update4MyStore)
	header('Location: '.$_SERVER['REQUEST_URI']);


//-----------------------------------
//  UPDATE RESELLER SETTINGS    
//-----------------------------------
if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['txt_reseller_name_r']) && isset($_POST['txl128_reseller_subdomain_r']) && isset($_POST['bit_reseller_active_r'])){

  //CHECK IF FIELDS WERE POSTED - redirect away if any missing
  $fields=array('txl128_reseller_subdomain_r', 'url_res_video_url', 'txt_reseller_name_r', 'bit_reseller_active_r', 'pho_res_csr_phone', 'ema_res_email', 'ema_res_csr_email', 'txt_res_google_analytics', 'bit_reseller_whitelabel_r');
  $hidePricingPageFlag = false; $hidePricingPageFlag = false;  $hideContactPageFlag = false;
  if ( isset($_POST['hide_pricing_page']) && $_POST['hide_pricing_page'] == 0) {
	array_push($fields, 'txt_res_pricing_header', 'htm1024_res_pricing_text', 'url_res_pricing_youtube' );
	$hidePricingPageFlag = true;
  }
  
  if ( isset($_POST['hide_contact_page']) && $_POST['hide_contact_page'] == 0) {
	  array_push($fields, 'txt_res_contact_header', 'htm1024_res_contact_text', 'url_res_contact_youtube');
	  $hideContactPageFlag = true;
  }				 	
  
  if ( isset($_POST['show_partners_page']) && $_POST['show_partners_page'] == 1) {
	  // array_push($fields, 'txt_res_contact_header', 'htm1024_res_contact_text', 'url_res_contact_youtube');
	  $showPartnersPageFlag = true;
  }
  
  //check the values of passed variables
  require_once '../app/class.variables.php';
  $cv = new _variables(); // new instance
  foreach($fields as $name=>$value) $cv->varible_in($value); //each variable is added to class by array loop
  $_v=$cv->get_cleaned_variables();
  $errors = $cv->get_bad_variables();
  $_v['reseller_subdomain'] = strtolower(preg_replace('/[^\w]/', '', $_v['reseller_subdomain']));

  // check if subdomain is a reserved word or in use by a different reseller
  include 'inc/function.check-subdomain.php';
  checkSubdomain($_v['reseller_subdomain'], $resellerID);

  if ( !count( $errors ) ) {
	
	 if ( isset($_POST['hide_localthanks_jump'])) {
	
	  if ( $_POST['hide_localthanks_jump'] == 0 ) {
		  
		$sql = "
			DELETE R2S 
			FROM tbl_reseller2switch R2S
			INNER JOIN tbl_reseller_switches RSW ON RSW.rss_id=R2S.rss_id
			WHERE R2S.res_id=:res_id AND RSW.rss_name = 'hide_mystore_lt_jump'";
			
			$qry = $dbo->prepare($sql);
			$qry->bindValue(':res_id', $resellerID, PDO::PARAM_INT);
			$qry=execPDO($qry); 
	  }
	  else {
		  $sql = '
			INSERT IGNORE INTO tbl_reseller2switch 
			(res_id, rss_id)
			SELECT	
			:res_id, rss_id 
			FROM tbl_reseller_switches 
			WHERE rss_name="hide_mystore_lt_jump"';
			
			$qry = $dbo->prepare($sql);
			$qry->bindValue(':res_id', $resellerID, PDO::PARAM_INT);
			$qry=execPDO($qry);
	  }
			  
	}	
	
    function getYoutubeID($url){
      $matches = array();
      preg_match("/^(?:http(?:s)?:\/\/)?(?:www\.)?(?:m\.)?(?:youtu\.be\/|youtube\.com\/(?:(?:watch)?\?(?:.*&)?v(?:i)?=|(?:embed|v|vi|user)\/))([^\?&\"'>]+)/", $url, $matches);
      return $matches[1];
    }

    if (!empty($_v['res_contact_youtube'])){
      $youtubeID_contact = getYoutubeID($_v["res_contact_youtube"]);
    }

	if (!empty( $_v['res_video_url'] ) ){      
	  parse_str( parse_url( $_v['res_video_url'], PHP_URL_QUERY ), $my_array_of_vars );
	  if ( isset($my_array_of_vars['v']) ) {
		  unset($_v['res_video_url']);
		  $_v['res_video_id'] = $my_array_of_vars['v'];
	  }
	  else {
		  $lastParamArr = explode('/',$_v['res_video_url']);
		  $_v['res_video_id'] = $lastParamArr[count($lastParamArr)-1];
	  }
    }
	else {
		$_v['res_video_id'] = null;
	}
	
	unset($_v['res_video_url']);
	
    if (!empty($_v['res_pricing_youtube'])){
      $youtubeID_pricing = getYoutubeID($_v["res_pricing_youtube"]);
    }

    //print_r($_v);
    $sql = '
	UPDATE `tbl_reseller` 
	SET res_name=:res_name, 
	'.($hideContactPageFlag?'
	res_contact_header=:res_contact_header, 
	res_contact_text=:res_contact_text, 
	res_contact_youtube=:res_contact_youtube,
	res_video_id=:res_video_id,	
	':'').($hidePricingPageFlag?'
	res_pricing_header=:res_pricing_header, 
	res_pricing_text=:res_pricing_text, 
	res_pricing_youtube=:res_pricing_youtube, 
	':'').'
	res_subdomain=:res_subdomain, 
	res_active=:res_active, 
	res_csr_phone=:res_csr_phone, 
	res_email=:res_email, 
	res_csr_email=:res_csr_email, 
	res_google_analytics=:res_google_analytics,
	res_whitelabel=:res_whitelabel
	WHERE res_id=:res_id';
	
    $qry = $dbo->prepare($sql);
    $qry->bindValue(':res_name', $_v['reseller_name'], PDO::PARAM_STR);
    $qry->bindValue(':res_subdomain', $_v['reseller_subdomain'], PDO::PARAM_STR);
    $qry->bindValue(':res_active', $_v['reseller_active']==1?1:0, PDO::PARAM_INT);
    $qry->bindValue(':res_csr_phone', $_v['res_csr_phone'], PDO::PARAM_INT);
    $qry->bindValue(':res_csr_email', $_v['res_csr_email'], PDO::PARAM_STR);
    $qry->bindValue(':res_email', empty($_v['res_email'])? null: $_v['res_email'], PDO::PARAM_STR);
    $qry->bindValue(':res_google_analytics', $_v['res_google_analytics'], PDO::PARAM_STR);
	$qry->bindValue(':res_video_id', $_v['res_video_id'], PDO::PARAM_STR);
	$qry->bindValue(':res_whitelabel', ($_v['reseller_whitelabel'] == 1 ? 1 : null), PDO::PARAM_INT);
	
	if ($hideContactPageFlag) {	
		$qry->bindValue(':res_contact_header', empty($_v['res_contact_header'])? null : nl2br($_v['res_contact_header']), PDO::PARAM_STR);
		$qry->bindValue(':res_contact_text', empty($_v['res_contact_text'])? null : nl2br($_v['res_contact_text']), PDO::PARAM_STR);
		$qry->bindValue(':res_contact_youtube', empty($youtubeID_contact)? null : $youtubeID_contact, PDO::PARAM_STR);
	}
	
	if ($hidePricingPageFlag) {
		$qry->bindValue(':res_pricing_header', empty($_v['res_pricing_header'])? null : nl2br($_v['res_pricing_header']), PDO::PARAM_STR);
		$qry->bindValue(':res_pricing_text', empty($_v['res_pricing_text'])? null : nl2br($_v['res_pricing_text']), PDO::PARAM_STR);
		$qry->bindValue(':res_pricing_youtube', empty($youtubeID_pricing)? null : $youtubeID_pricing, PDO::PARAM_STR);
	}
	
    $qry->bindValue(':res_id', $resellerID, PDO::PARAM_INT);
    $qry=execPDO($qry);
	
	if ( isset($_POST['hide_pricing_page']) && $_POST['hide_pricing_page'] == 1) {
		$qry = $dbo->prepare('INSERT IGNORE INTO `tbl_reseller2switch` (res_id, rss_id) VALUES (:res_id, (SELECT rss_id FROM tbl_reseller_switches WHERE rss_name="hide_pricing"))');
		$qry->bindValue(':res_id', $resellerID, PDO::PARAM_INT);
		$qry=execPDO($qry);
	}
	else {
		$qry = $dbo->prepare('DELETE FROM `tbl_reseller2switch` WHERE res_id=:res_id AND rss_id IN (SELECT rss_id FROM tbl_reseller_switches WHERE rss_name="hide_pricing")');
		$qry->bindValue(':res_id', $resellerID, PDO::PARAM_INT);
		$qry=execPDO($qry);
	}
	
	if ( isset($_POST['hide_contact_page']) && $_POST['hide_contact_page'] == 1) {
		$qry = $dbo->prepare('INSERT IGNORE INTO `tbl_reseller2switch` (res_id, rss_id) VALUES (:res_id, (SELECT rss_id FROM tbl_reseller_switches WHERE rss_name="hide_contact_us"))');
		$qry->bindValue(':res_id', $resellerID, PDO::PARAM_INT);
		$qry=execPDO($qry);
	}
	else {
		$qry = $dbo->prepare('DELETE FROM `tbl_reseller2switch` WHERE res_id=:res_id AND rss_id IN (SELECT rss_id FROM tbl_reseller_switches WHERE rss_name="hide_contact_us")');
		$qry->bindValue(':res_id', $resellerID, PDO::PARAM_INT);
		$qry=execPDO($qry);
	}

	if ( isset($_POST['show_partners_page']) && $_POST['show_partners_page'] == 1) {
		$qry = $dbo->prepare('INSERT IGNORE INTO `tbl_reseller2switch` (res_id, rss_id) VALUES (:res_id, (SELECT rss_id FROM tbl_reseller_switches WHERE rss_name="show_partners_page"))');
		$qry->bindValue(':res_id', $resellerID, PDO::PARAM_INT);
		$qry=execPDO($qry);
	}
	else {
		$qry = $dbo->prepare('DELETE FROM `tbl_reseller2switch` WHERE res_id=:res_id AND rss_id IN (SELECT rss_id FROM tbl_reseller_switches WHERE rss_name="show_partners_page")');
		$qry->bindValue(':res_id', $resellerID, PDO::PARAM_INT);
		$qry=execPDO($qry);
	}	
	
    header('Location: '.$_SERVER['REQUEST_URI']);
  }
}

//-----------------------------------
//  UPDATE RESELLER PLANS
//-----------------------------------
if ($_SERVER['REQUEST_METHOD'] == 'POST' && $_POST['savePlans']){

  $sql = "DELETE FROM lt_plans2reseller WHERE res_id=:res_id; OPTIMIZE TABLE lt_plans2reseller";
  $qry = $dbo->prepare($sql);
  $qry->bindValue(':res_id', $_REQUEST['res_id'], PDO::PARAM_INT);
  $qry=execPDO($qry);
  $qry->closeCursor();

  if (isset($_POST['isActivePlan'])){
    foreach($_POST['isActivePlan'] as $key=>$value){
      $sql = 'INSERT INTO lt_plans2reseller (lmp_id, res_id) VALUES (:lmp_id, :res_id)';
      $qry = $dbo->prepare($sql);
      $qry->bindValue(':lmp_id', $value, PDO::PARAM_INT);
      $qry->bindValue(':res_id', $_REQUEST['res_id'], PDO::PARAM_INT);
      $qry=execPDO($qry);
    }
  }
}

//-----------------------------------
//  GET THIS RESELLER
//-----------------------------------
$sql = 'SELECT res_video_id, mall_id, res_email, res_id, res_name, res_contact_header, res_contact_text, res_contact_youtube, res_pricing_header, res_pricing_text, res_pricing_youtube, res_subdomain, res_logo, res_csr_phone, res_csr_email, res_active, res_google_analytics, res_whitelabel FROM tbl_reseller WHERE res_id = :res_id LIMIT 1';
$qry = $dbo->prepare( $sql );
$qry->bindValue(':res_id', $_GET['res_id'], PDO::PARAM_INT);
$qry=execPDO($qry);
$qry = $qry->fetch( PDO::FETCH_ASSOC );

$currentResellerFiles = getResellerFiles ($_GET['res_id']);

$sql = 'SELECT * FROM `tbl_4mystore` WHERE res_id = :res_id LIMIT 1';
$qry1 = $dbo->prepare( $sql );
$qry1->bindValue(':res_id', $_GET['res_id'], PDO::PARAM_INT);
$qry1=execPDO($qry1);
$_4MyStore = $qry1->fetchAll( PDO::FETCH_ASSOC );

if(empty($qry)){
  $noReseller = true;
} else {
  $reseller = array (
    'id'         		=> $qry['res_id'],
    'name'       		=> $qry['res_name'],
    'subdomain'  		=> $qry['res_subdomain'],
    'csr_phone'  		=> $qry['res_csr_phone'],
	  'email'  			=> $qry['res_email'],
    'csr_email'  		=> $qry['res_csr_email'],
    'logo'       		=> $qry['res_logo'],
    'active'     		=> $qry['res_active'],
    'res_google_analytics' => $qry['res_google_analytics'],
	  'res_contact_header' => $qry['res_contact_header'],
    'res_contact_text'     => $qry['res_contact_text'],
    'res_contact_youtube'  => $qry['res_contact_youtube'],
    'res_pricing_header'   => $qry['res_pricing_header'],
    'res_pricing_text'     => $qry['res_pricing_text'],
    'res_pricing_youtube'  => $qry['res_pricing_youtube'],
	'res_video_id'  	   => $qry['res_video_id'],
	'mall_id'  			   => $qry['mall_id'],
	'res_whitelabel'       => $qry['res_whitelabel']
  );
}

//-----------------------------------
//  GET THIS RESELLERS CURRENT PLANS
//-----------------------------------
$sql = 'SELECT LMP.lmp_id FROM lt_merchant_plans LMP INNER JOIN lt_plans2reseller P2R ON LMP.lmp_id = P2R.lmp_id WHERE P2R.res_id = :res_id';
$qry = $dbo->prepare( $sql );
$qry->bindValue(':res_id', $_REQUEST['res_id'], PDO::PARAM_INT);
$qry=execPDO($qry);
$qry = $qry->fetchAll(PDO::FETCH_ASSOC);
$currentPlans = array();
if(empty($qry)){
  array_push($currentPlans, 0); // no active plans
} else {
  foreach ($qry as $k=>$v){
    array_push($currentPlans, $v['lmp_id']);
  }
  // var_dump($currentPlans);
}

//-----------------------------------
//  GET ALL AVAILABLE RESELLER PLANS
//-----------------------------------
$planList = '<form method="post">';
$planList .= '<table class="table table-striped table-bordered">';
$planList .= '<thead>
<th>Active for this Reseller?</th>
<th>ID</th>
<th>Display Name</th>
<th>Inhouse Name</th>
<th>Plan Type</th>
<th>Monthly Fee</th>
<th>Setup Fee</th>
<th>First bill delayed? (Months)</th>
<th class="col-md-1">Description</th>
<th>Max Promo Drafts</th>
<th>Max Active Promos</th>
<th>Displayed Active Promos</th>
<th>Max Keywords</th>
<th>Customer Service Time (minutes)</th>
<!--th>Bonus Catalog Points</th-->
<th>Signup Incentives</th>
<th>Emails per Month</th>
<th>Texts per Month</th>
<!--th>Push Msgs per Month</th-->
<th>Features</th>
</thead>';
$currentResellerSwitches = getResellerSwitches ($_GET['res_id']); //hide_contact_us        hide_pricing


$allPlans = getAllPlans($dbo);

foreach($allPlans as $k=>$v){

  $plan_features = array(
    'offers_site'  => checkPlanFeatures(1, $v['lmp_features'], $dbo),
    'phone_app'  => checkPlanFeatures(2, $v['lmp_features'], $dbo),
    'geo_location'  => checkPlanFeatures(3, $v['lmp_features'], $dbo),
    'business_listing'  => checkPlanFeatures(4, $v['lmp_features'], $dbo),
    'marketing_materials' => checkPlanFeatures(5, $v['lmp_features'], $dbo),
    'national_mall' => checkPlanFeatures(6, $v['lmp_features'], $dbo),
    'service_time' => checkPlanFeatures(7, $v['lmp_features'], $dbo),
    'consumer_reports' => checkPlanFeatures(8, $v['lmp_features'], $dbo),
    // 'catalog_pts'  => checkPlanFeatures(9, $v['lmp_features'], $dbo),
    'screcials'  => checkPlanFeatures(10, $v['lmp_features'], $dbo),
    'max_promos' => checkPlanFeatures(11, $v['lmp_features'], $dbo),
    'signup_incentives'  => checkPlanFeatures(12, $v['lmp_features'], $dbo),
    'max_emails'   => checkPlanFeatures(13, $v['lmp_features'], $dbo),
    'max_texts'   => checkPlanFeatures(14, $v['lmp_features'], $dbo),
    'max_push'     => checkPlanFeatures(15, $v['lmp_features'], $dbo),
    'max_cat'  => checkPlanFeatures(16, $v['lmp_features'], $dbo),
    'max_key'    => checkPlanFeatures(17, $v['lmp_features'], $dbo),
    'max_drafts' => checkPlanFeatures(18, $v['lmp_features'], $dbo),
    'displayed_active_promos' => checkPlanFeatures(19, $v['lmp_features'], $dbo)
  );
  // build the rest of the plan table
  $planList .= '<tr>';
    $planList .= '<td><input name="isActivePlan[]" value="'.$v["lmp_id"].'" type="checkbox"'.(in_array($v["lmp_id"], $currentPlans) ? 'checked' : '').'></td>';
    $planList .= '<td>'.$v["lmp_id"].'</td>';
    $planList .= '<td>'.$v["lmp_name"].'</td>';
    $planList .= '<td>'.$v["lmp_admin_name"].'</td>';
    $planList .= '<td>'.$v["pty_id"].'</td>';
    $planList .= '<td>'.$v["lmp_price"].'</td>';
    $planList .= '<td>'.$v["lmp_fee"].'</td>';
    $planList .= '<td>'.$v["lmp_billing_delay"].'</td>';
    $planList .= '<td><div class="plan-desc">'.$v["lmp_description"].'</div></td>';
    $planList .= '<td>'.($plan_features['max_drafts']['hasFeature'] ? $plan_features['max_drafts']['count'] : '0').'</td>';
    $planList .= '<td>'.($plan_features['max_promos']['hasFeature'] ? $plan_features['max_promos']['count'] : '0').'</td>';
    $planList .= '<td>'.($plan_features['displayed_active_promos']['hasFeature'] ? $plan_features['displayed_active_promos']['count'] : '0').'</td>';
    $planList .= '<td>'.($plan_features['max_key']['hasFeature'] ? $plan_features['max_key']['count'] : '0').'</td>';
    $planList .= '<td>'.($plan_features['service_time']['hasFeature'] ? $plan_features['service_time']['count'] : '0').'</td>';
    // $planList .= '<td>'.($plan_features['catalog_pts']['hasFeature'] ? (is_null($plan_features['catalog_pts']['count']) ? 'Unlimited' : $plan_features['catalog_pts']['count']) : '0').'</td>';
    $planList .= '<td>'.($plan_features['signup_incentives']['hasFeature'] ? $plan_features['signup_incentives']['count'] : '0').'</td>';
    $planList .= '<td>'.($plan_features['max_emails']['hasFeature'] ? $plan_features['max_emails']['count'] : '0').'</td>';
    $planList .= '<td>'.($plan_features['max_texts']['hasFeature'] ? $plan_features['max_texts']['count'] : '0').'</td>';
    // $planList .= '<td>'.($plan_features['max_push']['hasFeature'] ? $plan_features['max_push']['count'] : '0').'</td>';
    $planList .= '<td><ul class="features_list">';
      $planList .=  ($plan_features['max_push']['hasFeature'] ? '<li>'.$plan_features['max_push']['name'].'</li>' : '');
      $planList .=  ($plan_features['offers_site']['hasFeature'] ? '<li>'.$plan_features['offers_site']['name'].'</li>' : '');
      $planList .=  ($plan_features['phone_app']['hasFeature'] ? '<li>'.$plan_features['phone_app']['name'].'</li>' : '');
      $planList .=  ($plan_features['geo_location']['hasFeature'] ? '<li>'.$plan_features['geo_location']['name'].'</li>' : '');
      $planList .=  ($plan_features['business_listing']['hasFeature'] ? '<li>'.$plan_features['business_listing']['name'].'</li>' : '');
      $planList .=  ($plan_features['marketing_materials']['hasFeature'] ? '<li>'.$plan_features['marketing_materials']['name'].'</li>' : '');
      $planList .=  ($plan_features['national_mall']['hasFeature'] ? '<li>'.$plan_features['national_mall']['name'].'</li>' : '');
    $planList .= '</ul></td>';
  $planList .= '</tr>';
}
$planList .= '</table>';
$planList .= '<input type="hidden" name="savePlans" value="1">';
$planList .= '<button id="savePlans" class="btn btn-success disabled" type="submit">Save Plan Changes</button> <button id="cancelPlans" class="btn btn-danger disabled cancelBtn" type="button">Cancel</button>';
$planList .= '</form>';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['wnu_res_id_r'], $_POST['wnu_link_merchant_r'])) {	
  //check the values of passed variables
  require_once '../app/class.variables.php';
  $fields = array('wnu_res_id_r', 'wnu_link_merchant_r');
  $cv = new _variables(); // new instance
  foreach($fields as $name=>$value) $cv->varible_in($value); //each variable is added to class by array loop
  $_v=$cv->get_cleaned_variables();
  $errors=$cv->get_bad_variables();
  
  if (empty($errors)) {
	$sql="UPDATE tbl_reseller SET mall_id=:mallId WHERE res_id=:resId";
	$_q2 = $dbo->prepare($sql);
	$_q2->bindValue(':mallId', $_v['link_merchant'], PDO::PARAM_INT);
	$_q2->bindValue(':resId', $_v['res_id'], PDO::PARAM_INT);
	$_q2 = execPDO($_q2);
	if ($_q2)
		$reseller['mall_id'] = $_v['link_merchant'];
  }
}

$mallOptions = '';
$reselerMall = 0;

$sql="SELECT DISTINCT MALL.mall_id, MALL.mall_name
	  FROM tbl_mall MALL
	  WHERE MALL.mall_active = 1
	  ORDER BY MALL.mall_name";
$_q2 = $dbo->prepare($sql);
$_q2 = execPDO($_q2);
if( $_q2->rowCount(  ) ) {
	while ( $row = $_q2->fetch( PDO::FETCH_OBJ ) ) {
		if ( isset($reseller['mall_id']) && $reseller['mall_id']== $row->mall_id ) $reselerMall = intval( $row->mall_id );
		$mallOptions .= '<option'.( isset($reseller['mall_id']) && $reseller['mall_id'] == $row->mall_id ? ' selected':'' ).' value="' . $row->mall_id . '">' . $row->mall_name . '</option>'; 
	}
}

	
	
require 'header.php';

?>
<style>
#alert{
  text-align: center;
  position: fixed;
  top: 25%;
  z-index: 10;
  width: 50%;
  left: 25%;
  right: 50%;
  display: none;
  -webkit-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
  -moz-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
  box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
}
.sub-label {
  font-size: 85%;
}
.switches-wrap {
  display: table;
  border: 1px solid #e9e9e9;
  width: 100%;
  margin-bottom: 5px;
}
.radio-form {
  display: table-row;
}
.radio-form:nth-of-type(even){
  background: #e9e9e9;
}
.radio-form label, .radio-form input[type="radio"] {
  margin: 0;
  padding: 0;
  vertical-align: middle;
}
.radio-form__label {
  display: table-cell;
}
.radio-form__btns {
  display: table-cell;
  text-align: right;
}
.radio-form__label, .radio-form__btns {
  padding: 8px 5px;
}
.plan-desc {
  max-height: 75px;
  overflow-y: scroll;
}
ul.features_list {
  text-align: left;
  padding-left: 15px;
  margin: 0;
  /*max-height: 75px;*/
  font-size: 11px;
  list-style-type: disc;
  /*overflow-y: scroll;*/
}
ul.features_list li {
  padding-bottom: 7px;
}
</style>
<div id="adm_body">
  <div id='main' class='container-fluid'>
    <div class='row'>
      <div class='col-md-12'>
        <h1><a href="reseller"><span class='glyphicon glyphicon-tower'></span> Manage Resellers</a></h1>
        <?php echo '<h2>Editing <strong>'.$reseller['name'].'</strong></h2>';
          if (is_Array($errors) && !empty($errors)) {
            echo "<div id='push_errors' class='alert alert-danger'><span class='glyphicon glyphicon-exclamation-sign'></span> <strong>Error:</strong><ul>";
            foreach($errors as $key => $value) {
              $error_msg .= '<li>' . $value . '</li>';
            }
            echo $error_msg . "</ul></div>";
          }
        ?>
      </div>
    </div>
    <?php if ($noReseller != true) { ?>
      <div class="row">
        <div class="col-md-3">
		  <h2>Reseller Settings</h2>
		  <!-- logo upload -->
          <?php

          if ($reseller['logo']===null){
            $reseller['logo'] = 'logo.jpeg'; // default logo
            $logo_path = '../images/resellers/1/';
          }
          else {
            $logo_path = '../images/resellers/'.$resellerID.'/';
          }

          echo '<label>Current logo</label>: <br>
          300x70:
          <img id="current_logo" src="'.$logo_path.'/h_300x70_'.$reseller['logo'].'?m='.Date('U').'"><br>
          120x120:
          <img id="current_logo" src="'.$logo_path.'/h_120x120_'.$reseller['logo'].'?m='.Date('U').'">';

          ?>
          <br><hr><br>
          <form id="reseller_logo_form" method="POST" enctype="multipart/form-data">
            <label for="reseller_logo">Update Logo <span class="sub-label">(300x70 - .jpg, .png, .gif)</span></label>
            <input type="file" name="uploaded_img" id="reseller_logo" accept='image/*' required>
            <?php echo ($update4MyStore? $msg :''); ?>
            <br>
            <button type="submit" class="btn btn-success">Upload Logo</button>
          </form>
          <br>
		  
          <form id="edit_reseller_form" method="POST">
            <br><label for="reseller_name">Reseller Name*</label>
            <input type="text" name="txt_reseller_name_r" id="reseller_name" placeholder="example: Global Merchant Services" value="<?php echo $reseller['name']; ?>" class="form-control" required>
            <br>
            <label for="reseller_subdomain">Subdomain* <span class="sub-label">(<span id="sub-placehold"><?php echo $reseller['subdomain']; ?></span>.localthanks.com)</span></label>
            <input type="text" name="txl128_reseller_subdomain_r" id="reseller_subdomain" placeholder="example: GMS" value="<?php echo $reseller['subdomain']; ?>" class="form-control" required>
            <br>
	<label for="ema_res_email">Email*</label>
					<input type="text" name="ema_res_email" id="ema_res_email" value="<?php echo $reseller['email']; ?>" class="form-control" required>
					<p>This email is the one where the weekly report will be sent to</p>
					<br>
					
					<label for="ema_res_csr_email">Customer Service Email</label>
					<input type="text" name="ema_res_csr_email" id="ema_res_csr_email" value="<?php echo $reseller['csr_email']; ?>" class="form-control">
					<br>
					
					<label for="pho_res_csr_phone">Customer Service Phone Number</label>
					<input type="text" name="pho_res_csr_phone" id="pho_res_csr_phone" value="<?php echo $reseller['csr_phone']; ?>" class="form-control">
					<br>
					
					<label for="txt_res_google_analytics">LT Google Analytics ID</label>
					<input type="text" name="txt_res_google_analytics" id="txt_res_google_analytics" value="<?php echo $reseller['res_google_analytics']; ?>" class="form-control">
					<br>
					
					<label for="url_res_pricing_youtube">Home Page YouTube Video URL</label>
					<input type="text" name="url_res_video_url" id="url_res_video_url" class="form-control" value="<?php echo isset($reseller['res_video_id'])? 'https://www.youtube.com/watch?v=' . $reseller['res_video_id'] : ''; ?>">
					<br>
					
					<label>Hide National Mall Jump in Mystore?</label>
					<label for="hide_localthanks_jump"><input type="radio" name="hide_localthanks_jump" id="hide_localthanks_jump" value=1 <?php echo (isset($currentResellerSwitches['hide_mystore_lt_jump'])?'checked':''); ?>> Yes</label>
					<label for="hide_localthanks_jump_no"><input type="radio" name="hide_localthanks_jump" id="hide_localthanks_jump_no" value=0 <?php echo (!isset($currentResellerSwitches['hide_mystore_lt_jump'])?'checked':''); ?>> No</label><br>
					<p>The switch above will hide the National Mall jump customization in mystore and the banner to jump in Localthanks (Consumer Site), for every merchant that signs up under this reseller.</p>
					
					<label>Hide Contact Page?</label>
					<label for="hide_contact_page"><input type="radio" name="hide_contact_page" id="hide_contact_page" value=1 <?php echo (isset($currentResellerSwitches['hide_contact_us'])?'checked':''); ?>> Yes</label>
					<label for="hide_contact_page_no"><input type="radio" name="hide_contact_page" id="hide_contact_page_no" value=0 <?php echo (!isset($currentResellerSwitches['hide_contact_us'])?'checked':''); ?>> No</label><br>
					
					
					<div id="contactDiv">
						<label for="txt_res_contact_header">Contact Page Header</label>
						<textarea name="txt_res_contact_header" id="txt_res_contact_header" class="form-control"><?php echo isset($reseller['res_contact_header'])? str_replace('<br />',"",$reseller['res_contact_header']) : ''; ?></textarea>
						<br>
						<label for="htm1024_res_contact_text">Contact Page Text</label>
						<textarea name="htm1024_res_contact_text" id="htm1024_res_contact_text" class="form-control"><?php echo isset($reseller['res_contact_text'])? $reseller['res_contact_text'] : ''; ?></textarea>
						<br>
						<label for="url_res_contact_youtube">Contact Page YouTube Video URL</label>
						<input type="text" name="url_res_contact_youtube" id="url_res_contact_youtube" class="form-control" value="<?php echo isset($reseller['res_contact_youtube'])? 'https://www.youtube.com/watch?v='.$reseller['res_contact_youtube'] : ''; ?>">
						<br>
					</div><br>
					
					<label>Hide Pricing Page?</label>
					<label for="hide_pricing_page"><input type="radio" name="hide_pricing_page" id="hide_pricing_page" value=1 <?php echo (isset($currentResellerSwitches['hide_pricing'])?'checked':''); ?>> Yes</label>
					<label for="hide_pricing_page_no"><input type="radio" name="hide_pricing_page" id="hide_pricing_page_no" value=0 <?php echo (!isset($currentResellerSwitches['hide_pricing'])?'checked':''); ?>> No</label><br>					
					
					<div id="pricingDiv">
						<label for="txt_res_pricing_header">Pricing Page Header</label>
						<textarea name="txt_res_pricing_header" id="txt_res_pricing_header" class="form-control"><?php echo isset($reseller['res_pricing_header'])? str_replace('<br />',"",$reseller['res_pricing_header']) : ''; ?></textarea>
						<br>
						<label for="htm1024_res_pricing_text">Pricing Page Text</label>
						<textarea name="htm1024_res_pricing_text" id="htm1024_res_pricing_text" class="form-control"><?php echo isset($reseller['res_pricing_text'])? $reseller['res_pricing_text'] : ''; ?></textarea>
						<br>
						<label for="url_res_pricing_youtube">Pricing Page YouTube Video URL</label>
						<input type="text" name="url_res_pricing_youtube" id="url_res_pricing_youtube" class="form-control" value="<?php echo isset($reseller['res_pricing_youtube'])? 'https://www.youtube.com/watch?v='.$reseller['res_pricing_youtube'] : ''; ?>">
						<br>
					</div><br>

						<label>Show Partners Page?</label>
						<label for="show_partners_page"><input type="radio" name="show_partners_page" id="show_partners_page" value=1 <?php echo (isset($currentResellerSwitches['show_partners_page'])?'checked':''); ?>> Yes</label>
						<label for="show_partners_page_no"><input type="radio" name="show_partners_page" id="show_partners_page_no" value=0 <?php echo (!isset($currentResellerSwitches['show_partners_page'])?'checked':''); ?>> No</label><br>
						<br>

						<label>White Label?</label>
						<label for="reseller_whitelabel_yes"><input type="radio" name="bit_reseller_whitelabel_r" id="reseller_whitelabel_yes" value=1 <?php echo ($reseller['res_whitelabel']==1?'checked':''); ?>> Yes</label>
						<label for="reseller_whitelabel_no"><input type="radio" name="bit_reseller_whitelabel_r" id="reseller_whitelabel_no" value=0 <?php echo ($reseller['res_whitelabel']==0?'checked':''); ?>> No</label><br>
						<br>

					<label>Active?</label>
					<label for="reseller_active_yes"><input type="radio" name="bit_reseller_active_r" id="reseller_active_yes" value=1 <?php echo ($reseller['active']==1?'checked':''); ?>> Yes</label>
					<label for="reseller_active_no"><input type="radio" name="bit_reseller_active_r" id="reseller_active_no" value=0 <?php echo ($reseller['active']==0?'checked':''); ?>> No</label><br>
					<button type="button" id="reseller_submit" class="btn btn-success">Update Reseller</button>
					<br>
				  </form>
				  <br>
				  <hr/>
				  <h2>Current Reseller Files</h2>
				  <ul>
					<?php echo $currentResellerFiles; ?>
				  </ul>
				  <a href="/admin/reseller-files?res_id=<?php echo $resellerID; ?>"><button type="button" class="btn btn-info">Manage Reseller Files</button></a>
				  <br>
				  <br>
				  <hr/>
				  <h2>Reseller Discount Codes</h2>
					<a href="/admin/discount-codes?res_id=<?php echo $resellerID; ?>"><button type="button" class="btn btn-warning">Manage Discount Codes</button></a>
				  <br>
				  <br>
				  <hr/>
				  <div class="col-sm-12">
					<form action="" method="post">
						<h4>Link Reseller to a National Mall</h4>
	
						<div id="selectMallList">
							<br/>
							<label>Mall List</label>
							<div class="row">
								<div class="col-sm-8">
									<input type="hidden" name="wnu_res_id_r" value="<?php echo $_GET['res_id']; ?>"/>
									<select name="wnu_link_merchant_r" id="wnu_link_merchant_r" class="form-control">
										<?php echo $mallOptions; ?>
									</select>
								</div>
								<div class="col-sm-4">
									<button type="submit" class="btn btn-primary">Save Link</button>
								</div>
							</div>
						</div>	
					</form>
					<br/>
				</div>
			  </div>
			  
			  
			  
			  <div class="col-md-6">
				  <h2>Reseller Settings</h2>
				  <!-- logo upload -->
				  <?php

          if (isset($_4MyStore[0]['fms_logo'])){
            $logo_path = '/4my.store/public/images/'.$_4MyStore[0]['fms_id'].'/';
			echo '<label>Current logo</label>: <br>
			  <img id="current_logo" src="'.$logo_path.'h_'.$_4MyStore[0]['fms_logo'].'?m='.Date('U').'"><br>
			  ';
          }

          ?>

          <form id="edit_4mymtore_form" enctype="multipart/form-data" method="POST">
			<label for="4mystore_logo">Update Logo <span class="sub-label">(.jpg, .png, .gif)</span></label>
            <input type="file" name="uploaded_img" id="4mystore_logo" accept='image/*'>
			<?php echo ($update4MyStore? $msg :''); ?>
            <br>
			<br>
			<label for="4mymtore_prismpay_subid">Prismpay SubId</label>
            <input type="text" name="adn32_4mymtore_prismpay_subid_r" id="4mymtore_prismpay_subid" value="<?php echo isset($_4MyStore[0]['fms_prismpay_subid'])? $_4MyStore[0]['fms_prismpay_subid'] : ''; ?>" class="form-control" required />
            <br>
            <label for="4mymtore_description">Description</label>
            <textarea type="text" name="htm512_4mymtore_description_r" id="4mymtore_description" class="form-control" required><?php echo isset($_4MyStore[0]['fms_description'])? $_4MyStore[0]['fms_description'] : ''; ?></textarea>
            <br>
              <label for="txt_fms_google_analytics">4My.Store Google Analytics ID <span class="sub-label">(not required)</span></label>
              <input type="text" name="txt_fms_google_analytics" id="txt_fms_google_analytics" value="<?php echo $_4MyStore[0]['fms_google_analytics']; ?>" class="form-control">
            <br>	
            <button type="submit" id="4mymtore_submit" class="btn btn-success">Update 4MyStore</button>
            <br>
          </form>


          <br>
				<?php
				  if (isset($_4MyStore[0]['fms_logo_secondary'])){
					$logo_path = '/4my.store/public/images/'.$_4MyStore[0]['fms_id'].'/';
					echo '<label>Current secondary logo</label>: <br>
					  <img id="current_logo_secondary" src="'.$logo_path.'s_'.$_4MyStore[0]['fms_logo_secondary'].'?m='.Date('U').'"><br>
					  ';
				  }
				?>
			  <form enctype="multipart/form-data" method="POST">
			  	<label for="4mystore_logo2">Update Secondary Logo <span class="sub-label">(.jpg, .png, .gif)</span></label>
				<input type="file" name="uploaded_img" id="4mystore_logo2" accept='image/*'>
				<input type="hidden" name="4mystore_second_logo" value="1">
				<br>
				<button type="submit" class="btn btn-success">Update 4MyStore Secondary Logo</button>
			  </form>
        </div>
      </div>
      <br>
      <div class="row">
        <div class="col-md-12">
          <h2>Reseller Plans  <a href="reseller-manage-plans"><button type="button" class="btn btn-primary">Manage Reseller Plans</button></a></h2>
          <?php echo $planList; ?>
          <br><br>
        </div>
      </div>
    <?php } else { echo 'No reseller found.'; } ?>
  </div><!--end #main .container-->
</div>
<script>
  $(document).ready(function(){
    if ($("#hide_pricing_page").is(':checked')) {
		$("#pricingDiv").hide();
	}
	
	if ($("#hide_contact_page").is(':checked')) {
		$("#contactDiv").hide();
	}
	
	var hidePricingPage = $("input:radio[name=hide_pricing_page]");
	
	hidePricingPage.click(function() {
		var value = $(this).val();		
		if (value == 1) {
			$("#pricingDiv").hide();
		}
		else {
			$("#pricingDiv").show();
		}
	});
	
	var hideContactPage = $("input:radio[name=hide_contact_page]");
	
	hideContactPage.click( function() {
		var value = $( this ).val();
		
		if ( value == 1 ) {
			$("#contactDiv").hide();			
		}
		else {
			$("#contactDiv").show();
		}
	} );
    // remove anything that isnt a letter or number on change & keyup
    $('#reseller_subdomain').on('change keyup', function(){
      $(this).val($(this).val().replace(/[\W_]+/g, ''));
      if ($(this).val()!=''){
        $('#sub-placehold').text($(this).val());
      } else {
        $('#sub-placehold').text('<?php echo $reseller["subdomain"]; ?>');
      }
    });

    // front end form validation && duplicate entry prevention
    $('#reseller_submit').on('click', function(e){
      $('#reseller_submit').attr("disabled", true).val('Updating Reseller...');
      var reseller_name = $.trim($('#reseller_name').val());
      var reseller_subdomain = $.trim($('#reseller_subdomain').val());
      if (reseller_name != '' && reseller_name.length <= 255 && reseller_subdomain !='' && reseller_subdomain.length <= 128){
        $('#edit_reseller_form').submit();
      } else {
        // e.preventDefault();
        if (reseller_subdomain =='' || reseller_subdomain.length > 128){
          alert('Error: Subdomain cannot be empty & must be under 128 characters long.');
          $('#reseller_submit').attr("disabled", false).val('Update Reseller');
        } else if (reseller_name == '' || reseller_name.length > 255) {
          alert('Error: Reseller name cannot be empty & must be under 255 characters long.');
          $('#reseller_submit').attr("disabled", false).val('Update Reseller');
        }
      }
    });

    // activate buttons on checkbox change
    $('input[name="isActivePlan[]"]').on('change', function(){
      $('#savePlans, #cancelPlans').removeClass('disabled');
    });

    // refresh page when a cancel button is clicked
    $('.cancelBtn').on('click', function(){
      location.reload();
    });

  });
</script>
<?php
require 'footer.php';
/* EOF ?> */