<?php
if (!isset($_GET['res_id'])) {
	header('Location: /admin/reseller');
}
function saveMarketingDescript($resId, $desc){
  global $dbo;  
  $resIdOk = preg_replace("/[^0-9]/", "",$resId); 
  $clean = preg_replace("/\t+/", " ", $desc); //trim and remove tabs
  $clean = preg_replace('/(\r\n|\r|\n)/', "\n", $clean); //normalize line breaks
  $descOk = preg_replace("/[\n]{3,}/", "\n\n", $clean); //replace more than 3 line breaks into 2 line breaks
  $descOk = substr($descOk,0,65534);
  $descOk = empty($descOk)? null:$descOk;
  $sql="
	UPDATE tbl_reseller SET res_marketing_descript = :resDesc WHERE res_id=:resId
  ";
  $tmp = $dbo->prepare($sql);  
  $tmp->bindValue( ':resId', $resIdOk, PDO::PARAM_INT );
  $tmp->bindValue( ':resDesc', $descOk, PDO::PARAM_STR );
  $tmp->execute();
}
if (isset($_POST['page_description'], $_POST['res_id'])) {
	saveMarketingDescript($_POST['res_id'], $_POST['page_description']);
}

if( isset( $_GET['del_file'], $_GET['res_id'] ) && file_exists( '../merchant-custom-files/' . getDirectoryFromId( $_GET['res_id'] ) . '/_reseller_files/marketing/' . $_GET['del_file'] ) ) {		
	unlink('../merchant-custom-files/' . getDirectoryFromId( $_GET['res_id'] ) . '/_reseller_files/marketing/'.$_GET['del_file']);
	$dbo=connect();
	$tmp = explode( ".", $_GET['del_file'] )[0];
	$tmp = preg_replace( "/[^0-9a-zA-z]/", " ", $tmp );
	$qry = $dbo->prepare( 'DELETE FROM tbl_reseller_docs WHERE res_id=:res_id AND rdc_name=:rdc_name' );
	$qry->bindValue(':res_id', $_GET['res_id'], PDO::PARAM_INT);
	$qry->bindValue(':rdc_name', $tmp, PDO::PARAM_STR);
	$qry->execute();
	header('Location: /admin/reseller-files?res_id=' . $_GET['res_id']);	
}

if( isset( $_FILES['uploaded_file'], $_POST['file_name'], $_POST['res_id'] ) ) {
  $valid = array('pdf', 'html'); // allowed extensions
  $fileDbName = preg_replace("/[^0-9a-zA-z ]/", "",$_POST['file_name']);
  $fileName = preg_replace("/[^0-9a-zA-z]/", "_",$fileDbName);  
  if (isset( $_POST['file_description'] ) && !empty($_POST['file_description'])) {
	  $clean = trim(preg_replace("/\t+/", " ", $_POST['file_description'])); //trim and remove tabs
	  $clean = preg_replace('/(\r\n|\r|\n)/', "\n", $clean); //normalize line breaks
	  $clean = preg_replace("/[\n]{3,}/", "\n\n", $clean); //replace more than 3 line breaks into 2 line breaks
  }
  else {
	  $clean = null;
  }
  $fileDbDesc = $clean; 
  $resId = preg_replace("/[^0-9]/", "",$_POST['res_id']);
  if ( !empty( $resId ) ) { 
	if ( !empty( $fileName ) ) { 
		if($_FILES['uploaded_file']['size'] < (1024 * 10000)) { // max upload is 10Mb
		  $ext = strtolower( pathinfo( $_FILES['uploaded_file']['name'], PATHINFO_EXTENSION ) ); // get file extension
		  if( in_array( $ext, $valid ) ) {
			$subDir = getDirectoryFromId($resId);
			
			if ( !file_exists( '../merchant-custom-files/' . $subDir . '/_reseller_files/marketing' ) ) {
				
				$subDirArr = explode('/',$subDir); $pathStr = '../merchant-custom-files';
				foreach ($subDirArr as $idPart) {
					$pathStr .= '/' . $idPart;
					if ( !file_exists(  $pathStr  ) ) { 
						mkdir($pathStr);
					}
				}
				
				mkdir($pathStr . '/_reseller_files');
				mkdir($pathStr . '/_reseller_files/marketing');
			}
		
			move_uploaded_file($_FILES['uploaded_file']['tmp_name'], "../merchant-custom-files/{$subDir}/_reseller_files/marketing/{$fileName}.{$ext}");
			
			$dbo=connect();
				
			$sql = 'INSERT INTO tbl_reseller_docs (res_id, rdc_name, rdc_description) VALUES (:res_id, :rdc_name, :rdc_description)';
			$qry = $dbo->prepare( $sql );
			$qry->bindValue(':res_id', $resId, \PDO::PARAM_INT);
			$qry->bindValue(':rdc_name', $fileDbName, \PDO::PARAM_STR);
			$qry->bindValue(':rdc_description', $fileDbDesc, \PDO::PARAM_STR);
			$qry->execute();
			
			header('Location: /admin/reseller-files?res_id=' . $resId);
		  }
		  else {
			$msg = ' <span style="color:red;">Unsupported or empty file.</span>';
		  }
		}
		else {
		  $msg = ' <span style="color:red;">File must be smaller than 10MB.</span>';
		}
	}
	else {
		$msg = ' <span style="color:red;">Invalid file name.</span>';
	}
  }
  else {
		$msg = ' <span style="color:red;">Invalid resseler id.</span>';
	}
}

require '../app/start_session.php';
require 'header.php';

function getDirectoryFromId($resId){
	$_i = 0; $subId = substr( $resId, $_i, 2 ); $tmpResult = '';
	if ( !empty( $resId ) ) {
		do {			
			$tmpResult .= ( $tmpResult == ''? '': '/' ) . $subId;
			$_i+=2;
			$subId = substr( $resId, $_i, 2 );
		}
		while ( $subId != '' );
	}			
	
	return	$tmpResult;
}

function getFileList($resId, $type = 'pdf'){
	$Result = array();
	$tmpResult = getDirectoryFromId($resId);
	if ( file_exists( "../merchant-custom-files/{$tmpResult}/_reseller_files/marketing" ) ) {
		$Result = glob( "../merchant-custom-files/{$tmpResult}/_reseller_files/marketing/*.{$type}");
	}
	
	foreach ($Result as $k=>$v) {		
		$v = explode ('/', $v);
		
		if (count($v) > 0) {
			$Result[$k] = $v[count($v) - 1];
		}
		else
			$Result[$k] = '';
	}
	
	return	$Result;
}

function getReseller($resId){
  global $dbo;  
  $resIdOk = preg_replace("/[^0-9]/", "",$resId);
  $sql="
	SELECT * FROM tbl_reseller WHERE res_id=:resId LIMIT 1
  ";
  $tmp = $dbo->prepare($sql);  
  $tmp->bindValue( ':resId', $resIdOk, PDO::PARAM_INT );
  $tmp->execute();
  $tmpName = $tmp->fetchAll(PDO::FETCH_ASSOC);
  return isset($tmpName[0]) ? $tmpName[0] : ''; 
}

//Print current switches
function printFileList() {
 $fileList = getFileList($_GET['res_id']); 
 $fileList = array_merge($fileList, getFileList($_GET['res_id'], 'html')); 
 foreach ($fileList as $nam) {
	$i++; 
    echo '<tr><td style="text-align:left;">' . $nam . '</td><td><a style="margin-left: 20px;" href="/admin/reseller-files?res_id='.$_GET['res_id'].'&del_file='.$nam.'"><input type="button" style="background-color: #c12e2a;" name="remove" value="remove"></a></td></tr>';
 }
 if(!$i) {
	 echo '<tr><td colspan="2" style="text-align:left;color: #ddd;">No files found</td></tr>';
 }
}

$resellerName = getReseller($_GET['res_id']);

//var_dump($resellerName);
?>
<div class='container-fluid' style="text-align:center;">
  <div class='row'>
    <div class='col-sm-12'>

      <h1>Marketing Materials</h1>
	  
      <table style="width: 100%; max-width:500px; margin:auto;" class="table table-bordered table-striped">
		<caption><?php echo isset($resellerName['res_name']) && !empty($resellerName['res_name'])? '<strong>Selected Reseller:</strong> ' . $resellerName['res_name']  . ' <a href="/admin/reseller"><button class="btn btn-xs btn-default">Select a Different Reseller</button></a>' : ''; ?></caption>
        <thead>
		  
          <tr>
            <th>File</th>
            <th style="text-align:center;">Action</th>
          </tr>
        </thead>
       <tbody>
         <tr>
           <?php echo printFileList(); ?>
         </tr>
       </tbody>
      </table>
      <br>
		<?php 			
				echo '
				    
					<form method="POST" enctype="multipart/form-data" style="width: 100%; max-width:500px; margin:auto;">
						<hr><div class="form-group">
						    <input type="hidden" name="res_id" value="'.$_GET['res_id'].'">
							<label for="file_name">File Name</label>
							<input class="form-control" placeholder="Enter File Name" required name="file_name" id="file_name">
							<p>Allow characters are: a-z, A-Z, 0-9 and " ". If any other is entered will removed.</p>
							<label for="file_description">File Description (Optional)</label>
							<textarea maxlength="1024" class="form-control" placeholder="Enter File Description" name="file_description" id="file_description"></textarea>
														
							<label for="file_src">File</label>
							<input id="file_src" type="file" class="form-control"  name="uploaded_file" required>
							<p>Allow file types are: ".pdf" and ".html".</p>
						</div>
						<div class="form-group">
							' . ( isset($msg)? '<p style="color: #c12e2a;">'.$msg.'</p>':'' ) . '
							<input type="submit" class="form-control" value="submit">														
						</div>
					</form>';
			
		?>
		
		<form method="post" style="width: 100%; max-width:500px; margin:10px auto;">
			<hr>
			<input type="hidden" name="res_id" value="<?php echo $_GET['res_id']; ?>">
			<label for="page_description">Page Description (Optional)</label>
			<textarea style="margin-bottom:20px;" maxlength="65535" class="form-control" placeholder="Enter Page Description" name="page_description" id="page_description"><?php echo isset($resellerName['res_marketing_descript'])? $resellerName['res_marketing_descript']: '';?></textarea>			
			<input type="submit" class="form-control" value="submit">
		</form>	  
    </div>
  </div>
</div>


<script>
function go_switch(switch_id) {
  window.location = '?switch='+switch_id;
}
</script>

<?php

require 'footer.php';
