<?php
require '../app/start_session.php';
$dbo=connect();

//-----------------------------------
//  GET ALL AVAILABLE RESELLER PLANS
//-----------------------------------
function getAllPlans($dbo){
  $sql = 'SELECT LMP.lmp_id, LMP.lmp_name, LMP.lmp_admin_name, LMP.pty_id, LMP.lmp_price, LMP.lmp_fee, LMP.lmp_billing_delay,
  LMP.lmp_description, LMP.pty_id, LMP.lmp_active, LMP.lmp_featured, LPF.lpf_feature, LPF.lpf_id, MFC.mfc_count
  FROM lt_merchant_plans LMP
  INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id
  LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
  WHERE LPF.lpf_active = 1 AND MFC.ltb_id IS NULL ORDER BY LMP.lmp_id';
  $qry = $dbo->prepare( $sql );
  $qry->execute();
  $qry = $qry->fetchAll(PDO::FETCH_ASSOC);
  if(empty($qry)){
    // set array to avoid errors
    $results = array();
  }
  else {
    foreach ($qry as $k => $v) {
      if (!$results[$v['lmp_id']]){
        $results[$v['lmp_id']] = array(
          'lmp_id'                => $v['lmp_id'],
          'pty_id'                => $v['pty_id'],
          'lmp_name'              => $v['lmp_name'],
          'lmp_admin_name'        => $v['lmp_admin_name'],
          'lmp_price'             => $v['lmp_price'],
          'lmp_fee'               => $v['lmp_fee'],
          'lmp_billing_delay'     => $v['lmp_billing_delay'],
          'lmp_description'       => $v['lmp_description'],
          'lmp_featured'          => $v['lmp_featured'],
          'lmp_active'          => $v['lmp_active']
        );

        $results[$v['lmp_id']]['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);

        if ($v['lmp_price'] == 0 && $v['pty_id'] > 1) {
          $results[$v['lmp_id']]['lmp_no_price'] = 1;
        }
      }
      else {
        $results[$v['lmp_id']]['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
      }
    }
  }
  return $results;
}

function checkPlanFeatures($lpf_id, $features_array, $dbo){
  $results = array('hasFeature'=> false, 'count'=> $features_array[$lpf_id]['mfc_count'], 'name'=> $features_array[$lpf_id]['lpf_feature']);
  $present = array_search($lpf_id, array_map(function($v){return $v['lpf_id'];}, $features_array));
  if ($present) {
    $results['hasFeature'] = true;
  }
  return $results;
}


$planList = '<table class="table table-striped table-bordered">';
$planList .= '<thead>
<th>edit</th>
<th>ID</th>
<th>Display Name</th>
<th>Inhouse Name</th>
<th>Plan Type</th>
<th>Monthly Fee</th>
<th>Setup Fee</th>
<th>First bill delayed? (Months)</th>
<th class="col-md-1">Description</th>
<th>Featured?</th>
<th>Status</th>
<th>Max Promo Drafts</th>
<th>Max Active Promos</th>
<th>Displayed Active Promos</th>
<th>Max Keywords</th>
<th>Customer Service Time (minutes)</th>
<!--th>Bonus Catalog Points</th-->
<th>Signup Incentives</th>
<th>Emails per Month</th>
<th>Texts per Month</th>
<!--th>Push Msgs per Month</th-->
<th>Features</th>
</thead>';

$allPlans = getAllPlans($dbo);

  foreach($allPlans as $k=>$v){

  $plan_features = array(
    'offers_site'  => checkPlanFeatures(1, $v['lmp_features'], $dbo),
    'phone_app'  => checkPlanFeatures(2, $v['lmp_features'], $dbo),
    'geo_location'  => checkPlanFeatures(3, $v['lmp_features'], $dbo),
    'business_listing'  => checkPlanFeatures(4, $v['lmp_features'], $dbo),
    'marketing_materials' => checkPlanFeatures(5, $v['lmp_features'], $dbo),
    'national_mall' => checkPlanFeatures(6, $v['lmp_features'], $dbo),
    'service_time' => checkPlanFeatures(7, $v['lmp_features'], $dbo),
    'consumer_reports' => checkPlanFeatures(8, $v['lmp_features'], $dbo),
    // 'catalog_pts'  => checkPlanFeatures(9, $v['lmp_features'], $dbo),
    'screcials'  => checkPlanFeatures(10, $v['lmp_features'], $dbo),
    'max_promos' => checkPlanFeatures(11, $v['lmp_features'], $dbo),
    'signup_incentives'  => checkPlanFeatures(12, $v['lmp_features'], $dbo),
    'max_emails'   => checkPlanFeatures(13, $v['lmp_features'], $dbo),
    'max_texts'   => checkPlanFeatures(14, $v['lmp_features'], $dbo),
    'max_push'     => checkPlanFeatures(15, $v['lmp_features'], $dbo),
    'max_cat'  => checkPlanFeatures(16, $v['lmp_features'], $dbo),
    'max_key'    => checkPlanFeatures(17, $v['lmp_features'], $dbo),
    'max_drafts' => checkPlanFeatures(18, $v['lmp_features'], $dbo),
    'displayed_active_promos' => checkPlanFeatures(19, $v['lmp_features'], $dbo)
  );

    // get readable plan type instead of numeric values
    switch ($v["pty_id"]) {
      case 1:
        $v["pty_id"] = 'Free';
        break;
      case 3:
        $v["pty_id"] = 'Self-Service';
        break;
      case 4:
        $v["pty_id"] = 'Full-Service';
    }

    // build the rest of the plan table
    $planList .= '<tr>';
      $planList .= '<td><a href="reseller-edit-plan?lmp_id='.$v["lmp_id"].'">edit</a></td>';
      $planList .= '<td>'.$v["lmp_id"].'</td>';
      $planList .= '<td>'.$v["lmp_name"].'</td>';
      $planList .= '<td>'.$v["lmp_admin_name"].'</td>';
      $planList .= '<td>'.$v["pty_id"].'</td>';
      $planList .= '<td>'.$v["lmp_price"].'</td>';
      $planList .= '<td>'.$v["lmp_fee"].'</td>';
      $planList .= '<td>'.$v["lmp_billing_delay"].'</td>';
      $planList .= '<td><div class="plan-desc">'.$v["lmp_description"].'</div></td>';
      $planList .= '<td>'.($v["lmp_featured"] ? 'Yes' : 'No').'</td>';
      $planList .= '<td>'.($v["lmp_active"] ? 'Active' : 'Inactive').'</td>';
      $planList .= '<td>'.($plan_features['max_drafts']['hasFeature'] ? $plan_features['max_drafts']['count'] : '0').'</td>';
      $planList .= '<td>'.($plan_features['max_promos']['hasFeature'] ? $plan_features['max_promos']['count'] : '0').'</td>';
      $planList .= '<td>'.($plan_features['displayed_active_promos']['hasFeature'] ? $plan_features['displayed_active_promos']['count'] : '0').'</td>';
      $planList .= '<td>'.($plan_features['max_key']['hasFeature'] ? $plan_features['max_key']['count'] : '0').'</td>';
      $planList .= '<td>'.($plan_features['service_time']['hasFeature'] ? $plan_features['service_time']['count'] : '0').'</td>';
      // $planList .= '<td>'.($plan_features['catalog_pts']['hasFeature'] ? (is_null($plan_features['catalog_pts']['count']) ? 'Unlimited' : $plan_features['catalog_pts']['count']) : '0').'</td>';
      $planList .= '<td>'.($plan_features['signup_incentives']['hasFeature'] ? $plan_features['signup_incentives']['count'] : '0').'</td>';
      $planList .= '<td>'.($plan_features['max_emails']['hasFeature'] ? $plan_features['max_emails']['count'] : '0').'</td>';
      $planList .= '<td>'.($plan_features['max_texts']['hasFeature'] ? $plan_features['max_texts']['count'] : '0').'</td>';
      // $planList .= '<td>'.($plan_features['max_push']['hasFeature'] ? $plan_features['max_push']['count'] : '0').'</td>';
      $planList .= '<td><ul class="features_list">';
      $planList .=  ($plan_features['max_push']['hasFeature'] ? '<li>'.$plan_features['max_push']['name'].'</li>' : '');
      $planList .=  ($plan_features['offers_site']['hasFeature'] ? '<li>'.$plan_features['offers_site']['name'].'</li>' : '');
      $planList .=  ($plan_features['phone_app']['hasFeature'] ? '<li>'.$plan_features['phone_app']['name'].'</li>' : '');
      $planList .=  ($plan_features['geo_location']['hasFeature'] ? '<li>'.$plan_features['geo_location']['name'].'</li>' : '');
      $planList .=  ($plan_features['business_listing']['hasFeature'] ? '<li>'.$plan_features['business_listing']['name'].'</li>' : '');
      $planList .=  ($plan_features['marketing_materials']['hasFeature'] ? '<li>'.$plan_features['marketing_materials']['name'].'</li>' : '');
      $planList .=  ($plan_features['national_mall']['hasFeature'] ? '<li>'.$plan_features['national_mall']['name'].'</li>' : '');
      $planList .=  ($plan_features['consumer_reports']['hasFeature'] ? '<li>'.$plan_features['consumer_reports']['name'].'</li>' : '');
    $planList .= '</ul></td>';
    $planList .= '</tr>';
  }
$planList .= '</table>';

require 'header.php';
?>
<style>
#alert{
  text-align: center;
  position: fixed;
  top: 25%;
  z-index: 10;
  width: 50%;
  left: 25%;
  right: 50%;
  display: none;
  -webkit-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
  -moz-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
  box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
}
.lt_alerts{
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  background: rgba(5,155,5,1);
  color: #fff;
  text-align: center;
  padding: 10px;
  font-size: 32px;
}
.plan-desc {
  max-height: 75px;
  overflow-y: scroll;
}
ul.features_list {
  text-align: left;
  padding-left: 15px;
  margin: 0;
  /*max-height: 75px;*/
  font-size: 11px;
  list-style-type: disc;
  /*overflow-y: scroll;*/
}
ul.features_list li {
  padding-bottom: 7px;
}
</style>
<div id="adm_body">
  <div id='main' class='container-fluid'>
    <div class='row'>
      <div class='col-md-12'>
        <h1><a href="reseller"><span class='glyphicon glyphicon-tower'></span> Manage Resellers</a></h1>
        <?php
          if (is_Array($error)) {
            echo "<div id='push_errors' class='alert alert-danger'><span class='glyphicon glyphicon-exclamation-sign'></span> <strong>Error:</strong><ul>";
            foreach($error as $key => $value) {
              $error_msg .= '<li>' . $value . '</li>';
            }
            echo $error_msg . "</ul></div>";
          }
        ?>
      </div>
    </div>
    <?php if ($noReseller != true) { ?>
      <div class="row">
        <div class="col-md-12">
          <h2>Reseller Plans <a href="#new_plan_form"><button type="button" class="btn btn-primary btn-xs">Create New Plan</button></a></h2>
          <?php echo $planList; ?>
        </div>
      </div>
      <br>
      <div class="row">
        <div class="col-md-4">
          <form method="post" id="new_plan_form">
            <h2>Create a New Plan</h2>
            <div class="form-group"><label for="txt_lmp_name_r">Display Name</label><input type="text" name="txt_lmp_name_r" id="txt_lmp_name_r" class="form-control" placeholder="Plan's Front-end Display Name" required></div>
            <div class="form-group"><label for="txt_lmp_admin_name">Inhouse Display Name</label><input type="text" name="txt_lmp_admin_name" id="txt_lmp_admin_name" class="form-control" placeholder="Plan's Inhouse Name"></div>
            <div class="form-group">
              <label for="wnu_pty_id">Plan Type</label>
              <select name="wnu_pty_id" id="wnu_pty_id" class="form-control">
                <option value="1">Free</option>
                <option value="3">Self-Service</option>
                <option value="4">Full-Service</option>
              </select>
            </div>
            <div class="form-group"><label for="dec_lmp_price">Monthly Fee</label><input type="number" name="dec_lmp_price" id="dec_lmp_price" class="form-control" min="0" max="99999" step=".01" value="0" required></div>
            <div class="form-group"><label for="dec_lmp_fee">Setup Fee</label><input type="number" name="dec_lmp_fee" id="dec_lmp_fee" class="form-control" min="0" max="1000" step=".01" value="0" required></div>
            <div class="form-group">
              <label for="wnu_lmp_billing_delay">Delay First Bill? (months)</label>
              <select name="wnu_lmp_billing_delay" id="wnu_lmp_billing_delay" class="form-control" required>
                <option value="0">0</option>
                <option value="1">1</option>
                <option value="2">2</option>
                <option value="3">3</option>
                <option value="4">4</option>
                <option value="5">5</option>
                <option value="6">6</option>
                <option value="7">7</option>
                <option value="8">8</option>
                <option value="9">9</option>
                <option value="10">10</option>
                <option value="11">11</option>
                <option value="12">12</option>
              </select>
            </div>
            <div class="form-group"><label for="txt_lmp_description_r">Description</label><input type="text" name="txt_lmp_description_r" id="txt_lmp_description_r" class="form-control" placeholder="Plan's Description" required></div>
            <div class="form-group">
              <label for="bit_lmp_featured">Featured Plan?</label>
              <select name="bit_lmp_featured" id="bit_lmp_featured" class="form-control">
                <option value="1">Yes</option>
                <option value="0" selected>No</option>
              </select>
            </div>
            <div class="form-group">
              <label for="wnu_lmp_max_drafts">Max Promotion Drafts</label>
              <select name="wnu_lmp_max_drafts" id="wnu_lmp_max_drafts" class="form-control" required>
                <option value="0">0</option>
                <option value="2">2</option>
                <option value="4">4</option>
                <option value="6">6</option>
                <option value="8">8</option>
                <option value="10">10</option>
                <option value="12">12</option>
                <option value="14">14</option>
                <option value="16">16</option>
              </select>
            </div>
            <div class="form-group">
              <label for="wnu_lmp_max_promos">Max Active Promotions</label>
              <select name="wnu_lmp_max_promos" id="wnu_lmp_max_promos" class="form-control" required>
                <option value="0">0</option>
                <option value="2">2</option>
                <option value="4">4</option>
                <option value="6">6</option>
                <option value="8">8</option>
                <option value="10">10</option>
                <option value="12">12</option>
                <option value="14">14</option>
                <option value="16">16</option>
              </select>
            </div>
            <div class="form-group">
              <label for="wnu_lmp_displayed_active_promos">Displayed Active Promotions</label>
              <select name="wnu_lmp_displayed_active_promos" id="wnu_lmp_displayed_active_promos" class="form-control" required>
                <option value="0">0</option>
                <option value="2">2</option>
                <option value="4">4</option>
                <option value="6">6</option>
                <option value="8">8</option>
                <option value="10">10</option>
                <option value="12">12</option>
                <option value="14">14</option>
                <option value="16">16</option>
              </select>
            </div>
            <div class="form-group">
              <label for="wnu_lmp_max_key">Max # of Keywords</label>
              <select name="wnu_lmp_max_key" id="wnu_lmp_max_key" class="form-control" required>
                <option value="2">2</option>
                <option value="3">3</option>
                <option value="4">4</option>
                <option value="5">5</option>
                <option value="6">6</option>
                <option value="7">7</option>
                <option value="8">8</option>
                <option value="9">9</option>
                <option value="10">10</option>
              </select>
            </div>
            <div class="form-group"><label for="wnu_lmp_service_time">Customer Service Time (minutes)</label><input type="number" name="wnu_lmp_service_time" id="wnu_lmp_service_time" class="form-control" min="0" max="1000" step="1" value="0" required></div>
<!--             <div class="form-group">
              <label for="wnu_lmp_catalog_points">Bonus Catalog Points</label><input type="number" name="wnu_lmp_catalog_points" id="wnu_lmp_catalog_points" class="form-control" min="0" max="10000" step="1" value="0"><br>
              <input type="checkbox" id="catalog_unlimited" name="catalog_unlimited" value="1"> <label for="catalog_unlimited">Unlimited Bonus Catalog Points</label>
            </div> -->
            <div class="form-group"><label for="wnu_lmp_incentives">Sign Up Incentives</label><input type="number" name="wnu_lmp_incentives" id="wnu_lmp_incentives" class="form-control" min="0" max="10" step="1" value="0" required></div>
            <div class="form-group"><label for="wnu_lmp_emails">Emails per Month</label><input type="number" name="wnu_lmp_emails" id="wnu_lmp_emails" class="form-control" min="0" max="5000" step="1" value="0" required></div>
            <div class="form-group"><label for="wnu_lmp_sms_texts">SMS Texts per Month</label><input type="number" name="wnu_lmp_sms_texts" id="wnu_lmp_sms_texts" class="form-control" min="0" max="5000" step="1" value="0" required></div>
             <!-- <div class="form-group"><label for="wnu_lmp_push_msgs">Push Notifications/Messages per Month</label><input type="number" name="wnu_lmp_push_msgs" id="wnu_lmp_push_msgs" class="form-control" min="0" max="5000" step="1" value="<?php echo ($plan_features['max_push']['hasFeature'] ? $plan_features['max_push']['count']:0); ?>" required></div> -->

              <div class="form-group">
                <input type="checkbox" name="bit_lmp_push_msgs" id="bit_lmp_push_msgs" value="1" <?php echo ($plan_features['max_push']['hasFeature'] ? 'checked':''); ?>>
                <label for="bit_lmp_push_msgs">Push Notifications</label>
              </div>
            <div class="form-group">
              <input type="checkbox" name="bit_lps_branded_site" id="bit_lps_branded_site" value="1" checked>
              <label for="bit_lps_branded_site">Branded Offers Site</label>
            </div>
            <div class="form-group">
              <input type="checkbox" name="bit_lps_phone_app" id="bit_lps_phone_app" value="1" checked>
              <label for="bit_lps_phone_app">Branded Phone App</label>
            </div>
            <div class="form-group">
              <input type="checkbox" name="bit_lps_geo_location" id="bit_lps_geo_location" value="1" checked>
              <label for="bit_lps_geo_location">GeoLocation Service</label>
            </div>
            <div class="form-group">
              <input type="checkbox" name="bit_lps_business_listing" id="bit_lps_business_listing" value="1" checked>
              <label for="bit_lps_business_listing">Business Listing</label>
            </div>
            <div class="form-group">
              <input type="checkbox" name="bit_lps_marketing_materials" id="bit_lps_marketing_materials" value="1" checked>
              <label for="bit_lps_marketing_materials">In-Store Marketing Materials</label>
            </div>
            <div class="form-group">
              <input type="checkbox" name="bit_lps_national_mall" id="bit_lps_national_mall" value="1" checked>
              <label for="bit_lps_national_mall">National Mall</label>
            </div>
            <div class="form-group">
              <input type="checkbox" name="bit_lps_screcials" id="bit_lps_screcials" value="1" checked>
              <label for="bit_lps_screcials">Screcials</label>
            </div>
            <div class="form-group">
              <input type="checkbox" name="bit_lps_consumer_reports" id="bit_lps_consumer_reports" value="1" checked>
              <label for="bit_lps_consumer_reports">Analytics and Consumer Reports</label>
            </div>
            <input type="hidden" name="bit_lmp_active" value="1">
            <input type="hidden" name="createNewPlan" value="1">
            <button class="btn btn-success" type="submit" id="create_plan_btn">Create New Plan</button> <button class="btn btn-danger cancelBtn" type="button">Cancel</button>
          </form>
        </div>
      </div>
    <?php } else { echo 'No reseller found.'; } ?>
  </div><!--end #main .container-->
</div>

<script>
$(document).ready(function(){

  $('#new_plan_form').on('submit', function(e){
    e.preventDefault();
    $('#create_plan_btn').prop('disabled', true).text('Creating plan...');
    // create new plan
    var data = $(this).serialize();
    $.ajax({
      url: "../ajax/ajax.edit-reseller-plan.php",
      global: false,
      type: "POST",
      dataType: "JSON",
      data: data,
      success: function (response){
        // console.log(response);
        if (response['status'] === 'success'){
          console.log(response);
          location.reload();
        } else {
          console.log(response['status']);
        }
      },
      error: function(response){
        $('#create_plan_btn').prop('disabled', false).text('Create New Plan');
        console.log(response);
      }
    });
  });

  // refresh page when a cancel button is clicked
  $('.cancelBtn').on('click', function(){
   location.reload();
  });

});
</script>
<?php
require 'footer.php';
/* EOF ?> */
