<?php
require '../app/start_session.php';

if (isset($_GET['rss_id'])) {
	
	$_switchOk = preg_replace("/[^0-9]/", "",$_GET['rss_id']);
	
	if (!empty($_switchOk)) {
		$sql = '
			DELETE RSW, R2S FROM tbl_reseller_switches RSW LEFT JOIN tbl_reseller2switch R2S ON RSW.rss_id=R2S.rss_id WHERE RSW.rss_id=:sw 
		';
				
		$tmp = $dbo->prepare($sql);
		$tmp->bindValue( ':sw', $_switchOk, PDO::PARAM_INT );	
		$tmp->execute();		
		
	}
	header('Location: /admin/reseller-switches');
}
elseif (isset($_GET['switch_name'])) {
	
	$_switchOk = preg_replace("/[^0-9a-zA-Z\_\-]/", "",$_GET['switch_name']);
	
	if (!empty($_switchOk)) {
		$sql = '
			INSERT IGNORE INTO tbl_reseller_switches (rss_name) VALUES (:sw)
		';
		

		$tmp = $dbo->prepare($sql);
		$tmp->bindValue( ':sw', $_switchOk, PDO::PARAM_STR );
		$tmp->execute();		
		
		$tmpId = $dbo->lastInsertId();
		if ($tmpId) {header('Location: /admin/reseller-switches?switch=' . $tmpId);}
		
	}	
	
	header('Location: /admin/reseller-switches');
}
elseif (isset($_GET['switch'], $_GET['res_id'])) {
	$_switchOk = preg_replace("/[^0-9]/", "",$_GET['switch']);
	$_id = preg_replace("/[^0-9]/", "",$_GET['res_id']);
	
	$sql = '
		INSERT IGNORE INTO tbl_reseller2switch (rss_id, res_id) VALUES (:sw, :rId)
	';
	
	$tmp = $dbo->prepare($sql);
	$tmp->bindValue( ':sw', $_switchOk, PDO::PARAM_INT );
	$tmp->bindValue( ':rId', $_id, PDO::PARAM_INT );
	$tmp->execute();
	
	if (!$dbo->lastInsertId()) {
		$sql = '
			DELETE FROM tbl_reseller2switch WHERE rss_id=:sw AND res_id = :rId
		';
		$tmp = $dbo->prepare($sql);
		$tmp->bindValue( ':sw', $_switchOk, PDO::PARAM_INT );
		$tmp->bindValue( ':rId', $_id, PDO::PARAM_INT );
		$tmp->execute();
	}
		
	header('Location: /admin/reseller-switches?switch=' . $_switchOk);
}


require 'header.php';

//GET CURRENT SWITCHES
function getResellersHasSwitch ($_switch) {	
	global $dbo;
	$sql = '
		SELECT DISTINCT RES.res_name, RES.res_id, (CASE WHEN TMP.res_id IS NULL THEN 0 ELSE 1 END) AS has_it
		FROM tbl_reseller RES
		LEFT JOIN (
			SELECT R2S.res_id
			FROM tbl_reseller2switch R2S 
			LEFT JOIN tbl_reseller_switches RSW ON RSW.rss_id = R2S.rss_id		
			WHERE RSW.rss_id=:sw
		) TMP ON RES.res_id = TMP.res_id
		ORDER BY RES.res_name LIMIT 0 , 100
	';
	
	$tmp = $dbo->prepare($sql);
	$tmp->bindValue( ':sw', $_switch, PDO::PARAM_INT );	
	$tmp->execute();
	
	return $tmp->fetchAll(PDO::FETCH_ASSOC);
	
}

function getSwitchList($swId = null){
  $flag = false;
  global $dbo;  
  if ($swId !== null) {$swIdOk = preg_replace("/[^0-9]/", "",$swId); $flag = true;}
  $str='';
  //data-id="'. $switches[$i]['id'] .'"	
  $sql="
	SELECT RSW.rss_name, RSW.rss_id FROM tbl_reseller_switches RSW".($flag? ' WHERE RSW.rss_id=:sw': '')." ORDER BY RSW.rss_name LIMIT 0 , 100
  ";
  $tmp = $dbo->prepare($sql);
  if ($flag) {
	  $tmp->bindValue( ':sw', $swIdOk, PDO::PARAM_INT );	
  }
  $tmp->execute();
  
  return $tmp->fetchAll(PDO::FETCH_ASSOC);
}

//Print current switches
function printSwitchList() { 
 $switches= getSwitchList();
 for ($i=0; $i < count($switches); $i++) {
    echo '<tr><td style="text-align:left;">'.$switches[$i]['rss_name'].'</td><td><table><tr><td><input onclick="go_switch(\''.$switches[$i]['rss_id'].'\')" type="button" name="view" value="view"></td><td><a style="margin-left: 20px;" href="/admin/reseller-switches?rss_id='.$switches[$i]['rss_id'].'"><input type="button" style="background-color: #c12e2a;" name="remove" value="remove"></a></td></tr></table></td></tr>';
 }
}
	$switchName = '';
	
if (isset($_GET['switch']))	{
	$switchName = getSwitchList($_GET['switch']);
	$switchName = isset($switchName[0]['rss_name']) ? $switchName[0]['rss_name'] : '';
}	
	
function printResellerSwitch($_switch) {
 
 $_switchOk = preg_replace("/[^0-9]/", "",$_switch);	
 $res= getResellersHasSwitch ($_switchOk);
 for ($i=0; $i < count($res); $i++) {
	$flag = $res[$i]['has_it'] == 1;
    echo '<tr><td style="text-align:left;"><a href="/admin/reseller-edit?res_id='.$res[$i]['res_id'].'">'.$res[$i]['res_name'].'</a></td><td><a href="/admin/reseller-switches?switch='.$_switchOk.'&res_id='.$res[$i]['res_id'].'"><input type="button" style="background-color:'.($flag?'#c12e2a;':'#1f82c5;').'" name="'.($flag?'remove':'add').'" value="'.($flag?'remove':'add').'"></a></td></tr>';
 }
}
?>
<div class='container-fluid' style="text-align:center;">
  <div class='row'>
    <div class='col-sm-12'>

      <h1>Reseller Switches</h1>
      <table style="width: 100%; max-width:500px; margin:auto;" class="table table-bordered table-striped">
		<caption><?php echo !empty($switchName)? '<strong>Selected Switch:</strong> ' . $switchName  . ' <a href="/admin/reseller-switches"><button class="btn btn-xs btn-default">Select Different Switch</button></a>' : ''; ?></caption>
        <thead>
		  
          <tr>
            <th><?php echo isset($_GET['switch'])? 'Reseller': 'Switch'; ?></th>
            <th style="text-align:center;">Action</th>
          </tr>
        </thead>
       <tbody>
         <tr>
           <?php echo isset($_GET['switch'])? printResellerSwitch($_GET['switch']): printSwitchList(); ?>
         </tr>
       </tbody>
      </table>
      <br>
		<?php 
			if ( !isset( $_GET['switch'] ) ) {
				echo '
				<form method="get" style="width: 100%; max-width:500px; margin:auto;">
					<div class="form-group">
						<label for="switch_name">Switch Name</label>
						<input class="form-control" placeholder="Enter new switch name" name="switch_name" id="switch_name">						
					</div>
					<div class="form-group">
						<input type="submit" class="form-control" value="submit">
						<p>Allow characters are: a-z, A-Z, 0-9, "_" and "-". If any oter is entered will removed.</p>
					</div>
				</form>';
			}
		?>
    </div>
  </div>
</div>


<script>
function go_switch(switch_id) {
  window.location = '?switch='+switch_id;
}
</script>

<?php

require 'footer.php';
