<?php
//-----------------------------------
// admin/reseller.php
//-----------------------------------

require '../app/start_session.php';
$dbo=connect();

// --- GET CURRENT RESELLERS --- //
$sql = 'SELECT res_email, res_id, res_name, res_subdomain, res_logo, res_active FROM tbl_reseller ORDER BY res_timestamp DESC';
$qry = $dbo->prepare( $sql );
$qry=execPDO($qry);
$qry = $qry->fetchAll( PDO::FETCH_ASSOC );
if(empty($qry)){
  $noResellers = true;
} else {
  foreach ($qry as $key => $value) {
    $resellers[$key] = array(
      'id'         => $value['res_id'],
      'name'       => $value['res_name'],
	  'email'       => $value['res_email'],
      'subdomain'  => $value['res_subdomain'],
      'logo'       => $value['res_logo'],
      'active'     => $value['res_active']
    );
  }
}

if($_SERVER['REQUEST_METHOD'] = $_POST && isset($_POST['txt_reseller_name_r']) && isset($_POST['txl128_reseller_subdomain_r'])){
  //CHECK IF FIELDS WERE POSTED - redirect away if any missing
  $fields=array('txl128_reseller_subdomain_r', 'txt_reseller_name_r', 'ema_res_email_r', 'pho_res_csr_phone');
  //check the values of passed variables
  include '../app/class.variables.php';
  $cv = new _variables(); // new instance
  foreach($fields as $name=>$value) $cv->varible_in($value); //each variable is added to class by array loop
  $_v=$cv->get_cleaned_variables();
  $errors=$cv->get_bad_variables();

  $_v['reseller_subdomain'] = strtolower(preg_replace('/[^\w]/', '', $_v['reseller_subdomain']));

  // check if subdomain is a reserved word or in use by a different reseller
  include 'inc/function.check-subdomain.php';
  checkSubdomain($_v['reseller_subdomain']);
  
  if (!count($errors)){
      $sql = 'INSERT INTO `tbl_reseller` (res_name, res_subdomain, res_csr_phone, res_active, res_email) VALUES (:res_name, :res_subdomain, :res_csr_phone, 1, :res_email)';
      $qry = $dbo->prepare($sql);
      $qry->bindValue(':res_name', $_v['reseller_name'], PDO::PARAM_STR);
      $qry->bindValue(':res_subdomain', $_v['reseller_subdomain'], PDO::PARAM_STR);
      $qry->bindValue(':res_csr_phone', $_v['res_csr_phone'], PDO::PARAM_STR);
	  $qry->bindValue(':res_email', $_v['res_email'], PDO::PARAM_STR);
	  
	  
      $qry=execPDO($qry);
      $last_id = $dbo->lastInsertId();
      header('Location: reseller?success=1&res_id='.$last_id);
  } 
}

require 'header.php';
?>

<style>
#alert{
  text-align: center;
  position: fixed;
  top: 25%;
  z-index: 10;
  width: 50%;
  left: 25%;
  right: 50%;
  display: none;
  -webkit-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
  -moz-box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
  box-shadow: 0px 0px 15px 0px rgba(0,0,0,0.5);
}
#add_reseller_form {
  margin-bottom: 25px;
}
.sub-label {
  font-size: 85%;
}
</style>
<div id="adm_body">
  <div id='main' class='container'>
    <div class='row'>
      <div class='col-sm-12'>
        <h1><a href="reseller"><span class='glyphicon glyphicon-tower'></span> Manage Resellers</a></h1>
        <?php
          if (isset($_GET['success']) && $_GET['success'] == 1) {
            echo '<div class="alert alert-success" role="alert" style="font-size:175%;">Success! Reseller added. <a href="reseller-edit?res_id='.$_GET['res_id'].'">Click here to continue setup.</a></div>';
          }
          if (is_Array($errors)) { 
            echo "<div id='push_errors' class='alert alert-danger'><span class='glyphicon glyphicon-exclamation-sign'></span> <strong>Please check the error messages below:</strong><ul>"; 
            foreach($errors as $key => $value) { 
              $error_msg .= '<li>' . $value . '</li>'; 
            } 
            echo $error_msg . "</ul></div>"; 
          } 

          $_host = parse_url('http://'.$_SERVER['HTTP_HOST']);
          preg_match('/(.*?)((\.co)?.[a-z]{2,4})$/i', $_host['host'], $_m);
          $_ext = isset($_m[2]) ? $_m[2]: '';
          // var_dump($_ext);
        ?>
      </div>
    </div>
    <?php if ($noResellers != true) { ?>
      <div class="row">
        <div class="col-sm-4">
          <h2>Add a New Reseller</h2>
          <form id="add_reseller_form" method="POST">
            <label for="reseller_name">Reseller Name</label>
            <input type="text" name="txt_reseller_name_r" id="reseller_name" placeholder="example: Global Merchant Services" value="<?php echo $_POST['txt_reseller_name_r']; ?>" class="form-control" required>
            <br>
            <label for="reseller_subdomain">Subdomain <span class="sub-label">(<span id="sub-placehold">subdomain</span>.localthanks<?php echo $_ext; ?>)</span></label>
            <input type="text" name="txl128_reseller_subdomain_r" id="reseller_subdomain" placeholder="example: GMS" value="<?php echo $_POST['txl128_reseller_subdomain_r']; ?>" class="form-control" required>
            <br>
			<label for="ema_res_email_r">Email</label>
            <input type="text" name="ema_res_email_r" id="ema_res_email_r" value="<?php echo $_POST['ema_res_email_r']; ?>" class="form-control" required>
            <br>
            <label for="pho_res_csr_phone">Customer Service Phone Number <span class="sub-label">(not required)</span></label>
            <input type="text" name="pho_res_csr_phone" id="pho_res_csr_phone" value="<?php echo $_POST['pho_res_csr_phone']; ?>" class="form-control">
            <br>
            <input type="submit" id="reseller_submit" value="Add Reseller" class="form-control">
          </form>
          <a href="reseller-manage-plans"><button type="button" class="btn btn-primary">Manage Reseller Plans</button></a>
        </div>
        <div class="col-sm-8">
          <h2>Current Resellers</h2>
          <table class="table table-striped table-bordered" id="reseller_table">
            <thead>
              <th>ID</th>
              <th>Name</th>
              <th>Subdomain</th>
              <th>Logo</th>
              <th>Active?</th>
              <th></th>
            </thead>
            <?php foreach($resellers as $key => $value){ 
              echo 
                '<tr>
                  <td>'.$value['id'].'</td>
                  <td><a href="//'.$value['subdomain'].'.localthanks'.$_ext.'" target="_blank">'.$value['name'].'</a></td>
                  <td><a href="//'.$value['subdomain'].'.localthanks'.$_ext.'" target="_blank">'.$value['subdomain'].'</a></td>
                  <td>'.$value['logo'].'</td>
                  <td>'.($value['active'] == 1?'<span style="color:green">Yes</span>':'<span style="color:red">No</span>').'</td>
                  <td><a href="reseller-edit?res_id='.$value['id'].'">edit</a></td>
                </tr>';
            } ?>
          </table>
        </div>
      </div>
    <?php } else { echo 'No resellers found.'; } ?>

  </div><!--end #main .container-->
</div>
<script>
$(document).ready(function(){
  // access get variables with javascript
  var $_GET = <?php echo json_encode($_GET); ?>;

  // remove anything that isnt a letter or number on change & keyup
  $('#reseller_subdomain').on('change keyup', function(){
    $(this).val($(this).val().replace(/[\W_]+/g, ''));
    if ($(this).val()!=''){
      $('#sub-placehold').text($(this).val());
    } else {
      $('#sub-placehold').text('subdomain');
    }
  });

  // front end form validation && duplicate entry prevention
  $('#add_reseller_form').submit(function(e){
    $('#reseller_submit').attr("disabled", true).val('Adding Reseller...');
    var reseller_name = $.trim($('#reseller_name').val());
    var reseller_subdomain = $.trim($('#reseller_subdomain').val());
    if (reseller_name != '' && reseller_name.length <= 255 && reseller_subdomain !='' && reseller_subdomain.length <= 128){
      $('#add_reseller_form').submit();
    } else {
      e.preventDefault();
      if (reseller_subdomain =='' || reseller_subdomain.length > 128){
        alert('Error: Subdomain cannot be empty & must be under 128 characters long.');
        $('#reseller_submit').attr("disabled", false).val('Add Reseller');
      } else if (reseller_name == '' || reseller_name.length > 255) {
        alert('Error: Reseller name cannot be empty & must be under 255 characters long.');
        $('#reseller_submit').attr("disabled", false).val('Add Reseller');
      }
    }
  });

  $('#reseller_table').dataTable({
    "columns": [
        null,
        null,
        null,
        null,
        null,
        {'orderable': false, 'sortable': false}
        ],
    "order": [[ 0, 'desc' ]]
  });
});
</script>

<?php

require 'footer.php';



/* EOF ?> */