<?php
require '../app/start_session.php';
require '../app/class.variables.php';
require 'header.php';


$json='{
  	"id":          {"dbcol":"ltm_id",              "clean":"wnu12",  "placehold":"Acct #",          "type":"number"},
  	"Company":     {"dbcol":"ltm_company_name",    "clean":"nam64",  "placehold":"Company Name",    "type":"text"},
  	"Contact":     {"dbcol":"ltb_contact_name",    "clean":"nam64",  "placehold":"Contact Name",    "type":"text"},
  	"Email":       {"dbcol":"ltb_email",           "clean":"txt128", "placehold":"Contact Email",   "type":"text"},
  	"Phone":       {"dbcol":"ltb_phone_number",    "clean":"pho16",  "placehold":"Contact Phone",   "type":"text"},
  	"Plan":        {"dbcol":"'.($DB_SWITCH?'prod_name':'lmp_name').'",
                                                   "clean":"pho32",  "placehold":"Plan",            "type":"text"},
  	"Signup":      {"dbcol":"bill_date",           "clean":"dat64",  "placehold":"YYYY-MM-DD",      "type":"date"},
  	"Reseller":    {"dbcol":"res_name",            "clean":"txt32",  "placehold":"Reseller",        "type":"text"},
  	"Code":        {"dbcol":"dsc_code",            "clean":"aon64",  "placehold":"Promo Code",      "type":"text"},
  	"Agent":       {"dbcol":"ltb_referring_agent", "clean":"nam64",  "placehold":"Referring Agent", "type":"text"},
  	"Sales Person":{"dbcol":"ltb_salesperson",     "clean":"nam64",  "placehold":"Sales Person",    "type":"text"}
}';
$fields = json_decode( $json, true );



//clean variables
$cv= new _variables(); //new instance
foreach($fields as $field) $cv->varible_in($field['clean'].'_'.$field['dbcol']);
$_cv=$cv->get_cleaned_variables();
$errors=$cv->get_bad_variables();

$sql = "
SELECT 
LTM.ltm_id,
LTM.ltm_company_name,
LTB.ltb_contact_name,
LTB.ltb_email,
LTB.ltb_phone_number,
".($DB_SWITCH?
	'prod_name'
	:
	'lmp_name'
)." AS plan_name,  
BILL.bill_date,
RES.res_name,
dsc_code, 
LTB.ltb_referring_agent,
LTB.ltb_salesperson 
FROM lt_member_merchants LTB
INNER JOIN lt_merchants LTM ON LTB.ltb_id=LTM.ltb_id 
INNER JOIN tbl_reseller RES ON LTB.res_id=RES.res_id 
INNER JOIN lt_merchant_billing BILL ON LTM.ltm_id=BILL.ltm_id 
LEFT JOIN tbl_discount_code DSC ON BILL.dsc_id=DSC.dsc_id 

".($DB_SWITCH?
	'LEFT JOIN tbl_product PROD ON LTB.pk_id=PROD.prod_id'
	:
	'INNER JOIN lt_merchant_plans LMP ON BILL.lmp_id=LMP.lmp_id'
)."

WHERE BILL.bill_active=1";

foreach($fields as $field){ // loop through input fields
	if($_cv[$field['dbcol']]){ // if field input field has content
		list($tbl_alais) = explode("_", strtoupper($field['dbcol'])); //get table alias from column name
		if ($field['type']=='number')
			$sql.=" AND ". $tbl_alais.'.'.$field['dbcol'].' = :'.$field['dbcol']; 
		if ($field['type']=='date')
			$sql.=" AND ". $tbl_alais.'.'.$field['dbcol']." BETWEEN DATE_ADD(:".$field['dbcol'].", INTERVAL -7 DAY) AND :".$field['dbcol']." ";
		else
			$sql.=" AND ". $tbl_alais.'.'.$field['dbcol']." LIKE :".$field['dbcol']; 
	}
}
$sql.=" ORDER BY bill_date";

$stmt = $dbo->prepare( $sql );

foreach($fields as $field){ 
	if($_cv[$field['dbcol']]){
		if($field['type']=='number')
			$stmt->bindValue(":".$field['dbcol'], $_cv[$field['dbcol']], PDO::PARAM_INT);	
		else if($field['type']=='date'){
			list($m,$d,$y) = explode("/", $_cv[$field['dbcol']]); //var checker wanted the date variable in 'mm/dd/yyy' format. We need to convert that to format for what mysql wants
			$stmt->bindValue(":".$field['dbcol'], $y.'-'.$m.'-'.$d.' 23:59:59', PDO::PARAM_STR);	
		}else
			$stmt->bindValue(":".$field['dbcol'], $_cv[$field['dbcol']].'%', PDO::PARAM_STR);	
	}
}


$stmt->execute();
$stmt = $stmt->fetchAll(PDO::FETCH_ASSOC);
$json_data=json_encode($stmt);
//echo '<!--'.$json_data.'-->';


?>
<style>
.errors {color: red;font-size: 11px;display:inline-block;}
h1 {text-align: center;}
#results_table th {text-align:center !important;}
#search_wrap{
	color:#fff; 
	background-color:#333;
	padding:25px 15px;
	border-radius: 5px;
	margin-bottom: 15px;
}
</style>


<?php

function getWeek($week, $year) {
	$dto = new DateTime();
	$result['start'] = $dto->setISODate($year, $week, 0)->format('Y-m-d');
	$result['niceend'] = $dto->setISODate($year, $week, 6)->format('F j, Y');
	$result['end'] = $dto->setISODate($year, $week, 6)->format('m/d/Y');
	return $result;
}


?>

<div class='container-fluid'>
	<div class='row'>
		<div class='col-sm-12'>
			<h1><a href="merchant-search"><span class='glyphicon glyphicon-search'></span><?php echo $_GET['url2'];?> Sales </a></h1>
		</div>
	</div>


	<!-- start form -->
	<div id="search_wrap">
	<form method="get">
	<div class='row'>
		<div style="text-align:center;">
			<div style="display:inline-block;">

				<?php 
				foreach($fields as $field_label=>$field){
					echo '
				<div class="col-lg-1 col-md-2 col-sm-3 col-xs-6">
					<div class="form-group">
						<label for="'.$field['clean'].'_'.$field['dbcol'].'" style="white-space: nowrap;">'.$field_label.'</label>';
					if($field['type']=='date'){

						echo '<select class="form-control input-sm" name="'.$field['clean'].'_'.$field['dbcol'].'">';
						echo '	<option value="0">End of week</option>';

						//get the end of week date for the past year
						$year=date("Y"); $w = date("W"); $weeksback='53'; //setting vars 
						for($i=$weeksback;$i>0;$i--) { //looping 53 weeks
						    $result=getWeek($w,$year); //passing week count & year to date function
						    echo '
						    	<option value="'.$result['end'].'" '.
								($result['end']==$_REQUEST[$field['clean'].'_'.$field['dbcol']]?' selected ':'')
						    	.'>'.$result['niceend'].'</option>'; //output
						    $w--;
						}
						echo '</select>';
					}else{
						echo '
						<input type="'.$field['type'].'" class="form-control input-sm" name="'.$field['clean'].'_'.$field['dbcol'].'" value="'.$_REQUEST[$field['clean'].'_'.$field['dbcol']].'" placeholder="'.$field['placehold'].'">';
					}
					echo '
					</div>
				</div>';
				}
				?>		

				<div class="col-lg-1 col-md-2 col-sm-3 col-xs-6">
					<br><a href="#" id ="export" class="btn btn-sm btn-default form-control" onclick='downloadCSV({ filename: "stock-data.csv" })' style="color:#111;"><span class='glyphicon glyphicon-download-alt'></span> CSV</a>
				</div>


			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-lg-11">
			<button class="btn btn-sm btn-primary form-control"><span class='glyphicon glyphicon-search'></span> Search</button>
		</div>
	</div>
	</form>
	</div>
	<!-- end form -->


	<div class="row">
		<div class="col-xs-12">
			<table id="results_table" class="table table-bordered table-striped datatable">
				<thead class = "dt-head-center">
					<tr><?php foreach($fields as $field_label=>$field) echo '<th>'.$field_label.'</th>';?></tr>
				</thead>
				<tbody>
				<?php 
				foreach ($stmt as $k=>$v){
					echo '<tr>';
					foreach($fields as $field)	echo '<td>'.$v[$field['dbcol']].'</td>';
					echo '</tr>';
				}
				?>
				</tbody>
			</table>
		</div>
	</div>
</div>
<script>
$(document).ready(function(){
	$('#results_table').dataTable({

	});
});

var data = <?php echo $json_data;?>;


// prepare CSV data
var csvData = new Array();
csvData.push('"id","Company","Contact","Email","Phone","Plan","Signup Date","Reseller","Discount Code","Agent","Salesperson","Last Billed","Amount"');


for(var key in data) {
    json_row=data[key];
    csv_row='';
    for(var key in json_row) {
        json_val=json_row[key];
        if(!json_val) json_val="";
        csv_row+='"'+json_val+'",';
    }
    csv_row += '"",""'; //data of two end columns blank, use per marketing request.
	//console.log(csv_row);
    csvData.push(csv_row);
}

// download stuff
var fileName = "data.csv";
var buffer = csvData.join("\n");
var blob = new Blob([buffer], {
    "type": "text/csv;charset=utf8;"            
});

var link = document.getElementById("export");

if(link.download !== undefined) { // feature detection
    // Browsers that support HTML5 download attribute
    link.setAttribute("href", window.URL.createObjectURL(blob));
    link.setAttribute("download", fileName);
}



</script>
<?php require 'footer.php'; ?>