<?php 
require '../../app/start_session.php';

header( 'Content-Type: application/json; charset=utf-8' );

$response['status']='EMPTY';
// $response['test']=$_REQUEST;  

/* Handle MyStore login */

if ($_SERVER['REQUEST_METHOD'] == 'POST' || $_SERVER['REQUEST_METHOD'] == 'GET' && isset($_REQUEST['mystore_login'], $_REQUEST['ltm_id'], $_REQUEST['reason_for_entry'], $_SESSION['user']['admin']['adm_id']) && preg_match('/^[0-9]+$/',$_REQUEST['ltm_id']) && preg_match('/^[0-9]+$/',$_SESSION['user']['admin']['adm_id'])){
	require '../../app/function.connect.php';
	require '../../app/global.php';

	$_REQUEST['reason_for_entry'] = trim($_REQUEST['reason_for_entry']);

	if ($_REQUEST['reason_for_entry'] == ''){
		$response['status']='Provide a reason for entering this merchant\'s MyStore';
	} else {
		// get info and set sessions
		$qry = $dbo->prepare( "

			SELECT MMR.*

			FROM lt_merchants MRC

			INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=MRC.ltb_id

			WHERE MRC.ltm_id=:id LIMIT 1" );

			$qry->bindValue(':id', $_REQUEST['ltm_id'], PDO::PARAM_INT);

			$qry->execute();

		if ($usr = $qry->fetch(PDO::FETCH_ASSOC)){	

			// insert record of admin entry
	        $sql = 'INSERT INTO lt_merchant_cs_time (adm_id, ltm_id, cst_entry_reason) VALUES (:adm_id, :ltm_id, :entry_reason)';
		    $qry = $dbo->prepare($sql);
		    $qry->bindValue(':adm_id',$_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT );
			$qry->bindValue(':ltm_id',$_REQUEST['ltm_id'], PDO::PARAM_INT );
			$qry->bindValue(':entry_reason',$_REQUEST['reason_for_entry'], PDO::PARAM_STR );
		    $qry=execPDO($qry);
		    // return entry ID so we can use it to update the entry later
		    $response['cst_id'] = $dbo->lastInsertId();
		    // $response['test'] = $qry;
			// $response['cst_id'] = 123; // fake ticket ID for dev purposes

			// how many minutes do they get from their plan?
			$sql = '
			SELECT use_count 
			FROM tbl_use_count USC
			INNER JOIN tbl_product PROD ON PROD.prod_id = USC.prod_id
			INNER JOIN tbl_package PACK ON PROD.prod_id = PACK.pk_id
			WHERE PROD.prod_keyword = "LT_FULL_SERVICE"
				  AND PACK.pk_id = :pk_id 
				  AND USC.ltb_id = :ltb_id
			ORDER BY USC.ltb_id DESC';
			$qry = $dbo->prepare( $sql );
			$qry->bindValue(':pk_id', $usr['pk_id'], PDO::PARAM_INT);
			$qry->bindValue(':ltb_id', $usr['ltb_id'], PDO::PARAM_INT);
			$qry=execPDO($qry);
			$qry = $qry->fetchAll( PDO::FETCH_ASSOC );
			$cs_time = ($qry[0]['use_count'] * 60); // take lmp_service_time (minutes) and convert to seconds

		    // get merchant's customer service time left
			$sql = 'SELECT SUM(cst_seconds) AS time_spent FROM lt_merchant_cs_time WHERE ltm_id=:id AND MONTH(cst_start_time) = MONTH(NOW()) AND YEAR(cst_start_time) = YEAR(NOW())';
			$qry = $dbo->prepare( $sql );
			$qry->bindValue(':id',$_REQUEST['ltm_id'], PDO::PARAM_INT);
			$qry=execPDO($qry);
			$qry = $qry->fetch( PDO::FETCH_ASSOC );
			$cs_time = ($cs_time + $qry['time_spent']); // time spent is -seconds
			$response['time_left'] = $cs_time;

			// get merchant's call history
			$sql = 'SELECT DISTINCT CST.cst_start_time, CST.cst_call_summary, ADM.adm_chat_name, CST.cst_entry_reason FROM lt_merchant_cs_time CST LEFT JOIN tbl_admin ADM ON CST.adm_id = ADM.adm_id WHERE ltm_id=:id ORDER BY cst_start_time DESC LIMIT 20';
			$qry = $dbo->prepare( $sql );
			$qry->bindValue(':id',$_REQUEST['ltm_id'], PDO::PARAM_INT );
			$qry=execPDO($qry);
			$qry = $qry->fetchAll( PDO::FETCH_ASSOC );
			$response['call_history'] = $qry;
			
			//same as function.login "merchant"
			require_once '../../app/class.member-merchant.php';
			$merchantObj 				 = new App\MemberMerchant\MemberMerchant($dbo, true, $usr['ltb_id'], true);
			$arr['plan'] 				 = $merchantObj->getCurrent('Plan');					
			$arr['ltm_id']               = $merchantObj->getCurrentStore('ltm_id');
			$arr['ltm_company_name']     = $merchantObj->getCurrentStore('ltm_company_name');							
			$tmpMerchantReseller         = $merchantObj->getMerchantReseller( $usr['ltb_id'] );	
			$arr['res_id']               = isset($tmpMerchantReseller['res_id'])?$tmpMerchantReseller['res_id']:0;
			$arr['res_name']             = isset($tmpMerchantReseller['res_name'])?$tmpMerchantReseller['res_name']:'';
			//$arr['tmp_id']             = $usr[0]['tmp_id'];
			$arr['promo_count']          = $merchantObj->getTotalActivePromos();
			$arr['date']  				 = date('m/d/Y');
			
			foreach ($arr as $Key=>$Value) {	
			 $_SESSION['user']['merchant'][$Key] = $Value;
			}

			$response['reason_for_entry'] = $_REQUEST['reason_for_entry'];
			// set success response
			$response['status']='success';
		} else {
			// merchant could not be found
			$response['status']='Error Selecting Merchant';
		}
	}
} else {
	$response['status']='Required fields are missing';
}

echo json_encode($response);
?>