<?php 
require '../../app/start_session.php';

header( 'Content-Type: application/json; charset=utf-8' );

$response['status']='EMPTY';
// $response['test']=$_REQUEST;  

/* Handle MyStore login */

if ($_SERVER['REQUEST_METHOD'] == 'POST' || $_SERVER['REQUEST_METHOD'] == 'GET' && isset($_REQUEST['mystore_login'], $_REQUEST['ltm_id'], $_REQUEST['reason_for_entry'], $_SESSION['user']['admin']['adm_id']) && preg_match('/^[0-9]+$/',$_REQUEST['ltm_id']) && preg_match('/^[0-9]+$/',$_SESSION['user']['admin']['adm_id'])){
	require '../../app/function.connect.php';
	require '../../app/global.php';

	$_REQUEST['reason_for_entry'] = trim($_REQUEST['reason_for_entry']);

	if ($_REQUEST['reason_for_entry'] == ''){
		$response['status']='Provide a reason for entering this merchant\'s MyStore';
	} else {
		// get info and set sessions
		$qry = $dbo->prepare( "

			SELECT MMR.*

			FROM lt_merchants MRC

			INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=MRC.ltb_id

			WHERE MRC.ltm_id=:id LIMIT 1" );

			$qry->bindValue(':id', $_REQUEST['ltm_id'], PDO::PARAM_INT);

			$qry->execute();

		if ($usr = $qry->fetch(PDO::FETCH_ASSOC)){	

			// insert record of admin entry
	        $sql = 'INSERT INTO lt_merchant_cs_time (adm_id, ltm_id, cst_entry_reason) VALUES (:adm_id, :ltm_id, :entry_reason)';
		    $qry = $dbo->prepare($sql);
		    $qry->bindValue(':adm_id',$_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT );
			$qry->bindValue(':ltm_id',$_REQUEST['ltm_id'], PDO::PARAM_INT );
			$qry->bindValue(':entry_reason',$_REQUEST['reason_for_entry'], PDO::PARAM_STR );
		    $qry=execPDO($qry);
		    // return entry ID so we can use it to update the entry later
		    $response['cst_id'] = $dbo->lastInsertId();
		    // $response['test'] = $qry;
			// $response['cst_id'] = 123; // fake ticket ID for dev purposes

			// how many minutes do they get from their plan?
			$sql = 'SELECT mfc_count FROM lt_max_feature_cnt WHERE lpf_id = 7 AND lmp_id = :lmp_id AND (ltb_id = :ltb_id OR ltb_id IS NULL) ORDER BY ltb_id DESC';
			$qry = $dbo->prepare( $sql );
			$qry->bindValue(':lmp_id', $usr['lmp_id'], PDO::PARAM_INT);
			$qry->bindValue(':ltb_id', $usr['ltb_id'], PDO::PARAM_INT);
			$qry=execPDO($qry);
			$qry = $qry->fetchAll( PDO::FETCH_ASSOC );
			$cs_time = ($qry[0]['mfc_count'] * 60); // take lmp_service_time (minutes) and convert to seconds

		    // get merchant's customer service time left
			$sql = 'SELECT SUM(cst_seconds) AS time_spent FROM lt_merchant_cs_time WHERE ltm_id=:id AND MONTH(cst_start_time) = MONTH(NOW()) AND YEAR(cst_start_time) = YEAR(NOW())';
			$qry = $dbo->prepare( $sql );
			$qry->bindValue(':id',$_REQUEST['ltm_id'], PDO::PARAM_INT);
			$qry=execPDO($qry);
			$qry = $qry->fetch( PDO::FETCH_ASSOC );
			$cs_time = ($cs_time + $qry['time_spent']); // time spent is -seconds
			$response['time_left'] = $cs_time;

			// get merchant's call history
			$sql = 'SELECT DISTINCT CST.cst_start_time, CST.cst_call_summary, ADM.adm_chat_name, CST.cst_entry_reason FROM lt_merchant_cs_time CST LEFT JOIN tbl_admin ADM ON CST.adm_id = ADM.adm_id WHERE ltm_id=:id ORDER BY cst_start_time DESC LIMIT 20';
			$qry = $dbo->prepare( $sql );
			$qry->bindValue(':id',$_REQUEST['ltm_id'], PDO::PARAM_INT );
			$qry=execPDO($qry);
			$qry = $qry->fetchAll( PDO::FETCH_ASSOC );
			$response['call_history'] = $qry;


			// get merchant info and set sessions to allow login to mystore
			$m = $dbo->prepare( 'SELECT ltm_id,ltm_company_name FROM `lt_merchants` WHERE ltb_id=:id' );
			$m->bindValue( ':id', $usr['ltb_id'], PDO::PARAM_INT );
			$m->execute();
			$merchant = $m->fetch(PDO::FETCH_ASSOC);

			$r = $dbo->prepare( 'SELECT res_name FROM `tbl_reseller` WHERE res_id=:id' );
			$r->bindValue( ':id', $usr['res_id'], PDO::PARAM_INT );
			$r->execute();
			$reseller = $r->fetch(PDO::FETCH_ASSOC);

			$c = $dbo->prepare( 'SELECT COUNT(ltb_id) FROM `lt_promos` WHERE ltb_id=:id' );
			$c->bindValue( ':id', $usr['ltb_id'], PDO::PARAM_INT );
			$c->execute();
			$count = $c->fetch(PDO::FETCH_ASSOC);

			// new plan structure
			$p = 'SELECT LMP.lmp_id, LMP.lmp_name, LMP.pty_id, LPF.lpf_feature, LPF.lpf_id, MFC.mfc_count
			FROM lt_merchant_plans LMP 
			INNER JOIN lt_max_feature_cnt MFC ON LMP.lmp_id = MFC.lmp_id 
			LEFT JOIN lt_plan_features LPF ON MFC.lpf_id = LPF.lpf_id
			WHERE LMP.lmp_id = :lmp_id AND LPF.lpf_active = 1 AND (MFC.ltb_id IS NULL OR MFC.ltb_id = :ltb_id) ORDER BY MFC.ltb_id ASC';
			$p = $dbo->prepare( $p );
			$p->bindValue(':lmp_id', $usr['lmp_id'], PDO::PARAM_INT);
			$p->bindValue(':ltb_id', $usr['ltb_id'], PDO::PARAM_INT);
			$p->execute();
			$p = $p->fetchAll(PDO::FETCH_ASSOC);
			foreach ($p as $k => $v) {
			  if (!$results){
			    $results = array(
			      'lmp_id'                => $v['lmp_id'],
			      'pty_id'                => $v['pty_id'],
			      'lmp_name'              => $v['lmp_name'],
			    );
			    $results['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
			  } 
			  else {
			    // this will overwrite the default plan values with custom merchant values 
			    $results['lmp_features'][$v['lpf_id']] = array('lpf_id'=> $v['lpf_id'], 'lpf_feature'=>$v['lpf_feature'], 'mfc_count'=>$v['mfc_count']);
			  }
			}
			$plan = $results;

			$_SESSION['user']['merchant']['ltm_id']               = $merchant['ltm_id'];
			$_SESSION['user']['merchant']['ltm_company_name']     = $merchant['ltm_company_name'];
			$_SESSION['user']['merchant']['res_name']             = $reseller['res_name'];
			$_SESSION['user']['merchant']['res_id']               = $usr['res_id'];
			$_SESSION['user']['merchant']['tmp_id']               = $usr['tmp_id'];
			$_SESSION['user']['merchant']['promo_count']          = $count['COUNT(ltb_id)'];
			$_SESSION['user']['merchant']['plan']                 = $plan;
			$_SESSION['user']['merchant']['date']                 = date( 'm/d/Y' );
	        $_SESSION['user']['merchant']["ltb_id"]               = $usr["ltb_id"];
			$_SESSION['user']['merchant']["ltb_email"]            = $usr["ltb_email"];

			$response['reason_for_entry'] = $_REQUEST['reason_for_entry'];
			// set success response
			$response['status']='success';
		} else {
			// merchant could not be found
			$response['status']='Error Selecting Merchant';
		}
	}
} else {
	$response['status']='Required fields are missing';
}

echo json_encode($response);
?>