<?php 
function checkSubdomain ($subdomain, $res_id = 0) {
	global $dbo, $error;
	// get current resellers
	$sql = 'SELECT res_subdomain FROM tbl_reseller WHERE res_id != :res_id';
	$qry = $dbo->prepare( $sql );
	$qry->bindValue(':res_id', $res_id, PDO::PARAM_INT);
	$qry=execPDO($qry);
	$qry = $qry->fetchAll( PDO::FETCH_ASSOC );
	if(empty($qry)){
	  $noResellers = true;
	} else {
	  foreach ($qry as $key => $value) {
	    $usedSubdomains[$key] = $value['res_subdomain'];
	  }
	}
	// check if subdomain is in use already
	foreach($usedSubdomains as $key => $value){
	  if ($subdomain == $value){
	    $error['subdomain-used'] = 'The subdomain you chose is already in use.';
	  }
	}
	// reserved subdomain list
	$reserved_subdomains = array(
	    'ftp',
	    'reseller',
	    'resellers',
	    'blog',
	    'www',
	    'mail',
	    'demo',
	    'shop',
	    'news'
	);
	// check if subdomain is a reserved word
	foreach($reserved_subdomains as $key => $value){
	  if ($subdomain == $value) {
	    $error['subdomain-reserved'] = $value.' is a reserved word.';
	  }
	}
}
?>