function getMonthOptions(selected) {
	if (typeof selected == 'undefined') {var selected = 1;}
	var str = '';
	for (var i=1; i<=12; i++) {
		str += '<option'+(selected === i? ' selected':'')+' value="'+(i<10?'0':'')+i+'">'+i+'</option>';
	}
	return str;
}

function getDayOptions( selected ) {
	if (typeof selected == 'undefined') { var selected = 1; }
	var str = '';
	for (var i=1; i<=31; i++) {
		str += '<option'+(selected === i? ' selected':'')+' value="'+(i<10?'0':'')+i+'">'+i+'</option>';
	}
	return str;
}

function get5YearsNow ( selected ) {
	var currYear = new Date().getFullYear();
	if (typeof selected == 'undefined') { var selected = currYear; }
	var str = '';
	for (var i=0; i <= 9; i++) {
		str += '<option'+(selected === currYear + i? ' selected':'')+' value="'+(currYear + i)+'">'+(currYear + i)+'</option>';
	}	
	return str;
}

var codeListTable = {};

$( '#createCodeBtn' ).on( 'click', function ( e ) {
	$( '#globalModalLabel' ).text( "Create New Discount Code" );
	var formhtml = 
		'<div id="errorDiv"></div><form method="post" id="discountCodeCreate"><input type="hidden" name="res_id" value="'+_pageObj.get.res_id+'"/><div class="form-group"><label for="dsc_code">Code (Required)</label><input required type="text" class="form-control" maxlength="8" id="dsc_code" name="dsc_code" placeholder="Code"/></div><div class="form-group"><label for="dsc_discount_months">Month Count (Required)</label><input required placeholder="Month Count" class="form-control" name="dsc_discount_months" id="dsc_discount_months" type="text"/><p>For how many months the discount applies.</p></div><div class="form-group"><label for="dsc_setup_fee">Setup Fee Amount $</label><input class="form-control" placeholder="Setup Fee Amount" name="dsc_setup_fee" id="dsc_setup_fee" type="text"/><p>In the case this amount is bigger than the actual plan setup fee, the last one will be used instead. If you want to apply the actual plan setup fee do not enter any amount here.</p></div><div class="checkbox"><label><input id="expirationDateTrigger" type="checkbox"> Add Expiration Date</label></div><div id="expirationDateDiv" class="form-group" style="display: none;"><h3>Expiration Date</h3><input name="dsc_expire_date" id="dsc_expire_date" type="hidden"/><div class="row"><div class="col-sm-4"><label for="dsc_expire_month">Month</label><select class="form-control" type="text" placeholder="Month" id="dsc_expire_month">' + getMonthOptions() + '</select></div><div class="col-sm-4"><label for="dsc_expire_day">Day</label><select class="form-control" type="text" placeholder="Day" id="dsc_expire_day">'	 + getDayOptions() + '</select></div><div class="col-sm-4"><label for="dsc_expire_year">Year</label><select class="form-control" type="text" placeholder="Year" id="dsc_expire_year">' + get5YearsNow() + '</select></div></div><p>Until when the code can be used by the reseller, if no value is entered it can be used indefinitely.</p></div><div class="form-group"><label for="dsc_monthly_percent_off">Monthly Discount Percentage</label><input type="text" class="form-control" name="dsc_monthly_percent_off" id="dsc_monthly_percent_off" maxlength="3" placeholder="Monthly Discount Percentage"/></div><div class="form-group"><label for="dsc_monthly_dollar_off">Monthly Discount Amount $</label><input placeholder="Monthly Discount Amount" name="dsc_monthly_dollar_off" class="form-control" id="dsc_monthly_dollar_off" type="text"/></div><div class="form-group"><label for="dsc_quantity">Use Count</label><input placeholder="Use Count" maxlength="3" class="form-control" name="dsc_quantity" id="dsc_quantity" type="text"/><p>Amount of time the reseller can use this code, if no value is entered it can be used indefinitely until the expiration date is reached.</p></div>';
	formhtml += '<button type="submit" class="btn btn-primary">Save</button></form>';
	$( '#contentBody' ).html( formhtml );
});

$( '.deleteCodeBtn' ).on( 'click', function (  ) {
	if (confirm("Do you want to delete this code?"))
		var myData = JSON.stringify( {Delete: 1, dsc_id: $(this).data('id')} );	
		console.log(myData);
		 $.ajax({
		   url: "/admin/discount-codes",
		   global: false,
		   type: "POST",
		   dataType: "json",
		   error:function (err){ console.log(err); },
		   data: myData,
		   success: function (myArray) {
			//console.log(myArray);
				window.location.reload();
		   }
		});
});

$( '#contentBody' ).on('submit', '#discountCodeCreate', function ( e ) {
	var theForm = $(this);
	e.preventDefault();	
	var myDataArr = {};	
	theForm.find('input').each(function () {
		var inputField = $(this);
		if ( inputField.attr('name') != undefined ) {
			myDataArr[inputField.attr('name')] = inputField.val();
		}	
	});
	//console.log(myDataArr);
	var myData = JSON.stringify( myDataArr );	
	 $.ajax({
	   url: "/admin/discount-codes",
	   global: false,
	   type: "POST",
	   dataType: "json",
	   error:function (err){ console.log(err); },
	   data: myData,
	   success: function (myArray) {
		console.log( myArray );	
		if ( typeof myArray['Error'] != 'undefined' && myArray['Error'].length > 0 ) {
			
			var errorVal = '<div class="alert alert-danger"><ul>';
			
			for ( var i in myArray['Error'] ) {
				errorVal += '<li>' + myArray['Error'][i] + '</li>';
			}
			
			errorVal += '</ul></div>';
			$( '#contentBody' ).find('#errorDiv').html(errorVal);
		}
		else {
			window.location.reload();		
		}	
	   }
	});
});

$( '#contentBody' ).on('click', '#expirationDateTrigger', function (e) {
	var cCkeckBox = $(this);
	if (cCkeckBox.is(':checked')) {
		$('#expirationDateDiv').show();
		$("#dsc_expire_date").val($('#dsc_expire_month').val()+'/'+$('#dsc_expire_day').val()+'/'+$('#dsc_expire_year').val());
	}	
	else {
		$('#expirationDateDiv').hide();
		$("#dsc_expire_date").val('');
	}
});

$( '#contentBody' ).on('change', 'select', function (e) {
	$("#dsc_expire_date").val($('#dsc_expire_month').val()+'/'+$('#dsc_expire_day').val()+'/'+$('#dsc_expire_year').val());
});

function getDatePart (aDate, aPart) {	
	var resStr = '0'; 
	switch (aPart) {
		case 'day':
			var theIndex = 1;
		break;
		case 'month':	
			var theIndex = 2;
		break;	
		default:
			var theIndex = 0;
	}
	var dateMonth = aDate.split('-');
	
	
	
	if ( dateMonth.length === 3 ) {		
		resStr = dateMonth[theIndex];
	}
	return parseInt(resStr);
}

$( '#results_table' ).on('click', '.editCodeBtn', function (e) {
	var theBtn = $(this);
	e.preventDefault();	
	var myDataArr = {dsc_id: theBtn.data('id')};
	//console.log(myDataArr);
	var myData = JSON.stringify( myDataArr );
	
	 $.ajax({
	   url: "/admin/discount-codes",
	   global: false,
	   type: "POST",
	   dataType: "json",
	   error:function (err){ console.log(err); },
	   data: myData,
	   success: function (myArray) {
		if (typeof myArray['Result'] != 'undefined' && typeof myArray['Result']['dsc_code'] != 'undefined') {	
			$( '#globalModalLabel' ).text( "Edit Discount Code: " + myArray['Result']['dsc_code'] );
			var formhtml = 
				'<div id="errorDiv"></div><form method="post" id="discountCodeCreate"><input type="hidden" name="res_id" value="'+_pageObj.get.res_id+'"/><input type="hidden" name="dsc_id" value="'+myArray['Result']['dsc_id']+'"/><div class="form-group"><label for="dsc_code">Code (Required)</label><input required placeholder="Code" value="'+myArray['Result']['dsc_code']+'" class="form-control" name="dsc_code" id="dsc_code" type="text"/></div><div class="form-group"><label for="dsc_discount_months">Month Count (Required)</label><input required placeholder="Month Count" value="'+myArray['Result']['dsc_discount_months']+'" class="form-control" name="dsc_discount_months" id="dsc_discount_months" type="text"/><p>For how many months the discount applies.</p></div><div class="form-group"><label for="dsc_setup_fee">Setup Fee Amount $</label><input value="'+(myArray['Result']['dsc_setup_fee']?myArray['Result']['dsc_setup_fee']:'')+'" class="form-control" placeholder="Setup Fee Amount" name="dsc_setup_fee" id="dsc_setup_fee" type="text"/><p>In the case this amount is bigger than the actual plan setup fee, the last one will be used instead. If you want to apply the actual plan setup fee do not enter any amount here.</p></div><div class="checkbox"><label><input id="expirationDateTrigger"' + ( myArray['Result']['dsc_expire_date']?' checked': '' ) + ' type="checkbox"> Add Expiration Date</label></div><div id="expirationDateDiv" class="form-group"' + ( myArray['Result']['dsc_expire_date']?'': ' style="display: none;"' ) + '><h3>Expiration Date</h3><input name="dsc_expire_date" id="dsc_expire_date" type="hidden"/><div class="row"><div class="col-sm-4"><label for="dsc_expire_month">Month</label><select class="form-control" type="text" placeholder="Month" id="dsc_expire_month">' + ( myArray['Result']['dsc_expire_date']? getMonthOptions( getDatePart( myArray['Result']['dsc_expire_date'], 'month' ) ) :getMonthOptions() ) + '</select></div><div class="col-sm-4"><label for="dsc_expire_day">Day</label><select class="form-control" type="text" placeholder="Day" id="dsc_expire_day">' + ( myArray['Result']['dsc_expire_date']? getDayOptions( getDatePart ( myArray['Result']['dsc_expire_date'], 'day' ) ) : getDayOptions() ) + '</select></div><div class="col-sm-4"><label for="dsc_expire_year">Year</label><select class="form-control" type="text" placeholder="Year" id="dsc_expire_year">' + ( myArray['Result']['dsc_expire_date']? get5YearsNow( getDatePart( myArray['Result']['dsc_expire_date'], 'year' ) ) : get5YearsNow() ) + '</select></div></div><p>Until when the code can be used by the reseller, if no value is entered it can be used indefinitely.</p></div><div class="form-group"><label for="dsc_monthly_percent_off">Monthly Discount Percentage</label><input value="'+(myArray['Result']['dsc_monthly_percent_off']?myArray['Result']['dsc_monthly_percent_off']:'')+'" type="text" class="form-control" name="dsc_monthly_percent_off" id="dsc_monthly_percent_off" maxlength="3" placeholder="Monthly Discount Percentage"/></div><div class="form-group"><label for="dsc_monthly_dollar_off">Monthly Discount Amount $</label><input value="'+(myArray['Result']['dsc_monthly_dollar_off']?myArray['Result']['dsc_monthly_dollar_off']:'')+'" placeholder="Monthly Discount Amount" name="dsc_monthly_dollar_off" class="form-control" id="dsc_monthly_dollar_off" type="text"/></div><div class="form-group"><label for="dsc_quantity">Use Count</label><input value="'+(myArray['Result']['dsc_quantity']?myArray['Result']['dsc_quantity']:'')+'" placeholder="Use Count" maxlength="3" class="form-control" name="dsc_quantity" id="dsc_quantity" type="text"/><p>Amount of time the reseller can use this code, if no value is entered it can be used indefinitely until the expiration date is reached.</p></div>';
			formhtml += '<button type="submit" class="btn btn-primary">Save</button></form>';
			$( '#contentBody' ).html( formhtml );	
		}	
	   }
	});
});

$(document).ready(function (){
	codeListTable = $('#results_table').dataTable({});
});