<?php 
header( 'Content-Type: application/json; charset=utf-8' );
require_once '../app/start_session.php';
require_once '../app/function.connect.php';
require_once '../app/global.php';

if ( $_SERVER['REQUEST_METHOD'] == 'GET'
	&& isset($_SESSION['user']['consumer']['csm_id'], $_GET['csm_cell_number']) 
	&& is_numeric($_SESSION['user']['consumer']['csm_id']) 
	&& is_numeric($_GET['csm_cell_number']) ) 
{

	function check_txt_status($phone, $csm_id, $dbo){
		// remove any non-numeric characters
		$phone = preg_replace('/\D/', '', $phone);

		// get the status we have set in our DB
		$sql = "SELECT csm_txt_status FROM tbl_consumer WHERE csm_id = :csm_id LIMIT 1";
		$stmt = $dbo->prepare($sql);
		$stmt->bindValue(":csm_id", $csm_id, PDO::PARAM_INT);
		$stmt = execPDO($stmt);
		$qry = $stmt->fetchAll(PDO::FETCH_ASSOC);
		$txt_status = $qry[0]['csm_txt_status'];

		return (int)$txt_status;
	}

	$response['text_status'] = check_txt_status($_GET['csm_cell_number'], $_SESSION['user']['consumer']['csm_id'], $dbo);
} else {
	$response['text_status'] = 'Missing fields and/or invalid request type';
}

echo json_encode($response);
?>