<?php 
/* handle promotion redemption vouchers*/

// REQUIRED:
	// $_SESSION['user']['consumer']['csm_id']
	// $_REQUEST['ltp_id'] (promo id)
	// $_REQUEST['action'] - options:
		// 'get_voucher_id'
		// 'mark_as_used' - must pass $_REQUEST['lpr_voucher_id'] if marking a voucher as used

require '../app/start_session.php';

header( 'Content-Type: application/json; charset=utf-8' );

$response['status']='';

if (($_SERVER['REQUEST_METHOD'] == 'POST' || $_SERVER['REQUEST_METHOD'] == 'GET') && isset($_SESSION['user']['consumer']['csm_id'], $_REQUEST['ltp_id'], $_REQUEST['action']) && is_numeric($_SESSION['user']['consumer']['csm_id']) && is_numeric($_REQUEST['ltp_id'])) {
	require '../app/function.connect.php';
	require '../app/global.php';

	// get this promo's max redemption #'s
	$sql  = "SELECT ltp_max_redemptions_global, ltp_max_redemptions_user FROM lt_promos WHERE `ltp_id`=:id LIMIT 1";	
	$stmt = $dbo->prepare($sql);
	$stmt->bindValue(':id', $_REQUEST['ltp_id'], PDO::PARAM_INT);
	$stmt=execPDO($stmt);
	$stmt=$stmt->fetchAll(PDO::FETCH_ASSOC);
	$promo_redemption_count['global'] = $stmt[0]["ltp_max_redemptions_global"];
	$promo_redemption_count['user'] = $stmt[0]["ltp_max_redemptions_user"];

	// check if ltp_max_redemptions_global has been met or exceeded
	$sql  = "SELECT COUNT(ltp_id) FROM lt_promo_redemptions WHERE `ltp_id`=:id";	
	$stmt = $dbo->prepare($sql);
	$stmt->bindValue(':id', $_REQUEST['ltp_id'], PDO::PARAM_INT);
	$stmt=execPDO($stmt);
	$stmt=$stmt->fetchAll(PDO::FETCH_ASSOC);
	$global_redemption_count = $stmt[0]["COUNT(ltp_id)"];

	// check if this user has met or exceeded ltp_max_redemptions_user
	$sql  = "SELECT COUNT(ltp_id) FROM lt_promo_redemptions WHERE `ltp_id`=:id AND `csm_id`=:csm_id";	
	$stmt = $dbo->prepare($sql);
	$stmt->bindValue(':id', $_REQUEST['ltp_id'], PDO::PARAM_INT);
	$stmt->bindValue(':csm_id', $_SESSION['user']['consumer']['csm_id'], PDO::PARAM_INT);
	$stmt=execPDO($stmt);
	$stmt=$stmt->fetchAll(PDO::FETCH_ASSOC);
	$user_redemption_count = $stmt[0]["COUNT(ltp_id)"];

	if ($global_redemption_count >= $promo_redemption_count['global'] && $promo_redemption_count['global'] !== null){
		$response['status'] = 'This promotion\'s maximum redemption limit has been met.';
	}

	if ($user_redemption_count >= $promo_redemption_count['user'] && $promo_redemption_count['user'] !== null){
		$response['status'] = 'You cannot redeem this promotion again.';
	}	

	if ($response['status'] == ''){
		switch ($_REQUEST['action']) {
			case 'get_voucher_id':
				// get count of times this consumer has redeemed this promo
				$sql = "SELECT COUNT(lpr_id) AS count FROM lt_promo_redemptions WHERE csm_id=:csm_id AND ltp_id=:ltp_id";
				$stmt = $dbo->prepare( $sql );
				$stmt->bindValue(':csm_id', $_SESSION['user']['consumer']['csm_id'], PDO::PARAM_INT);
				$stmt->bindValue(':ltp_id', $_REQUEST['ltp_id'], PDO::PARAM_INT);
				$stmt=execPDO($stmt);
				$res=$stmt->fetchAll(PDO::FETCH_ASSOC);
				$response['count'] = $redeem_count = $res[0]['count'];
				$response['lpr_voucher_id'] = $_SESSION['user']['consumer']['csm_id'].'-'.$_REQUEST['ltp_id'].'-'.$redeem_count;
				$response['status']='success';
				break;

			case 'mark_as_used':
				if (isset($_REQUEST['lpr_voucher_id'])){			
			
					// make entry for this promo redemption
					$sql = "INSERT INTO lt_promo_redemptions (csm_id, ltp_id, lpr_voucher_id) VALUES (:csm_id, :ltp_id, :lpr_voucher_id)";
					$stmt = $dbo->prepare( $sql );
					$stmt->bindValue(':csm_id', $_SESSION['user']['consumer']['csm_id'], PDO::PARAM_INT);
					$stmt->bindValue(':ltp_id', $_REQUEST['ltp_id'], PDO::PARAM_INT);
					$stmt->bindValue(':lpr_voucher_id', $_REQUEST['lpr_voucher_id'], PDO::PARAM_STR);
					$stmt=execPDO($stmt);
					$response['qry'] = $stmt;
					$response['status']='success';

					if (($global_redemption_count + 1) == $promo_redemption_count['global'] && $promo_redemption_count['global'] !== null){
						// promo redemption max reached, make promo inactive
						$sql="UPDATE lt_promos SET ltp_active = 0 WHERE ltp_id = :ltp_id LIMIT 1";
						$stmt = $dbo->prepare($sql);
						$stmt->bindValue(':ltp_id', $_REQUEST['ltp_id'], PDO::PARAM_INT);						
				        execPDO($stmt);
					}
					
				} else {
					$response['status'] = 'Voucher ID is missing. Contact '.CSR_FORM_EMAIL.' for help.';
				}
				break;

			default:
				break;
		}
	}	
} else {
	$response['status']='Required fields are missing. Contact '.CSR_FORM_EMAIL.' for help.';
}
echo json_encode($response);
?>