<?php 
require '../app/start_session.php';

header( 'Content-Type: application/json; charset=utf-8' );

$response['status']='';

/* Resend Consumer Welcome Email */

if (($_SERVER['REQUEST_METHOD'] == 'POST' || $_SERVER['REQUEST_METHOD'] == 'GET') && isset($_SESSION['user']['admin']['adm_id'], $_REQUEST['ltb_email'], $_REQUEST['ltm_id']) && is_numeric($_REQUEST['ltm_id'])){
	require '../app/function.connect.php';
	require '../app/global.php';

	// get the amount they were charged && plan name
	$qry = $dbo->prepare("
	SELECT BILL.bill_fee, BILL.bill_price, LMP.lmp_name, LMP.tem_id, TEM.tem_path
	FROM lt_merchant_billing BILL
	LEFT JOIN lt_merchant_plans LMP ON BILL.lmp_id = LMP.lmp_id
	LEFT JOIN tbl_emails TEM ON LMP.tem_id = TEM.tem_id
	WHERE BILL.ltm_id=:ltm_id 
	ORDER BY BILL.bill_id DESC 
	LIMIT 1");
	$qry->bindValue(':ltm_id', $_REQUEST['ltm_id'], PDO::PARAM_INT);
	$qry->execute();
	$qry = $qry->fetch(PDO::FETCH_ASSOC);

	$email_settings = array();

	// custom email or default?
	if ($qry['tem_id'] == NULL){
		$email_settings['ema_body'] = file_get_contents($_SERVER["DOCUMENT_ROOT"].'/mail/localthanks/website/merchant_payment_welcome/merchant_payment_welcome.html');
	}
	else {
		$email_settings['ema_body'] = file_get_contents($_SERVER["DOCUMENT_ROOT"].$qry['tem_path']);	
	}

	$email_settings['ema_email'] =  $_REQUEST['ltb_email'];
	$email_settings['ema_ltm_id'] = $_REQUEST['ltm_id'];

	$amountCharged = ((float)$qry['bill_fee'] + (float)$qry['bill_price']) * 100;
	$amountCharged = $amountCharged == 0.01? $amountCharged : $amountCharged / 100;
	$amountCharged = strpos( $amountCharged , '.' ) === false ? $amountCharged.'.00' : ( strlen($amountCharged) - 2 == strpos($amountCharged , '.') ? $amountCharged . '.0' : $amountCharged);

	$email_settings['ema_message'] = '<p>Your payment of <span style="color: #0079FE; font-weight: bold;">$' . $amountCharged . '</span> was processesd.<p><p>Your <span style="color: #0079FE; font-weight: bold;">'.$qry['lmp_name'].' Membership</span> is now active under the following email address:</p><p style="margin: 0;"><span style="color: #0079FE; font-weight: bold;">'.$email_settings['ema_email'].'</span></p>';
	$email_settings['ema_subject'] = 'Welcome to Local Thanks!';

	require_once $_SERVER['DOCUMENT_ROOT'] . '/app/class.mailgun.php';
	$mailgun = new App\Mailgun\mailgun($dbo);
	$mgResponse = $mailgun->sendEmail($email_settings);

	if (isset($mgResponse['Error'])){
		$response['status'] = $mgResponse['Error'];
	}
	else {
		$response['status'] = 'success';
	}
	
} else {
	$response['status']='Required fields are missing.';
}

echo json_encode($response);
?>