<?php 
/* Allow merchants to suggest a keyword */

require '../app/start_session.php';

header( 'Content-Type: application/json; charset=utf-8' );

$response['status']='';

if (($_SERVER['REQUEST_METHOD'] == 'POST' || $_SERVER['REQUEST_METHOD'] == 'GET') && isset($_REQUEST['suggestedKeyword'])) {
	require '../app/function.connect.php';
	require '../app/global.php';

	// sanitize user suggested keyword
	$keyword = htmlspecialchars(preg_replace("/[^A-Za-z0-9 ]/", '', $_REQUEST['suggestedKeyword']));

	// check if keyword already exists
	$sql = "SELECT key_id, key_word FROM tbl_keywords WHERE key_word=:keyword LIMIT 1";
	$stmt = $dbo->prepare( $sql );
	$stmt->bindValue(':keyword', $keyword, PDO::PARAM_STR);
	$stmt=execPDO($stmt);
	$res=$stmt->fetchAll(PDO::FETCH_ASSOC);
	if (count($res)){
		$keyId = $res[0]['key_id'];
		$response['msg'] = 'That keyword exists or has already been suggested.';
	} else {
		if ( isset( $_SESSION['user']['admin']['adm_id'] ) ) {
			$_keywordStatus = 'active';
			$_keywordActive = 1;
		} 
		else {
			$_keywordStatus = 'suggested';
			$_keywordActive = null;
		}
		// add keyword to database, set status to "active or suggested"
		$sql = "INSERT INTO tbl_keywords (key_word, key_type, key_active) VALUES (:keyword, :status, :active)";
		$stmt = $dbo->prepare( $sql );
		$stmt->bindValue(':keyword', $keyword, PDO::PARAM_STR);
		$stmt->bindValue(':status', $_keywordStatus, PDO::PARAM_STR);
		$stmt->bindValue(':active', $_keywordActive, PDO::PARAM_INT);
		$stmt=execPDO($stmt);
		$keyId = $dbo->lastInsertId();
		$response['status']='success';
		$response['msg'] = "Added '{$keyword}' to the suggested keywords list!";
	}
	$response['test']=array('cat'=>$_REQUEST['catId'], 'key'=>$keyId);
	if ( isset( $_REQUEST['catId'], $_SESSION['user']['admin']['adm_id'] ) && !empty($_REQUEST['catId']) && preg_match('/^[0-9]{1,11}?$/', $_REQUEST['catId']) && $keyId ) {
		// add keyword to the sub-category, table tbl_c2keyword
		$sql = "INSERT INTO tbl_c2keyword (cat_id, key_id)		
				SELECT * FROM (SELECT :catid, :keyid) AS tmp 
				WHERE NOT EXISTS (
					SELECT 1 FROM tbl_c2keyword WHERE cat_id = :catid AND key_id = :keyid
				) LIMIT 1";
		$stmt = $dbo->prepare( $sql );
		$stmt->bindValue(':keyid', $keyId, PDO::PARAM_INT);
		$stmt->bindValue(':catid', $_REQUEST['catId'], PDO::PARAM_INT);			
		$stmt=execPDO($stmt);
		$c2keyId = $dbo->lastInsertId();
		if ($c2keyId) {$response['cat_id'] = $_REQUEST['catId'];}
		$response['msg'] = "Added '{$keyword}' to the keywords list!";
	}
} else {
	$response['status']='Required fields are missing.';
}
echo json_encode($response);
?>