<?php
require '../app/start_session.php';
header( 'Content-Type: application/json; charset=utf-8' );
$response['status']='EMPTY';
$response['Consumer_Id']=0;

function consumer_exists($dbo, $an_email){
 if ($stmt = $dbo->prepare("
   SELECT csm_id FROM tbl_consumer WHERE csm_email=:email LIMIT 1")){
	$stmt->bindValue(":email", $an_email, PDO::PARAM_STR);	
    $stmt->execute();
  if ($_Result=$stmt->fetch(PDO::FETCH_OBJ)){
   return $_Result->csm_id;
  }
 }	
 return false;
}

function _appCleanData( $data ){return htmlspecialchars( stripslashes( trim( $data ) ) );}
function _appProcessRequest( $data )
{
    $was_checked=false;
	// init arrays 
	$errors = array();
	// default title, free acct	
	// Sanitize data request array. 
	$required=array();$email=array();$nam = array();$numeric = array();$phone=array();$zipcode=array();$double=array();
	foreach( $data as $key => $val ) $data[$key] = _appCleanData($val);	
	// array for what is required	
	if (isset($data['csm_long'], $data['csm_lat'], $data['zip_code'], $data['f_name'], $data['l_name'], $data['cell_phone'], $data['email'], $data['password'], $data['re_password'], $data['su_merchant_id'])){
	 $required = array(
	  'su_first name'=> $data["f_name"]
	  ,'su_last name'=> $data["l_name"]
	  ,'su_email'=> $data["email"]
	  ,'su_password'=> $data["password"]
	  ,'su_re password'=> $data["re_password"]
	  ,'su_merchant id'=> $data["su_merchant_id"]	  
	  ,'su_ZIP code'=> $data["zip_code"] 
	  ,'su_latitude'=> $data["csm_lat"] 
	  ,'su_longitude'=> $data["csm_long"] 
	 );
	 $numeric  = array('su_merchant id'=> $data["su_merchant_id"]);
	 $phone = array('su_cell phone'=> $data["cell_phone"]);
	 $zipcode = array('su_ZIP code'=> $data["zip_code"]);
	 $nam = array(
	  'su_first name'=> $data["f_name"]
	  ,'su_last name'=> $data["l_name"]
	 );
	 $double = array(
	  'su_latitude'=> $data["csm_long"]
	  ,'su_latitude'=> $data["csm_lat"]
	 );
	 $email = array(
	  'su_email'=> $data["email"]	  
	 );
	 if (strcmp($data['password'],$data['re_password']) !== 0)
	  array_push( $errors, "Passwords must match" );
	  $was_checked=true;
	 }
	 else{
	  array_push( $errors, "Some data in the form are missing" );
	  $was_checked=true;
	 }
	// check required
	foreach( $double as $key => $val ) {
		if( !preg_match( '/[+-]?\\d*\\.?\\d+/', $val ) ) 
			array_push( $errors, ucfirst( trim( str_replace(array('su_','_'),' ',"$key has an invalid format.") ) ) );
	}
	foreach( $zipcode as $key => $val ) {
		if( !preg_match( '/^\d{5}(?:[-\s]\d{4})?$/', $val ) ) 
			array_push( $errors, ucfirst( trim( str_replace(array('su_','_'),' ',"$key has an invalid format.") ) ) );
	}
    foreach( $phone as $key => $val ) {
		if( !preg_match( '/^(\d[\s-]?)?[\(\[\s-]{0,2}?\d{3}[\)\]\s-]{0,2}?\d{3}[\s-]?\d{4}$/i', $val ) && !empty($val)) 
			array_push( $errors, ucfirst( trim( str_replace(array('su_','_'),' ',"$key has an invalid format.") ) ) );
	}
    foreach( $email as $key => $val ) {
		if( !filter_var($val, FILTER_VALIDATE_EMAIL) ) 
			array_push( $errors, ucfirst( trim( str_replace(array('su_','_'),' ',"$key has an invalid format.") ) ) );
	}
	foreach( $required as $key => $val ) {
		if( empty( $val ) ) 
			array_push( $errors, ucfirst( trim( str_replace(array('su_','_'),' ',"$key is required.") ) ) );
	}	
	foreach( $nam as $key => $val ) {
		if( !preg_match( '/^[a-zA-Z]+( [a-zA-Z\.]+)*$/', $val ) ) 
			array_push( $errors, ucfirst( trim( str_replace(array('su_','_'),' ',"$key can only have letters and white spaces.") ) ) );
	}
	foreach( $numeric as $key => $val ) {
		if( !preg_match( '/^[0-9]+$/', $val ) ) 
			array_push( $errors, ucfirst( trim( str_replace(array('su_','_'),' ',"$key can only have numeric characters.") ) ) );
	}
	// if no errors in array.
	if( empty( $errors ) ) {		
		$data['success'] = true;
		// Update Database here.
	}
	// else, there were errors. 
	else {
		// hide this unless the form was submitted.
		if ($was_checked){
			$data['notify'] = '<div class="alert alert-danger alert-error" role="alert"><a href="#" class="close" data-dismiss="alert">&times;</a><span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span><span class="sr-only">Error:</span> A problem has been occurred while submitting your data.<ol>';
			foreach( $errors as $val ) $data['notify'].= "<li>$val</li>"; 
			$data['notify'].= '</ol></div>';
		}		
	}
	return $data;
 }//end of the _appProcessRequest function
if (($_SERVER['REQUEST_METHOD'] == 'POST')){ 
 //if is set latitude and longitude
 require '../app/function.connect.php';
 require '../app/global.php';
 $request = _appProcessRequest( $_REQUEST );
 //$response['Test']=$request;
 if ($request['success']){
  if (consumer_exists($dbo, $request['email'])){
   $response['notify'] = '<div class="alert alert-danger alert-error" role="alert"><a href="#" class="close" data-dismiss="alert">&times;</a><span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span><span class="sr-only">Error:</span> A problem has been occurred while submitting your data.<ol><li> The email address: '.$request['email'].' is already taken</li></ol></div>';
   $response['status'] = 'EMPTY';
  }
  elseif ($stmt = $dbo->prepare("
   INSERT INTO tbl_consumer
   (csm_first_name, csm_last_name, csm_email, csm_password, csm_cell_number, csm_date_joined, csm_last_login, csm_lat, csm_long, csm_zip, ltm_id, ltm_pick_id) 
   VALUES (:fname, :lname, :email, :password, :cellphone, NOW(), NOW(), :csmlat, :csmlong, :zipcode, :merchantid, :merchantpickid)")){
    require '../app/model/crypt.php';
	$_crypt = new Crypt( $request['email'] );
	$stmt->bindValue(":fname", $request['f_name'], PDO::PARAM_STR);
	$stmt->bindValue(":lname", $request['l_name'], PDO::PARAM_STR);
	$stmt->bindValue(":email", $request['email'], PDO::PARAM_STR);
	$stmt->bindValue(":password", $_crypt->encode($request['password']), PDO::PARAM_STR);
	$stmt->bindValue(":cellphone", preg_replace("/[^0-9]/","",$request['cell_phone']), PDO::PARAM_STR);
	$stmt->bindValue(":zipcode", $request['zip_code'], PDO::PARAM_STR);
	$su_merchant_id=$request['su_merchant_id'];
	$stmt->bindValue(":merchantid", $su_merchant_id, PDO::PARAM_INT);
	$stmt->bindValue(":merchantpickid", $su_merchant_id, PDO::PARAM_INT);
	$stmt->bindValue(":csmlong", $request['csm_long'], PDO::PARAM_STR);
	$stmt->bindValue(":csmlat", $request['csm_lat'], PDO::PARAM_STR);
    $stmt->execute();
    $response['Consumer_Id'] = $dbo->lastInsertId();		
	if ($response['Consumer_Id']>1){
	 $response['status'] = 'OK'; 
		if ((isset($_REQUEST['send_email']) && $_REQUEST['send_email'] == '1') || !isset($_REQUEST['send_email'])){
			// welcome email
			$ema_body = file_get_contents('../mail/localthanks/website/consumer_welcome/consumer_welcome.html');
			$ema_email = $request['email'];
			$ema_ltm_pick_id = $request['su_merchant_id'];			
			include '../app/build-email.php';
			$to       = $ema_email;
			$subject  = 'Welcome to Local Thanks!';
			$message  = $ema_body;
			$headers  = "From: noreply@localthanks.com\r\n";
			$headers .= "Reply-To: noreply@localthanks.com\r\n";
			$headers .= "MIME-Version: 1.0\r\n";
			$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
			mail($to, $subject, $message, $headers);
		}
		// send opt-in text message
		if(isset($request['cell_phone']) && intval($request['text_opt_in'])===1){
			include '../app/function.send-text.php'; //_appSendText($_msg, $_recipient);
			$text_msg = 'Text YES to join LocalThanks.com Text Alerts. Msg&data rates may apply. Reply HELP for help, STOP to cancel.';
			_appSendText($text_msg, preg_replace("/[^0-9]/","",$request['cell_phone']));
		}
	}
   }
 }
 elseif (isset($request['notify'])){
  $response['notify'] = $request['notify'];
  $response['status'] = 'EMPTY';
 }
}
echo json_encode($response);