<?php
require '../app/start_session.php';
header( 'Content-Type: application/json; charset=utf-8' );
function consumer_exists($dbo, $an_email){
 if ($stmt = $dbo->prepare("
   SELECT csm_id FROM tbl_consumer WHERE csm_email=:email LIMIT 1")){
	$stmt->bindValue(":email", $an_email, PDO::PARAM_STR);	
    $stmt->execute();
  if ($_Result=$stmt->fetch(PDO::FETCH_OBJ)){
   return $_Result->csm_id;
  }
 }	
 return false;
}

function _appProcessRequest( $data )
{
	$errors = array(); $clean = array();
	// default title, free acct	
	// Sanitize data request array. 
	$required = array(); $email = array();$nam = array();$phone = array();$zipcode = array();$double = array();
	
	// array for what is required	
	if (isset( $data['csm_long'], $data['csm_lat'], $data['csm_zip'], $data['csm_first_name'], $data['csm_last_name'], $data['csm_email'], $data['csm_password'] ) ){
	  
	 $dataArr = array (
	   'nam_csm_first_name_r' => $data["csm_first_name"]
	  ,'nam_csm_last_name_r'  => $data["csm_last_name"]
	  ,'ema_csm_email_r'      => $data["csm_email"]	  
	  ,'psw_csm_password_r'   => $data["csm_password"]
	  ,'zip_csm_zip_r'        => $data["csm_zip"] 
	  ,'dec_csm_lat_r'        => $data["csm_lat"] 
	  ,'dec_csm_long_r'       => $data["csm_long"]	  
	 );
	 
	
 	$cv_array = array(
	
						'nam_csm_first_name_r',
						'nam_csm_last_name_r',
						'ema_csm_email_r',
						'psw_csm_password_r',
						'zip_csm_zip_r',
						'dec_csm_lat_r',
						'dec_csm_long_r'
						
					  );
	if (isset($data['csm_cell_number'])) {
	  $dataArr['pho_csm_cell_number'] =$data["csm_cell_number"];
	  array_push ($cv_array, 'pho_csm_cell_number');
    }	
		
		$cv= new _variables($dataArr);
		
		foreach($cv_array as $name=>$value) $cv->varible_in($value);
		$clean = $cv->get_cleaned_variables();
		$errorsFromObj = $cv->get_bad_variables();
		
		if (isset($errorsFromObj['nam_csm_first_name_r'])) {
			array_push( $errors, "The first name can only have letters and white spaces.");
		}
	 
		if (isset($errorsFromObj['nam_csm_last_name_r'])) {
			array_push( $errors,  "The last name can only have letters and white spaces."  );
		}
		
		if (isset($errorsFromObj['ema_csm_email_r'])) {
			array_push( $errors, "Email has an invalid format."  );
		}
		
		if (isset($errorsFromObj['psw_csm_password_r'])) {
			array_push( $errors, "Password has an invalid format." );
		}
		
		if (isset($errorsFromObj['zip_csm_zip_r'])) {
			array_push( $errors, "ZIP Code has an invalid format." );
		}
		
		if ( isset( $errorsFromObj['dec_csm_lat_r'] ) || isset( $errorsFromObj['dec_csm_long_r'] ) ) {
			array_push( $errors, "Location (Lat-Long) has an invalid format." );
		}
		
		if ( isset( $errorsFromObj['pho_csm_cell_number'] )) {
			array_push( $errors, "Cell Phone Number has an invalid format." );
		}
		
		//return $errorsFromObj;
		
	 }
	 else{
		array_push( $errors, "Some required fields are missing.");
	 }
	
	if( empty( $errors ) ) {		
		$clean['success'] = true;
	}
	else {
		
			$clean['notify'] = '<div class="alert alert-danger" role="alert"><ol>';
			foreach( $errors as $val ) $clean['notify'].= "<li>$val</li>"; 
			$clean['notify'].= '</ol></div>';
				
	}
	return $clean;
 }//end of the _appProcessRequest function
$response=array();

if (($_SERVER['REQUEST_METHOD'] == 'POST') && isset($_SESSION["user"]["merchant"]["ltm_id"], $_REQUEST['Fields'], $_REQUEST['Members'])){
	
 $_Fields=@json_decode($_REQUEST['Fields']);
 $_Members=@json_decode($_REQUEST['Members']);
  
 if ($_Members !== null && $_Fields !== null && json_last_error() == JSON_ERROR_NONE){
	
	require '../app/function.connect.php';
	require '../app/global.php';
    require '../app/model/crypt.php';
	require '../app/class.variables.php';
	
	$_Total=count($_Members);$str='';/*$str_Temp='';*/$_Measurer=0;$_MaxMeasurer=1000;$_Current=0; $su_merchant_id=$_SESSION["user"]["merchant"]["ltm_id"];	
		
	//$fp = @fopen($_SERVER["DOCUMENT_ROOT"] . "/mystore/upload_file/{$su_merchant_id}_temp.csv", 'w+');
	foreach ( $_Members as $_Values ){
		$_Values = base64_decode($_Values);
		++$_Current;
		$_ValuesArr=explode( ',', $_Values );
		if ( count( $_ValuesArr ) == count( $_Fields ) ) {
			$_NewArr = array_combine($_Fields, $_ValuesArr); 
			$request = _appProcessRequest( $_NewArr );
			
			if ($request['success']){
			  if (consumer_exists($dbo, $request['csm_email'])){
			   $response[] = $_Values . ',<div class="alert alert-danger" role="alert"><ol><li> The email address: '.$request['csm_email'].' is already taken</li></ol></div>';
			  }
			  else{
				$loadArr[$_Measurer]=$request;
				//$str_Temp.=(empty($str_Temp)?"":",")."(:csm_email_{$_Measurer})";
				$str.=(empty($str)?"":",")."('bulkupload', :csm_first_name_{$_Measurer}, :csm_last_name_{$_Measurer}, :csm_email_{$_Measurer}, :csm_password_{$_Measurer}, :csm_cell_number_{$_Measurer}, NOW(), :csm_lat_{$_Measurer}, :csm_long_{$_Measurer}, :csm_zip_{$_Measurer}, :ltm_id, :ltm_pick_id".(isset($_POST['csm_txt_status']) && $_POST['csm_txt_status']=='2'?", :csm_txt_status_{$_Measurer}":"").")";				
				if ($_Measurer==$_MaxMeasurer || $_Total==$_Current){
				   if ($stmt = $dbo->prepare("
				   INSERT IGNORE INTO tbl_consumer
				   (csm_added_by, csm_first_name, csm_last_name, csm_email, csm_password, csm_cell_number, csm_add_date, csm_lat, csm_long, csm_zip, ltm_id, ltm_pick_id".(isset($_POST['csm_txt_status']) && $_POST['csm_txt_status']=='2'?', csm_txt_status':'').") 
				   VALUES {$str}")){
						//$stmt1 = $dbo->prepare("INSERT IGNORE INTO tbl_member_unencrypted_pass (csm_email) VALUES {$str_Temp}");						
						foreach ($loadArr as $k=>$arr){
							//$stmt1->bindValue(":csm_email_{$k}", $arr['csm_email'], PDO::PARAM_STR); 
							$_crypt = new Crypt( $arr['csm_email'] );
							$stmt->bindValue(":csm_password_{$k}", $_crypt->encode($arr['csm_password']), PDO::PARAM_STR);						
							$stmt->bindValue(":csm_first_name_{$k}", $arr['csm_first_name'], PDO::PARAM_STR);
							$stmt->bindValue(":csm_last_name_{$k}", $arr['csm_last_name'], PDO::PARAM_STR);
							$stmt->bindValue(":csm_email_{$k}", $arr['csm_email'], PDO::PARAM_STR);							
							$stmt->bindValue(":csm_zip_{$k}", $arr['csm_zip'], PDO::PARAM_STR);
							$stmt->bindValue(":csm_long_{$k}", $arr['csm_long'], PDO::PARAM_STR);
							$stmt->bindValue(":csm_lat_{$k}", $arr['csm_lat'], PDO::PARAM_STR);							
							$stmt->bindValue(":csm_cell_number_{$k}", isset($arr['csm_cell_number'])?preg_replace("/[^0-9]/","",$arr['csm_cell_number']):'', PDO::PARAM_STR);
							if (isset($_POST['csm_txt_status']) && $_POST['csm_txt_status']=='2') {
								$stmt->bindValue(":csm_txt_status_{$k}", isset($arr['csm_cell_number']) && !empty($arr['csm_cell_number'])?'2':null, PDO::PARAM_STR);							
							}
						}						
						$stmt->bindValue(":ltm_id", $su_merchant_id, PDO::PARAM_INT);
						$stmt->bindValue(":ltm_pick_id", $su_merchant_id, PDO::PARAM_INT);
						$stmt->execute();
						//$stmt1->execute();
				   }				   
				   $_Measurer=0;$str='';/*$str_Temp='';*/unset($loadArr);				   
				}else{++$_Measurer;}			
			  } 
			 }
			 elseif (isset($request['notify'])){
			  $response[] = $_Values . ',' .$request['notify'];
			 }
		}
		else{
			$response[] = $_Values . ',<div class="alert alert-danger" role="alert"><ol><li>Unknown Error</li></ol></div>';
		}
	}
    //if ($fp) fclose($fp);	
 }
 
}
echo json_encode($response);