<?php 

require '../app/start_session.php';
header( 'Content-Type: application/json; charset=utf-8' );
$response['message']='Unknown error: Your request could not be completed';
if (($_SERVER['REQUEST_METHOD'] == 'POST' || $_SERVER['REQUEST_METHOD'] == 'GET') && isset($_REQUEST['action'])){
 require '../app/function.connect.php';
 $dbo=connect();
 $response['availability']=false; 
 if(isset($_SESSION['user']['admin']['adm_id'])){
	
    $stmt = $dbo->prepare("UPDATE tbl_admin SET adm_last_activity = CURRENT_TIMESTAMP WHERE adm_id=:admin");
	
	$stmt->bindValue(":admin", $_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT);
	
	$stmt->execute();
	
    if (isset($_REQUEST['adm_typing']) && is_array($_REQUEST['adm_typing'])){
		
		$_zeros='0';$_ones='0';
		
        foreach ($_REQUEST['adm_typing'] as $Key=>$Value){
			
			if ($Value=='0'){$_zeros.=','.$Key;}elseif($Value=='1'){$_ones.=','.$Key;}
			
		}
		
		if ($stmt = $dbo->prepare("UPDATE tbl_chat_sessions SET adm_typing = ( CASE WHEN cts_id IN ({$_zeros}) THEN 0 ELSE (CASE WHEN cts_id IN ({$_ones}) THEN 1 ELSE adm_typing END) END)")){	     

	     $stmt->execute();
	  
	    }		
		
	}
    		
	
	if ($_REQUEST['action'] == 'admin_activate_chat')
	
     if ($stmt = $dbo->prepare("UPDATE tbl_admin SET adm_logged_in = (CASE WHEN adm_logged_in THEN 0 ELSE 1 END) WHERE adm_id=:admin")){
	  
	  $stmt->bindValue(":admin", $_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT);

	  $stmt->execute();
	  
	 }    
	
    if ($stmt = $dbo->prepare("SELECT adm_logged_in FROM tbl_admin WHERE adm_id=:admin")){
	  
	  $stmt->bindValue(":admin", $_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT);

	  $stmt->execute();
	  
	  if ($_Result=$stmt->fetch(PDO::FETCH_ASSOC)){
	
	   $response['availability'] = $_Result['adm_logged_in'] == 1;
	 
	  }
	  
	}     
 }
 else{
	 
	 if (isset($_REQUEST['client_typing']) && is_array($_REQUEST['client_typing'])){
		
		$_zeros='0';$_ones='0';
		
        foreach ($_REQUEST['client_typing'] as $Key=>$Value){
			
			if ($Value=='0'){$_zeros.=','.$Key;}elseif($Value=='1'){$_ones.=','.$Key;}
			
		}
		
		if ($stmt = $dbo->prepare("UPDATE tbl_chat_sessions SET client_typing = ( CASE WHEN cts_id IN ({$_zeros}) THEN 0 ELSE (CASE WHEN cts_id IN ({$_ones}) THEN 1 ELSE client_typing END) END)")){	

	     $stmt->execute();
	  
	    }		
		
	}
	 
 }
 
 
 $_Max_Conversations=3;
 function clean($msg){
  $clean = trim(preg_replace("/\t+/", " ", $msg)); //trim and remove tabs
  $clean = preg_replace('/(\r\n|\r|\n)/', "\n", $clean); //normalize line breaks
  $clean = preg_replace("/[\n]{3,}/", "\n\n", $clean);
  return $clean;  
 }
 
 function getUserChat($dbo, $cts_id){
 
  if ($stmt = $dbo->prepare("CALL GetChatSession(:ctsid)")){
  
    $stmt->bindValue(":ctsid", $cts_id, PDO::PARAM_INT);

	$stmt->execute();
	
	return $stmt->fetchAll(PDO::FETCH_ASSOC);
	
   }
  
 }
 
 function checkfor_user_started_chats($dbo, $csm_id){
  if ($stmt = $dbo->prepare("   
   SELECT CSS.cts_id 
   FROM tbl_chat_sessions CSS
   INNER JOIN tbl_consumer CSM ON CSS.csm_id=CSM.csm_id
   WHERE CSM.csm_id=:csmid AND CSS.cts_active LIMIT 1
  ")){    
    $stmt->bindValue(":csmid", $csm_id, PDO::PARAM_INT);
	$stmt->execute();
	
	if ($_Result=$stmt->fetch(PDO::FETCH_ASSOC)){
	
	 return $_Result['cts_id'];
	 
	}
	
   }
   
   return false;
 }
 
 function checkfor_merchant_started_chats($dbo, $ltm_id){
  if ($stmt = $dbo->prepare("
  SELECT CSS.cts_id 
  FROM tbl_chat_sessions CSS 
  INNER JOIN lt_merchants MRC ON CSS.ltm_id=MRC.ltm_id
  WHERE MRC.ltm_id=:ltmid AND CSS.cts_active LIMIT 1")){
  
    $stmt->bindValue(":ltmid", $ltm_id, PDO::PARAM_INT);
	$stmt->execute();
	
	if ($_Result=$stmt->fetch(PDO::FETCH_ASSOC)){
	
	 return $_Result['cts_id'];
	 
	}
	
   }
   
   return false;
   
 }
 
 function get_Consumer($dbo, $csm_id){
  $str='';	 
  if ($stmt = $dbo->prepare("
  SELECT csm_first_name, csm_last_name, csm_email, csm_cell_number
  FROM tbl_consumer  
  WHERE csm_id=:csmid LIMIT 1")){
    $stmt->bindValue(":csmid", $csm_id, PDO::PARAM_INT);
	$stmt->execute();	
	if ($_Result=$stmt->fetch(PDO::FETCH_ASSOC)){
	 $str='Consumer Name: '.$_Result['csm_first_name'].' '.$_Result['csm_last_name'].'<br>'
	 .'Phone: '.$_Result['csm_cell_number'].'<br>'
	 .'Email: '.$_Result['csm_email'];
	}
   }
   return $str;
 }
 
 function get_CSAdminEmails($dbo){
  $arr=array();	 
  if ($stmt = $dbo->prepare("
	  SELECT ADM.adm_email
	  FROM tbl_admin2file A2F 
	  INNER JOIN tbl_admin ADM ON ADM.adm_id=A2F.adm_id
	  INNER JOIN tbl_file_structure FLE ON FLE.file_id=A2F.file_id 
	  WHERE NOT ADM.adm_master 
	  AND ADM.adm_active 
	  AND FLE.file_name = 'page-chat.php' 
	  AND FLE.file_parent_id IN (
		   SELECT file_id 
		   FROM tbl_file_structure 
		   WHERE file_parent_id IN (
				SELECT file_id 
				FROM tbl_file_structure 
				WHERE file_parent_id IN (
							SELECT file_id 
									FROM tbl_file_structure 
									WHERE file_name = 'admin' 
									AND file_isdir 
									AND NOT file_parent_id
								  ) 
				AND file_name = 'app' 
				AND file_isdir
		   ) 
		   AND file_name = 'view' 
		   AND file_isdir
	  )
  ")){
	$stmt->execute();	
	while ($_Result=$stmt->fetch(PDO::FETCH_ASSOC)){	
	 array_push($arr, $_Result['adm_email']);
	}
   } 
   return $arr;
 }
 
 function get_Merchant($dbo, $ltm_id){
  $str='';	 
  if ($stmt = $dbo->prepare("
  SELECT MMR.ltb_phone_number, MMR.ltb_contact_name, MMR.ltb_email, MRC.ltm_company_name, MRC.ltm_address, MRC.ltm_city, MRC.ltm_state, MRC.ltm_zipcode
  FROM lt_merchants MRC 
  INNER JOIN lt_member_merchants MMR ON MMR.ltb_id=MRC.ltb_id
  WHERE MRC.ltm_id=:ltmid LIMIT 1")){
    $stmt->bindValue(":ltmid", $ltm_id, PDO::PARAM_INT);
	$stmt->execute();	
	if ($_Result=$stmt->fetch(PDO::FETCH_ASSOC)){	
	 $str='Contact Name: '.$_Result['ltb_contact_name'].'<br>'
	 .'Phone: '.$_Result['ltb_phone_number'].'<br>'
	 .'Email: '.$_Result['ltb_email'].'<br>'
	 .'Company: '.$_Result['ltm_company_name'].'<br>'
	 .'Address: '.$_Result['ltm_address'].' '.$_Result['ltm_city'].', '. $_Result['ltm_state']. ' ' . $_Result['ltm_zipcode'];
	}
   } 
   return $str;
 }
 
 function check_AdminAvailability($dbo) {
	$stmt = $dbo->prepare("UPDATE tbl_admin SET adm_logged_in = (CASE WHEN (UNIX_TIMESTAMP() - UNIX_TIMESTAMP(adm_last_activity))/60 > 15 THEN 0 ELSE adm_logged_in END)");
	$stmt->execute();
    $stmt = $dbo->prepare("SELECT COUNT(adm_id) AS amount FROM tbl_admin WHERE adm_logged_in;");
	$stmt->execute();
	if ($_Result = $stmt->fetch(PDO::FETCH_ASSOC)) {
	 return $_Result['amount'] > 0;
	}
    return false;
 }
 
 function getAdminSessions($dbo, $adm_id){
  
  if ($stmt = $dbo->prepare("CALL GetChatSession_Admin(:admin)")){
  
    $stmt->bindValue(":admin", $adm_id, PDO::PARAM_INT);

	$stmt->execute();
	
	return $stmt->fetchAll(PDO::FETCH_ASSOC);
	
   }
  
 } 
 
 function search($dbo){
  
   if ($stmt = $dbo->prepare("CALL GetWaitingChat()")){

	$stmt->execute();
	
	return $stmt->fetchAll(PDO::FETCH_ASSOC);
	
   } 
 
 }

if (isset($_REQUEST['cts_id']) && preg_match('/^[0-9]{1,11}$/',$_REQUEST['cts_id'])){
 if (!$_REQUEST['cts_id']){
  $_var=false;
  if (check_AdminAvailability($dbo)){
   if (isset($_SESSION['user']["merchant"]['ltm_id'])){
    $_var=checkfor_merchant_started_chats($dbo, $_SESSION['user']["merchant"]['ltm_id']);  
   }
   elseif (isset($_SESSION['user']["consumer"]['csm_id']) && $_SESSION['user']["consumer"]['csm_id'] > 1){
    $_var=checkfor_user_started_chats($dbo, $_SESSION['user']["consumer"]['csm_id']);  
   }
  } 
  
  if ($_var){
   $_SESSION['chat']['cts_id']=$_var;
   $_SESSION['chat']['cts_signed_in']=1;
  }
  else{ 	  
   unset($_SESSION['chat']);
  }  
 }
 
 if ($_REQUEST['action'] == 'take_chat' && isset($_SESSION['user']['admin']['adm_id'])){    
  
  if ($stmt = $dbo->prepare("SELECT COUNT(CHS.cts_id) AS Taken_Amount FROM tbl_chat_sessions CHS WHERE CHS.adm_id=:admin AND CHS.cts_active")){
        
	$stmt->bindValue(":admin", $_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT);

	$stmt->execute();
	
	if ($result = $stmt->fetch(PDO::FETCH_ASSOC)){
     
     if ( $_Max_Conversations < $result['Taken_Amount'] ){
	  
	  $response['message']='Error: You have reached the maximum amount of chats that you can have simultaneously, you cannot take this chat';
	  
	 }
	 elseif ($stmt = $dbo->prepare("SELECT cts_id FROM tbl_chat_sessions WHERE adm_id IS NOT NULL AND cts_id=:ctsid")){
        
	  $stmt->bindValue(":ctsid", $_REQUEST['cts_id'], PDO::PARAM_INT);

	  $stmt->execute();
	
	  if ($result = $stmt->fetch(PDO::FETCH_ASSOC)){
	 
	   $response['message']='Error: The chat was picked almost simultaneously between you and another agent, it was given to her/him';
	  
	  }
     		
	  elseif ($stmt = $dbo->prepare("
	 
	  UPDATE tbl_chat_sessions SET adm_id=:admin WHERE cts_id=:ctsid")){
	  
	  $stmt->bindValue(":admin", $_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT);
	  
	  $stmt->bindValue(":ctsid", $_REQUEST['cts_id'], PDO::PARAM_INT);

	  $stmt->execute();
	  
	   if ($stmt = $dbo->prepare("SELECT adm_chat_name FROM tbl_admin WHERE adm_id=:admin LIMIT 1")){
	  
	    $stmt->bindValue(":admin", $_SESSION['user']['admin']['adm_id'], PDO::PARAM_INT);	   

	    $stmt->execute();
	   
	    $_TempAdm=$stmt->fetch(PDO::FETCH_ASSOC);
	   
	    if (isset($_TempAdm['adm_chat_name']) && $stmt=$dbo->prepare("CALL AddChatMsg_Admin(:ctsid, :ctamsg)")){
	  
	     $stmt->bindValue(":ctsid", $_REQUEST['cts_id'], PDO::PARAM_INT);
	  
	     $stmt->bindValue(":ctamsg", "Hi, I'm {$_TempAdm['adm_chat_name'] } with LocalThanks. How can I help you today?", PDO::PARAM_STR);

	     $stmt->execute();
	  
	    }
	   
	   } 
	  
	  }
    
     }	
	 
	}
	
  }  
 
 }
 elseif($_REQUEST['action'] == 'send_msg' && isset( $_REQUEST['cta_msg'],$_SESSION['user']['admin']['adm_id'] ) ){
      
    if ($stmt = $dbo->prepare("CALL AddChatMsg_Admin(:ctsid, :ctamsg)")){
	  
	 $stmt->bindValue(":ctsid", $_REQUEST['cts_id'], PDO::PARAM_INT);
	  
	 $stmt->bindValue(":ctamsg", clean($_REQUEST['cta_msg']), PDO::PARAM_STR);

	 $stmt->execute();
	  
	}
 }
 
 elseif($_REQUEST['action'] == 'user_send_msg' || $_REQUEST['action'] == 'merchant_send_msg'){
    
	$adm_AvailabilityFlag=check_AdminAvailability($dbo);
	
	if (!isset($_SESSION['chat']['cts_id'])){ 
	 $_var='csm_id';
	 if (isset($_SESSION['user']["merchant"]['ltm_id'])) {
	  $_var='ltm_id';
	  $_bind=$_SESSION['user']["merchant"]['ltm_id'];
	 }
	 elseif(isset($_SESSION['user']["consumer"]['csm_id']) && $_SESSION['user']["consumer"]['csm_id'] > 1){	  
	  $_bind=$_SESSION['user']["consumer"]['csm_id'];	  
	 }    
	
	 if ($adm_AvailabilityFlag && $stmt = $dbo->prepare("

	   INSERT INTO tbl_chat_sessions ({$_var}, cts_signed_in) VALUES (".(isset($_bind)?':csmid':'NULL').", :signedin)")){
	   	   
	   $stmt->bindValue(":signedin", isset($_bind)?1:0, PDO::PARAM_INT);
        
	   if (isset($_bind)) $stmt->bindValue(":csmid", $_bind, PDO::PARAM_INT);

	   $stmt->execute();
	   
	   $_SESSION['chat']['cts_id']=$dbo->lastInsertId(); 
       
	   if ($_REQUEST['action'] == 'user_send_msg'){
	   
        $_SESSION['chat']['cts_signed_in']=isset($_SESSION['user']["consumer"]['csm_id']) && $_SESSION['user']["consumer"]['csm_id'] > 1?1:0;
		
	   }
	   else if ($_REQUEST['action'] == 'merchant_send_msg') {
	   
	    $_SESSION['chat']['cts_signed_in']=isset($_SESSION['user']["merchant"]['ltm_id'])?1:0;
	   
	   }
	   
	  }	 
	 
	}
	
	if (!$adm_AvailabilityFlag) {
		
		$body = '';
		
		if ($_REQUEST['action'] == 'user_send_msg' && isset($_SESSION['user']["consumer"]['csm_id']) && $_SESSION['user']["consumer"]['csm_id'] > 1){
			//it is a logged in consumer grab his info and to include it in the email
			$body=get_Consumer($dbo, $_SESSION['user']["consumer"]['csm_id']);
	    }
	    else if ($_REQUEST['action'] == 'merchant_send_msg' && isset($_SESSION['user']["merchant"]['ltm_id'])) { 
			//it is a logged in merchant grab his info and to include it in the email
			$body=get_Merchant($dbo, $_SESSION['user']["merchant"]['ltm_id']);	   
	    }
		
		$adms=get_CSAdminEmails($dbo);$to='';
		foreach ($adms as $Val){
			$to.=(empty($to)?'':',').$Val;
		}
		if (!empty($to) && (isset($_REQUEST['ctc_msg'])||isset($_REQUEST['ctm_msg']))){
		    
			if (isset($_REQUEST['ctc_msg'])) $response['msg_sent'] = clean($_REQUEST['ctc_msg']); 
			elseif (isset($_REQUEST['ctm_msg'])) $response['msg_sent'] = clean($_REQUEST['ctm_msg']);
			$body .= '<br> Message: ' . $response['msg_sent'];			
			$subject = 'Missed Chat Session';
			$message = "<html><head><title>Missed Chat Session</title></head><body><table><tr><td>{$body}</td></tr></table></body></html>";
			$headers = "MIME-Version: 1.0" . "\r\n";
			$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";		
			$headers .= 'From: customerservice@localthanks.com' . "\r\n";
			mail($to,$subject,$message,$headers); 
			
		}
	}	
	
    if (isset($_SESSION['chat']['cts_id']) ){	   
       
	   $_var=''; $_bind='';$_sql_tbl='';
	   
	   if ($_REQUEST['action'] == 'user_send_msg'){
	    
		$_var = ':ctcmsg';
	    
		$_bind=clean($_REQUEST['ctc_msg']);
		
		$_sql_tbl = 'Consumer';
				
	   }
	   else if ($_REQUEST['action'] == 'merchant_send_msg') {
	   
	    
		$_var = ':ctmmsg';
	    
		$_bind=clean($_REQUEST['ctm_msg']);
		
		$_sql_tbl = 'Merchant';
		
	   
	   }
	   
	if (!empty($_sql_tbl) && !empty($_var))   
      
     if ($stmt = $dbo->prepare("CALL AddChatMsg_{$_sql_tbl}(:ctsid, {$_var})")){
	  
	  $stmt->bindValue(":ctsid", $_SESSION['chat']['cts_id'], PDO::PARAM_INT);
	  
	  $stmt->bindValue("{$_var}", $_bind, PDO::PARAM_STR);

	  $stmt->execute();
	  
	 }
	 
	}
 } 
 elseif($_REQUEST['action'] == 'close_chat_session' && ((isset($_REQUEST['cts_id']) && preg_match('/^[0-9]{1,11}$/',$_REQUEST['cts_id']))||(isset($_SESSION['chat']['cts_id']) && preg_match('/^[0-9]{1,11}$/',$_SESSION['chat']['cts_id'])))){
 
    if ($stmt = $dbo->prepare("UPDATE tbl_chat_sessions SET cts_active=0 WHERE cts_id=:ctsid")){
	  
	  $stmt->bindValue(":ctsid", isset($_SESSION['chat']['cts_id'])?$_SESSION['chat']['cts_id']:$_REQUEST['cts_id'], PDO::PARAM_INT);

	  $stmt->execute();
	  
	  unset($_SESSION['chat']);	  
	  
	}  
 }
}
 if (isset($_SESSION['user']['admin']['adm_id'])){
 
  $response['data'] = search($dbo);
 
  $response['chat'] = getAdminSessions($dbo, $_SESSION['user']['admin']['adm_id']);
  
 }
 else{
 
  $response['availability']=check_AdminAvailability($dbo);
  
  if (isset($_SESSION['chat']['cts_id'])) {
  
     if ( isset($_SESSION['chat']['cts_signed_in']) && !$_SESSION['chat']['cts_signed_in'] && ((isset($_SESSION['user']["merchant"]['ltm_id']))||(isset($_SESSION['user']["consumer"]['csm_id']) && $_SESSION['user']["consumer"]['csm_id'] > 1))) {	  
	  
	  if (isset($_SESSION['user']["merchant"]['ltm_id'])){
	  
	    $_var = ':ltmid';
	    
		$_bind=$_SESSION['user']["merchant"]['ltm_id'];
		
		$_sql_field = 'ltm_id';
		
	  }
	  else{
	   
	   $_var = ':csmid';
	    
	   $_bind=$_SESSION['user']["consumer"]['csm_id'];
		
	   $_sql_field = 'csm_id';
	  
	  }
	  
	  if ($stmt = $dbo->prepare("UPDATE tbl_chat_sessions SET cts_signed_in=1, {$_sql_field}={$_var} WHERE cts_id=:ctsid")){
	  
	   $stmt->bindValue(":ctsid", $_SESSION['chat']['cts_id'], PDO::PARAM_INT);
	   
	   $stmt->bindValue("{$_var}", $_bind, PDO::PARAM_INT);

	   $stmt->execute();
	   
	   $_SESSION['chat']['cts_signed_in']=1;
	   
	  }	  
	  
	 }
  
   $response['chat'] = getUserChat($dbo, $_SESSION['chat']['cts_id']); 
  
  } 
  
 }
 
}

echo json_encode($response);