<?php
require '../app/start_session.php';
header( 'Content-Type: application/json; charset=utf-8' );
$response['status']='';

if(($_SERVER['REQUEST_METHOD'] == 'POST' || $_SERVER['REQUEST_METHOD'] == 'GET') && isset($_REQUEST["ltp_id"], $_SESSION['user']['consumer']['csm_id'])){
	require '../app/function.connect.php';
	require '../app/class.variables.php';
	
	$valPost['wnu_ltp_id_r'] = $_REQUEST['ltp_id'];
	$cv= new _variables($valPost);
	
	$cv->varible_in('wnu_ltp_id_r');
	$clean = $cv->get_cleaned_variables();
	$errors = $cv->get_bad_variables();
	
	// get the cross-promoted merchant's name, header, hours, lat, long, address, city, state, zip, phone
	$stmt = $dbo->prepare( 
		"SELECT DISTINCT LTM.ltm_company_name, LTM.ltm_lat, LTM.ltm_long, LTM.ltm_address, LTM.ltm_city, 
		LTM.ltm_state, LTM.ltm_zipcode, LTM.ltm_phone_number, LTB.ltb_id, LTB.ltb_header_image, LTB.ltb_phone_number, MRH.*
		FROM lt_merchants LTM 
		INNER JOIN lt_member_merchants LTB ON LTM.ltb_id = LTB.ltb_id 
		INNER JOIN lt_cross_promotions CPR ON LTM.ltm_id = CPR.ltm_id 
		LEFT JOIN lt_merchant_hours MRH ON LTM.ltm_id=MRH.ltm_id 
		WHERE CPR.ltp_id=:ltp_id 
		LIMIT 1"	
	);
	$stmt->bindValue(':ltp_id', $clean["ltp_id"], PDO::PARAM_INT);
	$stmt->execute();
	$qry = $stmt->fetch(PDO::FETCH_ASSOC);
	$response['result'] = $qry;
	$response['status'] = 'success';
}
else {
	// errors
	if (!isset($_REQUEST["ltp_id"], $_SESSION['user']['consumer']['csm_id'])){
		$response['status'] = 'missing_required_fields';	
	}
	else if (!is_numeric($_REQUEST["ltp_id"])){
		$response['status'] = 'invalid_ltp_id';
	}
}

echo json_encode($response);